/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantBuilderImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureNameWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.sync.DynamicFeatureVariantModelTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001Bc\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001c\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0006H\u0014\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/DynamicFeatureTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/impl/DynamicFeatureVariantBuilderImpl;", "Lcom/android/build/api/variant/impl/DynamicFeatureVariantImpl;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/api/component/impl/TestComponentImpl;", "testFixturesComponents", "Lcom/android/build/api/component/impl/TestFixturesImpl;", "hasFlavors", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "extension", "Lcom/android/build/gradle/BaseExtension;", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLcom/android/build/gradle/options/ProjectOptions;Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/BaseExtension;Lcom/android/build/gradle/internal/scope/ProjectInfo;)V", "createDynamicBundleTask", "", "variantProperties", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "doCreateTasksForVariant", "variantInfo", "gradle-core"})
public final class DynamicFeatureTaskManager
extends AbstractAppTaskManager<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl> {
    public DynamicFeatureTaskManager(@NotNull List<? extends ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl>> variants, @NotNull List<? extends TestComponentImpl> testComponents, @NotNull List<? extends TestFixturesImpl> testFixturesComponents, boolean hasFlavors, @NotNull ProjectOptions projectOptions, @NotNull GlobalScope globalScope, @NotNull BaseExtension extension, @NotNull ProjectInfo projectInfo) {
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)projectInfo, (String)"projectInfo");
        super(variants, testComponents, testFixturesComponents, hasFlavors, projectOptions, globalScope, extension, projectInfo);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<DynamicFeatureVariantBuilderImpl, DynamicFeatureVariantImpl> variantInfo) {
        Intrinsics.checkNotNullParameter(variantInfo, (String)"variantInfo");
        this.createCommonTasks(variantInfo);
        DynamicFeatureVariantImpl variant2 = variantInfo.getVariant();
        this.createDynamicBundleTask(variant2);
        this.taskFactory.register(new DynamicFeatureVariantModelTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureSplitDeclarationWriterTask.CreationAction(variant2));
        if (variant2.getBuildFeatures().getDataBinding()) {
            this.taskFactory.register(new DataBindingExportFeatureInfoTask.CreationAction(variant2));
        }
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(variant2));
        this.taskFactory.register(new FeatureNameWriterTask.CreationAction(variant2));
    }

    private final void createDynamicBundleTask(DynamicFeatureVariantImpl variantProperties) {
        if (variantProperties.getServices().getProjectInfo().getExtension().getAaptOptions().getNamespaced()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variantProperties));
        if (!variantProperties.getDebuggable()) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variantProperties));
        }
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
    }
}

