/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "computeFile", "Ljava/io/File;", "rootFolder", "path", "", "copyFromFolder", "", "rootDirectory", "outputDirectory", "from", "pathSegments", "", "copyFromJar", "jarFile", "gradle-core"})
public final class LibraryJniLibsTaskKt {
    private static final Pattern pattern = Pattern.compile("lib/[^/]+/[^/]+\\.so");

    private static final void copyFromFolder(File rootDirectory, File outputDirectory) {
        boolean bl = false;
        LibraryJniLibsTaskKt.copyFromFolder(rootDirectory, outputDirectory, new ArrayList());
    }

    private static final void copyFromFolder(File from, File outputDirectory, List<String> pathSegments) {
        File[] children = from.listFiles(LibraryJniLibsTaskKt::copyFromFolder$lambda-0);
        if (children != null) {
            File[] fileArray = children;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File child = fileArray[n];
                ++n;
                String string = child.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"child.name");
                pathSegments.add(string);
                if (child.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    LibraryJniLibsTaskKt.copyFromFolder(child, outputDirectory, pathSegments);
                } else if (child.isFile() && pattern.matcher(Joiner.on((char)'/').join((Iterable)pathSegments)).matches()) {
                    File to = FileUtils.join((File)outputDirectory, (Iterable)pathSegments.subList(1, 3));
                    FileUtils.mkdirs((File)to.getParentFile());
                    FileUtils.copyFile((File)child, (File)to);
                }
                pathSegments.remove(pathSegments.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyFromJar(File jarFile, File outputDirectory) {
        Closeable closeable = new ZipFile(jarFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl3 = false;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ByteBuffer byteBuffer;
                ZipEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!pattern.matcher(entryPath).matches()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) continue;
                Closeable closeable2 = zipFile.getInputStream(entry);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl6 = false;
                    byteBuffer = ByteBuffer.wrap(ByteStreams.toByteArray((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ByteBuffer byteBuffer2 = byteBuffer;
                Intrinsics.checkNotNullExpressionValue((Object)entryPath, (String)"entryPath");
                File to = LibraryJniLibsTaskKt.computeFile(outputDirectory, entryPath);
                FileUtils.mkdirs((File)to.getParentFile());
                Files.write((byte[])byteBuffer2.array(), (File)to);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final File computeFile(File rootFolder, String path) {
        String string = path;
        int n = 4;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return new File(rootFolder, FileUtils.toSystemDependentPath((String)string3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean copyFromFolder$lambda-0(File file, String name) {
        if (file.isDirectory()) return true;
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        if (!StringsKt.endsWith$default((String)name, (String)".so", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final /* synthetic */ void access$copyFromJar(File jarFile, File outputDirectory) {
        LibraryJniLibsTaskKt.copyFromJar(jarFile, outputDirectory);
    }

    public static final /* synthetic */ void access$copyFromFolder(File rootDirectory, File outputDirectory) {
        LibraryJniLibsTaskKt.copyFromFolder(rootDirectory, outputDirectory);
    }
}

