/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.build.gradle.tasks.SourceSetInputs;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceSet;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010$\u001a\u00020%2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020 2\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\b\b\u0002\u0010-\u001a\u00020 2\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0007J.\u0010.\u001a\b\u0012\u0004\u0012\u00020(0,2\u0014\b\u0002\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u00192\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0002J(\u00100\u001a\u00020%2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\b\u00106\u001a\u0004\u0018\u00010\rR(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\r@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR<\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u00192\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u0019@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lcom/android/build/gradle/internal/DependencyResourcesComputer;", "", "()V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "extraGeneratedResFolders", "getExtraGeneratedResFolders", "()Lorg/gradle/api/file/FileCollection;", "setExtraGeneratedResFolders", "(Lorg/gradle/api/file/FileCollection;)V", "generatedResOutputDir", "getGeneratedResOutputDir", "setGeneratedResOutputDir", "Lorg/gradle/api/artifacts/ArtifactCollection;", "libraries", "getLibraries", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "setLibraries", "(Lorg/gradle/api/artifacts/ArtifactCollection;)V", "microApkResDirectory", "getMicroApkResDirectory", "setMicroApkResDirectory", "renderscriptResOutputDir", "getRenderscriptResOutputDir", "setRenderscriptResOutputDir", "", "", "resources", "getResources", "()Ljava/util/Map;", "setResources", "(Ljava/util/Map;)V", "", "validateEnabled", "getValidateEnabled", "()Z", "addLibraryResources", "", "resourceSetList", "", "Lcom/android/ide/common/resources/ResourceSet;", "resourceArePrecompiled", "aaptEnv", "compute", "", "precompileDependenciesResources", "getResSet", "resourcesMap", "initFromVariantScope", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "sourceSetInputs", "Lcom/android/build/gradle/tasks/SourceSetInputs;", "microApkResDir", "libraryDependencies", "gradle-core"})
public final class DependencyResourcesComputer {
    public Map<String, ? extends FileCollection> resources;
    @Nullable
    private ArtifactCollection libraries;
    public FileCollection renderscriptResOutputDir;
    public FileCollection generatedResOutputDir;
    @Nullable
    private FileCollection microApkResDirectory;
    @Nullable
    private FileCollection extraGeneratedResFolders;
    private boolean validateEnabled;

    @NotNull
    public final Map<String, FileCollection> getResources() {
        Map<String, FileCollection> map = this.resources;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        return null;
    }

    @VisibleForTesting
    public final void setResources(@NotNull Map<String, ? extends FileCollection> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.resources = map;
    }

    @Nullable
    public final ArtifactCollection getLibraries() {
        return this.libraries;
    }

    @VisibleForTesting
    public final void setLibraries(@Nullable ArtifactCollection artifactCollection) {
        this.libraries = artifactCollection;
    }

    @NotNull
    public final FileCollection getRenderscriptResOutputDir() {
        FileCollection fileCollection2 = this.renderscriptResOutputDir;
        if (fileCollection2 != null) {
            return fileCollection2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"renderscriptResOutputDir");
        return null;
    }

    @VisibleForTesting
    public final void setRenderscriptResOutputDir(@NotNull FileCollection fileCollection2) {
        Intrinsics.checkNotNullParameter((Object)fileCollection2, (String)"<set-?>");
        this.renderscriptResOutputDir = fileCollection2;
    }

    @NotNull
    public final FileCollection getGeneratedResOutputDir() {
        FileCollection fileCollection2 = this.generatedResOutputDir;
        if (fileCollection2 != null) {
            return fileCollection2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"generatedResOutputDir");
        return null;
    }

    @VisibleForTesting
    public final void setGeneratedResOutputDir(@NotNull FileCollection fileCollection2) {
        Intrinsics.checkNotNullParameter((Object)fileCollection2, (String)"<set-?>");
        this.generatedResOutputDir = fileCollection2;
    }

    @Nullable
    public final FileCollection getMicroApkResDirectory() {
        return this.microApkResDirectory;
    }

    @VisibleForTesting
    public final void setMicroApkResDirectory(@Nullable FileCollection fileCollection2) {
        this.microApkResDirectory = fileCollection2;
    }

    @Nullable
    public final FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    @VisibleForTesting
    public final void setExtraGeneratedResFolders(@Nullable FileCollection fileCollection2) {
        this.extraGeneratedResFolders = fileCollection2;
    }

    public final boolean getValidateEnabled() {
        return this.validateEnabled;
    }

    private final void addLibraryResources(ArtifactCollection libraries, List<ResourceSet> resourceSetList, boolean resourceArePrecompiled, String aaptEnv) {
        ArtifactCollection artifactCollection = libraries;
        if (artifactCollection != null) {
            ArtifactCollection artifactCollection2 = artifactCollection;
            boolean bl = false;
            boolean bl2 = false;
            ArtifactCollection it = artifactCollection2;
            boolean bl3 = false;
            Set libArtifacts = it.getArtifacts();
            for (ResolvedArtifactResult artifact : libArtifacts) {
                Intrinsics.checkNotNullExpressionValue((Object)artifact, (String)"artifact");
                ResourceSet resourceSet = new ResourceSet(ProcessApplicationManifest.Companion.getArtifactName(artifact), ResourceNamespace.RES_AUTO, null, this.getValidateEnabled(), aaptEnv);
                resourceSet.setFromDependency(true);
                resourceSet.addSource(artifact.getFile());
                if (resourceArePrecompiled) {
                    resourceSet.setAllowedFolderPrefix("values");
                }
                resourceSetList.add(0, resourceSet);
            }
        }
    }

    @JvmOverloads
    @NotNull
    public final List<ResourceSet> compute(boolean precompileDependenciesResources, @Nullable String aaptEnv) {
        Set set;
        Set it;
        boolean bl;
        boolean bl2;
        boolean bl3;
        List<ResourceSet> sourceFolderSets = this.getResSet(this.getResources(), aaptEnv);
        int size = 0;
        size = sourceFolderSets.size();
        ArtifactCollection artifactCollection = this.libraries;
        if (artifactCollection != null) {
            ArtifactCollection artifactCollection2 = artifactCollection;
            bl3 = false;
            bl2 = false;
            ArtifactCollection it2 = artifactCollection2;
            boolean bl4 = false;
            size += it2.getArtifacts().size();
        }
        ArrayList resourceSetList = new ArrayList(size);
        this.addLibraryResources(this.libraries, resourceSetList, precompileDependenciesResources, aaptEnv);
        resourceSetList.addAll(sourceFolderSets);
        bl3 = false;
        List generatedResFolders = new ArrayList();
        Collection collection = this.getRenderscriptResOutputDir().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"renderscriptResOutputDir.files");
        generatedResFolders.addAll(collection);
        collection = this.getGeneratedResOutputDir().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"generatedResOutputDir.files");
        generatedResFolders.addAll(collection);
        collection = this.extraGeneratedResFolders;
        if (collection != null) {
            Set set2 = collection;
            boolean bl5 = false;
            bl = false;
            it = set2;
            boolean bl6 = false;
            set = it.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.files");
            generatedResFolders.addAll(set);
        }
        collection = this.microApkResDirectory;
        if (collection != null) {
            Set set3 = collection;
            boolean bl7 = false;
            bl = false;
            it = set3;
            boolean bl8 = false;
            set = it.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.files");
            generatedResFolders.addAll(set);
        }
        collection = sourceFolderSets;
        bl2 = false;
        if (!collection.isEmpty()) {
            ResourceSet mainResourceSet = sourceFolderSets.get(0);
            bl2 = Intrinsics.areEqual((Object)mainResourceSet.getConfigName(), (Object)"main") || Intrinsics.areEqual((Object)mainResourceSet.getConfigName(), (Object)"androidTest");
            boolean bl9 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl10 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            mainResourceSet.addSources((Collection)generatedResFolders);
        }
        return resourceSetList;
    }

    public static /* synthetic */ List compute$default(DependencyResourcesComputer dependencyResourcesComputer, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return dependencyResourcesComputer.compute(bl, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceSet> getResSet(Map<String, ? extends FileCollection> resourcesMap, String aaptEnv) {
        void $this$mapTo$iv$iv;
        Map<String, ? extends FileCollection> $this$map$iv = resourcesMap;
        boolean $i$f$map = false;
        Map<String, ? extends FileCollection> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var8_8.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            ResourceSet resourceSet = new ResourceSet((String)it.getKey(), ResourceNamespace.RES_AUTO, null, this.getValidateEnabled(), aaptEnv);
            resourceSet.addSources((Collection)((FileCollection)it.getValue()).getFiles());
            ResourceSet resourceSet2 = resourceSet;
            collection.add(resourceSet2);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getResSet$default(DependencyResourcesComputer dependencyResourcesComputer, Map map, String string, int n, Object object) {
        if ((n & 1) != 0) {
            map = dependencyResourcesComputer.getResources();
        }
        return dependencyResourcesComputer.getResSet(map, string);
    }

    public final void initFromVariantScope(@NotNull ComponentCreationConfig creationConfig, @NotNull SourceSetInputs sourceSetInputs, @NotNull FileCollection microApkResDir, @Nullable ArtifactCollection libraryDependencies) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)sourceSetInputs, (String)"sourceSetInputs");
        Intrinsics.checkNotNullParameter((Object)microApkResDir, (String)"microApkResDir");
        ProjectOptions projectOptions = creationConfig.getServices().getProjectOptions();
        TaskCreationServices services = creationConfig.getServices();
        this.validateEnabled = !projectOptions.get(BooleanOption.DISABLE_RESOURCE_VALIDATION);
        this.libraries = libraryDependencies;
        Object[] objectArray = sourceSetInputs.getLocalResources().forUseAtConfigurationTime().get();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sourceSetInputs.localRes\u2026ConfigurationTime().get()");
        this.setResources((Map)objectArray);
        this.extraGeneratedResFolders = (FileCollection)sourceSetInputs.getExtraGeneratedResDir();
        objectArray = new Object[]{new File((String)sourceSetInputs.getRenderscriptResOutputDir().forUseAtConfigurationTime().get())};
        this.setRenderscriptResOutputDir((FileCollection)services.fileCollection(objectArray));
        objectArray = new Object[]{new File((String)sourceSetInputs.getGeneratedResDir().forUseAtConfigurationTime().get())};
        this.setGeneratedResOutputDir((FileCollection)services.fileCollection(objectArray));
        if (creationConfig.getTaskContainer().getGenerateApkDataTask() != null) {
            this.microApkResDirectory = microApkResDir;
        }
    }

    @JvmOverloads
    @NotNull
    public final List<ResourceSet> compute(@Nullable String aaptEnv) {
        return DependencyResourcesComputer.compute$default(this, false, aaptEnv, 1, null);
    }
}

