/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.dsl.DeviceGroup;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.prefs.AndroidLocationsProvider;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a&\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"GRADLE_AVD_DIRECTORY_PATH", "", "computeAvdName", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "apiLevel", "", "vendor", "abi", "hardwareProfile", "getManagedDeviceAvdFolder", "Lorg/gradle/api/file/DirectoryProperty;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "managedDeviceAllVariantsTaskName", "managedDeviceGroupAllVariantsTaskName", "deviceGroup", "Lcom/android/build/api/dsl/DeviceGroup;", "managedDeviceGroupSingleVariantTaskName", "creationConfig", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "setupTaskName", "gradle-core"})
public final class ManagedDeviceUtilsKt {
    @NotNull
    private static final String GRADLE_AVD_DIRECTORY_PATH = "gradle/avd";

    @NotNull
    public static final DirectoryProperty getManagedDeviceAvdFolder(@NotNull ObjectFactory objectFactory, @NotNull ProviderFactory providerFactory, @NotNull AndroidLocationsProvider androidLocationsProvider) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty().fileProvider(providerFactory.provider(new Callable(androidLocationsProvider){
            final /* synthetic */ AndroidLocationsProvider $androidLocationsProvider;
            {
                this.$androidLocationsProvider = $androidLocationsProvider;
            }

            public final File call() {
                return this.$androidLocationsProvider.getGradleAvdLocation().toFile();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"androidLocationsProvider\u2026dLocation.toFile()\n    })");
        return directoryProperty;
    }

    @NotNull
    public static final String computeAvdName(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return ManagedDeviceUtilsKt.computeAvdName(device.getApiLevel(), device.getSystemImageSource(), device.getAbi(), device.getDevice());
    }

    @NotNull
    public static final String computeAvdName(int apiLevel, @NotNull String vendor, @NotNull String abi, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        return "dev" + apiLevel + '_' + vendor + '_' + abi + '_' + StringsKt.replace$default((String)hardwareProfile, (char)' ', (char)'_', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String setupTaskName(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return Intrinsics.stringPlus((String)device.getName(), (Object)"Setup");
    }

    @NotNull
    public static final String managedDeviceAllVariantsTaskName(@NotNull ManagedVirtualDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return Intrinsics.stringPlus((String)device.getName(), (Object)"Check");
    }

    @NotNull
    public static final String managedDeviceGroupAllVariantsTaskName(@NotNull DeviceGroup deviceGroup) {
        Intrinsics.checkNotNullParameter((Object)deviceGroup, (String)"deviceGroup");
        return Intrinsics.stringPlus((String)deviceGroup.getName(), (Object)"GroupCheck");
    }

    @NotNull
    public static final String managedDeviceGroupSingleVariantTaskName(@NotNull VariantCreationConfig creationConfig, @NotNull DeviceGroup deviceGroup) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)deviceGroup, (String)"deviceGroup");
        return ComponentCreationConfig.DefaultImpls.computeTaskName$default(creationConfig, Intrinsics.stringPlus((String)deviceGroup.getName(), (Object)"Group"), null, 2, null);
    }
}

