/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.attributes.VariantAttr;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.builder.model.Dependencies;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u00a8\u0006\b"}, d2={"clone", "Lcom/android/builder/model/Dependencies;", "dependencies", "modelLevel", "", "getVariantName", "", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "gradle-core"})
@JvmName(name="LibraryUtils")
public final class LibraryUtils {
    @NotNull
    public static final Dependencies clone(@NotNull Dependencies dependencies, int modelLevel) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (modelLevel >= 4) {
            Dependencies dependencies2 = DependenciesImpl.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)dependencies2, (String)"EMPTY");
            return dependencies2;
        }
        List libraries = CollectionsKt.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List projects = CollectionsKt.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects, Lists.newArrayList((Iterable)dependencies.getRuntimeOnlyClasses()));
    }

    @Nullable
    public static final String getVariantName(@NotNull ResolvedArtifactResult $this$getVariantName) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariantName, (String)"<this>");
        VariantAttr variantAttr = (VariantAttr)$this$getVariantName.getVariant().getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr == null ? null : variantAttr.getName();
    }
}

