/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.Version;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.extension.impl.VariantApiOperationsRegistrar;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.api.variant.impl.GradleProperty;
import com.android.build.api.variant.impl.VariantBuilderImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.ApiObjectFactory;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.ClasspathVerifier;
import com.android.build.gradle.internal.DependencyConfigurator;
import com.android.build.gradle.internal.DependencyResolutionChecks;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.NonFinalPluginExpiry;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.attribution.BuildAttributionService;
import com.android.build.gradle.internal.crash.CrashReporting;
import com.android.build.gradle.internal.dependency.JacocoInstrumentationService;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.AbstractPublishing;
import com.android.build.gradle.internal.dsl.ApplicationPublishingImpl;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.InternalApplicationExtension;
import com.android.build.gradle.internal.dsl.InternalLibraryExtension;
import com.android.build.gradle.internal.dsl.LibraryPublishingImpl;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.IncompatibleProjectOptionsReporter;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.ide.v2.GlobalSyncService;
import com.android.build.gradle.internal.ide.v2.NativeModelBuilder;
import com.android.build.gradle.internal.lint.LintFixBuildService;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.NoOpAnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.NoOpAnalyticsService;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.Aapt2DaemonBuildService;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildService;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ClassesHierarchyBuildService;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.StringCachingBuildService;
import com.android.build.gradle.internal.services.SymbolTableBuildService;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.utils.KgpUtils;
import com.android.build.gradle.internal.utils.PublishingUtils;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.LegacyVariantInputManager;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.internal.variant.VariantModelImpl;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.v2.ide.ProjectType;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.Directory;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.slf4j.Logger;

public abstract class BasePlugin<AndroidT extends CommonExtension<?, ?, ?, ?>, AndroidComponentsT extends AndroidComponentsExtension<? extends CommonExtension<?, ?, ?, ?>, ? extends VariantBuilder, ? extends Variant>, VariantBuilderT extends VariantBuilderImpl, VariantT extends VariantImpl>
implements Plugin<Project> {
    private BaseExtension extension;
    private AndroidComponentsT androidComponentsExtension;
    private VariantManager<AndroidT, AndroidComponentsT, VariantBuilderT, VariantT> variantManager;
    private LegacyVariantInputManager variantInputModel;
    protected Project project;
    protected ProjectServices projectServices;
    protected DslServicesImpl dslServices;
    protected GlobalScope globalScope;
    protected SyncIssueReporterImpl syncIssueReporter;
    private VariantFactory<VariantBuilderT, VariantT> variantFactory;
    private final ToolingModelBuilderRegistry registry;
    private final SoftwareComponentFactory componentFactory;
    private LoggerWrapper loggerWrapper;
    protected ExtraModelInfo extraModelInfo;
    private String creator;
    private boolean hasCreatedTasks = false;
    private AnalyticsConfiguratorService configuratorService;
    private ProjectOptionService optionService;
    private final BuildEventsListenerRegistry listenerRegistry;

    public BasePlugin(ToolingModelBuilderRegistry registry, SoftwareComponentFactory componentFactory, BuildEventsListenerRegistry listenerRegistry) {
        ClasspathVerifier.checkClasspathSanity();
        this.registry = registry;
        this.componentFactory = componentFactory;
        this.creator = "Android Gradle " + Version.ANDROID_GRADLE_PLUGIN_VERSION;
        NonFinalPluginExpiry.verifyRetirementAge();
        this.listenerRegistry = listenerRegistry;
    }

    protected abstract BaseExtension createExtension(DslServices var1, GlobalScope var2, DslContainerProvider<DefaultConfig, BuildType, ProductFlavor, SigningConfig> var3, NamedDomainObjectContainer<BaseVariantOutput> var4, ExtraModelInfo var5);

    protected abstract AndroidComponentsT createComponentExtension(DslServices var1, VariantApiOperationsRegistrar<AndroidT, VariantBuilderT, VariantT> var2);

    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected abstract VariantFactory<VariantBuilderT, VariantT> createVariantFactory(ProjectServices var1, GlobalScope var2);

    protected abstract TaskManager<VariantBuilderT, VariantT> createTaskManager(List<ComponentInfo<VariantBuilderT, VariantT>> var1, List<TestComponentImpl> var2, List<TestFixturesImpl> var3, boolean var4, ProjectOptions var5, GlobalScope var6, BaseExtension var7, ProjectInfo var8);

    protected abstract int getProjectType();

    protected abstract ProjectType getProjectTypeV2();

    @VisibleForTesting
    public VariantManager<AndroidT, AndroidComponentsT, VariantBuilderT, VariantT> getVariantManager() {
        return this.variantManager;
    }

    @VisibleForTesting
    public VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> getVariantInputModel() {
        return this.variantInputModel;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    private ILogger getLogger() {
        if (this.loggerWrapper == null) {
            this.loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    public final void apply(Project project2) {
        CrashReporting.runAction(() -> {
            this.basePluginApply(project2);
            this.pluginSpecificApply(project2);
            project2.getPluginManager().apply(AndroidBasePlugin.class);
        });
    }

    private void basePluginApply(Project project2) {
        System.setProperty("java.awt.headless", "true");
        this.project = project2;
        new AndroidLocationsBuildService.RegistrationAction(project2).execute();
        this.optionService = (ProjectOptionService)new ProjectOptionService.RegistrationAction(project2).execute().get();
        this.createProjectServices(project2);
        this.checkMinJvmVersion();
        ProjectOptions projectOptions = this.projectServices.getProjectOptions();
        if (projectOptions.isAnalyticsEnabled()) {
            new AnalyticsService.RegistrationAction(project2).execute();
            this.configuratorService = (AnalyticsConfiguratorService)new AnalyticsConfiguratorService.RegistrationAction(project2).execute().get();
        } else {
            project2.getGradle().getSharedServices().registerIfAbsent(BuildServicesKt.getBuildServiceName(AnalyticsService.class), NoOpAnalyticsService.class, spec -> {});
            this.configuratorService = (AnalyticsConfiguratorService)project2.getGradle().getSharedServices().registerIfAbsent(BuildServicesKt.getBuildServiceName(AnalyticsConfiguratorService.class), NoOpAnalyticsConfiguratorService.class, spec -> {}).get();
        }
        DependencyResolutionChecks.registerDependencyCheck(project2, projectOptions);
        this.checkPathForErrors();
        String attributionFileLocation = projectOptions.get(StringOption.IDE_ATTRIBUTION_FILE_LOCATION);
        if (attributionFileLocation != null) {
            new BuildAttributionService.RegistrationAction(project2).execute();
            BuildAttributionService.Companion.init(project2, attributionFileLocation, this.listenerRegistry);
        }
        this.configuratorService.createAnalyticsService(project2, this.listenerRegistry);
        GradleBuildProject.Builder projectBuilder = this.configuratorService.getProjectBuilder(project2.getPath());
        if (projectBuilder != null) {
            projectBuilder.setAndroidPluginVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST).setOptions(AnalyticsUtil.toProto(projectOptions));
        }
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, project2.getPath(), null, this::configureProject);
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, project2.getPath(), null, this::configureExtension);
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, project2.getPath(), null, this::createTasks);
    }

    protected abstract void pluginSpecificApply(Project var1);

    private void configureProject() {
        Gradle gradle = this.project.getGradle();
        Provider stringCachingService = new StringCachingBuildService.RegistrationAction(this.project).execute();
        Provider mavenCoordinatesCacheBuildService = new MavenCoordinatesCacheBuildService.RegistrationAction(this.project, stringCachingService).execute();
        new LibraryDependencyCacheBuildService.RegistrationAction(this.project, mavenCoordinatesCacheBuildService).execute();
        new GlobalSyncService.RegistrationAction(this.project, mavenCoordinatesCacheBuildService).execute();
        this.extraModelInfo = new ExtraModelInfo();
        ProjectOptions projectOptions = this.projectServices.getProjectOptions();
        SyncIssueReporter issueReporter2 = this.projectServices.getIssueReporter();
        new Aapt2ThreadPoolBuildService.RegistrationAction(this.project, projectOptions).execute();
        new Aapt2DaemonBuildService.RegistrationAction(this.project, projectOptions).execute();
        new SyncIssueReporterImpl.GlobalSyncIssueService.RegistrationAction(this.project, SyncOptions.getModelQueryMode(projectOptions), SyncOptions.getErrorFormatMode(projectOptions)).execute();
        Provider sdkComponentsBuildService = new SdkComponentsBuildService.RegistrationAction(this.project, projectOptions).execute();
        Provider<AndroidLocationsBuildService> locationsProvider = BuildServicesKt.getBuildService(this.project.getGradle().getSharedServices(), AndroidLocationsBuildService.class);
        ProviderFactory providers = this.project.getProviders();
        Provider versionSdkLoader = sdkComponentsBuildService.map(buildService -> buildService.sdkLoader((Provider<String>)providers.provider(() -> this.extension.getCompileSdkVersion()), (Provider<Revision>)providers.provider(() -> this.extension.getBuildToolsRevision())));
        Provider avdComponentsBuildService = new AvdComponentsBuildService.RegistrationAction(this.project, (Provider<Directory>)ManagedDeviceUtilsKt.getManagedDeviceAvdFolder(this.project.getObjects(), this.project.getProviders(), (AndroidLocationsProvider)locationsProvider.get()), sdkComponentsBuildService, (Provider<String>)this.project.getProviders().provider(() -> this.extension.getCompileSdkVersion()), (Provider<Revision>)this.project.getProviders().provider(() -> this.extension.getBuildToolsRevision())).execute();
        new SymbolTableBuildService.RegistrationAction(this.project).execute();
        new ClassesHierarchyBuildService.RegistrationAction(this.project).execute();
        new LintFixBuildService.RegistrationAction(this.project).execute();
        new LintClassLoaderBuildService.RegistrationAction(this.project).execute();
        new JacocoInstrumentationService.RegistrationAction(this.project).execute();
        projectOptions.getAllOptions().forEach(this.projectServices.getDeprecationReporter()::reportOptionIssuesIfAny);
        IncompatibleProjectOptionsReporter.check(projectOptions, this.projectServices.getIssueReporter());
        GradlePluginUtils.enforceMinimumVersionsOfPlugins(this.project, issueReporter2);
        this.project.getPlugins().apply(JavaBasePlugin.class);
        this.dslServices = new DslServicesImpl(this.projectServices, sdkComponentsBuildService);
        MessageReceiverImpl messageReceiver = new MessageReceiverImpl(SyncOptions.getErrorFormatMode(projectOptions), (Logger)this.projectServices.getLogger());
        this.globalScope = new GlobalScope(this.project, this.creator, this.dslServices, sdkComponentsBuildService, avdComponentsBuildService, this.registry, messageReceiver, this.componentFactory);
        this.project.getTasks().named("assemble").configure(task -> task.setDescription("Assembles all variants of all applications and secondary packages."));
        gradle.projectsEvaluated(action -> DeprecationReporterImpl.Companion.clean());
        BasePlugin.createAndroidJdkImageConfiguration(this.project, this.globalScope);
    }

    public static void createAndroidJdkImageConfiguration(Project project2, GlobalScope globalScope) {
        Configuration config2 = (Configuration)project2.getConfigurations().create("androidJdkImage");
        config2.setVisible(false);
        config2.setCanBeConsumed(false);
        config2.setDescription("Configuration providing JDK image for compiling Java 9+ sources");
        project2.getDependencies().add("androidJdkImage", (Object)project2.files(new Object[]{globalScope.getVersionedSdkLoader().flatMap(SdkComponentsBuildService.VersionedSdkLoader::getCoreForSystemModulesProvider)}));
    }

    private void configureExtension() {
        DslServices dslServices2 = this.globalScope.getDslServices();
        NamedDomainObjectContainer buildOutputs = this.project.container(BaseVariantOutput.class);
        this.project.getExtensions().add("buildOutputs", (Object)buildOutputs);
        this.variantFactory = this.createVariantFactory(this.projectServices, this.globalScope);
        this.variantInputModel = new LegacyVariantInputManager(dslServices2, this.variantFactory.getVariantType(), new SourceSetManager(this.project, this.isPackagePublished(), dslServices2, new DelayedActionsExecutor()));
        this.extension = this.createExtension(dslServices2, this.globalScope, this.variantInputModel, (NamedDomainObjectContainer<BaseVariantOutput>)buildOutputs, this.extraModelInfo);
        this.globalScope.setExtension(this.extension);
        VariantApiOperationsRegistrar variantApiOperations = new VariantApiOperationsRegistrar((CommonExtension)this.extension);
        this.androidComponentsExtension = this.createComponentExtension(dslServices2, variantApiOperations);
        this.variantManager = new VariantManager<CommonExtension, AndroidComponentsT, VariantBuilderT, VariantT>(this.globalScope, this.project, this.projectServices.getProjectOptions(), (CommonExtension)this.extension, this.androidComponentsExtension, variantApiOperations, this.variantFactory, this.variantInputModel, this.projectServices);
        this.registerModels(this.registry, this.globalScope, this.variantInputModel, this.extension, this.extraModelInfo);
        this.variantFactory.createDefaultComponents(this.variantInputModel);
        this.createAndroidTestUtilConfiguration();
    }

    protected void registerModels(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> variantInputModel, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        VariantModel variantModel = this.createVariantModel();
        this.registerModelBuilder(registry, globalScope, variantModel, extension, extraModelInfo);
        registry.register(new com.android.build.gradle.internal.ide.v2.ModelBuilder(this.project, globalScope, this.projectServices.getProjectOptions(), variantModel, (CommonExtension)extension, this.projectServices.getIssueReporter(), this.getProjectTypeV2()));
        NativeModelBuilder nativeModelBuilderV2 = new NativeModelBuilder(this.projectServices.getIssueReporter(), this.projectServices.getProjectOptions(), globalScope, variantModel, this.projectServices.getProjectInfo());
        registry.register((ToolingModelBuilder)nativeModelBuilderV2);
    }

    private VariantModel createVariantModel() {
        return new VariantModelImpl(this.variantInputModel, (Function0<String>)((Function0)this.extension::getTestBuildType), (Function0<? extends List<? extends VariantImpl>>)((Function0)() -> this.variantManager.getMainComponents().stream().map(ComponentInfo::getVariant).collect(Collectors.toList())), (Function0<? extends List<? extends TestComponentImpl>>)((Function0)() -> this.variantManager.getTestComponents()), this.dslServices.getIssueReporter());
    }

    protected void registerModelBuilder(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantModel variantModel, BaseExtension extension, ExtraModelInfo extraModelInfo) {
        registry.register(new ModelBuilder<BaseExtension>(globalScope, variantModel, extension, extraModelInfo, this.projectServices.getProjectOptions(), this.projectServices.getIssueReporter(), this.getProjectType(), this.projectServices.getProjectInfo()));
    }

    private void createTasks() {
        this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.TASK_MANAGER_CREATE_TASKS, this.project.getPath(), null, () -> TaskManager.createTasksBeforeEvaluate(this.projectServices.getProjectOptions(), this.globalScope, this.variantFactory.getVariantType(), this.extension.getSourceSets(), this.projectServices.getProjectInfo()));
        this.project.afterEvaluate(CrashReporting.afterEvaluate(p -> {
            this.variantInputModel.getSourceSetManager().runBuildableArtifactsActions();
            this.configuratorService.recordBlock(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, this.project.getPath(), null, this::createAndroidTasks);
        }));
    }

    @VisibleForTesting
    final void createAndroidTasks() {
        if (this.extension.getCompileSdkVersion() == null) {
            if (SyncOptions.getModelQueryMode(this.projectServices.getProjectOptions()).equals((Object)SyncOptions.EvaluationMode.IDE)) {
                String newCompileSdkVersion = this.findHighestSdkInstalled();
                if (newCompileSdkVersion == null) {
                    newCompileSdkVersion = "android-30";
                }
                this.extension.setCompileSdkVersion(newCompileSdkVersion);
            }
            this.dslServices.getIssueReporter().reportError(IssueReporter.Type.COMPILE_SDK_VERSION_NOT_SET, "compileSdkVersion is not specified. Please add it to build.gradle");
        }
        Preconditions.checkState((this.extension.getCompileSdkVersion() != null ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        if (this.project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            String warningMsg = "One of the plugins you are using supports Java 8 language features. To try the support built into the Android plugin, remove the following from your build.gradle:\n    apply plugin: 'me.tatarka.retrolambda'\nTo learn more, go to https://d.android.com/r/tools/java-8-support-message.html\n";
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, warningMsg);
        }
        this.project.getRepositories().forEach(it -> {
            if (it instanceof FlatDirectoryArtifactRepository) {
                String warningMsg = String.format("Using %s should be avoided because it doesn't support any meta-data formats.", it.getName());
                this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, warningMsg);
            }
        });
        this.checkMavenPublishing();
        if (!(this.project.getState().getExecuted() && this.project.getState().getFailure() == null || SdkLocator.getSdkTestDirectory() != null)) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = true;
        this.variantManager.getVariantApiOperationsRegistrar().executeDslFinalizationBlocks();
        this.variantInputModel.lock();
        this.extension.disableWrite();
        GradleBuildProject.Builder projectBuilder = this.configuratorService.getProjectBuilder(this.project.getPath());
        if (projectBuilder != null) {
            projectBuilder.setCompileSdk(this.extension.getCompileSdkVersion()).setBuildToolsVersion(this.extension.getBuildToolsRevision().toString()).setSplits(AnalyticsUtil.toProto(this.extension.getSplits()));
            String kotlinPluginVersion = KgpUtils.getKotlinPluginVersion(this.project);
            if (kotlinPluginVersion != null) {
                projectBuilder.setKotlinPluginVersion(kotlinPluginVersion);
            }
        }
        AnalyticsUtil.recordFirebasePerformancePluginVersion(this.project);
        BuildFeatureValues buildFeatureValues = this.variantFactory.createBuildFeatureValues(this.extension.getBuildFeatures(), this.projectServices.getProjectOptions());
        this.variantManager.createVariants(buildFeatureValues);
        List<ComponentInfo<VariantBuilderT, VariantT>> variants = this.variantManager.getMainComponents();
        TaskManager<VariantBuilderT, VariantT> taskManager = this.createTaskManager(variants, this.variantManager.getTestComponents(), this.variantManager.getTestFixturesComponents(), !this.variantInputModel.getProductFlavors().isEmpty(), this.projectServices.getProjectOptions(), this.globalScope, this.extension, this.projectServices.getProjectInfo());
        taskManager.createTasks(this.variantFactory.getVariantType(), this.createVariantModel());
        new DependencyConfigurator(this.project, this.project.getName(), this.projectServices.getProjectOptions(), this.globalScope, this.variantInputModel, this.projectServices).configureDependencySubstitutions().configureDependencyChecks().configureGeneralTransforms().configureVariantTransforms(variants, this.variantManager.getNestedComponents()).configureAttributeMatchingStrategies();
        ApiObjectFactory apiObjectFactory = new ApiObjectFactory(this.extension, this.variantFactory, this.globalScope);
        for (ComponentInfo<VariantBuilderT, VariantT> componentInfo : variants) {
            apiObjectFactory.create((VariantImpl)componentInfo.getVariant());
        }
        this.variantManager.lockVariantProperties();
        this.variantInputModel.getSourceSetManager().checkForUnconfiguredSourceSets();
        KgpUtils.syncAgpAndKgpSources(this.project, this.extension.getSourceSets());
        taskManager.createPostApiTasks();
        for (ComponentInfo<VariantBuilderT, VariantT> componentInfo : variants) {
            ((VariantImpl)componentInfo.getVariant()).publishBuildArtifacts();
        }
        for (TestFixturesImpl testFixturesImpl : this.variantManager.getTestFixturesComponents()) {
            testFixturesImpl.publishBuildArtifacts();
        }
        this.checkSplitConfiguration();
        this.variantManager.setHasCreatedTasks(true);
        for (ComponentInfo componentInfo : variants) {
            ((VariantImpl)componentInfo.getVariant()).getArtifacts().ensureAllOperationsAreSatisfied();
        }
        GradleProperty.Companion.endOfEvaluation();
    }

    private String findHighestSdkInstalled() {
        String highestSdk = null;
        File folder = new File(SdkComponentsKt.getSdkDir(this.project.getRootDir(), this.syncIssueReporter), "platforms");
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            Arrays.sort(listOfFiles, Comparator.comparing(File::getName).reversed());
            for (File file : listOfFiles) {
                if (AndroidTargetHash.getPlatformVersion((String)file.getName()) == null) continue;
                highestSdk = file.getName();
                break;
            }
        }
        return highestSdk;
    }

    private void checkSplitConfiguration() {
        boolean splitsEnabled;
        String configApkUrl = "https://d.android.com/topic/instant-apps/guides/config-splits.html";
        boolean generatePureSplits = this.extension.getGeneratePureSplits();
        Splits splits = this.extension.getSplits();
        boolean bl = splitsEnabled = splits.getDensity().isEnable() || splits.getAbi().isEnable() || splits.getLanguage().isEnable();
        if (generatePureSplits) {
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, "Configuration APKs are supported by the Google Play Store only when publishing Android Instant Apps. To instead generate stand-alone APKs for different device configurations, set generatePureSplits=false. For more information, go to " + configApkUrl);
        }
        if (!generatePureSplits && splits.getLanguage().isEnable()) {
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, "Per-language APKs are supported only when building Android Instant Apps. For more information, go to " + configApkUrl);
        }
    }

    private void checkPathForErrors() {
        if (!System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        if (this.projectServices.getProjectOptions().get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY)) {
            return;
        }
        if (CharMatcher.ascii().matchesAllOf((CharSequence)this.project.getRootDir().getAbsolutePath())) {
            return;
        }
        String message = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line '" + BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY.getPropertyName() + "=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message);
    }

    protected boolean isPackagePublished() {
        return false;
    }

    private void createAndroidTestUtilConfiguration() {
        this.project.getLogger().debug("Creating configuration androidTestUtil");
        Configuration configuration = (Configuration)this.project.getConfigurations().maybeCreate("androidTestUtil");
        configuration.setVisible(false);
        configuration.setDescription("Additional APKs used during instrumentation testing.");
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(true);
    }

    private void createProjectServices(Project project2) {
        ObjectFactory objectFactory = project2.getObjects();
        org.gradle.api.logging.Logger logger = project2.getLogger();
        String projectPath = project2.getPath();
        ProjectOptions projectOptions = this.optionService.getProjectOptions();
        this.syncIssueReporter = new SyncIssueReporterImpl(SyncOptions.getModelQueryMode(projectOptions), SyncOptions.getErrorFormatMode(projectOptions), logger);
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(this.syncIssueReporter, projectOptions, projectPath);
        Aapt2FromMaven aapt2FromMaven = Aapt2FromMaven.create(project2, projectOptions);
        LintFromMaven lintFromMaven = LintFromMaven.from(project2, projectOptions, this.syncIssueReporter);
        this.projectServices = new ProjectServices(this.syncIssueReporter, deprecationReporter, objectFactory, project2.getLogger(), project2.getProviders(), project2.getLayout(), projectOptions, project2.getGradle().getSharedServices(), lintFromMaven, aapt2FromMaven, project2.getGradle().getStartParameter().getMaxWorkerCount(), new ProjectInfo(project2), (Function1<Object, ? extends File>)((Function1)arg_0 -> ((Project)project2).file(arg_0)));
    }

    private void checkMinJvmVersion() {
        JavaVersion minRequired;
        JavaVersion current = JavaVersion.current();
        if (!current.isCompatibleWith(minRequired = JavaVersion.VERSION_11)) {
            this.syncIssueReporter.reportError(IssueReporter.Type.AGP_USED_JAVA_VERSION_TOO_LOW, "Android Gradle plugin requires Java " + minRequired.toString() + " to run. You are currently using Java " + current.toString() + ".\nYour current JDK is located in  " + System.getProperty("java.home") + "\nYou can try some of the following options:\n  - changing the IDE settings.\n  - changing the JAVA_HOME environment variable.\n  - changing `org.gradle.java.home` in `gradle.properties`.");
        }
    }

    private void checkMavenPublishing() {
        if (this.project.getPlugins().hasPlugin("maven-publish")) {
            if (this.extension instanceof InternalApplicationExtension) {
                this.checkSoftwareComponents((ApplicationPublishingImpl)((InternalApplicationExtension)((Object)this.extension)).getPublishing());
            }
            if (this.extension instanceof InternalLibraryExtension) {
                this.checkSoftwareComponents((LibraryPublishingImpl)((InternalLibraryExtension)((Object)this.extension)).getPublishing());
            }
        }
    }

    private void checkSoftwareComponents(AbstractPublishing publishing) {
        boolean optIn = PublishingUtils.publishingFeatureOptIn(publishing, this.dslServices.getProjectOptions());
        if (!optIn) {
            String warning = "Software Components will not be created automatically for Maven publishing from Android Gradle Plugin 8.0. To opt-in to the future behavior, set the Gradle property android.disableAutomaticComponentCreation=true in the `gradle.properties` file or use the new publishing DSL.";
            this.dslServices.getIssueReporter().reportWarning(IssueReporter.Type.GENERIC, warning);
        }
    }
}

