/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.variant.impl.ApplicationVariantImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.packaging.JarCreatorFactory;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.MergeNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.packaging.JarCreator;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "Companion", "CreationAction", "MergeNativeDebugMetadataWorkAction", "gradle-core"})
public abstract class MergeNativeDebugMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final PatternSet patternSet;

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(MergeNativeDebugMetadataWorkAction.class, new Action(this){
            final /* synthetic */ MergeNativeDebugMetadataTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(MergeNativeDebugMetadataWorkAction.Parameters it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                Object[] objectArray = new Object[]{this.this$0.getInputFiles()};
                it.getInputFiles().from(objectArray);
                it.getOutputFile().set((Provider)this.this$0.getOutputFile());
            }
        });
    }

    static {
        String[] stringArray = new String[]{"**/*.dbg"};
        PatternSet patternSet = new PatternSet().include(stringArray);
        stringArray = new String[]{"**/*.sym"};
        MergeNativeDebugMetadataTask.patternSet = patternSet.include(stringArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$MergeNativeDebugMetadataWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$MergeNativeDebugMetadataWorkAction$Parameters;", "()V", "run", "", "Parameters", "gradle-core"})
    public static abstract class MergeNativeDebugMetadataWorkAction
    extends ProfileAwareWorkAction<Parameters> {
        @Override
        public void run() {
            Object object = ((Parameters)this.getParameters()).getInputFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.inputFiles.files");
            Collection collection = (Collection)object;
            object = ((Parameters)this.getParameters()).getOutputFile().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.outputFile.asFile.get()");
            Companion.mergeFiles$gradle_core(collection, (File)object);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$MergeNativeDebugMetadataWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "inputFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInputFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
        public static abstract class Parameters
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract ConfigurableFileCollection getInputFiles();

            @NotNull
            public abstract RegularFileProperty getOutputFile();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ#\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$Companion;", "", "()V", "patternSet", "Lorg/gradle/api/tasks/util/PatternSet;", "kotlin.jvm.PlatformType", "getNativeDebugMetadataFiles", "Lorg/gradle/api/file/FileCollection;", "variant", "Lcom/android/build/api/variant/impl/ApplicationVariantImpl;", "mergeFiles", "", "inputFiles", "", "Ljava/io/File;", "outputFile", "mergeFiles$gradle_core", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public final void mergeFiles$gradle_core(@NotNull Collection<? extends File> inputFiles2, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter(inputFiles2, (String)"inputFiles");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            FileUtils.deleteIfExists((File)outputFile);
            Object object = outputFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFile.toPath()");
            object = (Closeable)JarCreatorFactory.make$default(JarCreatorFactory.INSTANCE, (Path)object, null, null, 6, null);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                JarCreator zipCreator = (JarCreator)object;
                boolean bl3 = false;
                Iterable $this$forEach$iv = inputFiles2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl4 = false;
                    zipCreator.addFile(it.getParentFile().getName() + '/' + it.getName(), it.toPath());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        @NotNull
        public final FileCollection getNativeDebugMetadataFiles(@NotNull ApplicationVariantImpl variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            ConfigurableFileCollection nativeDebugMetadataDirs = variant2.getServices().fileCollection();
            NdkOptions.DebugSymbolLevel debugSymbolLevel = variant2.getNativeDebugSymbolLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[debugSymbolLevel.ordinal()];
            switch (n) {
                case 1: {
                    Object[] objectArray = new Object[]{variant2.getArtifacts().get(InternalArtifactType.NATIVE_DEBUG_METADATA.INSTANCE)};
                    nativeDebugMetadataDirs.from(objectArray);
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(variant2.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_NATIVE_DEBUG_METADATA, null, 8, null)};
                    nativeDebugMetadataDirs.from(objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Object[]{variant2.getArtifacts().get(InternalArtifactType.NATIVE_SYMBOL_TABLES.INSTANCE)};
                    nativeDebugMetadataDirs.from(objectArray);
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(variant2.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_NATIVE_SYMBOL_TABLES, null, 8, null)};
                    nativeDebugMetadataDirs.from(objectArray);
                }
            }
            nativeDebugMetadataDirs.disallowChanges();
            debugSymbolLevel = nativeDebugMetadataDirs.getAsFileTree().matching((PatternFilterable)patternSet);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)debugSymbolLevel), (String)"nativeDebugMetadataDirs.\u2026Tree.matching(patternSet)");
            return (FileCollection)debugSymbolLevel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NdkOptions.DebugSymbolLevel.values().length];
                nArray[NdkOptions.DebugSymbolLevel.FULL.ordinal()] = 1;
                nArray[NdkOptions.DebugSymbolLevel.SYMBOL_TABLE.ordinal()] = 2;
                nArray[NdkOptions.DebugSymbolLevel.NONE.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/MergeNativeDebugMetadataTask;", "Lcom/android/build/api/variant/impl/ApplicationVariantImpl;", "componentProperties", "(Lcom/android/build/api/variant/impl/ApplicationVariantImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<MergeNativeDebugMetadataTask, ApplicationVariantImpl> {
        public CreationAction(@NotNull ApplicationVariantImpl componentProperties) {
            Intrinsics.checkNotNullParameter((Object)componentProperties, (String)"componentProperties");
            super((ComponentCreationConfig)componentProperties);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("merge", "NativeDebugMetadata");
        }

        @Override
        @NotNull
        public Class<MergeNativeDebugMetadataTask> getType() {
            return MergeNativeDebugMetadataTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<MergeNativeDebugMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApplicationVariantImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("native-debug-symbols.zip").on(InternalArtifactType.MERGED_NATIVE_DEBUG_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull MergeNativeDebugMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{Companion.getNativeDebugMetadataFiles((ApplicationVariantImpl)this.creationConfig)};
            HasConfigurableValuesKt.fromDisallowChanges(task.getInputFiles(), objectArray);
        }
    }
}

