/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.component.impl.AndroidTestImpl;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.dsl.BuildFeatures;
import com.android.build.api.dsl.TestBuildFeatures;
import com.android.build.api.dsl.TestExtension;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.impl.FilterConfigurationImpl;
import com.android.build.api.variant.impl.TestVariantBuilderImpl;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.api.variant.impl.VariantOutputConfigurationImpl;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.dsl.ModulePropertyKeys;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.BuildFeatureValuesImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TestFixturesBuildFeaturesValuesImpl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.services.VariantApiServices;
import com.android.build.gradle.internal.services.VariantPropertiesApiServices;
import com.android.build.gradle.internal.variant.AbstractAppVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class TestVariantFactory
extends AbstractAppVariantFactory<TestVariantBuilderImpl, TestVariantImpl> {
    public TestVariantFactory(ProjectServices projectServices2, GlobalScope globalScope) {
        super(projectServices2, globalScope);
    }

    @Override
    public TestVariantBuilderImpl createVariantBuilder(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantApiServices variantApiServices) {
        return (TestVariantBuilderImpl)this.projectServices.getObjectFactory().newInstance(TestVariantBuilderImpl.class, new Object[]{variantDslInfo, componentIdentity, variantApiServices});
    }

    @Override
    public TestVariantImpl createVariant(TestVariantBuilderImpl variantBuilder, ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo<?> variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, BaseVariantData variantData, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices, AndroidComponentsExtension<?, ?, ?> androidComponentsExtension) {
        TestVariantImpl variant2 = (TestVariantImpl)this.projectServices.getObjectFactory().newInstance(TestVariantImpl.class, new Object[]{variantBuilder, buildFeatures, variantDslInfo, variantDependencies, variantSources, paths, artifacts2, variantScope, variantData, transformManager, variantPropertiesApiServices, taskCreationServices, androidComponentsExtension.getSdkComponents(), this.globalScope});
        variant2.addVariantOutput(new VariantOutputConfigurationImpl(false, (Collection<FilterConfigurationImpl>)ImmutableList.of()), null);
        return variant2;
    }

    @Override
    public BuildFeatureValues createBuildFeatureValues(BuildFeatures buildFeatures, ProjectOptions projectOptions) {
        if (buildFeatures instanceof TestBuildFeatures) {
            return new BuildFeatureValuesImpl(buildFeatures, projectOptions, false, false);
        }
        throw new RuntimeException("buildFeatures not of type TestBuildFeatures");
    }

    @Override
    public BuildFeatureValues createTestFixturesBuildFeatureValues(BuildFeatures buildFeatures, ProjectOptions projectOptions) {
        if (buildFeatures instanceof TestBuildFeatures) {
            return new TestFixturesBuildFeaturesValuesImpl(buildFeatures, projectOptions, false, false);
        }
        throw new RuntimeException("buildFeatures not of type TestBuildFeatures");
    }

    @Override
    public BuildFeatureValues createTestBuildFeatureValues(BuildFeatures buildFeatures, DataBindingOptions dataBindingOptions, ProjectOptions projectOptions) {
        throw new RuntimeException("cannot instantiate test build features in test plugin");
    }

    @Override
    public UnitTestImpl createUnitTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo<?> variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestVariantData variantData, VariantImpl testedVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices, AndroidComponentsExtension<?, ?, ?> androidComponentsExtension) {
        throw new RuntimeException("cannot instantiate unit-test properties in test plugin");
    }

    @Override
    public AndroidTestImpl createAndroidTest(ComponentIdentity componentIdentity, BuildFeatureValues buildFeatures, VariantDslInfo<?> variantDslInfo, VariantDependencies variantDependencies, VariantSources variantSources, VariantPathHelper paths, ArtifactsImpl artifacts2, VariantScope variantScope, TestVariantData variantData, VariantImpl testedVariant, TransformManager transformManager, VariantPropertiesApiServices variantPropertiesApiServices, TaskCreationServices taskCreationServices, AndroidComponentsExtension<?, ?, ?> androidComponentsExtension) {
        throw new RuntimeException("cannot instantiate android-test properties in test plugin");
    }

    @Override
    public void preVariantWork(Project project2) {
        super.preVariantWork(project2);
        TestExtension testExtension = (TestExtension)this.globalScope.getExtension();
        String path = testExtension.getTargetProjectPath();
        if (path == null) {
            throw new GradleException("targetProjectPath cannot be null in test project " + project2.getName());
        }
        DependencyHandler handler2 = project2.getDependencies();
        ImmutableMap projectNotation = ImmutableMap.of((Object)"path", (Object)path);
        if (!ModulePropertyKeys.SELF_INSTRUMENTING.getValueAsBoolean(testExtension.getExperimentalProperties())) {
            handler2.add("compileOnly", (Object)handler2.project((Map)projectNotation));
        }
        Configuration testedApks = (Configuration)project2.getConfigurations().maybeCreate("testedApks");
        testedApks.setCanBeConsumed(false);
        testedApks.setCanBeResolved(false);
        handler2.add("testedApks", (Object)handler2.project((Map)projectNotation));
    }

    @Override
    public void createDefaultComponents(DslContainerProvider dslContainers) {
        dslContainers.getSigningConfigContainer().create("debug");
        dslContainers.getBuildTypeContainer().create("debug");
    }

    @Override
    public VariantType getVariantType() {
        return VariantTypeImpl.TEST_APK;
    }
}

