/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.store.FeatureInfoList;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.databinding.ExportNamespacesParams;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.tooling.BuildException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/databinding/ExportNamespacesRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/databinding/ExportNamespacesParams;", "()V", "run", "", "gradle-core"})
public abstract class ExportNamespacesRunnable
extends ProfileAwareWorkAction<ExportNamespacesParams> {
    @Override
    public void run() {
        boolean bl = false;
        Set packages = new LinkedHashSet();
        for (File featureSplitDeclaration : (Set)((ExportNamespacesParams)this.getParameters()).getFeatureDeclarations().get()) {
            try {
                Object object = FeatureSplitDeclaration.load(featureSplitDeclaration);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"load(featureSplitDeclaration)");
                FeatureSplitDeclaration loaded = object;
                object = loaded.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"loaded.namespace");
                packages.add(object);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Cannot read features split declaration file", (Throwable)e);
            }
        }
        File outputFolder = ((Directory)((ExportNamespacesParams)this.getParameters()).getPackageListOutFolder().get()).getAsFile();
        FileUtils.cleanOutputDir((File)outputFolder);
        outputFolder.mkdirs();
        new FeatureInfoList(packages).serialize(new File(outputFolder, "all_features.json"));
    }
}

