/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.EncodedLoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.string.StringDecoder;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.utils.cxx.CxxBugDiagnosticCode;
import com.android.utils.cxx.CxxDiagnosticCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a4\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0012\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0017\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0003*\u00020\u0001\u00a8\u0006\u001b"}, d2={"bugRecordOf", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "message", "", "diagnosticCode", "Lcom/android/utils/cxx/CxxBugDiagnosticCode;", "createLoggingMessage", "level", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage$LoggingLevel;", "tag", "file", "", "decodeLoggingMessage", "encoded", "Lcom/android/build/gradle/internal/cxx/logging/EncodedLoggingMessage;", "decoder", "Lcom/android/build/gradle/internal/cxx/string/StringDecoder;", "errorRecordOf", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "infoRecordOf", "lifecycleRecordOf", "warnRecordOf", "decode", "encode", "encoder", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "text", "gradle-core"})
public final class LoggingMessageKt {
    @NotNull
    public static final LoggingMessage createLoggingMessage(@NotNull LoggingMessage.LoggingLevel level, @NotNull String message, @NotNull String tag, @NotNull String file, int diagnosticCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LoggingMessage loggingMessage = LoggingMessage.newBuilder().setLevel(level).setMessage(message).setTag(tag).setFile(file).setDiagnosticCode(diagnosticCode).build();
        Intrinsics.checkNotNullExpressionValue((Object)loggingMessage, (String)"newBuilder()\n        .se\u2026ticCode)\n        .build()");
        return loggingMessage;
    }

    public static /* synthetic */ LoggingMessage createLoggingMessage$default(LoggingMessage.LoggingLevel loggingLevel, String string, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return LoggingMessageKt.createLoggingMessage(loggingLevel, string, string2, string3, n);
    }

    @NotNull
    public static final EncodedLoggingMessage encode(@NotNull LoggingMessage $this$encode, @NotNull StringEncoder encoder) {
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        EncodedLoggingMessage.Builder builder = EncodedLoggingMessage.newBuilder().setLevel($this$encode.getLevel());
        String string = $this$encode.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
        EncodedLoggingMessage.Builder builder2 = builder.setMessageId(encoder.encode(string));
        string = $this$encode.getTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tag");
        EncodedLoggingMessage.Builder builder3 = builder2.setTagId(encoder.encode(string));
        string = $this$encode.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file");
        EncodedLoggingMessage encodedLoggingMessage = builder3.setFileId(encoder.encode(string)).setDiagnosticCode($this$encode.getDiagnosticCode()).build();
        Intrinsics.checkNotNullExpressionValue((Object)encodedLoggingMessage, (String)"newBuilder()\n        .se\u2026ticCode)\n        .build()");
        return encodedLoggingMessage;
    }

    @NotNull
    public static final LoggingMessage decode(@NotNull EncodedLoggingMessage $this$decode, @NotNull StringDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        LoggingMessage loggingMessage = LoggingMessage.newBuilder().setLevel($this$decode.getLevel()).setMessage(decoder.decode($this$decode.getMessageId())).setTag(decoder.decode($this$decode.getTagId())).setFile(decoder.decode($this$decode.getFileId())).setDiagnosticCode($this$decode.getDiagnosticCode()).build();
        Intrinsics.checkNotNullExpressionValue((Object)loggingMessage, (String)"newBuilder()\n        .se\u2026ticCode)\n        .build()");
        return loggingMessage;
    }

    @NotNull
    public static final LoggingMessage decodeLoggingMessage(@NotNull EncodedLoggingMessage encoded, @NotNull StringDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return LoggingMessageKt.decode(encoded, decoder);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String text(@NotNull LoggingMessage $this$text) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        int n = $this$text.getDiagnosticCode();
        if (n == 0) {
            string2 = "C/C++: ";
        } else {
            LoggingMessage.LoggingLevel loggingLevel = $this$text.getLevel();
            int n2 = loggingLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()];
            string2 = n2 == 1 ? "[bug " + $this$text.getDiagnosticCode() + "] " : "[CXX" + $this$text.getDiagnosticCode() + "] ";
        }
        String codeHeader = string2;
        String string3 = $this$text.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file");
        if (StringsKt.isBlank((CharSequence)string3)) {
            String string4 = $this$text.getTag();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tag");
            if (StringsKt.isBlank((CharSequence)string4)) {
                string = Intrinsics.stringPlus((String)codeHeader, (Object)$this$text.getMessage());
                return string;
            }
        }
        String string5 = $this$text.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"file");
        CharSequence charSequence = string5;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            String string6 = $this$text.getTag();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"tag");
            if (StringsKt.isBlank((CharSequence)string6)) {
                string = codeHeader + $this$text.getFile() + " : " + $this$text.getMessage();
                return string;
            }
        }
        String string7 = $this$text.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"file");
        if (StringsKt.isBlank((CharSequence)string7)) {
            String string8 = $this$text.getTag();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"tag");
            CharSequence charSequence2 = string8;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                string = codeHeader + $this$text.getTag() + " : " + $this$text.getMessage();
                return string;
            }
        }
        string = codeHeader + $this$text.getFile() + ' ' + $this$text.getTag() + " : " + $this$text.getMessage();
        return string;
    }

    @NotNull
    public static final LoggingMessage bugRecordOf(@NotNull String message, @NotNull CxxBugDiagnosticCode diagnosticCode) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
        return LoggingMessageKt.createLoggingMessage$default(LoggingMessage.LoggingLevel.BUG, message, null, null, diagnosticCode.getBugNumber(), 12, null);
    }

    @NotNull
    public static final LoggingMessage errorRecordOf(@NotNull String message, @Nullable CxxDiagnosticCode diagnosticCode) {
        int n;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CxxDiagnosticCode cxxDiagnosticCode = diagnosticCode;
        return LoggingMessageKt.createLoggingMessage$default(LoggingMessage.LoggingLevel.ERROR, message, null, null, cxxDiagnosticCode == null ? 0 : (n = cxxDiagnosticCode.getErrorCode()), 12, null);
    }

    @NotNull
    public static final LoggingMessage warnRecordOf(@NotNull String message, @Nullable CxxDiagnosticCode diagnosticCode) {
        int n;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CxxDiagnosticCode cxxDiagnosticCode = diagnosticCode;
        return LoggingMessageKt.createLoggingMessage$default(LoggingMessage.LoggingLevel.WARN, message, null, null, cxxDiagnosticCode == null ? 0 : (n = cxxDiagnosticCode.getWarningCode()), 12, null);
    }

    @NotNull
    public static final LoggingMessage lifecycleRecordOf(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return LoggingMessageKt.createLoggingMessage$default(LoggingMessage.LoggingLevel.LIFECYCLE, message, null, null, 0, 28, null);
    }

    @NotNull
    public static final LoggingMessage infoRecordOf(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return LoggingMessageKt.createLoggingMessage$default(LoggingMessage.LoggingLevel.INFO, message, null, null, 0, 28, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoggingMessage.LoggingLevel.values().length];
            nArray[LoggingMessage.LoggingLevel.BUG.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

