/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.ide.common.process.ProcessInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0012"}, d2={"prefabConfigurationPackages", "", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getPrefabConfigurationPackages", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;)Ljava/util/List;", "generatePrefabPackages", "", "ops", "Lorg/gradle/process/ExecOperations;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "toFinalPrefabPackage", "", "from", "translateFromConfigurationToFinal", "configureOutput", "finalOutput", "gradle-core"})
public final class GeneratePrefabPackagesKt {
    /*
     * WARNING - void declaration
     */
    public static final void generatePrefabPackages(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        NativeBuildSystem nativeBuildSystem = abi.getVariant().getModule().getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                string = "ndk-build";
                break;
            }
            case 2: {
                string = "cmake";
                break;
            }
            default: {
                String string2 = String.valueOf((Object)abi.getVariant().getModule().getBuildSystem());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        String buildSystem = string;
        int osVersion = abi.getAbiPlatformVersion();
        File file = CreateCxxVariantModelKt.getPrefabClassPath(abi.getVariant());
        if (file == null) {
            throw new RuntimeException("CxxAbiModule.prefabClassPath cannot be null when Prefab is used");
        }
        File prefabClassPath = file;
        File configureOutput = FilesKt.resolve((File)abi.getPrefabFolder(), (String)"prefab-configure");
        File finalOutput = FilesKt.resolve((File)abi.getPrefabFolder(), (String)"prefab");
        Iterable iterable = GeneratePrefabPackagesKt.getPrefabConfigurationPackages(abi.getVariant());
        ProcessInfoBuilder processInfoBuilder = new ProcessInfoBuilder().setClasspath(prefabClassPath.toString()).setMain("com.google.prefab.cli.AppKt").addArgs("--build-system", buildSystem).addArgs("--platform", "android").addArgs("--abi", abi.getAbi().getTag()).addArgs("--os-version", String.valueOf(osVersion)).addArgs("--stl", abi.getVariant().getStlType()).addArgs("--ndk-version", String.valueOf(abi.getVariant().getModule().getNdkVersion().getMajor())).addArgs("--output", configureOutput.getPath());
        boolean $i$f$map = false;
        void var10_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.getPath();
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        ProcessInfoBuilder builder = processInfoBuilder.addArgs((List)collection);
        File file3 = FilesKt.resolve((File)abi.getSoFolder(), (String)("prefab_command_" + buildSystem + '_' + abi.getAbi().getTag() + ".txt"));
        File file4 = FilesKt.resolve((File)abi.getSoFolder(), (String)("prefab_stdout_" + buildSystem + '_' + abi.getAbi().getTag() + ".txt"));
        File file5 = FilesKt.resolve((File)abi.getSoFolder(), (String)("prefab_stderr_" + buildSystem + '_' + abi.getAbi().getTag() + ".txt"));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        ProcessOutputJunctionKt.createProcessOutputJunction(file3, file4, file5, builder, "prefab").javaProcess().logStderr().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super JavaExecSpec>, ExecResult>((Object)ops2){

            public final ExecResult invoke(Action<? super JavaExecSpec> p0) {
                return ((ExecOperations)this.receiver).javaexec(p0);
            }
        }));
        GeneratePrefabPackagesKt.translateFromConfigurationToFinal(configureOutput, finalOutput);
    }

    private static final void translateFromConfigurationToFinal(File configureOutput, File finalOutput) {
        for (File configureFile : FilesKt.walkTopDown((File)configureOutput)) {
            File relativeFile = FilesKt.relativeTo((File)configureFile, (File)configureOutput);
            File finalFile = FilesKt.resolve((File)finalOutput, (File)relativeFile);
            if (configureFile.isDirectory()) {
                finalFile.mkdirs();
                continue;
            }
            String string = FilesKt.getExtension((File)relativeFile);
            if (Intrinsics.areEqual((Object)string, (Object)"cmake")) {
                StringBuilder sb = new StringBuilder();
                FilesKt.forEachLine$default((File)configureFile, null, (Function1)((Function1)new Function1<String, Unit>(sb){
                    final /* synthetic */ StringBuilder $sb;
                    {
                        this.$sb = $sb;
                        super(1);
                    }

                    public final void invoke(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        StringBuilder stringBuilder = this.$sb;
                        String string = StringsKt.contains$default((CharSequence)line, (CharSequence)"IMPORTED_LOCATION", (boolean)false, (int)2, null) ? GeneratePrefabPackagesKt.access$toFinalPrefabPackage(line) : line;
                        boolean bl = false;
                        StringBuilder stringBuilder2 = stringBuilder.append(string);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        StringBuilder stringBuilder3 = stringBuilder2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                    }
                }), (int)1, null);
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
                FilesKt.writeText$default((File)finalFile, (String)string2, null, (int)2, null);
                continue;
            }
            FilesKt.copyTo$default((File)configureFile, (File)finalFile, (boolean)false, (int)0, (int)6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getPrefabConfigurationPackages(@NotNull CxxVariantModel $this$prefabConfigurationPackages) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$prefabConfigurationPackages, (String)"<this>");
        Iterable $this$map$iv = CreateCxxVariantModelKt.getPrefabPackageConfigurationDirectoriesList($this$prefabConfigurationPackages);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            String string2 = GeneratePrefabPackagesKt.toFinalPrefabPackage(string);
            collection.add(string2);
        }
        Set coveredByConfigurationPackage = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = CreateCxxVariantModelKt.getPrefabPackageDirectoryList($this$prefabConfigurationPackages);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(!coveredByConfigurationPackage.contains(it.getPath()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List aarPackages = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)CreateCxxVariantModelKt.getPrefabPackageConfigurationDirectoriesList($this$prefabConfigurationPackages), (Iterable)aarPackages);
    }

    private static final String toFinalPrefabPackage(String from) {
        return StringsKt.replaceFirst$default((String)from, (String)"prefab_package_configuration", (String)"prefab_package", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ String access$toFinalPrefabPackage(String from) {
        return GeneratePrefabPackagesKt.toFinalPrefabPackage(from);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 1;
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

