/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.res.shrinker.LinkedResourcesFormat;
import com.android.build.gradle.internal.res.shrinker.LoggerAndFileDebugReporter;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerImpl;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.gatherer.ProtoResourceTableGatherer;
import com.android.build.gradle.internal.res.shrinker.graph.ProtoResourcesGraphBuilder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ProguardMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.DexUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ProtoAndroidManifestUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2DaemonServiceKey;
import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesTask;
import com.android.build.gradle.internal.transforms.ShrinkProtoResourcesParams;
import com.android.build.gradle.internal.workeractions.WorkActionAdapter;
import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkProtoResourcesAction;", "Lcom/android/build/gradle/internal/workeractions/WorkActionAdapter;", "Lcom/android/build/gradle/internal/transforms/ShrinkProtoResourcesParams;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "doExecute", "", "toKbString", "", "size", "", "gradle-core"})
public abstract class ShrinkProtoResourcesAction
implements WorkActionAdapter<ShrinkProtoResourcesParams> {
    private final Logger logger = Logging.getLogger(ShrinkAppBundleResourcesTask.class);

    @Inject
    public ShrinkProtoResourcesAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void doExecute() {
        boolean bl;
        Aapt2DaemonServiceKey aapt2ServiceKey = (Aapt2DaemonServiceKey)((ShrinkProtoResourcesParams)this.getParameters()).getAapt2ServiceKey().get();
        File originalFile = ((RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getOriginalFile().get()).getAsFile();
        File originalProtoFile = ((RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getOriginalProtoFile().get()).getAsFile();
        File shrunkProtoFile = ((RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getShrunkProtoFile().get()).getAsFile();
        File shrunkFile = ((RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getOutputFile().get()).getAsFile();
        FileUtils.mkdirs((File)shrunkFile.getParentFile());
        Object object = ((ShrinkProtoResourcesParams)this.getParameters()).getRequiresInitialConversionToProto().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.requiresInitialConversionToProto.get()");
        if (((Boolean)object).booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)aapt2ServiceKey, (String)"aapt2ServiceKey");
            object = (Closeable)Aapt2Daemon.getAaptDaemon$default(aapt2ServiceKey, null, 2, null);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Aapt2DaemonManager.LeasedAaptDaemon it = (Aapt2DaemonManager.LeasedAaptDaemon)object;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)originalFile, (String)"originalFile");
                Intrinsics.checkNotNullExpressionValue((Object)originalProtoFile, (String)"originalProtoFile");
                it.convert(new AaptConvertConfig(originalFile, originalProtoFile, true), (ILogger)new LoggerWrapper(this.logger));
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        object = FileUtils.createZipFilesystem((Path)originalProtoFile.toPath());
        bl = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            ProguardMappingsRecorder proguardMappingsRecorder;
            boolean bl5;
            Object object2;
            Path $this$mapTo$iv$iv;
            FileSystem fs = (FileSystem)object;
            boolean bl6 = false;
            Object object3 = ((ShrinkProtoResourcesParams)this.getParameters()).getDex().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.dex.get()");
            Iterable $this$map$iv = (Iterable)object3;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object2 = (Directory)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl5 = false;
                Path path = it.getAsFile().toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.asFile.toPath()");
                DexUsageRecorder dexUsageRecorder = new DexUsageRecorder(path);
                collection.add(dexUsageRecorder);
            }
            List dexRecorders = (List)destination$iv$iv;
            Path $i$f$map22 = fs.getPath("AndroidManifest.xml", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"fs.getPath(\"AndroidManifest.xml\")");
            ProtoAndroidManifestUsageRecorder manifestRecorder = new ProtoAndroidManifestUsageRecorder($i$f$map22);
            $this$mapTo$iv$iv = ((File)((ShrinkProtoResourcesParams)this.getParameters()).getResourceDir().getAsFile().get()).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"parameters.resourceDir.asFile.get().toPath()");
            ToolsAttributeUsageRecorder toolsRecorder = new ToolsAttributeUsageRecorder($this$mapTo$iv$iv);
            destination$iv$iv = fs.getPath("resources.pb", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"fs.getPath(\"resources.pb\")");
            ProtoResourceTableGatherer gatherer = new ProtoResourceTableGatherer((Path)destination$iv$iv);
            Path $i$f$mapTo22 = fs.getPath("res", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo22, (String)"fs.getPath(\"res\")");
            Path path = $i$f$mapTo22;
            $i$f$mapTo22 = fs.getPath("resources.pb", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo22, (String)"fs.getPath(\"resources.pb\")");
            ProtoResourcesGraphBuilder graphBuilder = new ProtoResourcesGraphBuilder(path, $i$f$mapTo22);
            Object object4 = (RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getMappingFileSrc().getOrNull();
            if (object4 == null) {
                proguardMappingsRecorder = null;
            } else {
                File file = object4.getAsFile();
                if (file == null) {
                    proguardMappingsRecorder = null;
                } else {
                    object2 = file;
                    bl5 = false;
                    boolean bl7 = false;
                    Object it = object2;
                    boolean bl8 = false;
                    Path path2 = ((File)it).toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it.toPath()");
                    ProguardMappingsRecorder proguardMappingsRecorder2 = new ProguardMappingsRecorder(path2);
                    proguardMappingsRecorder = proguardMappingsRecorder2;
                }
            }
            ProguardMappingsRecorder obfuscationMappings = proguardMappingsRecorder;
            List list = CollectionsKt.listOf((Object)gatherer);
            ObfuscationMappingsRecorder obfuscationMappingsRecorder = obfuscationMappings;
            List list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)dexRecorders, (Object)manifestRecorder), (Object)toolsRecorder);
            List list3 = CollectionsKt.listOf((Object)graphBuilder);
            object4 = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"logger");
            RegularFile regularFile = object4;
            object4 = (RegularFile)((ShrinkProtoResourcesParams)this.getParameters()).getReportFile().getOrNull();
            ShrinkerDebugReporter shrinkerDebugReporter = new LoggerAndFileDebugReporter((Logger)regularFile, object4 == null ? null : object4.getAsFile());
            object4 = ((ShrinkProtoResourcesParams)this.getParameters()).getUsePreciseShrinking().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.usePreciseShrinking.get()");
            object4 = new ResourceShrinkerImpl(list, obfuscationMappingsRecorder, list2, list3, shrinkerDebugReporter, false, (Boolean)object4);
            boolean bl9 = false;
            boolean bl10 = false;
            Throwable throwable2 = null;
            try {
                ResourceShrinkerImpl shrinker = (ResourceShrinkerImpl)object4;
                boolean bl11 = false;
                shrinker.analyze();
                Intrinsics.checkNotNullExpressionValue((Object)originalProtoFile, (String)"originalProtoFile");
                Intrinsics.checkNotNullExpressionValue((Object)shrunkProtoFile, (String)"shrunkProtoFile");
                shrinker.rewriteResourcesInApkFormat(originalProtoFile, shrunkProtoFile, LinkedResourcesFormat.PROTO);
                if (shrunkProtoFile.length() < originalProtoFile.length()) {
                    Intrinsics.checkNotNullExpressionValue((Object)aapt2ServiceKey, (String)"aapt2ServiceKey");
                    Closeable closeable = (Closeable)Aapt2Daemon.getAaptDaemon$default(aapt2ServiceKey, null, 2, null);
                    boolean bl12 = false;
                    boolean bl13 = false;
                    Throwable throwable3 = null;
                    try {
                        Aapt2DaemonManager.LeasedAaptDaemon it = (Aapt2DaemonManager.LeasedAaptDaemon)closeable;
                        boolean bl14 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)shrunkFile, (String)"shrunkFile");
                        it.convert(new AaptConvertConfig(shrunkProtoFile, shrunkFile, false), (ILogger)new LoggerWrapper(this.logger));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable3);
                    }
                    if (originalFile.length() < shrunkFile.length()) {
                        Files.copy((File)originalFile, (File)shrunkFile);
                    }
                } else {
                    Files.copy((File)originalFile, (File)shrunkFile);
                }
                if (shrinker.getUnusedResourceCount() > 0) {
                    long before = originalFile.length();
                    long after = shrunkFile.length();
                    int percent = (int)((before - after) * (long)100 / before);
                    String stat = "Removed unused resources: Binary resource data reduced from " + this.toKbString(before) + "KB to " + this.toKbString(after) + "KB. Removed " + percent + '%';
                    this.logger.info(stat);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object4, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final String toKbString(long size) {
        return String.valueOf((int)size / 1024);
    }
}

