/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.attribution;

import com.android.build.gradle.internal.cxx.attribution.AttributionKey;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttribution;
import com.android.build.gradle.internal.cxx.attribution.BuildTaskAttributions;
import com.android.build.gradle.internal.cxx.attribution.OperationType;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.builder.profile.ChromeTraceJson;
import com.android.builder.profile.TraceEventJson;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u001a&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020 \u001a\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020 2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0$\u001a\u001e\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0$2\u0006\u0010!\u001a\u00020 H\u0002\u001a\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0)2\u0006\u0010*\u001a\u00020\u001aH\u0002\u001a\"\u0010+\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u0006H\u0002\u001a2\u00100\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\fH\u0002\u001a\"\u00104\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0001H\u0002\u001a\u0014\u00105\u001a\u00020\u0018*\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0006*\u00020\u001cH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0005*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"MICROSECOND_IN_MILLISECOND", "", "illegalChars", "Lkotlin/text/Regex;", "describe", "", "Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;", "getDescribe", "(Lcom/android/build/gradle/internal/cxx/attribution/AttributionKey;)Ljava/lang/String;", "filename", "getFilename", "name", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttribution;", "getName", "(Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttribution;)Ljava/lang/String;", "type", "Lcom/android/build/gradle/internal/cxx/attribution/OperationType;", "getType", "(Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttribution;)Lcom/android/build/gradle/internal/cxx/attribution/OperationType;", "createAttributionKey", "module", "variant", "abi", "generateChromeTrace", "", "allTasks", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions;", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "buildStartTime", "", "extraChromeTraceDir", "Ljava/io/File;", "file", "outputFile", "allAttributions", "", "generateNinjaSourceFileAttribution", "linesToSkip", "readZipContent", "squashTasks", "", "tasks", "addProcessNameMetaEvent", "", "Lcom/android/builder/profile/TraceEventJson;", "pid", "key", "addTaskEvent", "tid", "buildStartTimeMs", "task", "addThreadNameMetaEvent", "collectTask", "Lcom/android/build/gradle/internal/cxx/attribution/BuildTaskAttributions$Builder;", "line", "gradle-core"})
public final class BuildAttributionUtilsKt {
    private static final int MICROSECOND_IN_MILLISECOND = 1000;
    @NotNull
    private static final Regex illegalChars = new Regex("[:\\\\/\"'|?*<>]");

    public static final void generateChromeTrace(@NotNull File file, @NotNull File outputFile) {
        Map<AttributionKey, BuildTaskAttributions> map;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        try {
            map = BuildAttributionUtilsKt.readZipContent(file);
        }
        catch (Throwable e) {
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Cannot parse native build attribution zip file. Exception: ", (Object)Throwables.getStackTraceAsString((Throwable)e)), new Object[0]);
            return;
        }
        Map<AttributionKey, BuildTaskAttributions> allAttributions = map;
        BuildAttributionUtilsKt.generateChromeTrace(outputFile, allAttributions);
    }

    public static /* synthetic */ void generateChromeTrace$default(File file, File file2, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = new File(file.getParentFile(), Intrinsics.stringPlus((String)FilesKt.getNameWithoutExtension((File)file), (Object)".json.gz"));
        }
        BuildAttributionUtilsKt.generateChromeTrace(file, file2);
    }

    public static final void generateChromeTrace(@NotNull BuildTaskAttributions allTasks, @NotNull CxxAbiModel abiModel, long buildStartTime, @NotNull File extraChromeTraceDir) {
        Intrinsics.checkNotNullParameter((Object)allTasks, (String)"allTasks");
        Intrinsics.checkNotNullParameter((Object)abiModel, (String)"abiModel");
        Intrinsics.checkNotNullParameter((Object)extraChromeTraceDir, (String)"extraChromeTraceDir");
        AttributionKey attributionKey = BuildAttributionUtilsKt.createAttributionKey(abiModel);
        extraChromeTraceDir.mkdirs();
        BuildAttributionUtilsKt.generateChromeTrace(FilesKt.resolve((File)extraChromeTraceDir, (String)("external_native_build-" + buildStartTime + '-' + BuildAttributionUtilsKt.getFilename(attributionKey) + ".json.gz")), MapsKt.mapOf((Pair)TuplesKt.to((Object)attributionKey, (Object)allTasks)));
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateChromeTrace(@NotNull File outputFile, @NotNull Map<AttributionKey, BuildTaskAttributions> allAttributions) {
        void $this$forEachIndexed$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter(allAttributions, (String)"allAttributions");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        List allEvents = new ArrayList();
        Iterable iterable = allAttributions.entrySet();
        boolean $i$f$sortedBy = false;
        boolean bl5 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                int n;
                int n2;
                boolean bl = false;
                Map.Entry $dstr$_u24__u24$tasks = (Map.Entry)a;
                boolean bl2 = false;
                Object object = $dstr$_u24__u24$tasks;
                boolean bl3 = false;
                BuildTaskAttributions tasks = (BuildTaskAttributions)object.getValue();
                List<BuildTaskAttribution> list = tasks.getAttributionList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"tasks.attributionList");
                object = (BuildTaskAttribution)CollectionsKt.firstOrNull(list);
                $dstr$_u24__u24$tasks = (Map.Entry)b;
                Comparable comparable = Integer.valueOf(object == null ? 0 : (n2 = ((BuildTaskAttribution)object).getStartTimeOffsetMs()));
                bl2 = false;
                object = $dstr$_u24__u24$tasks;
                boolean bl4 = false;
                tasks = (BuildTaskAttributions)object.getValue();
                List<BuildTaskAttribution> list2 = tasks.getAttributionList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"tasks.attributionList");
                object = (BuildTaskAttribution)CollectionsKt.firstOrNull(list2);
                Integer n3 = object == null ? 0 : (n = ((BuildTaskAttribution)object).getStartTimeOffsetMs());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $dstr$key$tasksForAnAbi;
            int n = index$iv++;
            boolean bl6 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv;
            int pid = n;
            boolean bl7 = false;
            void var16_17 = $dstr$key$tasksForAnAbi;
            boolean bl8 = false;
            AttributionKey key = (AttributionKey)var16_17.getKey();
            void var17_18 = $dstr$key$tasksForAnAbi;
            boolean bl9 = false;
            BuildTaskAttributions tasksForAnAbi = (BuildTaskAttributions)var17_18.getValue();
            BuildAttributionUtilsKt.addProcessNameMetaEvent(allEvents, pid, key);
            Iterable $this$forEachIndexed$iv2 = BuildAttributionUtilsKt.squashTasks(tasksForAnAbi);
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void tasks;
                int n2 = index$iv2++;
                boolean bl10 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                BuildTaskAttributions buildTaskAttributions = (BuildTaskAttributions)item$iv2;
                int tid = n2;
                boolean bl11 = false;
                BuildAttributionUtilsKt.addThreadNameMetaEvent(allEvents, pid, tid);
                List<BuildTaskAttribution> list = tasks.getAttributionList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"tasks.attributionList");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BuildTaskAttribution task = (BuildTaskAttribution)element$iv;
                    boolean bl12 = false;
                    long l = tasksForAnAbi.getBuildStartTimeMs();
                    Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                    BuildAttributionUtilsKt.addTaskEvent(allEvents, pid, tid, l, task);
                }
            }
        }
        outputFile.getParentFile().mkdirs();
        new ChromeTraceJson(allEvents).storeToFile(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map<AttributionKey, BuildTaskAttributions> readZipContent(File file) {
        void $this$mapTo$iv$iv;
        boolean bl;
        AttributionKey attributionKey;
        Object abi;
        Object object;
        boolean bl2 = false;
        Map allAttributions = new LinkedHashMap();
        ZipFile zipFile = new ZipFile(file);
        Closeable closeable = new ZipInputStream(new FileInputStream(file));
        boolean bl3 = false;
        boolean bl4 = false;
        Object object2 = null;
        try {
            ZipInputStream it = (ZipInputStream)closeable;
            boolean bl5 = false;
            while ((object = it.getNextEntry()) != null) {
                Object entry = object;
                if (((ZipEntry)entry).isDirectory()) continue;
                Iterator iterator2 = ((ZipEntry)entry).getName();
                Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"entry.name");
                CharSequence charSequence = (CharSequence)((Object)iterator2);
                iterator2 = (Iterator)new char[1];
                iterator2[0] = 47;
                Object object3 = object = StringsKt.split$default((CharSequence)charSequence, (char[])iterator2, (boolean)false, (int)3, (int)2, null);
                boolean bl6 = false;
                String module2 = (String)object3.get(0);
                Object object4 = object;
                boolean bl7 = false;
                String variant2 = (String)object4.get(1);
                Object object5 = object;
                boolean bl8 = false;
                abi = (String)object5.get(2);
                object5 = allAttributions;
                attributionKey = BuildAttributionUtilsKt.createAttributionKey(module2, variant2, (String)abi);
                BuildTaskAttributions.Builder builder = BuildTaskAttributions.newBuilder();
                boolean bl9 = false;
                bl = false;
                BuildTaskAttributions.Builder $this$readZipContent_u24lambda_u2d9_u24lambda_u2d8 = builder;
                boolean bl10 = false;
                Closeable closeable2 = new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), StandardCharsets.UTF_8);
                boolean bl11 = false;
                boolean bl12 = false;
                Throwable throwable = null;
                try {
                    InputStreamReader inputStreamReader = (InputStreamReader)closeable2;
                    boolean bl13 = false;
                    for (String line : TextStreamsKt.readLines((Reader)inputStreamReader)) {
                        if (StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                            String string;
                            String string2;
                            BuildTaskAttributions.Builder builder2;
                            String string3;
                            block18: {
                                void $this$takeWhile$iv;
                                String string4;
                                int index$iv;
                                int n;
                                String $this$dropWhile$iv;
                                block17: {
                                    string3 = line;
                                    builder2 = $this$readZipContent_u24lambda_u2d9_u24lambda_u2d8;
                                    boolean $i$f$dropWhile = false;
                                    int n2 = 0;
                                    n = ((CharSequence)$this$dropWhile$iv).length();
                                    while (n2 < n) {
                                        char c2 = $this$dropWhile$iv.charAt(index$iv);
                                        boolean bl14 = false;
                                        if (!(!Character.isDigit(c2))) {
                                            String c2 = $this$dropWhile$iv;
                                            bl14 = false;
                                            String string5 = c2.substring(index$iv);
                                            string4 = string5;
                                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                                            break block17;
                                        }
                                        ++index$iv;
                                    }
                                    string4 = "";
                                }
                                $this$dropWhile$iv = string2 = string4;
                                boolean $i$f$takeWhile = false;
                                n = $this$takeWhile$iv.length();
                                for (index$iv = 0; index$iv < n; ++index$iv) {
                                    char c = $this$takeWhile$iv.charAt(index$iv);
                                    boolean bl15 = false;
                                    if (Character.isDigit(c)) continue;
                                    void var32_51 = $this$takeWhile$iv;
                                    int n3 = 0;
                                    boolean bl16 = false;
                                    String string6 = var32_51.substring(n3, index$iv);
                                    string = string6;
                                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    break block18;
                                }
                                string = $this$takeWhile$iv;
                            }
                            string3 = string2 = string;
                            boolean bl17 = false;
                            builder2.setBuildStartTimeMs(Long.parseLong(string3));
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)$this$readZipContent_u24lambda_u2d9_u24lambda_u2d8, (String)"");
                        BuildAttributionUtilsKt.collectTask($this$readZipContent_u24lambda_u2d9_u24lambda_u2d8, line);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                BuildTaskAttributions.Builder builder3 = builder;
                Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder().apply {\n   \u2026      }\n                }");
                boolean bl18 = false;
                object5.put(attributionKey, builder3);
            }
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            object2 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        Map $this$map$iv = allAttributions;
        boolean $i$f$map = false;
        object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv;
        boolean bl19 = false;
        for (Map.Entry item$iv$iv : object.entrySet()) {
            void $dstr$key$value;
            abi = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl20 = false;
            attributionKey = $dstr$key$value;
            boolean bl21 = false;
            AttributionKey key = (AttributionKey)attributionKey.getKey();
            void var15_27 = $dstr$key$value;
            bl = false;
            BuildTaskAttributions.Builder value = (BuildTaskAttributions.Builder)var15_27.getValue();
            Pair pair = TuplesKt.to((Object)key, (Object)value.build());
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final void collectTask(BuildTaskAttributions.Builder $this$collectTask, String line) {
        List list;
        char[] cArray = new char[]{'\t'};
        List list2 = list = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        String start = (String)list2.get(0);
        List list3 = list;
        boolean bl2 = false;
        String end = (String)list3.get(1);
        Object object = list;
        boolean bl3 = false;
        String output2 = (String)object.get(3);
        object = start;
        bl3 = false;
        BuildTaskAttribution.Builder builder = BuildTaskAttribution.newBuilder().setStartTimeOffsetMs(Integer.parseInt((String)object));
        object = end;
        bl3 = false;
        $this$collectTask.addAttribution(builder.setEndTimeOffsetMs(Integer.parseInt((String)object)).setOutputFile(output2).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final BuildTaskAttributions generateNinjaSourceFileAttribution(@NotNull CxxAbiModel abi, int linesToSkip, long buildStartTime) {
        void $this$useLines$iv;
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        BuildTaskAttributions.Builder allTasks = BuildTaskAttributions.newBuilder().setKey(BuildAttributionUtilsKt.createAttributionKey(abi)).setBuildFolder(CxxAbiModelKt.getNinjaLogFile(abi).getParent()).setNinjaLogStartLine(linesToSkip).setBuildStartTimeMs(buildStartTime);
        Object object = CxxAbiModelKt.getNinjaLogFile(abi);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset$iv = charset;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        boolean bl = false;
        Reader reader = closeable;
        boolean bl2 = false;
        InputStream inputStream = reader;
        boolean bl3 = false;
        inputStream = new FileInputStream((File)((Object)inputStream));
        bl3 = false;
        reader = new InputStreamReader(inputStream, charset$iv);
        bl2 = false;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl4 = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl5 = false;
            Sequence $this$forEach$iv = SequencesKt.drop((Sequence)lines, (int)linesToSkip);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl6 = false;
                if (StringsKt.startsWith$default((String)line, (String)"# ", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)allTasks, (String)"allTasks");
                BuildAttributionUtilsKt.collectTask(allTasks, line);
            }
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        object = allTasks.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allTasks.build()");
        return object;
    }

    private static final void addProcessNameMetaEvent(List<TraceEventJson> $this$addProcessNameMetaEvent, int pid, AttributionKey key) {
        $this$addProcessNameMetaEvent.add(new TraceEventJson(pid, 0, 0L, "M", null, "process_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)BuildAttributionUtilsKt.getDescribe(key))), 80, null));
    }

    private static final void addThreadNameMetaEvent(List<TraceEventJson> $this$addThreadNameMetaEvent, int pid, int tid) {
        $this$addThreadNameMetaEvent.add(new TraceEventJson(pid, tid, 0L, "M", null, "thread_name", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)Intrinsics.stringPlus((String)"ninja->clang ", (Object)tid))), 80, null));
    }

    private static final void addTaskEvent(List<TraceEventJson> $this$addTaskEvent, int pid, int tid, long buildStartTimeMs, BuildTaskAttribution task) {
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, (buildStartTimeMs + (long)task.getStartTimeOffsetMs()) * (long)1000, "B", BuildAttributionUtilsKt.getType(task).toString(), BuildAttributionUtilsKt.getName(task), BuildAttributionUtilsKt.getType(task).getColorName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"output", (Object)task.getOutputFile()))));
        $this$addTaskEvent.add(new TraceEventJson(pid, tid, (buildStartTimeMs + (long)task.getEndTimeOffsetMs()) * (long)1000, "E", null, null, null, null, 240, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<BuildTaskAttributions> squashTasks(BuildTaskAttributions tasks) {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        List result2 = new ArrayList();
        List<BuildTaskAttribution> list = tasks.getAttributionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tasks.attributionList");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        boolean bl2 = false;
        for (BuildTaskAttribution task : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                BuildTaskAttribution it = (BuildTaskAttribution)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getStartTimeOffsetMs());
                it = (BuildTaskAttribution)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getStartTimeOffsetMs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        })) {
            Object v0;
            Object[] $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = result2;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int n;
                List it = (List)element$iv$iv;
                boolean bl3 = false;
                BuildTaskAttribution buildTaskAttribution = (BuildTaskAttribution)CollectionsKt.lastOrNull((List)it);
                if (!((buildTaskAttribution == null ? 0 : (n = buildTaskAttribution.getEndTimeOffsetMs())) <= task.getStartTimeOffsetMs())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    int it;
                    Object element$iv$iv;
                    List it2 = (List)maxElem$iv;
                    boolean bl4 = false;
                    element$iv$iv = (BuildTaskAttribution)CollectionsKt.lastOrNull((List)it2);
                    int maxValue$iv = element$iv$iv == null ? 0 : (it = ((BuildTaskAttribution)element$iv$iv).getEndTimeOffsetMs());
                    do {
                        int n;
                        int v$iv;
                        Object e$iv = iterator$iv.next();
                        List it3 = (List)e$iv;
                        $i$a$-maxByOrNull-BuildAttributionUtilsKt$squashTasks$chosenTrack$2 = false;
                        BuildTaskAttribution buildTaskAttribution = (BuildTaskAttribution)CollectionsKt.lastOrNull((List)it3);
                        int n2 = v$iv = buildTaskAttribution == null ? 0 : (n = buildTaskAttribution.getEndTimeOffsetMs());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            List chosenTrack = v0;
            if (chosenTrack == null) {
                $this$maxByOrNull$iv = new BuildTaskAttribution[1];
                Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                $this$maxByOrNull$iv[0] = task;
                result2.add(CollectionsKt.mutableListOf((Object[])$this$maxByOrNull$iv));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
            chosenTrack.add(task);
        }
        Iterable $this$map$iv = result2;
        boolean $i$f$map = false;
        Iterable chosenTrack = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List maxValue$iv = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            BuildTaskAttributions buildTaskAttributions = BuildTaskAttributions.newBuilder().addAllAttribution((Iterable)it).build();
            collection.add(buildTaskAttributions);
        }
        return (List)destination$iv$iv;
    }

    private static final String getDescribe(AttributionKey $this$describe) {
        return $this$describe.getModule() + " / " + $this$describe.getVariant() + " / " + $this$describe.getAbi();
    }

    private static final String getFilename(AttributionKey $this$filename) {
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence charSequence = $this$filename.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"module");
        charSequence = charSequence;
        Regex regex = illegalChars;
        String string = "_";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(regex.replace(charSequence, string)).append('-');
        charSequence = $this$filename.getVariant();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"variant");
        charSequence = charSequence;
        regex = illegalChars;
        string = "_";
        bl = false;
        return stringBuilder2.append(regex.replace(charSequence, string)).append('-').append((Object)$this$filename.getAbi()).toString();
    }

    private static final AttributionKey createAttributionKey(String module2, String variant2, String abi) {
        AttributionKey attributionKey = AttributionKey.newBuilder().setModule(module2).setVariant(variant2).setAbi(abi).build();
        Intrinsics.checkNotNullExpressionValue((Object)attributionKey, (String)"newBuilder()\n        .se\u2026Abi(abi)\n        .build()");
        return attributionKey;
    }

    private static final AttributionKey createAttributionKey(CxxAbiModel $this$createAttributionKey) {
        AttributionKey attributionKey = AttributionKey.newBuilder().setModule($this$createAttributionKey.getVariant().getModule().getGradleModulePathName()).setVariant($this$createAttributionKey.getVariant().getVariantName()).setAbi($this$createAttributionKey.getAbi().getTag()).build();
        Intrinsics.checkNotNullExpressionValue((Object)attributionKey, (String)"newBuilder()\n        .se\u2026abi.tag)\n        .build()");
        return attributionKey;
    }

    @NotNull
    public static final OperationType getType(@NotNull BuildTaskAttribution $this$type) {
        Intrinsics.checkNotNullParameter((Object)$this$type, (String)"<this>");
        String string = $this$type.getOutputFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile");
        return StringsKt.endsWith$default((String)string, (String)".o", (boolean)false, (int)2, null) ? OperationType.COMPILE : OperationType.LINK;
    }

    @NotNull
    public static final String getName(@NotNull BuildTaskAttribution $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = new File($this$name.getOutputFile()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(outputFile).name");
        return string;
    }
}

