/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.ide.DefaultAppBundleProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultAppBundleVariantBuildOutput;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/AppModelBuilder;", "Lcom/android/build/gradle/internal/ide/ModelBuilder;", "Lcom/android/build/gradle/internal/dsl/BaseAppModuleExtension;", "project", "Lorg/gradle/api/Project;", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "config", "extraModelInfo", "Lcom/android/build/gradle/internal/ExtraModelInfo;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/variant/VariantModel;Lcom/android/build/gradle/internal/dsl/BaseAppModuleExtension;Lcom/android/build/gradle/internal/ExtraModelInfo;)V", "buildAll", "", "modelName", "", "buildMinimalisticModel", "canBuild", "", "getDynamicFeatures", "", "isBaseSplit", "gradle-core"})
public final class AppModelBuilder
extends ModelBuilder<BaseAppModuleExtension> {
    @NotNull
    private final VariantModel variantModel;

    public AppModelBuilder(@NotNull Project project2, @NotNull VariantModel variantModel, @NotNull BaseAppModuleExtension config2, @NotNull ExtraModelInfo extraModelInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variantModel, (String)"variantModel");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)extraModelInfo, (String)"extraModelInfo");
        super(project2, variantModel, (BaseExtension)config2, extraModelInfo);
        this.variantModel = variantModel;
    }

    @Override
    protected boolean isBaseSplit() {
        return true;
    }

    @Override
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return super.canBuild(modelName) || Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName());
    }

    @Override
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName())) {
            object = this.buildMinimalisticModel();
        } else {
            Object object2 = super.buildAll(modelName, project2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"super.buildAll(modelName, project)");
            object = object2;
        }
        return object;
    }

    @Override
    @NotNull
    protected Collection<String> getDynamicFeatures() {
        return (Collection)GuavaKtxKt.toImmutableSet((Iterable)((BaseAppModuleExtension)this.extension).getDynamicFeatures());
    }

    private final Object buildMinimalisticModel() {
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        for (ComponentImpl component2 : this.variantModel.getVariants()) {
            ArtifactsImpl artifacts = component2.getArtifacts();
            if (!component2.getVariantType().isBaseModule() || component2.getGlobal().getNamespacedAndroidResources()) continue;
            Provider bundleFile = artifacts.get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE);
            Provider apkFolder = artifacts.get(InternalArtifactType.EXTRACTED_APKS.INSTANCE);
            variantsOutput.add((Object)new DefaultAppBundleVariantBuildOutput(component2.getName(), ((RegularFile)bundleFile.get()).getAsFile(), ((Directory)apkFolder.get()).getAsFile()));
        }
        return new DefaultAppBundleProjectBuildOutput((ImmutableList<AppBundleVariantBuildOutput>)variantsOutput.build());
    }
}

