/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.ide.BuildTypeImpl;
import com.android.build.gradle.internal.ide.SourceProviderContainerImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class BuildTypeContainerImpl
implements BuildTypeContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BuildType buildType;
    private final SourceProvider sourceProvider;
    private final Collection<SourceProviderContainer> extraSourceProviders;

    static BuildTypeContainer create(BuildTypeData<com.android.build.gradle.internal.dsl.BuildType> buildTypeData, boolean includeProdSourceSet, boolean includeAndroidTest, boolean includeUnitTest, Collection<SourceProviderContainer> sourceProviderContainers) {
        DefaultAndroidSourceSet sourceSet;
        List<SourceProviderContainer> clonedContainers = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        if (includeAndroidTest && (sourceSet = buildTypeData.getTestSourceSet((VariantType)VariantTypeImpl.ANDROID_TEST)) != null) {
            clonedContainers.add(SourceProviderContainerImpl.create(VariantTypeImpl.ANDROID_TEST.getArtifactName(), sourceSet));
        }
        if (includeUnitTest && (sourceSet = buildTypeData.getTestSourceSet((VariantType)VariantTypeImpl.UNIT_TEST)) != null) {
            clonedContainers.add(SourceProviderContainerImpl.create(VariantTypeImpl.UNIT_TEST.getArtifactName(), sourceSet));
        }
        SourceProviderImpl prodSourceSet = null;
        if (includeProdSourceSet) {
            prodSourceSet = new SourceProviderImpl(buildTypeData.getSourceSet());
        }
        return new BuildTypeContainerImpl(new BuildTypeImpl(buildTypeData.getBuildType()), prodSourceSet, clonedContainers);
    }

    private BuildTypeContainerImpl(BuildTypeImpl buildType, SourceProviderImpl sourceProvider, Collection<SourceProviderContainer> extraSourceProviders) {
        this.buildType = buildType;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildTypeContainerImpl that = (BuildTypeContainerImpl)o;
        return Objects.equals(this.buildType, that.buildType) && Objects.equals(this.sourceProvider, that.sourceProvider) && Objects.equals(this.extraSourceProviders, that.extraSourceProviders);
    }

    public int hashCode() {
        return Objects.hash(this.buildType, this.sourceProvider, this.extraSourceProviders);
    }
}

