/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.Version;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.dsl.ApplicationExtension;
import com.android.build.api.variant.AndroidTest;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.HasAndroidTest;
import com.android.build.api.variant.UnitTest;
import com.android.build.api.variant.impl.DirectoryEntry;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.DefaultConfigData;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.core.VariantDslInfoImpl;
import com.android.build.gradle.internal.core.VariantSources;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.AndroidGradlePluginProjectFlagsImpl;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.ConvertersKt;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultProjectSyncIssues;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependenciesInfoImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.FailsafeModelBuilderParameter;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.ide.LintOptionsImpl;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SigningConfigImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.build.gradle.internal.ide.StudioVersions;
import com.android.build.gradle.internal.ide.TestOptionsImpl;
import com.android.build.gradle.internal.ide.TestedTargetVariantImpl;
import com.android.build.gradle.internal.ide.VariantBuildInformationImp;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.ide.ViewBindingOptionsImpl;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputsImpl;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilderKt;
import com.android.build.gradle.internal.ide.dependencies.Level1DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.Level2DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.LibraryDependencyCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.GlobalLibraryMapImpl;
import com.android.build.gradle.internal.lint.CustomLintCheckUtils;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AnchorTaskNames;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.compiling.BuildConfigType;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidGradlePluginProjectFlags;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.CodeShrinker;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.ProjectSyncIssues;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.builder.model.VariantBuildInformation;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.jvm.functions.Function1;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class ModelBuilder<Extension extends BaseExtension>
implements ParameterizedToolingModelBuilder<ModelBuilderParameter> {
    private final Project project;
    protected final Extension extension;
    private final ExtraModelInfo extraModelInfo;
    private final VariantModel variantModel;
    private int modelLevel = 0;
    private boolean modelWithFullDependency = false;
    private ImmutableMap<String, String> buildMapping = null;

    public ModelBuilder(Project project2, VariantModel variantModel, Extension extension2, ExtraModelInfo extraModelInfo) {
        this.project = project2;
        this.extension = extension2;
        this.extraModelInfo = extraModelInfo;
        this.variantModel = variantModel;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(GlobalLibraryMap.class.getName()) || modelName.equals(Variant.class.getName()) || modelName.equals(ProjectSyncIssues.class.getName());
    }

    public Object buildAll(String modelName, Project project2) {
        this.initBuildMapping(project2);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project2, true);
        }
        if (modelName.equals(Variant.class.getName())) {
            throw new RuntimeException("Please use parameterized tooling API to obtain Variant model.");
        }
        return this.buildNonParameterizedModels(modelName);
    }

    public Object buildAll(String modelName, ModelBuilderParameter parameter, Project project2) {
        parameter = new FailsafeModelBuilderParameter(parameter);
        this.initBuildMapping(project2);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project2, parameter.getShouldBuildVariant());
        }
        if (modelName.equals(Variant.class.getName())) {
            return this.buildVariant(project2, parameter.getVariantName(), parameter.getShouldGenerateSources());
        }
        return this.buildNonParameterizedModels(modelName);
    }

    private Object buildNonParameterizedModels(String modelName) {
        if (modelName.equals(GlobalLibraryMap.class.getName())) {
            return ModelBuilder.buildGlobalLibraryMap(this.project.getGradle().getSharedServices());
        }
        if (modelName.equals(ProjectSyncIssues.class.getName())) {
            return this.buildProjectSyncIssuesModel();
        }
        throw new RuntimeException("Invalid model requested: " + modelName);
    }

    public Class<ModelBuilderParameter> getParameterType() {
        return ModelBuilderParameter.class;
    }

    private static Object buildGlobalLibraryMap(BuildServiceRegistry buildServiceRegistry) {
        LibraryDependencyCacheBuildService libraryDependencyCacheBuildService = (LibraryDependencyCacheBuildService)BuildServicesKt.getBuildService(buildServiceRegistry, LibraryDependencyCacheBuildService.class).get();
        return new GlobalLibraryMapImpl(libraryDependencyCacheBuildService.getGlobalLibMap());
    }

    private Object buildProjectSyncIssuesModel() {
        this.variantModel.getSyncIssueReporter().lockHandler();
        ImmutableSet.Builder allIssues = ImmutableSet.builder();
        allIssues.addAll(this.variantModel.getSyncIssueReporter().getSyncIssues());
        allIssues.addAll(((SyncIssueReporterImpl.GlobalSyncIssueService)BuildServicesKt.getBuildService(this.project.getGradle().getSharedServices(), SyncIssueReporterImpl.GlobalSyncIssueService.class).get()).getAllIssuesAndClear());
        return new DefaultProjectSyncIssues((Collection<? extends SyncIssue>)allIssues.build());
    }

    /*
     * WARNING - void declaration
     */
    private Object buildAndroidProject(Project project2, boolean shouldBuildVariant) {
        void var26_35;
        void var26_32;
        List<String> bootClasspath2;
        ProjectOptionService optionService2 = (ProjectOptionService)BuildServicesKt.getBuildService(project2.getGradle().getSharedServices(), ProjectOptionService.class).get();
        ProjectOptions projectOptions = optionService2.getProjectOptions();
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires a newer IDE able to request IDE model level 3. For Android Studio this means version 3.0+");
        }
        StudioVersions.verifyIDEIsNotOld(projectOptions);
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        if (((Boolean)((SdkComponentsBuildService.VersionedSdkLoader)this.variantModel.getVersionedSdkLoader().get()).getSdkSetupCorrectly().get()).booleanValue()) {
            List bootClasspath3 = ((List)this.variantModel.getFilteredBootClasspath().get()).stream().map(it -> it.getAsFile().getAbsolutePath()).collect(Collectors.toList());
        } else {
            bootClasspath2 = Collections.emptyList();
        }
        List<File> frameworkSource = Collections.emptyList();
        ArrayList artifactMetaDataList = Lists.newArrayList(this.extraModelInfo.getExtraArtifacts());
        for (VariantType variantType : VariantType.Companion.getTestComponents()) {
            artifactMetaDataList.add(new ArtifactMetaDataImpl(variantType.getArtifactName(), true, variantType.getArtifactType()));
        }
        LintOptionsImpl lintOptions2 = ConvertersKt.convertLintOptions(((BaseExtension)this.extension).getLintOptions());
        AaptOptions aaptOptions = AaptOptionsImpl.create(((BaseExtension)this.extension).getAaptOptions());
        boolean viewBinding2 = this.variantModel.getVariants().stream().anyMatch(variantProperties -> variantProperties.getBuildFeatures().getViewBinding());
        ViewBindingOptionsImpl viewBindingOptions = new ViewBindingOptionsImpl(viewBinding2);
        DependenciesInfoImpl dependenciesInfo2 = null;
        if (this.extension instanceof ApplicationExtension) {
            ApplicationExtension applicationExtension = (ApplicationExtension)this.extension;
            boolean inApk = applicationExtension.getDependenciesInfo().getIncludeInApk();
            boolean inBundle = applicationExtension.getDependenciesInfo().getIncludeInBundle();
            dependenciesInfo2 = new DependenciesInfoImpl(inApk, inBundle);
        }
        ArrayList flavorDimensionList = ((BaseExtension)this.extension).getFlavorDimensionList() != null ? ImmutableList.copyOf(((BaseExtension)this.extension).getFlavorDimensionList()) : Lists.newArrayList();
        VariantInputModel<DefaultConfig, BuildType, ProductFlavor, SigningConfig> variantInputs = this.variantModel.getInputs();
        DimensionInformation variantDimensionInfo = DimensionInformation.createFrom(this.variantModel.getVariants());
        DimensionInformation androidTests = DimensionInformation.createFrom(this.variantModel.getTestComponents().stream().filter(it -> it instanceof AndroidTest).map(it -> (AndroidTest)it).collect(Collectors.toList()));
        DimensionInformation unitTests = DimensionInformation.createFrom(this.variantModel.getTestComponents().stream().filter(it -> it instanceof UnitTest).map(it -> (UnitTest)it).collect(Collectors.toList()));
        DefaultConfigData<DefaultConfig> defaultConfigData = variantInputs.getDefaultConfigData();
        ProductFlavorContainer defaultConfig = ProductFlavorContainerImpl.createProductFlavorContainer(defaultConfigData, defaultConfigData.getDefaultConfig(), variantDimensionInfo.isNotEmpty(), androidTests.isNotEmpty(), unitTests.isNotEmpty(), this.extraModelInfo.getExtraFlavorSourceProviders("main"));
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        ArrayList variantNames = Lists.newArrayList();
        for (BuildTypeData<BuildType> buildTypeData : variantInputs.getBuildTypes().values()) {
            String buildTypeName = buildTypeData.getBuildType().getName();
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, variantDimensionInfo.buildTypes.contains(buildTypeName), androidTests.buildTypes.contains(buildTypeName), unitTests.buildTypes.contains(buildTypeName), this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeName)));
        }
        for (ProductFlavorData productFlavorData : variantInputs.getProductFlavors().values()) {
            ProductFlavor productFlavor = (ProductFlavor)productFlavorData.getProductFlavor();
            Pair dimensionValue = Pair.of((Object)productFlavor.getDimension(), (Object)productFlavor.getName());
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, productFlavor, variantDimensionInfo.flavors.contains(dimensionValue), androidTests.flavors.contains(dimensionValue), unitTests.flavors.contains(dimensionValue), this.extraModelInfo.getExtraFlavorSourceProviders(productFlavor.getName())));
        }
        String defaultVariant = this.variantModel.getDefaultVariant();
        Object var26_31 = null;
        String androidTestNamespace = null;
        for (ComponentImpl variant2 : this.variantModel.getVariants()) {
            AndroidTest test;
            variantNames.add(variant2.getName());
            if (shouldBuildVariant) {
                variants.add(this.createVariant(variant2));
            }
            String string = (String)variant2.getNamespace().get();
            if (!(variant2 instanceof HasAndroidTest) || !((test = ((HasAndroidTest)variant2).getAndroidTest()) instanceof TestComponentCreationConfig)) continue;
            androidTestNamespace = (String)((TestComponentCreationConfig)test).getNamespaceForR().get();
        }
        if (var26_32 == null) {
            String string = "";
        }
        String groupId = project2.getGroup().toString();
        AndroidGradlePluginProjectFlagsImpl flags = this.getFlags();
        Collection variantBuildOutputs = this.variantModel.getVariants().stream().map(this::createBuildInformation).collect(Collectors.toList());
        return new DefaultAndroidProject(project2.getName(), groupId, (String)var26_35, androidTestNamespace, defaultConfig, flavorDimensionList, buildTypes, productFlavors, variants, variantNames, defaultVariant, ((BaseExtension)this.extension).getCompileSdkVersion(), (Collection<String>)bootClasspath2, (Collection<File>)frameworkSource, ModelBuilder.cloneSigningConfigs(((BaseExtension)this.extension).getSigningConfigs()), aaptOptions, artifactMetaDataList, (Collection<SyncIssue>)ImmutableList.of(), ((BaseExtension)this.extension).getCompileOptions(), lintOptions2, (List<File>)CustomLintCheckUtils.getLocalCustomLintChecksForModel(project2, this.variantModel.getSyncIssueReporter()), project2.getBuildDir(), ((BaseExtension)this.extension).getResourcePrefix(), (Collection<NativeToolchain>)ImmutableList.of(), ((BaseExtension)this.extension).getBuildToolsVersion(), ((BaseExtension)this.extension).getNdkVersion(), this.variantModel.getProjectTypeV1(), Version.BUILDER_MODEL_API_VERSION, this.isBaseSplit(), this.getDynamicFeatures(), viewBindingOptions, dependenciesInfo2, flags, variantBuildOutputs);
    }

    private VariantBuildInformation createBuildInformation(ComponentImpl component2) {
        return new VariantBuildInformationImp(component2.getName(), component2.getTaskContainer().assembleTask.getName(), ModelBuilder.toAbsolutePath((RegularFile)component2.getArtifacts().get(InternalArtifactType.APK_IDE_REDIRECT_FILE.INSTANCE).getOrNull()), component2.getTaskContainer().getBundleTask() == null ? component2.computeTaskName("bundle") : component2.getTaskContainer().getBundleTask().getName(), ModelBuilder.toAbsolutePath((RegularFile)component2.getArtifacts().get(InternalArtifactType.BUNDLE_IDE_REDIRECT_FILE.INSTANCE).getOrNull()), AnchorTaskNames.INSTANCE.getExtractApksAnchorTaskName(component2), ModelBuilder.toAbsolutePath((RegularFile)component2.getArtifacts().get(InternalArtifactType.APK_FROM_BUNDLE_IDE_REDIRECT_FILE.INSTANCE).getOrNull()));
    }

    private AndroidGradlePluginProjectFlagsImpl getFlags() {
        ImmutableMap.Builder flags = ImmutableMap.builder();
        ProjectOptions projectOptions = this.variantModel.getProjectOptions();
        boolean finalResIds = !projectOptions.get(BooleanOption.USE_NON_FINAL_RES_IDS);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.APPLICATION_R_CLASS_CONSTANT_IDS, (Object)finalResIds);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.TEST_R_CLASS_CONSTANT_IDS, (Object)finalResIds);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.JETPACK_COMPOSE, (Object)this.variantModel.getVariants().stream().anyMatch(variantProperties -> variantProperties.getBuildFeatures().getCompose()));
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.ML_MODEL_BINDING, (Object)this.variantModel.getVariants().stream().anyMatch(variantProperties -> variantProperties.getBuildFeatures().getMlModelBinding()));
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.UNIFIED_TEST_PLATFORM, (Object)projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM));
        boolean transitiveRClass = !projectOptions.get(BooleanOption.NON_TRANSITIVE_R_CLASS);
        flags.put((Object)AndroidGradlePluginProjectFlags.BooleanFlag.TRANSITIVE_R_CLASS, (Object)transitiveRClass);
        return new AndroidGradlePluginProjectFlagsImpl((Map<AndroidGradlePluginProjectFlags.BooleanFlag, Boolean>)flags.build());
    }

    protected boolean isBaseSplit() {
        return false;
    }

    private static String toAbsolutePath(RegularFile regularFile) {
        return regularFile != null ? regularFile.getAsFile().getAbsolutePath() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean inspectManifestForInstantTag(ComponentImpl component2) {
        int projectType = this.variantModel.getProjectTypeV1();
        if (projectType != 0 && projectType != 6) {
            return false;
        }
        VariantSources variantSources = component2.getVariantSources();
        ArrayList<File> manifests2 = new ArrayList<File>(variantSources.getManifestOverlays());
        File mainManifest = variantSources.getMainManifestIfExists();
        if (mainManifest != null) {
            manifests2.add(mainManifest);
        }
        if (manifests2.isEmpty()) {
            return false;
        }
        Iterator iterator2 = manifests2.iterator();
        while (iterator2.hasNext()) {
            File manifest = (File)iterator2.next();
            try (FileInputStream inputStream = new FileInputStream(manifest);){
                XMLInputFactory factory2 = XMLInputFactory.newInstance();
                XMLEventReader eventReader = factory2.createXMLEventReader(inputStream);
                while (eventReader.hasNext() && !eventReader.peek().isEndDocument()) {
                    XMLEvent event = eventReader.nextTag();
                    if (event.isStartElement()) {
                        Attribute instant;
                        StartElement startElement = event.asStartElement();
                        if (!startElement.getName().getNamespaceURI().equals("http://schemas.android.com/apk/distribution") || !startElement.getName().getLocalPart().equalsIgnoreCase("module") || (instant = startElement.getAttributeByName(new QName("http://schemas.android.com/apk/distribution", "instant"))) == null || !instant.getValue().equals("true") && !instant.getValue().equals("1")) continue;
                        eventReader.close();
                        boolean bl = true;
                        return bl;
                    }
                    if (!event.isEndElement() || !((EndElement)event).getName().getLocalPart().equalsIgnoreCase("manifest")) continue;
                }
                eventReader.close();
            }
            catch (IOException | XMLStreamException e) {
                this.variantModel.getSyncIssueReporter().reportError(IssueReporter.Type.GENERIC, "Failed to parse XML in " + manifest.getPath() + "\n" + e.getMessage());
            }
        }
        return false;
    }

    protected Collection<String> getDynamicFeatures() {
        return ImmutableList.of();
    }

    private VariantImpl buildVariant(Project project2, String variantName, boolean shouldScheduleSourceGeneration) {
        if (variantName == null) {
            throw new IllegalArgumentException("Variant name cannot be null.");
        }
        for (ComponentImpl component2 : this.variantModel.getVariants()) {
            if (!component2.getName().equals(variantName)) continue;
            VariantImpl variant2 = this.createVariant(component2);
            if (shouldScheduleSourceGeneration) {
                ModelBuilder.scheduleSourceGeneration(project2, variant2);
            }
            return variant2;
        }
        throw new IllegalArgumentException(String.format("Variant with name '%s' doesn't exist.", variantName));
    }

    private static void scheduleSourceGeneration(Project project2, Variant variant2) {
        ArrayList artifacts = Lists.newArrayList((Object[])new BaseArtifact[]{variant2.getMainArtifact()});
        artifacts.addAll(variant2.getExtraAndroidArtifacts());
        artifacts.addAll(variant2.getExtraJavaArtifacts());
        Set sourceGenerationTasks = artifacts.stream().map(BaseArtifact::getIdeSetupTaskNames).flatMap(Collection::stream).map(taskName -> project2.getPath() + ":" + taskName).collect(Collectors.toSet());
        try {
            StartParameter startParameter = project2.getGradle().getStartParameter();
            HashSet tasks = new HashSet(startParameter.getTaskNames());
            tasks.addAll(sourceGenerationTasks);
            startParameter.setTaskNames(tasks);
        }
        catch (Throwable e) {
            throw new RuntimeException("Can't modify scheduled tasks at current build step", e);
        }
    }

    private VariantImpl createVariant(ComponentImpl component2) {
        AndroidArtifact mainArtifact = this.createAndroidArtifact("_main_", component2);
        VariantDslInfoImpl variantDslInfo = (VariantDslInfoImpl)component2.getVariantDslInfo();
        File manifest = component2.getVariantSources().getMainManifestIfExists();
        if (manifest != null) {
            DefaultManifestParser attributeSupplier = new DefaultManifestParser(manifest, () -> true, component2.getVariantType().getRequiresManifest(), (IssueReporter)this.variantModel.getSyncIssueReporter());
            try {
                this.validateMinSdkVersion((ManifestAttributeSupplier)attributeSupplier);
                this.validateTargetSdkVersion((ManifestAttributeSupplier)attributeSupplier);
            }
            catch (Throwable e) {
                this.variantModel.getSyncIssueReporter().reportError(IssueReporter.Type.GENERIC, "Failed to parse XML in " + manifest.getPath() + "\n" + e.getMessage());
            }
        }
        String variantName = component2.getName();
        ArrayList extraAndroidArtifacts = Lists.newArrayList(this.extraModelInfo.getExtraAndroidArtifacts(variantName));
        LibraryDependencyCacheBuildService libraryDependencyCache = (LibraryDependencyCacheBuildService)BuildServicesKt.getBuildService(component2.getServices().getBuildServiceRegistry(), LibraryDependencyCacheBuildService.class).get();
        List<JavaArtifact> clonedExtraJavaArtifacts = this.extraModelInfo.getExtraJavaArtifacts(variantName).stream().map(javaArtifact -> JavaArtifactImpl.clone(javaArtifact, this.modelLevel, this.modelWithFullDependency, libraryDependencyCache)).collect(Collectors.toList());
        if (component2 instanceof com.android.build.api.variant.impl.VariantImpl) {
            com.android.build.api.variant.impl.VariantImpl variant2 = (com.android.build.api.variant.impl.VariantImpl)component2;
            block6: for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                ComponentImpl testVariant = variant2.getTestComponents().get(variantType);
                if (testVariant == null) continue;
                switch ((VariantTypeImpl)variantType) {
                    case ANDROID_TEST: {
                        extraAndroidArtifacts.add(this.createAndroidArtifact(variantType.getArtifactName(), testVariant));
                        continue block6;
                    }
                    case UNIT_TEST: {
                        clonedExtraJavaArtifacts.add(this.createUnitTestsJavaArtifact(variantType, testVariant));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported test variant type ${variantType}.");
            }
        }
        Collection<TestedTargetVariant> testTargetVariants = this.getTestTargetVariants(component2);
        this.checkProguardFiles(component2);
        return new VariantImpl(variantName, component2.getBaseName(), component2.getBuildType(), ModelBuilder.getProductFlavorNames(component2), new ProductFlavorImpl(variantDslInfo.getMergedFlavor(), (Provider<String>)variantDslInfo.getApplicationId()), mainArtifact, extraAndroidArtifacts, clonedExtraJavaArtifacts, testTargetVariants, this.inspectManifestForInstantTag(component2), (List<String>)ImmutableList.of());
    }

    private void checkProguardFiles(ComponentImpl component2) {
        boolean isBaseModule = component2.getVariantType().isBaseModule();
        boolean isDynamicFeature = component2.getVariantType().isDynamicFeature();
        if (!isBaseModule) {
            List<File> consumerProguardFiles = component2.getVariantScope().getConsumerProguardFilesForFeatures();
            ExportConsumerProguardFilesTask.checkProguardFiles(this.project.getLayout().getBuildDirectory(), isDynamicFeature, consumerProguardFiles, errorMessage -> this.variantModel.getSyncIssueReporter().reportError(IssueReporter.Type.GENERIC, (String)errorMessage));
        }
    }

    private Collection<TestedTargetVariant> getTestTargetVariants(ComponentImpl component2) {
        if (this.extension instanceof TestAndroidConfig) {
            TestAndroidConfig testConfig = (TestAndroidConfig)this.extension;
            ArtifactCollection apkArtifacts = component2.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK);
            if (apkArtifacts.getArtifacts().size() == 1) {
                ResolvedArtifactResult result2 = (ResolvedArtifactResult)Iterables.getOnlyElement((Iterable)apkArtifacts.getArtifacts());
                String variant2 = LibraryUtils.getVariantName(result2);
                return ImmutableList.of((Object)new TestedTargetVariantImpl(testConfig.getTargetProjectPath(), variant2));
            }
            if (!apkArtifacts.getFailures().isEmpty()) {
                new DependencyFailureHandler().addErrors(this.project.getPath() + "@" + component2.getName() + "/testTarget", apkArtifacts.getFailures()).registerIssues(this.variantModel.getSyncIssueReporter());
            }
        }
        return ImmutableList.of();
    }

    private JavaArtifactImpl createUnitTestsJavaArtifact(VariantType variantType, ComponentImpl component2) {
        ArtifactsImpl artifacts = component2.getArtifacts();
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(component2);
        Pair<Dependencies, DependencyGraphs> result2 = this.getDependencies(component2, this.buildMapping, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(component2.getVariantData().getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(component2.getVariantData().getAllPostJavacGeneratedBytecode().getFiles());
        if (component2.getGlobal().getTestOptions().getUnitTests().isIncludeAndroidResources()) {
            additionalTestClasses.add(((Directory)artifacts.get(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE).get()).getAsFile());
        }
        if (!((BaseExtension)this.extension).getAaptOptions().getNamespaced() && component2.getBuildFeatures().getAndroidResources()) {
            additionalTestClasses.add(((RegularFile)component2.getVariantScope().getRJarForUnitTests().get()).getAsFile());
        }
        File mockableJar = this.variantModel.getMockableJarArtifact().getFiles().stream().findFirst().orElse(null);
        return new JavaArtifactImpl(variantType.getArtifactName(), component2.getTaskContainer().getAssembleTask().getName(), component2.getTaskContainer().getCompileTask().getName(), Sets.newHashSet((Object[])new String[]{"createMockableJar"}), ModelBuilder.getGeneratedSourceFoldersForUnitTests(component2), ((Directory)artifacts.get(InternalArtifactType.JAVAC.INSTANCE).get()).getAsFile(), additionalTestClasses, component2.getVariantData().getJavaResourcesForUnitTesting(), mockableJar, (Dependencies)result2.getFirst(), (DependencyGraphs)result2.getSecond(), sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider);
    }

    private Pair<Dependencies, DependencyGraphs> getDependencies(ComponentImpl component2, ImmutableMap<String, String> buildMapping, int modelLevel, boolean modelWithFullDependency) {
        Pair result2;
        if (this.variantModel.getSyncIssueReporter().hasIssue(IssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            result2 = Pair.of((Object)DependenciesImpl.EMPTY, (Object)EmptyDependencyGraphs.EMPTY);
        } else {
            DependencyGraphBuilder graphBuilder = DependencyGraphBuilderKt.getDependencyGraphBuilder();
            if (modelLevel >= 4) {
                Level2DependencyModelBuilder modelBuilder = new Level2DependencyModelBuilder(component2.getServices().getBuildServiceRegistry());
                ArtifactCollectionsInputsImpl artifactCollectionsInputs = new ArtifactCollectionsInputsImpl(component2, ArtifactCollectionsInputs.RuntimeType.FULL, buildMapping);
                graphBuilder.createDependencies(modelBuilder, artifactCollectionsInputs, modelWithFullDependency, this.variantModel.getSyncIssueReporter());
                result2 = Pair.of((Object)DependenciesImpl.EMPTY, (Object)modelBuilder.createModel());
            } else {
                Level1DependencyModelBuilder modelBuilder = new Level1DependencyModelBuilder(component2.getServices().getBuildServiceRegistry());
                ArtifactCollectionsInputsImpl artifactCollectionsInputs = new ArtifactCollectionsInputsImpl(component2, ArtifactCollectionsInputs.RuntimeType.PARTIAL, buildMapping);
                graphBuilder.createDependencies(modelBuilder, artifactCollectionsInputs, modelWithFullDependency, this.variantModel.getSyncIssueReporter());
                result2 = Pair.of((Object)modelBuilder.createModel(), (Object)EmptyDependencyGraphs.EMPTY);
            }
        }
        return result2;
    }

    private AndroidArtifact createAndroidArtifact(String name, ComponentImpl component2) {
        VariantScope variantScope2 = component2.getVariantScope();
        VariantDslInfo variantDslInfo = component2.getVariantDslInfo();
        com.android.build.api.variant.impl.SigningConfigImpl signingConfig2 = null;
        boolean isSigningReady = false;
        if (component2 instanceof ApkCreationConfig && (signingConfig2 = ((ApkCreationConfig)((Object)component2)).getSigningConfigImpl()) != null) {
            isSigningReady = signingConfig2.hasConfig() && signingConfig2.isSigningReady();
        }
        String signingConfigName = null;
        if (signingConfig2 != null) {
            signingConfigName = signingConfig2.getName();
        }
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(component2);
        InstantRunImpl instantRun = new InstantRunImpl(this.project.file((Object)"build_info_removed"), 7);
        Pair<Dependencies, DependencyGraphs> dependencies = this.getDependencies(component2, this.buildMapping, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalClasses = new HashSet<File>();
        additionalClasses.addAll(component2.getVariantData().getAllPreJavacGeneratedBytecode().getFiles());
        additionalClasses.addAll(component2.getVariantData().getAllPostJavacGeneratedBytecode().getFiles());
        additionalClasses.addAll(component2.getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH).getFiles());
        ArrayList<File> additionalRuntimeApks = new ArrayList<File>();
        TestOptionsImpl testOptions = null;
        if (component2.getVariantType().isTestComponent() || component2 instanceof TestVariantImpl) {
            Configuration testHelpers = (Configuration)this.project.getConfigurations().findByName("androidTestUtil");
            if (testHelpers != null) {
                additionalRuntimeApks.addAll(testHelpers.getFiles());
            }
            DeviceProviderInstrumentTestTask.checkForNonApks(additionalRuntimeApks, message -> this.variantModel.getSyncIssueReporter().reportError(IssueReporter.Type.GENERIC, (String)message));
            TestOptions testOptionsDsl = ((BaseExtension)this.extension).getTestOptions();
            testOptions = new TestOptionsImpl(testOptionsDsl.getAnimationsDisabled(), testOptionsDsl.getExecutionEnum());
        }
        MutableTaskContainer taskContainer = component2.getTaskContainer();
        ArtifactsImpl artifacts = component2.getArtifacts();
        CodeShrinker codeShrinker = component2 instanceof ConsumableCreationConfig && ((ConsumableCreationConfig)((Object)component2)).getMinifiedEnabled() ? CodeShrinker.R8 : null;
        return new AndroidArtifactImpl(name, ProjectInfo.getBaseName(this.project) + "-" + component2.getBaseName(), taskContainer.getAssembleTask().getName(), (RegularFile)artifacts.get(InternalArtifactType.APK_IDE_REDIRECT_FILE.INSTANCE).getOrNull(), isSigningReady || component2.getVariantData().outputsAreSigned, signingConfigName, taskContainer.getSourceGenTask().getName(), taskContainer.getCompileTask().getName(), ModelBuilder.getGeneratedSourceFolders(component2), ModelBuilder.getGeneratedResourceFolders(component2), ((Directory)artifacts.get(InternalArtifactType.JAVAC.INSTANCE).get()).getAsFile(), additionalClasses, component2.getVariantData().getJavaResourcesForUnitTesting(), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), additionalRuntimeApks, sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider, variantDslInfo.getSupportedAbis(), instantRun, testOptions, taskContainer.getConnectedTestTask() == null ? null : taskContainer.getConnectedTestTask().getName(), taskContainer.getBundleTask() == null ? component2.computeTaskName("bundle") : taskContainer.getBundleTask().getName(), (RegularFile)artifacts.get(InternalArtifactType.BUNDLE_IDE_REDIRECT_FILE.INSTANCE).getOrNull(), AnchorTaskNames.INSTANCE.getExtractApksAnchorTaskName(component2), (RegularFile)artifacts.get(InternalArtifactType.APK_FROM_BUNDLE_IDE_REDIRECT_FILE.INSTANCE).getOrNull(), codeShrinker);
    }

    private void validateMinSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getMinSdkVersion() != null) {
            this.variantModel.getSyncIssueReporter().reportError(IssueReporter.Type.MIN_SDK_VERSION_IN_MANIFEST, "The minSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file.");
        }
    }

    private void validateTargetSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getTargetSdkVersion() != null) {
            this.variantModel.getSyncIssueReporter().reportWarning(IssueReporter.Type.TARGET_SDK_VERSION_IN_MANIFEST, "The targetSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file.");
        }
    }

    private static SourceProviders determineSourceProviders(ComponentImpl component2) {
        DefaultAndroidSourceSet variantSourceProvider = component2.getVariantSources().getVariantSourceProvider();
        DefaultAndroidSourceSet multiFlavorSourceProvider = component2.getVariantSources().getMultiFlavorSourceProvider();
        return new SourceProviders(variantSourceProvider != null ? new SourceProviderImpl(variantSourceProvider, component2.getSources()) : null, multiFlavorSourceProvider != null ? new SourceProviderImpl(multiFlavorSourceProvider) : null);
    }

    private static List<String> getProductFlavorNames(ComponentImpl component2) {
        return component2.getProductFlavors().stream().map(kotlin.Pair::getSecond).collect(Collectors.toList());
    }

    public static List<File> getGeneratedSourceFoldersForUnitTests(ComponentImpl component2) {
        return Streams.stream((Iterable)ModelBuilder.getGeneratedSourceFoldersFileCollectionForUnitTests(component2)).collect(Collectors.toList());
    }

    private static FileCollection getGeneratedSourceFoldersFileCollectionForUnitTests(ComponentImpl component2) {
        ConfigurableFileCollection fileCollection2 = component2.getServices().fileCollection();
        fileCollection2.from(new Object[]{component2.getSources().getJava().variantSourcesForModel$gradle_core((Function1<? super DirectoryEntry, Boolean>)((Function1)directoryEntry -> directoryEntry.isGenerated() && directoryEntry.getShouldBeAddedToIdeModel()))});
        fileCollection2.from(new Object[]{component2.getVariantData().getExtraGeneratedSourceFoldersOnlyInModel()});
        fileCollection2.from(new Object[]{component2.getArtifacts().get(InternalArtifactType.AP_GENERATED_SOURCES.INSTANCE)});
        fileCollection2.disallowChanges();
        return fileCollection2;
    }

    public static List<File> getGeneratedSourceFolders(ComponentImpl component2) {
        return Streams.stream((Iterable)ModelBuilder.getGeneratedSourceFoldersFileCollection(component2)).collect(Collectors.toList());
    }

    public static FileCollection getGeneratedSourceFoldersFileCollection(ComponentImpl component2) {
        boolean ndkMode;
        ConfigurableFileCollection fileCollection2 = component2.getServices().fileCollection();
        ArtifactsImpl artifacts = component2.getArtifacts();
        fileCollection2.from(new Object[]{ModelBuilder.getGeneratedSourceFoldersFileCollectionForUnitTests(component2)});
        Callable<Directory> aidlCallable = () -> (Directory)artifacts.get(InternalArtifactType.AIDL_SOURCE_OUTPUT_DIR.INSTANCE).getOrNull();
        fileCollection2.from(new Object[]{aidlCallable});
        if (component2.getBuildConfigType() == BuildConfigType.JAVA_SOURCE) {
            Callable<Directory> buildConfigCallable = () -> (Directory)component2.getPaths().getBuildConfigSourceOutputDir().getOrNull();
            fileCollection2.from(new Object[]{buildConfigCallable});
        }
        if (!(ndkMode = component2.getVariantDslInfo().getRenderscriptNdkModeEnabled())) {
            Callable<Directory> renderscriptCallable = () -> (Directory)artifacts.get(InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR.INSTANCE).getOrNull();
            fileCollection2.from(new Object[]{renderscriptCallable});
        }
        boolean isDataBindingEnabled = component2.getBuildFeatures().getDataBinding();
        boolean isViewBindingEnabled = component2.getBuildFeatures().getViewBinding();
        if (isDataBindingEnabled || isViewBindingEnabled) {
            Callable<Directory> dataBindingCallable = () -> (Directory)artifacts.get(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT.INSTANCE).getOrNull();
            fileCollection2.from(new Object[]{dataBindingCallable});
        }
        fileCollection2.disallowChanges();
        return fileCollection2;
    }

    public static List<File> getGeneratedResourceFolders(ComponentImpl component2) {
        return Streams.stream((Iterable)ModelBuilder.getGeneratedResourceFoldersFileCollection(component2)).collect(Collectors.toList());
    }

    public static FileCollection getGeneratedResourceFoldersFileCollection(ComponentImpl component2) {
        ConfigurableFileCollection fileCollection2 = component2.getServices().fileCollection();
        fileCollection2.from(new Object[]{component2.getVariantData().getExtraGeneratedResFolders()});
        if (component2.getBuildFeatures().getRenderScript()) {
            fileCollection2.from(new Object[]{component2.getArtifacts().get(InternalArtifactType.RENDERSCRIPT_GENERATED_RES.INSTANCE)});
        }
        if (component2.getAndroidResourcesEnabled() && component2.getArtifacts().get(InternalArtifactType.GENERATED_RES.INSTANCE).isPresent()) {
            fileCollection2.from(new Object[]{component2.getArtifacts().get(InternalArtifactType.GENERATED_RES.INSTANCE)});
        }
        fileCollection2.disallowChanges();
        return fileCollection2;
    }

    private static Collection<com.android.builder.model.SigningConfig> cloneSigningConfigs(Collection<? extends com.android.builder.model.SigningConfig> signingConfigs) {
        return signingConfigs.stream().map(SigningConfigImpl::createSigningConfig).collect(Collectors.toList());
    }

    private void initBuildMapping(Project project2) {
        if (this.buildMapping == null) {
            this.buildMapping = BuildMappingUtils.computeBuildMapping(project2.getGradle());
        }
    }

    private static class SourceProviders {
        protected SourceProviderImpl variantSourceProvider;
        protected SourceProviderImpl multiFlavorSourceProvider;

        public SourceProviders(SourceProviderImpl variantSourceProvider, SourceProviderImpl multiFlavorSourceProvider) {
            this.variantSourceProvider = variantSourceProvider;
            this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        }
    }

    static class DimensionInformation {
        Set<String> buildTypes;
        Set<Pair<String, String>> flavors;

        DimensionInformation(Set<String> buildTypes, Set<Pair<String, String>> flavors) {
            this.buildTypes = buildTypes;
            this.flavors = flavors;
        }

        Boolean isNotEmpty() {
            return !this.buildTypes.isEmpty() || !this.flavors.isEmpty();
        }

        static DimensionInformation createFrom(Collection<? extends Component> components2) {
            HashSet<String> buildTypes = new HashSet<String>();
            HashSet<Pair<String, String>> flavors = new HashSet<Pair<String, String>>();
            for (Component component2 : components2) {
                if (component2.getBuildType() != null) {
                    buildTypes.add(component2.getBuildType());
                }
                flavors.addAll(component2.getProductFlavors().stream().map(pair -> Pair.of((Object)((String)pair.getFirst()), (Object)((String)pair.getSecond()))).collect(Collectors.toList()));
            }
            return new DimensionInformation(buildTypes, flavors);
        }
    }
}

