/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.component.UnitTestCreationConfig;
import com.android.build.gradle.internal.lint.AndroidLintAnalysisTask;
import com.android.build.gradle.internal.lint.AndroidLintCopyReportTask;
import com.android.build.gradle.internal.lint.AndroidLintGlobalTask;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.lint.AndroidLintTextOutputTask;
import com.android.build.gradle.internal.lint.LintModelWriterTask;
import com.android.build.gradle.internal.lint.LintTaskManager;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.tasks.LintModelMetadataTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.builder.core.VariantType;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJH\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/lint/LintTaskManager;", "", "globalTaskCreationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "taskFactory", "Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;", "project", "Lorg/gradle/api/Project;", "(Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskFactory;Lorg/gradle/api/Project;)V", "attachTestsToVariants", "Ljava/util/LinkedHashMap;", "", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "Lkotlin/collections/LinkedHashMap;", "variantPropertiesList", "", "Lcom/android/build/api/variant/impl/VariantImpl;", "testComponentPropertiesList", "", "Lcom/android/build/api/component/impl/TestComponentImpl;", "ignoreTestFixturesSources", "", "createBeforeEvaluateLintTasks", "", "createLintTasks", "variantType", "Lcom/android/builder/core/VariantType;", "variantModel", "Lcom/android/build/gradle/internal/variant/VariantModel;", "getTaskPath", "taskName", "task", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "Companion", "gradle-core"})
public final class LintTaskManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalTaskCreationConfig globalTaskCreationConfig;
    @NotNull
    private final TaskFactory taskFactory;
    @NotNull
    private final Project project;

    public LintTaskManager(@NotNull GlobalTaskCreationConfig globalTaskCreationConfig, @NotNull TaskFactory taskFactory, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)globalTaskCreationConfig, (String)"globalTaskCreationConfig");
        Intrinsics.checkNotNullParameter((Object)taskFactory, (String)"taskFactory");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.globalTaskCreationConfig = globalTaskCreationConfig;
        this.taskFactory = taskFactory;
        this.project = project2;
    }

    public final void createBeforeEvaluateLintTasks() {
        this.taskFactory.register(new AndroidLintGlobalTask.LintFixCreationAction(this.globalTaskCreationConfig));
        TaskProvider globalTask = this.taskFactory.register(new AndroidLintGlobalTask.GlobalCreationAction(this.globalTaskCreationConfig));
        this.taskFactory.configure("check", (Action<? super Task>)new Action(globalTask){
            final /* synthetic */ TaskProvider<AndroidLintGlobalTask> $globalTask;
            {
                this.$globalTask = $globalTask;
            }

            public final void execute(Task it) {
                Object[] objectArray = new Object[]{this.$globalTask};
                it.dependsOn(objectArray);
            }
        });
        this.taskFactory.register(new AndroidLintGlobalTask.UpdateBaselineCreationAction(this.globalTaskCreationConfig));
    }

    public final void createLintTasks(@NotNull VariantType variantType, @NotNull VariantModel variantModel, @NotNull List<? extends VariantImpl> variantPropertiesList, @NotNull Collection<? extends TestComponentImpl> testComponentPropertiesList) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)variantType, (String)"variantType");
        Intrinsics.checkNotNullParameter((Object)variantModel, (String)"variantModel");
        Intrinsics.checkNotNullParameter(variantPropertiesList, (String)"variantPropertiesList");
        Intrinsics.checkNotNullParameter(testComponentPropertiesList, (String)"testComponentPropertiesList");
        if (variantType.isForTesting()) {
            return;
        }
        if (this.globalTaskCreationConfig.getLintOptions().getIgnoreTestSources()) {
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        } else {
            collection = testComponentPropertiesList;
        }
        LinkedHashMap<String, VariantWithTests> variantsWithTests = this.attachTestsToVariants(variantPropertiesList, collection, this.globalTaskCreationConfig.getLintOptions().getIgnoreTestFixturesSources());
        boolean bl = false;
        Map variantLintTaskToLintVitalTask = new LinkedHashMap();
        boolean needsCopyReportTask = Companion.needsCopyReportTask$gradle_core(this.globalTaskCreationConfig.getLintOptions());
        for (VariantWithTests variantWithTests : variantsWithTests.values()) {
            boolean bl2;
            ConsumableCreationConfig mainVariant;
            if (variantType.isAar()) {
                Intrinsics.checkNotNullExpressionValue((Object)variantWithTests, (String)"variantWithTests");
                this.taskFactory.register(new LintModelWriterTask.LintCreationAction(variantWithTests, false, 2, null));
                this.taskFactory.register(new LintModelMetadataTask.CreationAction(variantWithTests.getMain()));
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)variantWithTests, (String)"variantWithTests");
                this.taskFactory.register(new LintModelWriterTask.LintCreationAction(variantWithTests, false));
            }
            this.taskFactory.register(new AndroidLintAnalysisTask.SingleVariantCreationAction(variantWithTests));
            if (variantType.isDynamicFeature()) {
                this.taskFactory.register(new AndroidLintAnalysisTask.LintVitalCreationAction(variantWithTests.getMain()));
                this.taskFactory.register(new LintModelWriterTask.LintVitalCreationAction(variantWithTests.getMain(), false, 2, null));
                continue;
            }
            TaskProvider updateLintBaselineTask2 = this.taskFactory.register(new AndroidLintTask.UpdateBaselineCreationAction(variantWithTests));
            TaskProvider taskProvider = this.taskFactory.register(new AndroidLintTask.SingleVariantCreationAction(variantWithTests));
            boolean bl3 = false;
            boolean bl4 = false;
            TaskProvider it = taskProvider;
            boolean bl5 = false;
            it.configure(new Action(updateLintBaselineTask2){
                final /* synthetic */ TaskProvider<AndroidLintTask> $updateLintBaselineTask;
                {
                    this.$updateLintBaselineTask = $updateLintBaselineTask;
                }

                public final void execute(AndroidLintTask task) {
                    Object[] objectArray = new Object[]{this.$updateLintBaselineTask};
                    task.mustRunAfter(objectArray);
                }
            });
            TaskProvider variantLintTask2 = taskProvider;
            TaskProvider variantLintTextOutputTask = this.taskFactory.register(new AndroidLintTextOutputTask.SingleVariantCreationAction(variantWithTests.getMain()));
            if (needsCopyReportTask) {
                TaskProvider copyLintReportTask = this.taskFactory.register(new AndroidLintCopyReportTask.CreationAction(variantWithTests.getMain()));
                variantLintTextOutputTask.configure(new Action(copyLintReportTask){
                    final /* synthetic */ TaskProvider<AndroidLintCopyReportTask> $copyLintReportTask;
                    {
                        this.$copyLintReportTask = $copyLintReportTask;
                    }

                    public final void execute(AndroidLintTextOutputTask it) {
                        Object[] objectArray = new Object[]{this.$copyLintReportTask};
                        it.finalizedBy(objectArray);
                    }
                });
            }
            if ((mainVariant = variantWithTests.getMain()).getVariantType().isBaseModule() && !mainVariant.getVariantDslInfo().isDebuggable() && this.globalTaskCreationConfig.getLintOptions().getCheckReleaseBuilds()) {
                this.taskFactory.register(new AndroidLintAnalysisTask.LintVitalCreationAction(mainVariant));
                it = this.taskFactory.register(new AndroidLintTask.LintVitalCreationAction(mainVariant));
                bl2 = false;
                boolean bl6 = false;
                TaskProvider it22 = it;
                boolean bl7 = false;
                it22.configure(new Action(updateLintBaselineTask2){
                    final /* synthetic */ TaskProvider<AndroidLintTask> $updateLintBaselineTask;
                    {
                        this.$updateLintBaselineTask = $updateLintBaselineTask;
                    }

                    public final void execute(AndroidLintTask task) {
                        Object[] objectArray = new Object[]{this.$updateLintBaselineTask};
                        task.mustRunAfter(objectArray);
                    }
                });
                TaskProvider lintVitalTask2 = it;
                TaskProvider lintVitalTextOutputTask = this.taskFactory.register(new AndroidLintTextOutputTask.LintVitalCreationAction(mainVariant));
                Map map = variantLintTaskToLintVitalTask;
                String string = this.getTaskPath(variantLintTask2);
                boolean it22 = false;
                map.put(string, lintVitalTask2);
                map = variantLintTaskToLintVitalTask;
                string = this.getTaskPath(variantLintTextOutputTask);
                it22 = false;
                map.put(string, lintVitalTextOutputTask);
            }
            TaskProvider taskProvider2 = this.taskFactory.register(new AndroidLintTask.FixSingleVariantCreationAction(variantWithTests));
            boolean bl8 = false;
            bl2 = false;
            TaskProvider it2 = taskProvider2;
            boolean bl9 = false;
            it2.configure(new Action(updateLintBaselineTask2){
                final /* synthetic */ TaskProvider<AndroidLintTask> $updateLintBaselineTask;
                {
                    this.$updateLintBaselineTask = $updateLintBaselineTask;
                }

                public final void execute(AndroidLintTask task) {
                    Object[] objectArray = new Object[]{this.$updateLintBaselineTask};
                    task.mustRunAfter(objectArray);
                }
            });
        }
        if (variantType.isDynamicFeature()) {
            return;
        }
        String defaultVariant = variantModel.getDefaultVariant();
        if (defaultVariant != null) {
            this.taskFactory.configure("lint", AndroidLintGlobalTask.class, (Action)new Action(defaultVariant){
                final /* synthetic */ String $defaultVariant;
                {
                    this.$defaultVariant = $defaultVariant;
                }

                public final void execute(AndroidLintGlobalTask globalTask) {
                    Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"lint", (String)this.$defaultVariant)};
                    globalTask.dependsOn(objectArray);
                }
            });
            this.taskFactory.configure("lintFix", AndroidLintGlobalTask.class, (Action)new Action(defaultVariant){
                final /* synthetic */ String $defaultVariant;
                {
                    this.$defaultVariant = $defaultVariant;
                }

                public final void execute(AndroidLintGlobalTask globalFixTask) {
                    Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"lintFix", (String)this.$defaultVariant)};
                    globalFixTask.dependsOn(objectArray);
                }
            });
            this.taskFactory.configure("updateLintBaseline", AndroidLintGlobalTask.class, (Action)new Action(defaultVariant){
                final /* synthetic */ String $defaultVariant;
                {
                    this.$defaultVariant = $defaultVariant;
                }

                public final void execute(AndroidLintGlobalTask updateLintBaselineTask2) {
                    Object[] objectArray = new Object[]{StringHelper.appendCapitalized((String)"updateLintBaseline", (String)this.$defaultVariant)};
                    updateLintBaselineTask2.dependsOn(objectArray);
                }
            });
        }
        String lintTaskPath = this.getTaskPath("lint");
        this.project.getGradle().getTaskGraph().whenReady(new Action(variantLintTaskToLintVitalTask, lintTaskPath){
            final /* synthetic */ Map<String, TaskProvider<? extends Task>> $variantLintTaskToLintVitalTask;
            final /* synthetic */ String $lintTaskPath;
            {
                this.$variantLintTaskToLintVitalTask = $variantLintTaskToLintVitalTask;
                this.$lintTaskPath = $lintTaskPath;
            }

            public final void execute(TaskExecutionGraph it) {
                Map.Entry<String, TaskProvider<? extends Task>> entry;
                Map.Entry<String, TaskProvider<? extends Task>> element$iv;
                Map<String, TaskProvider<? extends Task>> $this$forEach$iv = this.$variantLintTaskToLintVitalTask;
                boolean $i$f$forEach = false;
                Map<String, TaskProvider<? extends Task>> map = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<String, TaskProvider<? extends Task>>> iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, TaskProvider<? extends Task>> $dstr$taskPath$taskToDisable = element$iv = iterator2.next();
                    boolean bl2 = false;
                    entry = $dstr$taskPath$taskToDisable;
                    boolean bl3 = false;
                    String taskPath = entry.getKey();
                    Map.Entry<String, TaskProvider<? extends Task>> entry2 = $dstr$taskPath$taskToDisable;
                    boolean bl4 = false;
                    TaskProvider<? extends Task> taskToDisable = entry2.getValue();
                    if (!it.hasTask(taskPath)) continue;
                    taskToDisable.configure((Action)createLintTasks.1.1.INSTANCE);
                }
                if (it.hasTask(this.$lintTaskPath)) {
                    $this$forEach$iv = this.$variantLintTaskToLintVitalTask;
                    $i$f$forEach = false;
                    map = $this$forEach$iv;
                    bl = false;
                    iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, TaskProvider<? extends Task>> $dstr$_u24__u24$lintVitalTask = element$iv = iterator2.next();
                        boolean bl5 = false;
                        entry = $dstr$_u24__u24$lintVitalTask;
                        boolean bl6 = false;
                        TaskProvider<? extends Task> lintVitalTask2 = entry.getValue();
                        lintVitalTask2.configure((Action)createLintTasks.2.1.INSTANCE);
                    }
                }
            }
        });
    }

    private final LinkedHashMap<String, VariantWithTests> attachTestsToVariants(List<? extends VariantImpl> variantPropertiesList, Collection<? extends TestComponentImpl> testComponentPropertiesList, boolean ignoreTestFixturesSources) {
        Object object;
        LinkedHashMap<String, VariantWithTests> variantsWithTests = new LinkedHashMap<String, VariantWithTests>();
        for (VariantImpl variantImpl : variantPropertiesList) {
            Map map = variantsWithTests;
            String string = variantImpl.getName();
            object = new VariantWithTests(variantImpl, null, null, ignoreTestFixturesSources ? (TestFixturesImpl)null : (TestFixturesImpl)variantImpl.getTestFixturesComponent(), 6, null);
            boolean map2 = false;
            map.put(string, object);
        }
        for (TestComponentImpl testComponentImpl : testComponentPropertiesList) {
            VariantWithTests bl6;
            boolean string;
            String key = testComponentImpl.getTestedConfig().getName();
            VariantWithTests variantWithTests = variantsWithTests.get(key);
            Intrinsics.checkNotNull((Object)variantWithTests);
            object = variantWithTests;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variantsWithTests[key]!!");
            VariantWithTests current = object;
            object = testComponentImpl;
            if (object instanceof AndroidTestCreationConfig) {
                boolean bl5 = current.getAndroidTest() == null;
                boolean bl = false;
                string = false;
                if (!bl5) {
                    boolean bl4 = false;
                    String string2 = "Component " + current.getMain() + " appears to have two conflicting android test components " + current.getAndroidTest() + " and " + testComponentImpl;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                Map map = variantsWithTests;
                bl6 = new VariantWithTests(current.getMain(), (AndroidTestCreationConfig)((Object)testComponentImpl), current.getUnitTest(), current.getTestFixtures());
                string = false;
                map.put(key, bl6);
                continue;
            }
            if (object instanceof UnitTestCreationConfig) {
                boolean bl = current.getUnitTest() == null;
                boolean bl2 = false;
                string = false;
                if (!bl) {
                    boolean bl7 = false;
                    String string3 = "Component " + current.getMain() + " appears to have two conflicting unit test components " + current.getUnitTest() + " and " + testComponentImpl;
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                Map map = variantsWithTests;
                bl6 = new VariantWithTests(current.getMain(), current.getAndroidTest(), (UnitTestCreationConfig)((Object)testComponentImpl), current.getTestFixtures());
                string = false;
                map.put(key, bl6);
                continue;
            }
            throw new IllegalStateException("Unexpected test component type");
        }
        return variantsWithTests;
    }

    private final String getTaskPath(TaskProvider<? extends Task> task) {
        String string = task.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
        return this.getTaskPath(string);
    }

    private final String getTaskPath(String taskName) {
        return this.project.getRootProject() == this.project ? Intrinsics.stringPlus((String)":", (Object)taskName) : this.project.getPath() + ':' + taskName;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0011\u0010\b\u001a\u00020\u0004*\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0011\u0010\u000b\u001a\u00020\u0004*\u00020\tH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/lint/LintTaskManager$Companion;", "", "()V", "needsCopyReportTask", "", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "needsCopyReportTask$gradle_core", "isLintStderr", "Ljava/io/File;", "isLintStderr$gradle_core", "isLintStdout", "isLintStdout$gradle_core", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isLintStdout$gradle_core(@NotNull File $this$isLintStdout) {
            Intrinsics.checkNotNullParameter((Object)$this$isLintStdout, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isLintStdout.getPath(), (Object)new File("stdout").getPath());
        }

        public final boolean isLintStderr$gradle_core(@NotNull File $this$isLintStderr) {
            Intrinsics.checkNotNullParameter((Object)$this$isLintStderr, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isLintStderr.getPath(), (Object)new File("stderr").getPath());
        }

        public final boolean needsCopyReportTask$gradle_core(@NotNull Lint lintOptions2) {
            Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
            File textOutput = lintOptions2.getTextOutput();
            return lintOptions2.getTextReport() && textOutput != null && !this.isLintStdout$gradle_core(textOutput) && !this.isLintStderr$gradle_core(textOutput) || lintOptions2.getHtmlReport() && lintOptions2.getHtmlOutput() != null || lintOptions2.getXmlReport() && lintOptions2.getXmlOutput() != null || lintOptions2.getSarifReport() && lintOptions2.getSarifOutput() != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

