/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.AvdComponentsBuildService;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedDeviceUtilsKt;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.EmulatorSnapshots;
import com.android.build.gradle.internal.dsl.ManagedVirtualDevice;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ManagedDeviceInstrumentationTestTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.TestsAnalytics;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.build.gradle.internal.testing.TestData;
import com.android.build.gradle.internal.testing.utp.ManagedDeviceTestRunner;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.internal.testing.utp.RetentionConfigKt;
import com.android.build.gradle.internal.testing.utp.UtpDependencies;
import com.android.build.gradle.internal.testing.utp.UtpDependencyUtilsKt;
import com.android.build.gradle.internal.testing.utp.UtpManagedDevice;
import com.android.build.gradle.internal.testing.utp.UtpTestUtilsKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.TestOptions;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0002ABB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H'J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020!0\u0005H'J\b\u00107\u001a\u000205H'J\b\u00108\u001a\u00020!H\u0016J\b\u00109\u001a\u000205H'J\b\u0010:\u001a\u000205H'J\b\u0010;\u001a\u00020!H\u0017J\u0010\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020!H\u0007J\u0010\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020!H\u0016J\b\u0010@\u001a\u00020!H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u000e\u0010#\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014R\u000e\u0010*\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\bR\u0014\u0010.\u001a\u00020/8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006C"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lcom/android/build/gradle/internal/tasks/AndroidTestTask;", "()V", "abi", "Lorg/gradle/api/provider/Property;", "", "getAbi", "()Lorg/gradle/api/provider/Property;", "apiLevel", "", "getApiLevel", "avdComponents", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "getAvdComponents", "avdName", "getAvdName", "buddyApks", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBuddyApks", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "buildConfigClasses", "getBuildConfigClasses", "classes", "getClasses", "<set-?>", "Lorg/gradle/api/artifacts/ArtifactCollection;", "dependencies", "getDependencies", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "deviceName", "getDeviceName", "enableEmulatorDisplay", "", "getEnableEmulatorDisplay", "hasFailures", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "rClasses", "getRClasses", "shouldIgnore", "testData", "Lcom/android/build/gradle/internal/testing/TestData;", "getTestData", "testRunnerFactory", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "getTestRunnerFactory", "()Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "doTaskAction", "", "getAdditionalTestOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getAdditionalTestOutputEnabled", "getCoverageDirectory", "getIgnoreFailures", "getReportsDir", "getResultsDir", "getTestFailed", "setDisplayEmulatorOption", "value", "setIgnoreFailures", "ignore", "testsFound", "CreationAction", "TestRunnerFactory", "gradle-core"})
public abstract class ManagedDeviceInstrumentationTestTask
extends NonIncrementalTask
implements AndroidTestTask {
    private boolean hasFailures;
    private boolean shouldIgnore;
    private ArtifactCollection dependencies;

    @Nested
    @NotNull
    public abstract TestRunnerFactory getTestRunnerFactory();

    @Nested
    @NotNull
    public abstract Property<TestData> getTestData();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getInstallOptions();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getBuddyApks();

    @Internal
    @VisibleForTesting
    @NotNull
    public final ArtifactCollection getDependencies() {
        ArtifactCollection artifactCollection = this.dependencies;
        if (artifactCollection != null) {
            return artifactCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        return null;
    }

    @Input
    @NotNull
    public abstract Property<String> getDeviceName();

    @Input
    @NotNull
    public abstract Property<String> getAvdName();

    @Input
    @NotNull
    public abstract Property<Integer> getApiLevel();

    @Input
    @NotNull
    public abstract Property<String> getAbi();

    @Internal
    @NotNull
    public abstract Property<AvdComponentsBuildService> getAvdComponents();

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.hasFailures;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableEmulatorDisplay();

    @Option(option="enable-display", description="Adding this option will display the emulator while testing, insteadof running the tests on a headless emulator.")
    public final void setDisplayEmulatorOption(boolean value) {
        this.getEnableEmulatorDisplay().set((Object)value);
    }

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getBuildConfigClasses();

    @Classpath
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getRClasses();

    public boolean getIgnoreFailures() {
        return this.shouldIgnore;
    }

    public void setIgnoreFailures(boolean ignore) {
        this.shouldIgnore = ignore;
    }

    @Override
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getResultsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportsDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCoverageDirectory();

    @Input
    @NotNull
    public abstract Property<Boolean> getAdditionalTestOutputEnabled();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getAdditionalTestOutputDir();

    @Override
    public void doTaskAction() {
        boolean bl;
        File additionalTestOutputDir;
        Object object;
        Object it2;
        Provider<Directory> emulatorProvider = ((AvdComponentsBuildService)this.getAvdComponents().get()).getEmulatorDirectory();
        Preconditions.checkArgument((boolean)emulatorProvider.isPresent(), (String)"The emulator is missing. Download the emulator in order to use managed devices.", (Object[])new Object[0]);
        Object object2 = this.getDeviceName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"deviceName.get()");
        String string = (String)object2;
        object2 = this.getAvdName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"avdName.get()");
        String string2 = (String)object2;
        object2 = this.getApiLevel().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apiLevel.get()");
        int n = ((Number)object2).intValue();
        object2 = this.getAbi().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"abi.get()");
        String string3 = (String)object2;
        object2 = ((Directory)((AvdComponentsBuildService)this.getAvdComponents().get()).getAvdFolder().get()).getAsFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"avdComponents.get().avdF\u2026get().asFile.absolutePath");
        Object object3 = object2;
        object2 = this.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"path");
        Object object4 = object2;
        Object object5 = ((Directory)emulatorProvider.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"emulatorProvider.get().asFile");
        File file = object5;
        object5 = SdkConstants.FN_EMULATOR;
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"FN_EMULATOR");
        object2 = FilesKt.resolve((File)file, (String)object5).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"emulatorProvider.get().a\u2026FN_EMULATOR).absolutePath");
        Object object6 = object2;
        object2 = this.getEnableEmulatorDisplay().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"enableEmulatorDisplay.get()");
        UtpManagedDevice managedDevice = new UtpManagedDevice(string, string2, n, string3, (String)object3, (String)object4, (String)object6, (Boolean)object2);
        DeviceProviderInstrumentTestTask.checkForNonApks(this.getBuddyApks().getFiles(), doTaskAction.1.INSTANCE);
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        File codeCoverageOutDir = ((Directory)this.getCoverageDirectory().get()).getAsFile();
        FileUtils.cleanOutputDir((File)codeCoverageOutDir);
        Object object7 = this.getAdditionalTestOutputEnabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"getAdditionalTestOutputEnabled().get()");
        if (((Boolean)object7).booleanValue()) {
            object7 = ((Directory)this.getAdditionalTestOutputDir().get()).getAsFile();
            boolean bl2 = false;
            boolean bl3 = false;
            it2 = object7;
            boolean bl4 = false;
            FileUtils.cleanOutputDir((File)it2);
            object = object7;
        } else {
            object = additionalTestOutputDir = (File)null;
        }
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            bl = true;
        } else {
            boolean runner22;
            try {
                ManagedDeviceTestRunner runner22 = this.getTestRunnerFactory().createTestRunner(this.getWorkerExecutor());
                Intrinsics.checkNotNullExpressionValue((Object)resultsOutDir, (String)"resultsOutDir");
                Intrinsics.checkNotNullExpressionValue((Object)codeCoverageOutDir, (String)"codeCoverageOutDir");
                Object object8 = this.getProjectPath().get();
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"projectPath.get()");
                String string4 = (String)object8;
                object8 = ((TestData)this.getTestData().get()).getFlavorName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"testData.get().flavorName.get()");
                String string5 = (String)object8;
                StaticTestData staticTestData = ((TestData)this.getTestData().get()).getAsStaticData();
                boolean it2 = false;
                object8 = this.getInstallOptions().getOrElse((Object)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"installOptions.getOrElse(listOf())");
                List list = (List)object8;
                object8 = this.getBuddyApks().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"buddyApks.files");
                runner22 = runner22.runTests(managedDevice, resultsOutDir, codeCoverageOutDir, additionalTestOutputDir, string4, string5, staticTestData, list, (Set<? extends File>)object8, new LoggerWrapper(this.getLogger()));
            }
            catch (Exception e) {
                ArtifactCollection artifactCollection = this.getDependencies();
                it2 = this.getTestRunnerFactory().getExecutionEnum().get();
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"testRunnerFactory.executionEnum.get()");
                TestOptions.Execution execution = (TestOptions.Execution)it2;
                it2 = this.getAnalyticsService().get();
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"analyticsService.get()");
                TestsAnalytics.recordCrashedInstrumentedTestRun(artifactCollection, execution, false, (AnalyticsService)it2);
                throw e;
            }
            bl = runner22;
        }
        boolean success = bl;
        File reportOutDir = ((Directory)this.getReportsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        CompositeTestResults results = report.generateReport();
        ArtifactCollection artifactCollection = this.getDependencies();
        Object bl4 = this.getTestRunnerFactory().getExecutionEnum().get();
        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"testRunnerFactory.executionEnum.get()");
        TestOptions.Execution execution = (TestOptions.Execution)bl4;
        int n2 = results.getTestCount();
        bl4 = this.getAnalyticsService().get();
        Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"analyticsService.get()");
        TestsAnalytics.recordOkInstrumentedTestRun(artifactCollection, execution, false, n2, (AnalyticsService)bl4);
        if (!success) {
            this.hasFailures = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message = Intrinsics.stringPlus((String)"There were failing tests. See the report at: ", (Object)reportUrl);
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
                return;
            }
            throw new GradleException(message);
        }
        this.hasFailures = false;
    }

    private final boolean testsFound() {
        Object object = ((TestData)this.getTestData().get()).hasTests((FileCollection)this.getClasses(), (FileCollection)this.getRClasses(), (FileCollection)this.getBuildConfigClasses()).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testData\n            .ge\u2026asses)\n            .get()");
        return (Boolean)object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$TestRunnerFactory;", "", "()V", "buildToolsRevision", "Lorg/gradle/api/provider/Property;", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "()Lorg/gradle/api/provider/Property;", "compileSdkVersion", "", "getCompileSdkVersion", "emulatorGpuFlag", "getEmulatorGpuFlag", "executionEnum", "Lcom/android/builder/model/TestOptions$Execution;", "getExecutionEnum", "retentionConfig", "Lcom/android/build/gradle/internal/testing/utp/RetentionConfig;", "getRetentionConfig", "sdkBuildService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkBuildService", "showEmulatorKernelLoggingFlag", "", "getShowEmulatorKernelLoggingFlag", "testShardsSize", "", "getTestShardsSize", "unifiedTestPlatform", "getUnifiedTestPlatform", "utpDependencies", "Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "getUtpDependencies", "()Lcom/android/build/gradle/internal/testing/utp/UtpDependencies;", "utpLoggingLevel", "Ljava/util/logging/Level;", "getUtpLoggingLevel", "createTestRunner", "Lcom/android/build/gradle/internal/testing/utp/ManagedDeviceTestRunner;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "gradle-core"})
    public static abstract class TestRunnerFactory {
        @Input
        @NotNull
        public abstract Property<Boolean> getUnifiedTestPlatform();

        @Input
        @NotNull
        public abstract Property<TestOptions.Execution> getExecutionEnum();

        @Input
        @NotNull
        public abstract Property<RetentionConfig> getRetentionConfig();

        @Input
        @NotNull
        public abstract Property<String> getCompileSdkVersion();

        @Input
        @NotNull
        public abstract Property<Revision> getBuildToolsRevision();

        @Input
        @Optional
        @NotNull
        public abstract Property<Integer> getTestShardsSize();

        @Internal
        @NotNull
        public abstract Property<SdkComponentsBuildService> getSdkBuildService();

        @Nested
        @NotNull
        public abstract UtpDependencies getUtpDependencies();

        @Internal
        @NotNull
        public abstract Property<Level> getUtpLoggingLevel();

        @Input
        @NotNull
        public abstract Property<String> getEmulatorGpuFlag();

        @Input
        @NotNull
        public abstract Property<Boolean> getShowEmulatorKernelLoggingFlag();

        @NotNull
        public final ManagedDeviceTestRunner createTestRunner(@NotNull WorkerExecutor workerExecutor) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
            Object object = this.getUnifiedTestPlatform().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unifiedTestPlatform.get()");
            Preconditions.checkArgument((boolean)((Boolean)object), (String)"android.experimental.androidTest.useUnifiedTestPlatform must be enabled.", (Object[])new Object[0]);
            Object object2 = (TestOptions.Execution)this.getExecutionEnum().get();
            int n = object2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            boolean useOrchestrator = bl;
            UtpDependencies utpDependencies = this.getUtpDependencies();
            SdkComponentsBuildService.VersionedSdkLoader versionedSdkLoader2 = ((SdkComponentsBuildService)this.getSdkBuildService().get()).sdkLoader((Provider<String>)((Provider)this.getCompileSdkVersion()), (Provider<Revision>)((Provider)this.getBuildToolsRevision()));
            object2 = this.getRetentionConfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"retentionConfig.get()");
            RetentionConfig retentionConfig = (RetentionConfig)object2;
            Integer n2 = (Integer)this.getTestShardsSize().getOrNull();
            object2 = this.getEmulatorGpuFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"emulatorGpuFlag.get()");
            String string = (String)object2;
            object2 = this.getShowEmulatorKernelLoggingFlag().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"showEmulatorKernelLoggingFlag.get()");
            boolean bl2 = (Boolean)object2;
            object2 = this.getUtpLoggingLevel().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"utpLoggingLevel.get()");
            return new ManagedDeviceTestRunner(workerExecutor, utpDependencies, versionedSdkLoader2, retentionConfig, useOrchestrator, n2, string, bl2, (Level)object2, null, null, 1536, null);
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestOptions.Execution.values().length];
                nArray[TestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR.ordinal()] = 1;
                nArray[TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0016\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ManagedDeviceInstrumentationTestTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "device", "Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;", "testData", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testResultOutputDir", "Ljava/io/File;", "testReportOutputDir", "nameSuffix", "", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lcom/android/build/gradle/internal/dsl/ManagedVirtualDevice;Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ManagedDeviceInstrumentationTestTask, VariantCreationConfig> {
        @NotNull
        private final ManagedVirtualDevice device;
        @NotNull
        private final AbstractTestDataImpl testData;
        @NotNull
        private final File testResultOutputDir;
        @NotNull
        private final File testReportOutputDir;
        @NotNull
        private final String nameSuffix;
        @NotNull
        private final String name;
        @NotNull
        private final Class<ManagedDeviceInstrumentationTestTask> type;

        public CreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull ManagedVirtualDevice device, @NotNull AbstractTestDataImpl testData, @NotNull File testResultOutputDir, @NotNull File testReportOutputDir, @NotNull String nameSuffix) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
            Intrinsics.checkNotNullParameter((Object)testResultOutputDir, (String)"testResultOutputDir");
            Intrinsics.checkNotNullParameter((Object)testReportOutputDir, (String)"testReportOutputDir");
            Intrinsics.checkNotNullParameter((Object)nameSuffix, (String)"nameSuffix");
            super((ComponentCreationConfig)creationConfig);
            this.device = device;
            this.testData = testData;
            this.testResultOutputDir = testResultOutputDir;
            this.testReportOutputDir = testReportOutputDir;
            this.nameSuffix = nameSuffix;
            this.name = this.computeTaskName(this.device.getName(), this.nameSuffix);
            this.type = ManagedDeviceInstrumentationTestTask.class;
        }

        public /* synthetic */ CreationAction(VariantCreationConfig variantCreationConfig, ManagedVirtualDevice managedVirtualDevice, AbstractTestDataImpl abstractTestDataImpl, File file, File file2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                string = "";
            }
            this(variantCreationConfig, managedVirtualDevice, abstractTestDataImpl, file, file2, string);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ManagedDeviceInstrumentationTestTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ManagedDeviceInstrumentationTestTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.1.INSTANCE).withName("managedDevice").on(InternalArtifactType.MANAGED_DEVICE_CODE_COVERAGE.INSTANCE);
            boolean isAdditionalAndroidTestOutputEnabled = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT);
            if (isAdditionalAndroidTestOutputEnabled) {
                ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, handleProvider.2.INSTANCE).withName("managedDevice").on(InternalArtifactType.MANAGED_DEVICE_ANDROID_TEST_ADDITIONAL_OUTPUT.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull ManagedDeviceInstrumentationTestTask task) {
            VariantCreationConfig testedConfig;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getEnableEmulatorDisplay().convention((Object)false);
            GlobalTaskCreationConfig globalConfig2 = ((VariantCreationConfig)this.creationConfig).getGlobal();
            ProjectOptions projectOptions = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions();
            VariantCreationConfig variantCreationConfig = testedConfig = ((VariantCreationConfig)this.creationConfig).getTestedConfig();
            String string = variantCreationConfig == null ? null : variantCreationConfig.getName();
            String variantName = string == null ? ((VariantCreationConfig)this.creationConfig).getName() : string;
            task.setDescription("Installs and runs the test for " + variantName + "  on the managed device " + this.device.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getDeviceName(), this.device.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getAvdName(), ManagedDeviceUtilsKt.computeAvdName(this.device));
            if (this.device.getApiLevel() <= 26 && !projectOptions.get(BooleanOption.GRADLE_MANAGED_DEVICE_ALLOW_OLD_API_LEVEL_DEVICES)) {
                throw new GradleException(StringsKt.trimIndent((String)("\n                    API level 26 and lower is currently not supported for Gradle Managed devices.\n                    Your current configuration requires API level " + this.device.getApiLevel() + ".\n                    While it's not recommended, you can use API levels 26 and lower by adding\n                    android.experimental.testOptions.managedDevices.allowOldApiLevelDevices=true\n                    to your gradle.properties file.\n                ")));
            }
            HasConfigurableValuesKt.setDisallowChanges(task.getApiLevel(), this.device.getApiLevel());
            HasConfigurableValuesKt.setDisallowChanges(task.getAbi(), ManagedDeviceUtilsKt.computeAbiFromArchitecture(this.device));
            Property<AvdComponentsBuildService> property = task.getAvdComponents();
            BuildServiceRegistry buildServiceRegistry$iv = ((VariantCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AvdComponentsBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Object[] objectArray = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
            HasConfigurableValuesKt.setDisallowChanges(property, objectArray);
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getTestData(), this.testData);
            task.getInstallOptions().set((Iterable)globalConfig2.getInstallationOptions().getInstallOptions());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getCompileSdkVersion(), globalConfig2.getCompileSdkHashString());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getBuildToolsRevision(), globalConfig2.getBuildToolsRevision());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getSdkBuildService(), BuildServicesKt.getBuildService(((VariantCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry(), SdkComponentsBuildService.class));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getTestShardsSize(), projectOptions.get(IntegerOption.MANAGED_DEVICE_SHARD_POOL_SIZE));
            TestOptions.Execution executionEnum = globalConfig2.getTestOptionExecutionEnum();
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getExecutionEnum(), executionEnum);
            object = testedConfig;
            boolean useUtp = UtpTestUtilsKt.shouldEnableUtp(projectOptions, globalConfig2.getTestOptions(), object == null ? null : object.getVariantType());
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getUnifiedTestPlatform(), useUtp);
            if (useUtp) {
                if (!projectOptions.get(BooleanOption.ANDROID_TEST_USES_UNIFIED_TEST_PLATFORM)) {
                    LoggerWrapper.getLogger(CreationAction.class).warning("Implicitly enabling Unified Test Platform because related features are specified in gradle test options. Please add -Pandroid.experimental.androidTest.useUnifiedTestPlatform=true to your gradle command to suppress this warning.", new Object[0]);
                }
                object = task.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.project");
                UtpDependencyUtilsKt.maybeCreateUtpConfigurations((Project)object);
                UtpDependencies utpDependencies = task.getTestRunnerFactory().getUtpDependencies();
                object = task.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.project.configurations");
                UtpDependencyUtilsKt.resolveDependencies(utpDependencies, (ConfigurationContainer)object);
            }
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getEmulatorGpuFlag(), ManagedDeviceUtilsKt.computeManagedDeviceEmulatorMode(((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions()));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getShowEmulatorKernelLoggingFlag(), ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.GRADLE_MANAGED_DEVICE_EMULATOR_SHOW_KERNEL_LOGGING));
            boolean infoLoggingEnabled = Logging.getLogger(ManagedDeviceInstrumentationTestTask.class).isInfoEnabled();
            task.getTestRunnerFactory().getUtpLoggingLevel().set((Object)(infoLoggingEnabled ? Level.INFO : Level.OFF));
            HasConfigurableValuesKt.setDisallowChanges(task.getTestRunnerFactory().getRetentionConfig(), RetentionConfigKt.createRetentionConfig(projectOptions, (EmulatorSnapshots)globalConfig2.getTestOptions().getEmulatorSnapshots()));
            task.dependencies = VariantDependencies.getArtifactCollection$default(((VariantCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR, null, 8, null);
            task.getAdditionalTestOutputEnabled().set((Object)projectOptions.get(BooleanOption.ENABLE_ADDITIONAL_ANDROID_TEST_OUTPUT));
            task.getResultsDir().set(this.testResultOutputDir);
            task.getReportsDir().set(this.testReportOutputDir);
            objectArray = (Configuration)task.getProject().getConfigurations().findByName("androidTestUtil");
            if (objectArray != null) {
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                boolean bl2 = false;
                Object[] it = objectArray2;
                boolean bl3 = false;
                Object[] objectArray3 = new Object[]{it};
                task.getBuddyApks().from(objectArray3);
            }
            objectArray = new Object[]{((VariantCreationConfig)this.creationConfig).getArtifacts().getAllClasses()};
            task.getClasses().from(objectArray);
            task.getClasses().disallowChanges();
            objectArray = new Object[]{((ComponentImpl)this.creationConfig).getCompiledBuildConfig()};
            task.getBuildConfigClasses().from(objectArray);
            task.getBuildConfigClasses().disallowChanges();
            objectArray = new Object[]{((ComponentImpl)this.creationConfig).getCompiledRClasses(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH)};
            task.getRClasses().from(objectArray);
            task.getRClasses().disallowChanges();
        }
    }
}

