/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.android.build.gradle.internal.testing.utp.UtpTestUtilsKt;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.XmlTestRunListener;
import com.android.tools.utp.plugins.result.listener.gradle.proto.GradleAndroidTestResultListenerProto;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.testing.platform.proto.api.core.IssueProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/testing/utp/DdmlibTestResultAdapter;", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "ddmlibTestRunName", "", "ddmlibTestResultListener", "Lcom/android/ddmlib/testrunner/XmlTestRunListener;", "(Ljava/lang/String;Lcom/android/ddmlib/testrunner/XmlTestRunListener;)V", "numTestFails", "", "startTimestamp", "", "onTestResultEvent", "", "testResultEvent", "Lcom/android/tools/utp/plugins/result/listener/gradle/proto/GradleAndroidTestResultListenerProto$TestResultEvent;", "gradle-core"})
public final class DdmlibTestResultAdapter
implements UtpTestResultListener {
    @NotNull
    private final String ddmlibTestRunName;
    @NotNull
    private final XmlTestRunListener ddmlibTestResultListener;
    private int numTestFails;
    private long startTimestamp;

    public DdmlibTestResultAdapter(@NotNull String ddmlibTestRunName, @NotNull XmlTestRunListener ddmlibTestResultListener) {
        Intrinsics.checkNotNullParameter((Object)ddmlibTestRunName, (String)"ddmlibTestRunName");
        Intrinsics.checkNotNullParameter((Object)ddmlibTestResultListener, (String)"ddmlibTestResultListener");
        this.ddmlibTestRunName = ddmlibTestRunName;
        this.ddmlibTestResultListener = ddmlibTestResultListener;
    }

    @Override
    public void onTestResultEvent(@NotNull GradleAndroidTestResultListenerProto.TestResultEvent testResultEvent) {
        Intrinsics.checkNotNullParameter((Object)testResultEvent, (String)"testResultEvent");
        GradleAndroidTestResultListenerProto.TestResultEvent.StateCase stateCase = testResultEvent.getStateCase();
        int n = stateCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[stateCase.ordinal()];
        switch (n) {
            case 1: {
                this.startTimestamp = System.currentTimeMillis();
                Any any = testResultEvent.getTestSuiteStarted().getTestSuiteMetadata();
                Intrinsics.checkNotNullExpressionValue((Object)any, (String)"testResultEvent.testSuiteStarted.testSuiteMetadata");
                Any $this$unpack$iv = any;
                boolean $i$f$unpack = false;
                Message message = $this$unpack$iv.unpack(TestSuiteResultProto.TestSuiteMetaData.class);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"unpack(T::class.java)");
                TestSuiteResultProto.TestSuiteMetaData testSuite = (TestSuiteResultProto.TestSuiteMetaData)message;
                this.ddmlibTestResultListener.testRunStarted(this.ddmlibTestRunName, testSuite.getScheduledTestCaseCount());
                break;
            }
            case 2: {
                Any $this$unpack$iv = testResultEvent.getTestCaseStarted().getTestCase();
                Intrinsics.checkNotNullExpressionValue((Object)$this$unpack$iv, (String)"testResultEvent.testCaseStarted.testCase");
                boolean $i$f$unpack = false;
                Message message = $this$unpack$iv.unpack(TestCaseProto.TestCase.class);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"unpack(T::class.java)");
                TestCaseProto.TestCase testCase = (TestCaseProto.TestCase)message;
                TestIdentifier testId = new TestIdentifier(testCase.getTestPackage() + '.' + testCase.getTestClass(), testCase.getTestMethod());
                this.ddmlibTestResultListener.testStarted(testId);
                break;
            }
            case 3: {
                Any testId = testResultEvent.getTestCaseFinished().getTestCaseResult();
                Intrinsics.checkNotNullExpressionValue((Object)testId, (String)"testResultEvent.testCaseFinished.testCaseResult");
                Any $this$unpack$iv = testId;
                boolean $i$f$unpack322 = false;
                Message message = $this$unpack$iv.unpack(TestResultProto.TestResult.class);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"unpack(T::class.java)");
                TestResultProto.TestResult testResult = (TestResultProto.TestResult)message;
                testId = new TestIdentifier(testResult.getTestCase().getTestPackage() + '.' + testResult.getTestCase().getTestClass(), testResult.getTestCase().getTestMethod());
                TestStatusProto.TestStatus $i$f$unpack322 = testResult.getTestStatus();
                int n2 = $i$f$unpack322 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[$i$f$unpack322.ordinal()];
                switch (n2) {
                    case 1: 
                    case 2: {
                        this.ddmlibTestResultListener.testFailed((TestIdentifier)testId, testResult.getError().getStackTrace());
                        DdmlibTestResultAdapter ddmlibTestResultAdapter = this;
                        ++ddmlibTestResultAdapter.numTestFails;
                        int cfr_ignored_0 = ddmlibTestResultAdapter.numTestFails;
                        break;
                    }
                    case 3: {
                        this.ddmlibTestResultListener.testIgnored((TestIdentifier)testId);
                    }
                }
                boolean $i$f$unpack322 = false;
                this.ddmlibTestResultListener.testEnded((TestIdentifier)testId, MapsKt.emptyMap());
                break;
            }
            case 4: {
                if (this.numTestFails > 0) {
                    this.ddmlibTestResultListener.testRunFailed("There was " + this.numTestFails + " failure(s).");
                }
                Any testId = testResultEvent.getTestSuiteFinished().getTestSuiteResult();
                Intrinsics.checkNotNullExpressionValue((Object)testId, (String)"testResultEvent.testSuiteFinished.testSuiteResult");
                Object $this$unpack$iv = testId;
                boolean $i$f$unpack = false;
                Message message = $this$unpack$iv.unpack(TestSuiteResultProto.TestSuiteResult.class);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"unpack(T::class.java)");
                TestSuiteResultProto.TestSuiteResult testSuiteResult = (TestSuiteResultProto.TestSuiteResult)message;
                if (testSuiteResult.hasPlatformError()) {
                    this.ddmlibTestResultListener.addSystemError(Intrinsics.stringPlus((String)UtpTestUtilsKt.getPlatformErrorMessage(testSuiteResult), (Object)"\n"));
                }
                $this$unpack$iv = testSuiteResult.getIssueList();
                Intrinsics.checkNotNullExpressionValue((Object)$this$unpack$iv, (String)"testSuiteResult.issueList");
                Iterable $this$forEach$iv = (Iterable)$this$unpack$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IssueProto.Issue issue = (IssueProto.Issue)element$iv;
                    boolean bl = false;
                    this.ddmlibTestResultListener.addSystemError(Intrinsics.stringPlus((String)issue.getMessage(), (Object)"\n"));
                }
                boolean bl = false;
                this.ddmlibTestResultListener.testRunEnded(System.currentTimeMillis() - this.startTimestamp, MapsKt.emptyMap());
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.values().length];
            nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_STARTED.ordinal()] = 1;
            nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_CASE_STARTED.ordinal()] = 2;
            nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_CASE_FINISHED.ordinal()] = 3;
            nArray[GradleAndroidTestResultListenerProto.TestResultEvent.StateCase.TEST_SUITE_FINISHED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TestStatusProto.TestStatus.values().length];
            nArray[TestStatusProto.TestStatus.FAILED.ordinal()] = 1;
            nArray[TestStatusProto.TestStatus.ERROR.ordinal()] = 2;
            nArray[TestStatusProto.TestStatus.IGNORED.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

