/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.extension.impl;

import com.android.Version;
import com.android.build.api.AndroidPluginVersion;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"CURRENT_AGP_VERSION", "Lcom/android/build/api/AndroidPluginVersion;", "getCURRENT_AGP_VERSION", "()Lcom/android/build/api/AndroidPluginVersion;", "parseAndroidGradlePluginVersion", "version", "", "gradle-core"})
public final class CurrentAndroidGradlePluginVersionKt {
    @NotNull
    private static final AndroidPluginVersion CURRENT_AGP_VERSION;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public static final AndroidPluginVersion parseAndroidGradlePluginVersion(@NotNull String version) {
        AndroidPluginVersion androidPluginVersion;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        GradleVersion parsed = GradleVersion.parseAndroidGradlePluginVersion((String)version);
        AndroidPluginVersion stable = new AndroidPluginVersion(parsed.getMajor(), parsed.getMinor(), parsed.getMicro());
        if (StringsKt.endsWith$default((String)version, (String)"-dev", (boolean)false, (int)2, null)) {
            return stable.dev();
        }
        String string = parsed.getPreviewType();
        if (string == null) {
            androidPluginVersion = stable;
            return androidPluginVersion;
        }
        int n = -1;
        switch (string.hashCode()) {
            case 3633: {
                if (!string.equals("rc")) break;
                n = 1;
                break;
            }
            case 92909918: {
                if (!string.equals("alpha")) break;
                n = 2;
                break;
            }
            case 3020272: {
                if (!string.equals("beta")) break;
                n = 3;
                break;
            }
        }
        switch (n) {
            case 2: {
                androidPluginVersion = stable.alpha(parsed.getPreview());
                return androidPluginVersion;
            }
            case 3: {
                androidPluginVersion = stable.beta(parsed.getPreview());
                return androidPluginVersion;
            }
            case 1: {
                androidPluginVersion = stable.rc(parsed.getPreview());
                return androidPluginVersion;
            }
        }
        throw new IllegalStateException("Internal error: Unexpected Android Gradle Plugin version: " + version + ": " + parsed.getPreviewType() + " is expected to be 'alpha', 'beta' or 'rc'.");
    }

    @NotNull
    public static final AndroidPluginVersion getCURRENT_AGP_VERSION() {
        return CURRENT_AGP_VERSION;
    }

    static {
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        CURRENT_AGP_VERSION = CurrentAndroidGradlePluginVersionKt.parseAndroidGradlePluginVersion(string);
    }
}

