/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.google.common.base.Preconditions;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u0007J\b\u0010\"\u001a\u00020\u001aH\u0007J\b\u0010#\u001a\u00020\u001aH\u0007J\u0006\u0010$\u001a\u00020\u001aJ\u0006\u0010%\u001a\u00020\u001aJ\u0006\u0010&\u001a\u00020\u001aJ\b\u0010'\u001a\u00020\u0003H\u0007J\u0006\u0010(\u001a\u00020\nJ\u0006\u0010)\u001a\u00020\u001aJ\b\u0010*\u001a\u0004\u0018\u00010\u001aJ\b\u0010+\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\nJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0014\u001a\u00020\nJ\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010\u000e2\u0006\u0010\u0014\u001a\u00020\nR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\f\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/scope/ProjectInfo;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "group", "", "getGroup", "()Ljava/lang/String;", "intermediatesDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getIntermediatesDirectory", "()Lorg/gradle/api/provider/Provider;", "name", "getName", "path", "getPath", "projectDirectory", "getProjectDirectory", "()Lorg/gradle/api/file/Directory;", "rootDir", "Ljava/io/File;", "getRootDir", "()Ljava/io/File;", "version", "getVersion", "createTestResources", "Lorg/gradle/api/resources/TextResource;", "value", "getBuildDir", "getIntermediatesDir", "getJacocoAgent", "getJacocoAgentOutputDirectory", "getOutputsDir", "getProject", "getProjectBaseName", "getReportsDir", "getTestReportFolder", "getTestResultsFolder", "getTmpFolder", "hasPlugin", "", "plugin", "intermediatesFile", "Lorg/gradle/api/file/RegularFile;", "Companion", "gradle-core"})
public final class ProjectInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ProjectInfo(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final String getProjectBaseName() {
        return Companion.getBaseName(this.project);
    }

    @NotNull
    public final String getPath() {
        String string = this.project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        return string;
    }

    @NotNull
    public final String getName() {
        String string = this.project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        return string;
    }

    @NotNull
    public final String getGroup() {
        return this.project.getGroup().toString();
    }

    @NotNull
    public final String getVersion() {
        return this.project.getVersion().toString();
    }

    @NotNull
    public final Directory getProjectDirectory() {
        Directory directory2 = this.project.getLayout().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directory2, (String)"project.layout.projectDirectory");
        return directory2;
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        DirectoryProperty directoryProperty = this.project.getLayout().getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.layout.buildDirectory");
        return directoryProperty;
    }

    @NotNull
    public final File getRootDir() {
        File file = this.project.getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        return file;
    }

    @NotNull
    public final Provider<Directory> getIntermediatesDirectory() {
        Provider provider2 = this.project.getLayout().getBuildDirectory().dir("intermediates");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026nstants.FD_INTERMEDIATES)");
        return provider2;
    }

    @NotNull
    public final Provider<Directory> intermediatesDirectory(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Provider provider2 = this.project.getLayout().getBuildDirectory().dir("intermediates").map(new Transformer(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
            }

            public final Directory transform(Directory it) {
                return it.dir(this.$path);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"path: String): Provider<\u2026   it.dir(path)\n        }");
        return provider2;
    }

    @NotNull
    public final Provider<RegularFile> intermediatesFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Provider provider2 = this.project.getLayout().getBuildDirectory().dir("intermediates").map(new Transformer(path){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
            }

            public final RegularFile transform(Directory it) {
                return it.file(this.$path);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"path: String): Provider<\u2026  it.file(path)\n        }");
        return provider2;
    }

    @Deprecated(message="Do not use: b/202449978")
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Deprecated(message="DO NOT USE - Only use the new Gradle Property objects")
    @NotNull
    public final TextResource createTestResources(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TextResource textResource = this.project.getResources().getText().fromString(value);
        Intrinsics.checkNotNullExpressionValue((Object)textResource, (String)"project.resources.text.fromString(value)");
        return textResource;
    }

    public final boolean hasPlugin(@NotNull String plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        return this.project.getPlugins().hasPlugin(plugin);
    }

    @Deprecated(message="Use buildDirectory instead")
    @NotNull
    public final File getBuildDir() {
        File file = this.project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        return file;
    }

    @Nullable
    public final File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    @NotNull
    public final File getReportsDir() {
        return new File(this.getBuildDir(), "reports");
    }

    @Nullable
    public final File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    @Deprecated(message="Use the version that returns a provider")
    @NotNull
    public final File getIntermediatesDir() {
        return new File(this.getBuildDir(), "intermediates");
    }

    @NotNull
    public final File getTmpFolder() {
        return new File(this.getIntermediatesDir(), "tmp");
    }

    @NotNull
    public final File getOutputsDir() {
        return new File(this.getBuildDir(), "outputs");
    }

    @NotNull
    public final File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    @NotNull
    public final File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }

    @JvmStatic
    @NotNull
    public static final String getBaseName(@NotNull Project $this$getBaseName) {
        return Companion.getBaseName($this$getBaseName);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/scope/ProjectInfo$Companion;", "", "()V", "getBaseName", "", "Lorg/gradle/api/Project;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getBaseName(@NotNull Project $this$getBaseName) {
            BasePluginConvention convention;
            Intrinsics.checkNotNullParameter((Object)$this$getBaseName, (String)"<this>");
            BasePluginConvention basePluginConvention = convention = (BasePluginConvention)Preconditions.checkNotNull((Object)$this$getBaseName.getConvention().findPlugin(BasePluginConvention.class));
            Intrinsics.checkNotNull((Object)basePluginConvention);
            String string = basePluginConvention.getArchivesBaseName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convention!!.archivesBaseName");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

