/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.utils.ILogger;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public abstract class UninstallTask
extends NonIncrementalTask {
    private String variantName;
    private String projectName;
    private int mTimeOutInMs = 0;

    @Input
    public abstract Property<String> getApplicationId();

    public UninstallTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Uninstall task is always run.");
            return false;
        });
    }

    @Override
    protected void doTaskAction() throws DeviceException, ExecutionException {
        Logger logger = this.getLogger();
        logger.info("Uninstalling app: {}", this.getApplicationId());
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.getBuildToolsExecutableInput().adbExecutable(), this.getTimeOutInMs(), (ILogger)iLogger, System.getenv("ANDROID_SERIAL"));
        deviceProvider.use(() -> {
            List devices = deviceProvider.getDevices();
            for (DeviceConnector device : devices) {
                device.uninstallPackage((String)this.getApplicationId().get(), this.getTimeOutInMs(), iLogger);
                logger.lifecycle("Uninstalling {} (from {}:{}) from device '{}' ({}).", new Object[]{this.getApplicationId().get(), this.projectName, this.variantName, device.getName(), device.getSerialNumber()});
            }
            int n = devices.size();
            logger.quiet("Uninstalled {} from {} device{}.", new Object[]{this.getApplicationId().get(), n, n == 1 ? "" : "s"});
            return null;
        });
    }

    @Input
    public int getTimeOutInMs() {
        return this.mTimeOutInMs;
    }

    @Nested
    public abstract BuildToolsExecutableInput getBuildToolsExecutableInput();

    public void setTimeOutInMs(int timeoutInMs) {
        this.mTimeOutInMs = timeoutInMs;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<UninstallTask, ApkCreationConfig> {
        public CreationAction(ApkCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("uninstall");
        }

        @Override
        public Class<UninstallTask> getType() {
            return UninstallTask.class;
        }

        @Override
        public void configure(UninstallTask task) {
            super.configure(task);
            task.variantName = ((ApkCreationConfig)this.creationConfig).getName();
            task.projectName = task.getProject().getName();
            task.getApplicationId().set(((ApkCreationConfig)this.creationConfig).getApplicationId());
            task.setDescription("Uninstalls the " + ((ApkCreationConfig)this.creationConfig).getDescription() + ".");
            task.setGroup("Install");
            task.setTimeOutInMs(((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions().getTimeOutInMs());
            SdkComponentsKt.initialize(task.getBuildToolsExecutableInput(), this.creationConfig);
        }

        @Override
        public void handleProvider(TaskProvider<UninstallTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setUninstallTask(taskProvider);
        }
    }
}

