/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.prefab;

import com.android.build.api.dsl.PrefabPackagingOptions;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.prefab.AndroidAbiMetadata;
import com.android.build.gradle.internal.cxx.prefab.JsonSerializer;
import com.android.build.gradle.internal.cxx.prefab.ModuleMetadataV1;
import com.android.build.gradle.internal.cxx.prefab.PackageMetadataV1;
import com.android.build.gradle.internal.cxx.prefab.PrefabModuleTaskData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.FileOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a(\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\u001a\"\u0010\u001e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\"\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\u0004\u001a\n\u0010#\u001a\u00020\u0004*\u00020$\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020&\u001a\n\u0010'\u001a\u00020\u0004*\u00020$\u001a\n\u0010(\u001a\u00020\u0004*\u00020$\u001a\n\u0010)\u001a\u00020\u0004*\u00020$\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"EXTRACT_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "PREFAB_PACKAGE_CONFIGURATION_SEGMENT", "", "PREFAB_PACKAGE_SEGMENT", "configurePrefab", "", "fileOperations", "Lorg/gradle/api/internal/file/FileOperations;", "installDir", "Ljava/io/File;", "packageName", "packageVersion", "modules", "", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabModuleTaskData;", "configurationModel", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "createAbiJson", "libDir", "moduleName", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "createLibs", "moduleDir", "createModule", "module", "packageDir", "createModuleJson", "createPrefabJson", "installHeaders", "headers", "versionOrError", "version", "prefabConfigurePackageTaskName", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "prefabPackageConfigurationData", "Lcom/android/build/gradle/internal/component/LibraryCreationConfig;", "prefabPackageConfigurationLocation", "prefabPackageLocation", "prefabPackageTaskName", "gradle-core"})
public final class PrefabPublishingKt {
    @NotNull
    public static final String PREFAB_PACKAGE_SEGMENT = "prefab_package";
    @NotNull
    public static final String PREFAB_PACKAGE_CONFIGURATION_SEGMENT = "prefab_package_configuration";
    private static final Pattern EXTRACT_VERSION_PATTERN = Pattern.compile("^\\d+(\\.\\d+(\\.\\d+(\\.\\d+)?)?)?");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PrefabModuleTaskData> prefabPackageConfigurationData(@NotNull LibraryCreationConfig $this$prefabPackageConfigurationData) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$prefabPackageConfigurationData, (String)"<this>");
        Project project2 = $this$prefabPackageConfigurationData.getServices().getProjectInfo().getProject();
        Iterable $this$map$iv = $this$prefabPackageConfigurationData.getGlobal().getPrefab();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file;
            void options;
            PrefabPackagingOptions prefabPackagingOptions = (PrefabPackagingOptions)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = options.getHeaders();
            if (string == null) {
                file = null;
            } else {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String headers = string2;
                boolean bl4 = false;
                file = project2.getLayout().getProjectDirectory().dir(headers).getAsFile();
            }
            File headers = file;
            PrefabModuleTaskData prefabModuleTaskData = new PrefabModuleTaskData(options.getName(), headers, options.getLibraryName());
            collection.add(prefabModuleTaskData);
        }
        return (List)destination$iv$iv;
    }

    public static final void configurePrefab(@NotNull FileOperations fileOperations, @NotNull File installDir, @NotNull String packageName, @Nullable String packageVersion, @NotNull List<PrefabModuleTaskData> modules, @NotNull CxxConfigurationModel configurationModel) {
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"fileOperations");
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)configurationModel, (String)"configurationModel");
        installDir.mkdirs();
        PrefabPublishingKt.createPrefabJson(installDir, packageName, packageVersion);
        for (PrefabModuleTaskData module2 : modules) {
            PrefabPublishingKt.createModule(fileOperations, module2, installDir, configurationModel);
        }
    }

    private static final void createPrefabJson(File installDir, String packageName, String packageVersion) {
        List list = CollectionsKt.emptyList();
        FilesKt.writeText$default((File)FilesKt.resolve((File)installDir, (String)"prefab.json"), (String)new JsonSerializer().toJson(new PackageMetadataV1(packageName, 2, list, packageVersion)), null, (int)2, null);
    }

    private static final void createModule(FileOperations fileOperations, PrefabModuleTaskData module2, File packageDir, CxxConfigurationModel configurationModel) {
        File file = FilesKt.resolve((File)packageDir, (String)Intrinsics.stringPlus((String)"modules/", (Object)module2.getName()));
        boolean bl = false;
        boolean bl2 = false;
        File $this$createModule_u24lambda_u2d2 = file;
        boolean bl3 = false;
        $this$createModule_u24lambda_u2d2.mkdirs();
        File moduleDir = file;
        PrefabPublishingKt.createModuleJson(module2, moduleDir);
        PrefabPublishingKt.installHeaders(fileOperations, module2.getHeaders(), moduleDir);
        PrefabPublishingKt.createLibs(moduleDir, module2.getName(), configurationModel);
    }

    private static final void createModuleJson(PrefabModuleTaskData module2, File moduleDir) {
        FilesKt.writeText$default((File)FilesKt.resolve((File)moduleDir, (String)"module.json"), (String)new JsonSerializer().toJson(new ModuleMetadataV1(CollectionsKt.emptyList(), module2.getLibraryName(), null, 4, null)), null, (int)2, null);
    }

    private static final void installHeaders(FileOperations fileOperations, File headers, File moduleDir) {
        File includeDir = FilesKt.resolve((File)moduleDir, (String)"include");
        if (headers == null) {
            FilesKt.deleteRecursively((File)includeDir);
            return;
        }
        includeDir.mkdirs();
        LoggingEnvironmentKt.infoln("Installing header " + headers + " to " + includeDir, new Object[0]);
        fileOperations.sync(new Action(headers, includeDir){
            final /* synthetic */ File $headers;
            final /* synthetic */ File $includeDir;
            {
                this.$headers = $headers;
                this.$includeDir = $includeDir;
            }

            public final void execute(CopySpec spec) {
                Object[] objectArray = new Object[]{this.$headers};
                spec.from(objectArray);
                spec.into((Object)this.$includeDir);
            }
        });
    }

    private static final void createLibs(File moduleDir, String moduleName, CxxConfigurationModel configurationModel) {
        File file = FilesKt.resolve((File)moduleDir, (String)"libs");
        boolean bl = false;
        boolean bl2 = false;
        File $this$createLibs_u24lambda_u2d3 = file;
        boolean bl3 = false;
        FilesKt.deleteRecursively((File)$this$createLibs_u24lambda_u2d3);
        File libsDir = file;
        for (CxxAbiModel abiData : configurationModel.getActiveAbis()) {
            File libDir = FilesKt.resolve((File)libsDir, (String)Intrinsics.stringPlus((String)"android.", (Object)abiData.getAbi().getTag()));
            PrefabPublishingKt.createAbiJson(libDir, moduleName, abiData);
        }
    }

    private static final void createAbiJson(File libDir, String moduleName, CxxAbiModel abi) {
        String string;
        File file;
        Object v0;
        block2: {
            NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, null);
            Intrinsics.checkNotNullExpressionValue((Object)nativeBuildConfigValueMini, (String)"getNativeBuildMiniConfig(abi, null)");
            NativeBuildConfigValueMini config2 = nativeBuildConfigValueMini;
            Iterable $this$singleOrNull$iv = config2.libraries.values();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                NativeLibraryValueMini it = (NativeLibraryValueMini)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.artifactName, (Object)moduleName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        NativeLibraryValueMini library = v0;
        Object object = library;
        Boolean bl = object == null ? null : ((file = ((NativeLibraryValueMini)object).output) == null ? null : ((string = file.getPath()) == null ? null : Boolean.valueOf(StringsKt.endsWith$default((String)string, (String)".a", (boolean)false, (int)2, null))));
        libDir.mkdirs();
        File file2 = FilesKt.resolve((File)libDir, (String)"abi.json");
        JsonSerializer jsonSerializer = new JsonSerializer();
        object = abi.getAbi().getTag();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"abi.abi.tag");
        FilesKt.writeText$default((File)file2, (String)jsonSerializer.toJson(new AndroidAbiMetadata((String)object, CxxAbiModelKt.getMinSdkVersion(abi), abi.getVariant().getModule().getNdkVersion().getMajor(), abi.getVariant().getStlType(), bl)), null, (int)2, null);
    }

    @NotNull
    public static final String prefabPackageTaskName(@NotNull ComponentCreationConfig $this$prefabPackageTaskName) {
        Intrinsics.checkNotNullParameter((Object)$this$prefabPackageTaskName, (String)"<this>");
        return $this$prefabPackageTaskName.computeTaskName("prefab", "Package");
    }

    @NotNull
    public static final String prefabConfigurePackageTaskName(@NotNull ComponentCreationConfig $this$prefabConfigurePackageTaskName) {
        Intrinsics.checkNotNullParameter((Object)$this$prefabConfigurePackageTaskName, (String)"<this>");
        return $this$prefabConfigurePackageTaskName.computeTaskName("prefab", "ConfigurePackage");
    }

    @NotNull
    public static final String prefabPackageLocation(@NotNull ComponentCreationConfig $this$prefabPackageLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$prefabPackageLocation, (String)"<this>");
        String string = FilesKt.resolve((File)FilesKt.resolve((File)$this$prefabPackageLocation.getServices().getProjectInfo().getIntermediatesDir(), (String)PREFAB_PACKAGE_SEGMENT), (String)$this$prefabPackageLocation.getName()).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"services.projectInfo.get\u2026me)\n        .absolutePath");
        return string;
    }

    @NotNull
    public static final String prefabPackageConfigurationLocation(@NotNull ComponentCreationConfig $this$prefabPackageConfigurationLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$prefabPackageConfigurationLocation, (String)"<this>");
        String string = FilesKt.resolve((File)FilesKt.resolve((File)$this$prefabPackageConfigurationLocation.getServices().getProjectInfo().getIntermediatesDir(), (String)PREFAB_PACKAGE_CONFIGURATION_SEGMENT), (String)$this$prefabPackageConfigurationLocation.getName()).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"services.projectInfo.get\u2026me)\n        .absolutePath");
        return string;
    }

    @Nullable
    public static final String versionOrError(@NotNull String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Matcher m = EXTRACT_VERSION_PATTERN.matcher(version);
        if (m.find()) {
            string = m.group();
        } else if (Intrinsics.areEqual((Object)version, (Object)"unspecified")) {
            string = null;
        } else {
            LoggingEnvironmentKt.errorln("The version package version '" + version + "' is incompatible with CMake", new Object[0]);
            string = version;
        }
        return string;
    }
}

