/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.component.impl;

import com.android.build.api.variant.AndroidVersion;
import com.android.build.api.variant.Renderscript;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.core.dsl.ConsumableComponentDslInfo;
import com.android.build.gradle.internal.core.dsl.DynamicFeatureVariantDslInfo;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.VariantServices;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/android/build/api/component/impl/ConsumableCreationConfigImpl;", "T", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "", "config", "dslInfo", "Lcom/android/build/gradle/internal/core/dsl/ConsumableComponentDslInfo;", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;Lcom/android/build/gradle/internal/core/dsl/ConsumableComponentDslInfo;)V", "getConfig", "()Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "getDexingType", "()Lcom/android/builder/dexing/DexingType;", "getDslInfo", "()Lcom/android/build/gradle/internal/core/dsl/ConsumableComponentDslInfo;", "isCoreLibraryDesugaringEnabled", "", "()Z", "minSdkVersionForDexing", "Lcom/android/build/api/variant/AndroidVersion;", "getMinSdkVersionForDexing", "()Lcom/android/build/api/variant/AndroidVersion;", "needsShrinkDesugarLibrary", "getNeedsShrinkDesugarLibrary", "getJava8LangSupportType", "Lcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;", "getNeedsMergedJavaResStream", "creationConfig", "renderscript", "Lcom/android/build/api/variant/Renderscript;", "internalServices", "Lcom/android/build/gradle/internal/services/VariantServices;", "gradle-core"})
public class ConsumableCreationConfigImpl<T extends ConsumableCreationConfig> {
    @NotNull
    private final T config;
    @NotNull
    private final ConsumableComponentDslInfo dslInfo;

    public ConsumableCreationConfigImpl(@NotNull T config2, @NotNull ConsumableComponentDslInfo dslInfo) {
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)dslInfo, (String)"dslInfo");
        this.config = config2;
        this.dslInfo = dslInfo;
    }

    @NotNull
    protected final T getConfig() {
        return this.config;
    }

    @NotNull
    protected ConsumableComponentDslInfo getDslInfo() {
        return this.dslInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final DexingType getDexingType() {
        DexingType dexingType;
        DexingType dexingType2;
        Object object = this.getDslInfo();
        Object object2 = object instanceof DynamicFeatureVariantDslInfo ? (DynamicFeatureVariantDslInfo)object : null;
        DexingType dexingType3 = dexingType2 = object2 == null ? null : object2.getDexingType();
        if (dexingType2 != null) {
            dexingType = dexingType2;
            return dexingType;
        }
        if (!this.config.isMultiDexEnabled()) {
            dexingType = DexingType.MONO_DEX;
            return dexingType;
        }
        if (VariantApiExtensionsKt.getFeatureLevel(this.config.getMinSdkVersion()) < 21) {
            boolean bl;
            object2 = this.getDslInfo().getTargetDeployApiFromIDE();
            if (object2 == null) {
                bl = false;
            } else {
                object = object2;
                int it = ((Number)object).intValue();
                boolean bl2 = false;
                bl = it >= 21;
            }
            if (!bl) {
                dexingType = DexingType.LEGACY_MULTIDEX;
                return dexingType;
            }
        }
        dexingType = DexingType.NATIVE_MULTIDEX;
        return dexingType;
    }

    public boolean getNeedsMergedJavaResStream() {
        Collection collection;
        return this.getDslInfo().getComponentType().isAar() || !(collection = (Collection)this.getDslInfo().getTransforms()).isEmpty() || this.config.getMinifiedEnabled();
    }

    @NotNull
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        return !this.getDslInfo().getCompileOptions().getTargetCompatibility().isJava8Compatible() ? VariantScope.Java8LangSupport.UNUSED : (this.config.getServices().getProjectInfo().hasPlugin("me.tatarka.retrolambda") ? VariantScope.Java8LangSupport.RETROLAMBDA : (this.config.getMinifiedEnabled() ? VariantScope.Java8LangSupport.R8 : VariantScope.Java8LangSupport.D8));
    }

    public final boolean isCoreLibraryDesugaringEnabled() {
        return this.isCoreLibraryDesugaringEnabled((ConsumableCreationConfig)this.config);
    }

    public boolean getNeedsShrinkDesugarLibrary() {
        return this.isCoreLibraryDesugaringEnabled((ConsumableCreationConfig)this.config);
    }

    public final boolean isCoreLibraryDesugaringEnabled(@NotNull ConsumableCreationConfig creationConfig) {
        boolean langDesugarEnabled;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        boolean libDesugarEnabled = this.getDslInfo().getCompileOptions().isCoreLibraryDesugaringEnabled();
        boolean multidexEnabled = creationConfig.isMultiDexEnabled();
        VariantScope.Java8LangSupport langSupportType = this.getJava8LangSupportType();
        boolean bl = langDesugarEnabled = langSupportType == VariantScope.Java8LangSupport.D8 || langSupportType == VariantScope.Java8LangSupport.R8;
        if (libDesugarEnabled && !langDesugarEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.config.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable java 8 language desugaring with D8 or R8.", null, null, (int)12, null);
        }
        if (libDesugarEnabled && !multidexEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.config.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable multidex.", null, null, (int)12, null);
        }
        return libDesugarEnabled;
    }

    @NotNull
    public AndroidVersion getMinSdkVersionForDexing() {
        return this.config.getMinSdkVersion();
    }

    @Nullable
    public final Renderscript renderscript(@NotNull VariantServices internalServices) {
        Renderscript renderscript2;
        Intrinsics.checkNotNullParameter((Object)internalServices, (String)"internalServices");
        if (this.config.getBuildFeatures().getRenderScript()) {
            Renderscript renderscript3;
            Renderscript it = renderscript3 = internalServices.newInstance(Renderscript.class, new Object[0]);
            boolean bl = false;
            it.getSupportModeEnabled().set((Object)this.getDslInfo().getRenderscriptSupportModeEnabled());
            it.getSupportModeBlasEnabled().set((Object)this.getDslInfo().getRenderscriptSupportModeBlasEnabled());
            it.getNdkModeEnabled().set((Object)this.getDslInfo().getRenderscriptNdkModeEnabled());
            it.getOptimLevel().set((Object)this.getDslInfo().getRenderscriptOptimLevel());
            renderscript2 = renderscript3;
        } else {
            renderscript2 = null;
        }
        return renderscript2;
    }
}

