/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.LibraryVariantBuilder;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.cxx.configure.CxxCreateGradleTasksKt;
import com.android.build.gradle.internal.dependency.ConfigurationVariantMapping;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.res.GenerateApiPublicTxtTask;
import com.android.build.gradle.internal.res.GenerateEmptyResourceFilesTask;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.DokkaParallelBuildService;
import com.android.build.gradle.internal.tasks.AarMetadataTask;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesDir;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesJar;
import com.android.build.gradle.internal.tasks.BundleLibraryJavaRes;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.BundleAar;
import com.android.build.gradle.tasks.CompileLibraryResourcesTask;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.JavaDocGenerationTask;
import com.android.build.gradle.tasks.JavaDocJarTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.ProcessLibraryArtProfileTask;
import com.android.build.gradle.tasks.ProcessLibraryManifest;
import com.android.build.gradle.tasks.SourceJarTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.build.gradle.tasks.sync.LibraryVariantModelTask;
import com.android.builder.errors.IssueReporter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

public class LibraryTaskManager
extends TaskManager<LibraryVariantBuilder, LibraryCreationConfig> {
    public LibraryTaskManager(Project project2, Collection<? extends ComponentInfo<LibraryVariantBuilder, LibraryCreationConfig>> variants, Collection<? extends TestComponentCreationConfig> testComponents, Collection<? extends TestFixturesCreationConfig> testFixturesComponents, GlobalTaskCreationConfig globalConfig2, TaskManagerConfig localConfig, BaseExtension extension2) {
        super(project2, variants, testComponents, testFixturesComponents, globalConfig2, localConfig, extension2);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<LibraryVariantBuilder, LibraryCreationConfig> variantInfo) {
        LibraryCreationConfig libraryVariant = variantInfo.getVariant();
        BuildFeatureValues buildFeatures = libraryVariant.getBuildFeatures();
        this.createAnchorTasks(libraryVariant);
        this.taskFactory.register(new LibraryVariantModelTask.CreationAction(libraryVariant));
        this.createDependencyStreams(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createGenerateResValuesTask(libraryVariant);
            this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(libraryVariant));
            this.taskFactory.register(new ExtractDeepLinksTask.AarCreationAction(libraryVariant));
        } else {
            if (this.globalConfig.getNamespacedAndroidResources()) {
                this.getLogger().error("Disabling resource processing in resource namespace aware modules is not supported currently.");
            }
            this.taskFactory.register(new GenerateEmptyResourceFilesTask.CreateAction(libraryVariant));
        }
        this.taskFactory.register(new CheckManifest.CreationAction(libraryVariant));
        this.taskFactory.register(new ProcessLibraryManifest.CreationAction(libraryVariant, libraryVariant.getTargetSdkVersion(), libraryVariant.getMaxSdkVersion(), libraryVariant.getManifestPlaceholders()));
        this.createRenderscriptTask(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createMergeResourcesTasks(libraryVariant);
            this.createCompileLibraryResourcesTask(libraryVariant);
        }
        this.createShaderTask(libraryVariant);
        this.createMergeAssetsTask(libraryVariant);
        this.createLibraryAssetsTask(libraryVariant);
        this.createBuildConfigTask(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createProcessResTask(libraryVariant, null, TaskManager.MergeType.PACKAGE, libraryVariant.getServices().getProjectInfo().getProjectBaseName());
            if (!libraryVariant.getDebuggable() && !this.globalConfig.getNamespacedAndroidResources()) {
                this.createVerifyLibraryResTask(libraryVariant);
            }
            this.registerLibraryRClassTransformStream(libraryVariant);
        }
        this.createProcessJavaResTask(libraryVariant);
        this.createAidlTask(libraryVariant);
        this.createDataBindingTasksIfNecessary(libraryVariant);
        this.createMlkitTask(libraryVariant);
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(libraryVariant);
        this.addJavacClassesStream(libraryVariant);
        TaskManager.setJavaCompilerTask(javacTask, libraryVariant);
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(libraryVariant));
        CxxCreateGradleTasksKt.createCxxVariantBuildTask(this.taskFactory, variantInfo.getVariant(), this.project.getProviders(), this.project.getLayout());
        this.createMergeJniLibFoldersTasks(libraryVariant);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(libraryVariant));
        this.taskFactory.register(new PackageRenderscriptTask.CreationAction(libraryVariant));
        this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(libraryVariant));
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(libraryVariant));
        if (libraryVariant.getServices().getProjectOptions().get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.register(new ExtractAnnotations.CreationAction(libraryVariant));
        }
        boolean instrumented = libraryVariant.isAndroidTestCoverageEnabled();
        TransformManager transformManager = libraryVariant.getTransformManager();
        if (instrumented) {
            this.createJacocoTask(libraryVariant);
        }
        this.maybeCreateTransformClassesWithAsmTask(libraryVariant);
        List<Transform> customTransforms = this.globalConfig.getTransforms();
        List<List<Object>> customTransformsDependencies = this.globalConfig.getTransformsDependencies();
        IssueReporter issueReporter2 = libraryVariant.getServices().getIssueReporter();
        int count = customTransforms.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Transform transform2 = customTransforms.get(i2);
            Sets.SetView difference = Sets.difference((Set)transform2.getScopes(), TransformManager.PROJECT_ONLY);
            if (!difference.isEmpty()) {
                String scopes2 = difference.toString();
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes2));
            }
            List<Object> deps = customTransformsDependencies.get(i2);
            transformManager.addTransform(this.taskFactory, libraryVariant, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(libraryVariant.getTaskContainer().getAssembleTask(), taskProvider);
                }
            });
        }
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(libraryVariant, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
        this.taskFactory.register(new BundleLibraryClassesDir.CreationAction(libraryVariant));
        this.taskFactory.register(new BundleLibraryJavaRes.CreationAction(libraryVariant));
        this.taskFactory.register(new ZipMergingTask.CreationAction(libraryVariant));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectOnlyCreationAction(libraryVariant, InternalArtifactType.LIBRARY_JNI.INSTANCE));
        this.createMergeJavaResTask(libraryVariant);
        this.maybeCreateJavaCodeShrinkerTask(libraryVariant);
        this.taskFactory.register(new LibraryAarJarsTask.CreationAction(libraryVariant, libraryVariant.getMinifiedEnabled()));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectAndLocalJarsCreationAction(libraryVariant, InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI.INSTANCE));
        this.taskFactory.register(new AarMetadataTask.CreationAction(libraryVariant));
        this.taskFactory.register(new BundleAar.LibraryLocalLintCreationAction(libraryVariant));
        this.createBundleTask(libraryVariant);
    }

    private void createBundleTask(LibraryCreationConfig variant2) {
        this.taskFactory.register(new BundleAar.LibraryCreationAction(variant2));
        variant2.getTaskContainer().getAssembleTask().configure(task -> task.dependsOn(new Object[]{variant2.getArtifacts().get(SingleArtifact.AAR.INSTANCE)}));
        VariantPublishingInfo publishInfo = variant2.getPublishInfo();
        if (publishInfo != null) {
            List<ComponentPublishingInfo> components2 = publishInfo.getComponents();
            if (components2.stream().anyMatch(ComponentPublishingInfo::getWithSourcesJar)) {
                this.taskFactory.register(new SourceJarTask.CreationAction(variant2));
            }
            if (components2.stream().anyMatch(ComponentPublishingInfo::getWithJavadocJar)) {
                new DokkaParallelBuildService.RegistrationAction(this.project).execute();
                this.taskFactory.register(new JavaDocGenerationTask.CreationAction(variant2));
                this.taskFactory.register(new JavaDocJarTask.CreationAction(variant2));
            }
            for (ComponentPublishingInfo component2 : components2) {
                this.createComponent(variant2, component2.getComponentName(), component2.isClassifierRequired());
            }
        }
    }

    private void createComponent(LibraryCreationConfig variant2, String componentName, boolean isClassifierRequired) {
        VariantDependencies variantDependencies2 = variant2.getVariantDependencies();
        AdhocComponentWithVariants component2 = (AdhocComponentWithVariants)this.project.getComponents().findByName(componentName);
        if (component2 == null) {
            component2 = this.localConfig.getComponentFactory().adhoc(componentName);
            this.project.getComponents().add((Object)component2);
        }
        Configuration apiPub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.API_PUBLICATION, componentName, isClassifierRequired));
        Configuration runtimePub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION, componentName, isClassifierRequired));
        Configuration sourcePub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.SOURCE_PUBLICATION, componentName, isClassifierRequired));
        Configuration javaDocPub = variantDependencies2.getElements(new PublishedConfigSpec(AndroidArtifacts.PublishedConfigType.JAVA_DOC_PUBLICATION, componentName, isClassifierRequired));
        component2.addVariantsFromConfiguration(apiPub, (Action)new ConfigurationVariantMapping("compile", isClassifierRequired));
        component2.addVariantsFromConfiguration(runtimePub, (Action)new ConfigurationVariantMapping("runtime", isClassifierRequired));
        if (sourcePub != null) {
            component2.addVariantsFromConfiguration(sourcePub, (Action)new ConfigurationVariantMapping("runtime", true));
        }
        if (javaDocPub != null) {
            component2.addVariantsFromConfiguration(javaDocPub, (Action)new ConfigurationVariantMapping("runtime", true));
        }
    }

    @Override
    protected void createDependencyStreams(ComponentCreationConfig creationConfig) {
        super.createDependencyStreams(creationConfig);
        creationConfig.getTransformManager().addStream(OriginalStream.builder("local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setFileCollection(creationConfig.computeLocalPackagedJars()).build());
    }

    private void createMergeResourcesTasks(LibraryCreationConfig variant2) {
        ImmutableSet flags = this.globalConfig.getNamespacedAndroidResources() ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[]{MergeResources.Flag.PROCESS_VECTOR_DRAWABLES}) : Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]);
        MergeResourceCallback callback = new MergeResourceCallback(variant2);
        this.basicCreateMergeResourcesTask(variant2, TaskManager.MergeType.PACKAGE, false, false, false, (Set<MergeResources.Flag>)flags, callback);
        this.createMergeResourcesTask(variant2, false, (Set<MergeResources.Flag>)ImmutableSet.of());
        this.taskFactory.register(new GenerateApiPublicTxtTask.CreationAction(variant2));
    }

    private void createCompileLibraryResourcesTask(LibraryCreationConfig variant2) {
        if (variant2.getAndroidResourcesCreationConfig() != null && variant2.getAndroidResourcesCreationConfig().isPrecompileDependenciesResourcesEnabled()) {
            this.taskFactory.register(new CompileLibraryResourcesTask.CreationAction(variant2));
        }
    }

    @Override
    protected void postJavacCreation(ComponentCreationConfig creationConfig) {
        super.postJavacCreation(creationConfig);
        if (creationConfig.getServices().getProjectOptions().get(BooleanOption.ENABLE_ART_PROFILES)) {
            this.taskFactory.register(new ProcessLibraryArtProfileTask.CreationAction(creationConfig));
        }
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(creationConfig, AndroidArtifacts.PublishedConfigType.API_ELEMENTS));
    }

    public void createLibraryAssetsTask(LibraryCreationConfig variant2) {
        this.taskFactory.register(new MergeSourceSetFolders.LibraryAssetCreationAction(variant2));
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(ComponentCreationConfig creationConfig, QualifiedContent.ContentType contentType) {
        Preconditions.checkArgument((contentType == QualifiedContent.DefaultContentType.RESOURCES ? 1 : 0) != 0, (Object)"contentType must be RESOURCES");
        if (creationConfig.getComponentType().isTestComponent()) {
            return TransformManager.SCOPE_FULL_PROJECT_WITH_LOCAL_JARS;
        }
        return TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS;
    }

    @Override
    protected void createPrepareLintJarForPublishTask() {
        super.createPrepareLintJarForPublishTask();
        for (LibraryCreationConfig variant2 : this.variantPropertiesList) {
            variant2.getArtifacts().copy(InternalArtifactType.LINT_PUBLISH_JAR.INSTANCE, this.globalConfig.getGlobalArtifacts());
        }
    }

    private static class MergeResourceCallback
    implements TaskProviderCallback<MergeResources> {
        private final LibraryCreationConfig variant;

        private MergeResourceCallback(LibraryCreationConfig variant2) {
            this.variant = variant2;
        }

        @Override
        public void handleProvider(TaskProvider<MergeResources> taskProvider) {
            this.variant.getArtifacts().setInitialProvider(taskProvider, MergeResources::getPublicFile).withName("public.txt").on(InternalArtifactType.PUBLIC_RES.INSTANCE);
        }
    }
}

