/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.builder.core.ComponentType;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.v2.CustomSourceDirectory;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BQ\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170,R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\n8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\n8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u0013\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%\u00a8\u0006-"}, d2={"Lcom/android/build/gradle/internal/core/VariantSources;", "", "fullName", "", "componentType", "Lcom/android/builder/core/ComponentType;", "defaultSourceProvider", "Lcom/android/builder/model/SourceProvider;", "buildTypeSourceProvider", "flavorSourceProviders", "", "multiFlavorSourceProvider", "Lcom/android/build/gradle/internal/api/DefaultAndroidSourceSet;", "variantSourceProvider", "(Ljava/lang/String;Lcom/android/builder/core/ComponentType;Lcom/android/builder/model/SourceProvider;Lcom/android/builder/model/SourceProvider;Ljava/util/List;Lcom/android/build/gradle/internal/api/DefaultAndroidSourceSet;Lcom/android/build/gradle/internal/api/DefaultAndroidSourceSet;)V", "artProfileIfExists", "Ljava/io/File;", "getArtProfileIfExists", "()Ljava/io/File;", "getComponentType", "()Lcom/android/builder/core/ComponentType;", "customSourceList", "", "", "Lcom/android/builder/model/v2/CustomSourceDirectory;", "getCustomSourceList", "()Ljava/util/Map;", "getFullName", "()Ljava/lang/String;", "mainManifestFilePath", "getMainManifestFilePath", "mainManifestIfExists", "getMainManifestIfExists", "manifestOverlays", "getManifestOverlays", "()Ljava/util/List;", "getMultiFlavorSourceProvider", "()Lcom/android/build/gradle/internal/api/DefaultAndroidSourceSet;", "sortedSourceProviders", "getSortedSourceProviders", "getVariantSourceProvider", "getSourceFiles", "", "f", "Ljava/util/function/Function;", "gradle-core"})
public final class VariantSources {
    @NotNull
    private final String fullName;
    @NotNull
    private final ComponentType componentType;
    @NotNull
    private final SourceProvider defaultSourceProvider;
    @Nullable
    private final SourceProvider buildTypeSourceProvider;
    @NotNull
    private final List<SourceProvider> flavorSourceProviders;
    @Nullable
    private final DefaultAndroidSourceSet multiFlavorSourceProvider;
    @Nullable
    private final DefaultAndroidSourceSet variantSourceProvider;

    public VariantSources(@NotNull String fullName, @NotNull ComponentType componentType, @NotNull SourceProvider defaultSourceProvider, @Nullable SourceProvider buildTypeSourceProvider, @NotNull List<? extends SourceProvider> flavorSourceProviders, @Nullable DefaultAndroidSourceSet multiFlavorSourceProvider, @Nullable DefaultAndroidSourceSet variantSourceProvider) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)defaultSourceProvider, (String)"defaultSourceProvider");
        Intrinsics.checkNotNullParameter(flavorSourceProviders, (String)"flavorSourceProviders");
        this.fullName = fullName;
        this.componentType = componentType;
        this.defaultSourceProvider = defaultSourceProvider;
        this.buildTypeSourceProvider = buildTypeSourceProvider;
        this.flavorSourceProviders = flavorSourceProviders;
        this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        this.variantSourceProvider = variantSourceProvider;
    }

    public /* synthetic */ VariantSources(String string, ComponentType componentType, SourceProvider sourceProvider, SourceProvider sourceProvider2, List list, DefaultAndroidSourceSet defaultAndroidSourceSet, DefaultAndroidSourceSet defaultAndroidSourceSet2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceProvider2 = null;
        }
        if ((n & 0x20) != 0) {
            defaultAndroidSourceSet = null;
        }
        if ((n & 0x40) != 0) {
            defaultAndroidSourceSet2 = null;
        }
        this(string, componentType, sourceProvider, sourceProvider2, list, defaultAndroidSourceSet, defaultAndroidSourceSet2);
    }

    @NotNull
    public final String getFullName() {
        return this.fullName;
    }

    @NotNull
    public final ComponentType getComponentType() {
        return this.componentType;
    }

    @Nullable
    public final DefaultAndroidSourceSet getMultiFlavorSourceProvider() {
        return this.multiFlavorSourceProvider;
    }

    @Nullable
    public final DefaultAndroidSourceSet getVariantSourceProvider() {
        return this.variantSourceProvider;
    }

    @NotNull
    public final File getMainManifestFilePath() {
        File file = this.defaultSourceProvider.getManifestFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"defaultSourceProvider.manifestFile");
        return file;
    }

    @Nullable
    public final File getMainManifestIfExists() {
        File mainManifest = this.getMainManifestFilePath();
        return mainManifest.isFile() ? mainManifest : null;
    }

    @Nullable
    public final File getArtProfileIfExists() {
        File composeFile = new File(new File(this.defaultSourceProvider.getManifestFile().getParent()), "baseline-prof.txt");
        return composeFile.isFile() ? composeFile : null;
    }

    @NotNull
    public final List<SourceProvider> getSortedSourceProviders() {
        SourceProvider p0;
        DefaultAndroidSourceSet defaultAndroidSourceSet;
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)(this.flavorSourceProviders.size() + 4));
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayListWithExpected\u2026SourceProviders.size + 4)");
        List providers = arrayList;
        providers.add(this.defaultSourceProvider);
        int n = this.flavorSourceProviders.size() + -1;
        if (0 <= n) {
            do {
                int n2 = n--;
                providers.add(this.flavorSourceProviders.get(n2));
            } while (0 <= n);
        }
        if ((defaultAndroidSourceSet = this.multiFlavorSourceProvider) != null) {
            DefaultAndroidSourceSet defaultAndroidSourceSet2 = defaultAndroidSourceSet;
            p0 = defaultAndroidSourceSet2;
            boolean bl = false;
            providers.add(p0);
        }
        defaultAndroidSourceSet = this.buildTypeSourceProvider;
        if (defaultAndroidSourceSet != null) {
            DefaultAndroidSourceSet defaultAndroidSourceSet3 = defaultAndroidSourceSet;
            p0 = defaultAndroidSourceSet3;
            boolean bl = false;
            providers.add(p0);
        }
        defaultAndroidSourceSet = this.variantSourceProvider;
        if (defaultAndroidSourceSet != null) {
            DefaultAndroidSourceSet defaultAndroidSourceSet4 = defaultAndroidSourceSet;
            p0 = defaultAndroidSourceSet4;
            boolean bl = false;
            providers.add(p0);
        }
        return providers;
    }

    @NotNull
    public final List<File> getManifestOverlays() {
        DefaultAndroidSourceSet defaultAndroidSourceSet;
        List inputs = new ArrayList();
        Function1 gatherManifest2 = (Function1)new Function1<SourceProvider, Unit>((List<File>)inputs){
            final /* synthetic */ List<File> $inputs;
            {
                this.$inputs = $inputs;
                super(1);
            }

            public final void invoke(@NotNull SourceProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                File variantLocation = it.getManifestFile();
                if (variantLocation.isFile()) {
                    Intrinsics.checkNotNullExpressionValue((Object)variantLocation, (String)"variantLocation");
                    this.$inputs.add(variantLocation);
                }
            }
        };
        DefaultAndroidSourceSet defaultAndroidSourceSet2 = this.variantSourceProvider;
        if (defaultAndroidSourceSet2 != null) {
            defaultAndroidSourceSet = defaultAndroidSourceSet2;
            gatherManifest2.invoke((Object)defaultAndroidSourceSet);
        }
        defaultAndroidSourceSet2 = this.buildTypeSourceProvider;
        if (defaultAndroidSourceSet2 != null) {
            defaultAndroidSourceSet = defaultAndroidSourceSet2;
            gatherManifest2.invoke((Object)defaultAndroidSourceSet);
        }
        defaultAndroidSourceSet2 = this.multiFlavorSourceProvider;
        if (defaultAndroidSourceSet2 != null) {
            defaultAndroidSourceSet = defaultAndroidSourceSet2;
            gatherManifest2.invoke((Object)defaultAndroidSourceSet);
        }
        Iterable $this$forEach$iv = this.flavorSourceProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            gatherManifest2.invoke(element$iv);
        }
        return inputs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getSourceFiles(@NotNull Function<SourceProvider, Collection<File>> f) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Iterable $this$flatMap$iv = this.getSortedSourceProviders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SourceProvider it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Collection<File> collection = f.apply(it);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"f.apply(it)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Map<String, Collection<CustomSourceDirectory>> getCustomSourceList() {
        ImmutableMap.Builder builder$iv;
        boolean $i$f$immutableMapBuilder = false;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        ImmutableMap.Builder $this$_get_customSourceList__u24lambda_u2d4 = builder$iv = builder;
        boolean bl = false;
        Iterable $this$forEach$iv = this.getSortedSourceProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SourceProvider it = (SourceProvider)element$iv;
            boolean bl2 = false;
            $this$_get_customSourceList__u24lambda_u2d4.put((Object)it.getName(), (Object)it.getCustomDirectories());
        }
        builder = builder$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder.build()");
        return MapsKt.toMap((Map)((Map)builder));
    }
}

