/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.caching;

import com.android.build.gradle.internal.cxx.caching.CacheFileNames;
import com.android.build.gradle.internal.cxx.caching.ThreadCachingEnvironment;
import com.android.build.gradle.internal.cxx.hashing.HashHelpersKt;
import com.android.build.gradle.internal.cxx.json.JsonHelpersKt;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ9\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\r2\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010JM\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\r2\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u0002H\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00032\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002JQ\u0010\u001d\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\r2\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u00020\n2\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/cxx/caching/CachingEnvironment;", "Lcom/android/build/gradle/internal/cxx/caching/ThreadCachingEnvironment;", "cacheFolder", "Ljava/io/File;", "(Ljava/io/File;)V", "filenames", "Lcom/android/build/gradle/internal/cxx/caching/CacheFileNames;", "TKey", "key", "baseName", "", "(Ljava/lang/Object;Ljava/lang/String;)Lcom/android/build/gradle/internal/cxx/caching/CacheFileNames;", "read", "TValue", "valueType", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "write", "", "value", "log", "", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Ljava/util/List;Ljava/lang/Class;)V", "writeExceptionFile", "file", "reason", "Ljava/lang/Exception;", "Lkotlin/Exception;", "writeFailure", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Exception;Ljava/util/List;Ljava/lang/Class;)V", "gradle-core"})
public final class CachingEnvironment
extends ThreadCachingEnvironment {
    @NotNull
    private final File cacheFolder;

    public CachingEnvironment(@NotNull File cacheFolder) {
        Intrinsics.checkNotNullParameter((Object)cacheFolder, (String)"cacheFolder");
        this.cacheFolder = cacheFolder;
    }

    private final <TKey> CacheFileNames filenames(TKey key, String baseName2) {
        String[] stringArray = new String[]{baseName2 + "_" + HashHelpersKt.shortSha256Of$default(key, false, 2, null)};
        File keyBase = FileUtils.join((File)this.cacheFolder, (String[])stringArray);
        return new CacheFileNames(new File(keyBase + "_key.json"), new File(keyBase + ".json"), new File(keyBase + ".log"), new File(keyBase + "_exception.txt"));
    }

    @Override
    @Nullable
    public <TKey, TValue> TValue read(TKey key, @NotNull String baseName2, @NotNull Class<TValue> valueType) {
        Intrinsics.checkNotNullParameter((Object)baseName2, (String)"baseName");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        CacheFileNames cacheFileNames = this.filenames(key, baseName2);
        File keyFile = cacheFileNames.component1();
        File valueFile = cacheFileNames.component2();
        if (!keyFile.exists()) {
            return null;
        }
        if (!valueFile.exists()) {
            return null;
        }
        TValue keyRead = JsonHelpersKt.readJsonFile(keyFile, valueType);
        if (!Intrinsics.areEqual(keyRead, key)) {
            return null;
        }
        return JsonHelpersKt.readJsonFile(valueFile, valueType);
    }

    @Override
    public <TKey, TValue> void write(TKey key, @NotNull String baseName2, TValue value, @NotNull List<LoggingMessage> log2, @NotNull Class<TValue> valueType) {
        Intrinsics.checkNotNullParameter((Object)baseName2, (String)"baseName");
        Intrinsics.checkNotNullParameter(log2, (String)"log");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        CacheFileNames cacheFileNames = this.filenames(key, baseName2);
        File keyFile = cacheFileNames.component1();
        File valueFile = cacheFileNames.component2();
        File logFile = cacheFileNames.component3();
        File exceptionFile = cacheFileNames.component4();
        JsonHelpersKt.writeJsonFile(logFile, log2);
        JsonHelpersKt.writeJsonFile(valueFile, value);
        JsonHelpersKt.writeJsonFile(keyFile, key);
        Files.deleteIfExists(exceptionFile.toPath());
    }

    @Override
    public <TKey, TValue> void writeFailure(TKey key, @NotNull String baseName2, @NotNull Exception reason, @NotNull List<LoggingMessage> log2, @NotNull Class<TValue> valueType) {
        Intrinsics.checkNotNullParameter((Object)baseName2, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(log2, (String)"log");
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        CacheFileNames cacheFileNames = this.filenames(key, baseName2);
        File keyFile = cacheFileNames.component1();
        File logFile = cacheFileNames.component3();
        File exceptionFile = cacheFileNames.component4();
        JsonHelpersKt.writeJsonFile(logFile, log2);
        this.writeExceptionFile(exceptionFile, reason);
        JsonHelpersKt.writeJsonFile(keyFile, key);
    }

    private final void writeExceptionFile(File file, Exception reason) {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteStream);
        reason.printStackTrace(printStream);
        String stack2 = byteStream.toString("UTF8");
        Object object = reason.getMessage();
        String string = reason.getClass() + ": " + (String)(object == null ? "" : object) + " " + stack2;
        object = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF_8");
        FilesKt.writeText((File)file, (String)string, (Charset)object);
    }
}

