/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J.\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J*\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ \u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "", "ndkRoot", "Ljava/io/File;", "(Ljava/io/File;)V", "platformNameAliases", "", "", "", "sensibleDefaultPlatformApiVersionForErrorCase", "veryHighPlatformApiVersion", "clamp", "minSdkVersion", "displayVersion", "Lcom/android/sdklib/AndroidVersion;", "min", "max", "computeMinSdkVersion", "abiName", "androidVersionOrNull", "displayVersionString", "findPlatformConfiguratorLegacy", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "platformDir", "findSuitablePlatformVersion", "androidVersion", "findSuitablePlatformVersionLogged", "ndkMetaPlatforms", "Lcom/android/build/gradle/internal/cxx/configure/NdkMetaPlatforms;", "getLinkerSysrootPath", "platformVersion", "gradle-core"})
public final class PlatformConfigurator {
    @NotNull
    private final File ndkRoot;
    private final int sensibleDefaultPlatformApiVersionForErrorCase;
    private final int veryHighPlatformApiVersion;
    @NotNull
    private final Map<String, Integer> platformNameAliases;

    public PlatformConfigurator(@NotNull File ndkRoot) {
        Intrinsics.checkNotNullParameter((Object)ndkRoot, (String)"ndkRoot");
        this.ndkRoot = ndkRoot;
        this.sensibleDefaultPlatformApiVersionForErrorCase = 22;
        this.veryHighPlatformApiVersion = Integer.MAX_VALUE;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"20", (Object)19), TuplesKt.to((Object)"25", (Object)24), TuplesKt.to((Object)"J", (Object)16), TuplesKt.to((Object)"J-MR1", (Object)17), TuplesKt.to((Object)"J-MR2", (Object)18), TuplesKt.to((Object)"K", (Object)19), TuplesKt.to((Object)"L", (Object)21), TuplesKt.to((Object)"L-MR1", (Object)22), TuplesKt.to((Object)"M", (Object)23), TuplesKt.to((Object)"N", (Object)24), TuplesKt.to((Object)"N-MR1", (Object)24), TuplesKt.to((Object)"O", (Object)26), TuplesKt.to((Object)"O-MR1", (Object)27), TuplesKt.to((Object)"P", (Object)28)};
        this.platformNameAliases = MapsKt.mapOf((Pair[])pairArray);
    }

    public final int findSuitablePlatformVersionLogged(@NotNull String abiName, @Nullable AndroidVersion androidVersionOrNull, @Nullable NdkMetaPlatforms ndkMetaPlatforms) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)abiName, (String)"abiName");
        String[] stringArray2 = Abi.getByName(abiName);
        if (stringArray2 == null) {
            PlatformConfigurator platformConfigurator;
            PlatformConfigurator $this$findSuitablePlatformVersionLogged_u24lambda_u2d0 = platformConfigurator = this;
            boolean bl = false;
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.ABI_IS_INVALID, "Specified abi='" + abiName + "' is not recognized.", new Object[0]);
            return $this$findSuitablePlatformVersionLogged_u24lambda_u2d0.sensibleDefaultPlatformApiVersionForErrorCase;
        }
        String[] abi = stringArray = stringArray2;
        if (ndkMetaPlatforms == null) {
            stringArray2 = new String[]{"platforms"};
            File platformDir = FileUtils.join((File)this.ndkRoot, (String[])stringArray2);
            if (!platformDir.isDirectory()) {
                LoggingEnvironmentKt.warnln(CxxDiagnosticCode.NDK_CORRUPTED, "NDK folder '" + this.ndkRoot + "' specified does not contain 'platforms'.", new Object[0]);
                return this.sensibleDefaultPlatformApiVersionForErrorCase;
            }
            int minSdkVersion2 = this.computeMinSdkVersion(abiName, androidVersionOrNull, this.platformNameAliases);
            Intrinsics.checkNotNullExpressionValue((Object)platformDir, (String)"platformDir");
            return this.findPlatformConfiguratorLegacy((Abi)abi, minSdkVersion2, androidVersionOrNull, platformDir);
        }
        int minSdkVersion3 = this.computeMinSdkVersion(abiName, androidVersionOrNull, ndkMetaPlatforms.getAliases());
        return this.clamp(minSdkVersion3, androidVersionOrNull, ndkMetaPlatforms.getMin(), ndkMetaPlatforms.getMax());
    }

    private final int computeMinSdkVersion(String abiName, AndroidVersion androidVersionOrNull, Map<String, Integer> platformNameAliases) {
        Integer n;
        Integer n2;
        CharSequence charSequence;
        AndroidVersion androidVersion = androidVersionOrNull;
        Integer minSdkVersionOrNull = androidVersion == null ? null : Integer.valueOf(androidVersion.getApiLevel());
        AndroidVersion androidVersion2 = androidVersionOrNull;
        String codeNameOrNull = androidVersion2 == null ? null : androidVersion2.getCodename();
        if (codeNameOrNull == null || (charSequence = (CharSequence)codeNameOrNull).length() == 0) {
            n2 = null;
        } else {
            int n3;
            Integer lookup = platformNameAliases.get(codeNameOrNull);
            if (lookup != null) {
                LoggingEnvironmentKt.infoln("Version minSdkVersion='" + codeNameOrNull + "' is mapped to '" + lookup + "'.", new Object[0]);
                n3 = lookup;
            } else {
                LoggingEnvironmentKt.errorln("API codeName '" + codeNameOrNull + "' is not supported by NDK '" + this.ndkRoot + "'.", new Object[0]);
                n3 = this.veryHighPlatformApiVersion;
            }
            n2 = n3;
        }
        Integer minSdkVersionFromCodeName = n2;
        Integer n4 = minSdkVersionOrNull;
        int n5 = AndroidVersion.DEFAULT.getApiLevel();
        boolean minSdkVersionIsDefault = n4 != null && n4 == n5;
        if (minSdkVersionIsDefault && minSdkVersionFromCodeName == null) {
            LoggingEnvironmentKt.infoln("Neither codeName nor minSdkVersion specified. Using minimum platform version for '" + abiName + "'.", new Object[0]);
            n = 0;
        } else if (!minSdkVersionIsDefault && minSdkVersionFromCodeName != null) {
            int n6;
            Integer n7 = minSdkVersionOrNull;
            if (Intrinsics.areEqual((Object)n7, (Object)minSdkVersionFromCodeName)) {
                LoggingEnvironmentKt.warnln("Both codeName and minSdkVersion specified. They agree but only one should be specified.", new Object[0]);
                n6 = minSdkVersionOrNull;
            } else {
                LoggingEnvironmentKt.infoln("Disagreement between codeName='" + codeNameOrNull + "' and minSdkVersion='" + minSdkVersionOrNull + "'. Probably a preview release. Using " + minSdkVersionFromCodeName + " to match code name.", new Object[0]);
                n6 = minSdkVersionFromCodeName;
            }
            n = n6;
        } else if (minSdkVersionIsDefault) {
            n = minSdkVersionFromCodeName;
        } else {
            Integer lookup = platformNameAliases.get(String.valueOf(minSdkVersionOrNull));
            if (lookup != null) {
                Integer n8 = minSdkVersionOrNull;
                Intrinsics.checkNotNull((Object)n8);
                LoggingEnvironmentKt.infoln("Version minSdkVersion='" + this.displayVersionString(n8, androidVersionOrNull) + "' is mapped to '" + lookup + "'.", new Object[0]);
                return lookup;
            }
            n = minSdkVersionOrNull;
        }
        Integer n9 = n;
        return n9 == null ? 22 : n9;
    }

    /*
     * WARNING - void declaration
     */
    private final int findPlatformConfiguratorLegacy(Abi abi, int minSdkVersion2, AndroidVersion displayVersion, File platformDir) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        File[] platformSubDirs2;
        String linkerSysrootPath = this.getLinkerSysrootPath(this.ndkRoot, abi, "android-" + minSdkVersion2);
        if (new File(linkerSysrootPath).isDirectory()) {
            return minSdkVersion2;
        }
        File[] $this$orEmpty$iv = platformDir.listFiles(findPlatformConfiguratorLegacy.platformSubDirs.1.INSTANCE);
        boolean $i$f$orEmpty22 = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new File[0];
        }
        File[] $i$f$orEmpty22 = platformSubDirs2 = objectArray;
        boolean $i$f$filter = false;
        void var10_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            if (!StringsKt.startsWith$default((String)string, (String)"android-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String[] bl2 = new String[]{"arch-" + abi.getArchitecture()};
            if (!FileUtils.join((File)it, (String[])bl2).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl3 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            int n3 = "android-".length();
            String string2 = string.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            Integer version = StringsKt.toIntOrNull((String)string2);
            if (version == null) {
                LoggingEnvironmentKt.infoln("Found non-numeric platform folder '" + it.getName() + "'. Ignoring.", new Object[0]);
            }
            if (version == null) continue;
            Integer it$iv$iv = n2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List versions = (List)destination$iv$iv;
        if (versions.isEmpty()) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.ABI_IS_INVALID, "Abi '" + abi + "' is not recognized in '" + this.ndkRoot + "'.", new Object[0]);
            return this.sensibleDefaultPlatformApiVersionForErrorCase;
        }
        Comparable comparable = CollectionsKt.minOrNull((Iterable)versions);
        Intrinsics.checkNotNull((Object)comparable);
        int min = ((Number)((Object)comparable)).intValue();
        Comparable comparable2 = CollectionsKt.maxOrNull((Iterable)versions);
        Intrinsics.checkNotNull((Object)comparable2);
        int max = ((Number)((Object)comparable2)).intValue();
        int clamped = this.clamp(minSdkVersion2, displayVersion, min, max);
        if (!versions.contains(clamped)) {
            LoggingEnvironmentKt.warnln("Expected platform folder platforms/android-" + clamped + ", using platform API " + min + " instead.", new Object[0]);
            return min;
        }
        return clamped;
    }

    private final int clamp(int minSdkVersion2, AndroidVersion displayVersion, int min, int max) {
        int n;
        if (minSdkVersion2 < min) {
            n = min;
        } else if (minSdkVersion2 > max) {
            if (minSdkVersion2 < this.veryHighPlatformApiVersion) {
                LoggingEnvironmentKt.warnln("Platform version '" + this.displayVersionString(minSdkVersion2, displayVersion) + "' is beyond '" + max + "', the maximum API level supported by this NDK.", new Object[0]);
            }
            n = max;
        } else {
            n = minSdkVersion2;
        }
        return n;
    }

    private final String displayVersionString(int minSdkVersion2, AndroidVersion displayVersion) {
        String string;
        if (displayVersion == null) {
            string = String.valueOf(minSdkVersion2);
        } else {
            String string2 = displayVersion.getApiLevel() == AndroidVersion.DEFAULT.getApiLevel() ? displayVersion.getApiString() : String.valueOf(displayVersion.getApiLevel());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            if (displa\u2026)\n            }\n        }");
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int findSuitablePlatformVersion(@NotNull String abiName, @Nullable AndroidVersion androidVersion) {
        NdkMetaPlatforms ndkMetaPlatforms;
        Intrinsics.checkNotNullParameter((Object)abiName, (String)"abiName");
        File ndkMetaPlatformsFile = NdkMetaPlatforms.Companion.jsonFile(this.ndkRoot);
        if (ndkMetaPlatformsFile.isFile()) {
            Closeable closeable = new FileReader(ndkMetaPlatformsFile);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                NdkMetaPlatforms ndkMetaPlatforms2 = NdkMetaPlatforms.Companion.fromReader(reader);
                ndkMetaPlatforms = ndkMetaPlatforms2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            ndkMetaPlatforms = null;
        }
        NdkMetaPlatforms ndkMetaPlatforms3 = ndkMetaPlatforms;
        return this.findSuitablePlatformVersionLogged(abiName, androidVersion, ndkMetaPlatforms3);
    }

    private final String getLinkerSysrootPath(File ndkRoot, Abi abi, String platformVersion) {
        String[] stringArray = new String[]{ndkRoot.getPath(), "platforms", platformVersion, "arch-" + abi.getArchitecture()};
        String string = FileUtils.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(\n            ndkRoo\u2026bi.architecture\n        )");
        return string;
    }
}

