/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.LintKt;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"checkCanonicalize", "", "location", "", "file", "Ljava/io/File;", "lint", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "json", "gradle-core"})
public final class LintKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void lint(@NotNull NativeBuildConfigValueMini $this$lint, @NotNull File json) {
        Intrinsics.checkNotNullParameter((Object)$this$lint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(json, null, false, 6, null);
        Throwable throwable = null;
        try {
            boolean bl;
            boolean bl2;
            String it$iv$iv;
            Object object;
            Object it;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object object2;
            NativeLibraryValueMini library;
            boolean bl3;
            PassThroughPrefixingLoggingEnvironment it2 = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
            boolean bl32 = false;
            for (File file : $this$lint.buildFiles) {
                if (file.isFile()) continue;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_FILE_DID_NOT_EXIST, "expected buildFiles file '" + file + "' to exist", new Object[0]);
            }
            List<String> list = $this$lint.buildTargetsCommandComponents;
            List<String> buildCommand = list == null ? CollectionsKt.emptyList() : list;
            Object object3 = buildCommand;
            boolean bl4 = bl3 = !object3.isEmpty();
            if (bl3 && !new File(buildCommand.get(0)).isFile()) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_DID_NOT_EXIST, "expected buildTargetsCommandComponents command '" + buildCommand.get(0) + "' to exist", new Object[0]);
            } else if (bl3 && !Intrinsics.areEqual((Object)CollectionsKt.last(buildCommand), (Object)"{LIST_OF_TARGETS_TO_BUILD}")) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_DID_NOT_EXIST, "expected buildTargetsCommandComponents command '" + CollectionsKt.joinToString$default((Iterable)buildCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' to have {LIST_OF_TARGETS_TO_BUILD} at the end", new Object[0]);
            }
            Object object4 = $this$lint.libraries;
            Intrinsics.checkNotNullExpressionValue(object4, (String)"libraries");
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                String string;
                List<String> buildCommandComponents;
                Object object5 = object4 = (Map.Entry)object3.next();
                String name = (String)object5.getKey();
                Object object6 = object4;
                library = (NativeLibraryValueMini)object6.getValue();
                List<String> list2 = library.buildCommandComponents;
                List<String> list3 = buildCommandComponents = list2 == null ? CollectionsKt.emptyList() : list2;
                if (buildCommandComponents.isEmpty()) {
                    if (!bl3) {
                        LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_DID_NOT_EXIST, "expected buildTargetsCommandComponents or " + name + ".buildCommandComponents to exist", new Object[0]);
                    }
                } else if (!new File(buildCommandComponents.get(0)).isFile()) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_COMMAND_DID_NOT_EXIST, "expected " + name + ".buildCommandComponents command '" + buildCommandComponents.get(0) + "' to exist", new Object[0]);
                }
                Object object7 = (string = library.artifactName) == null ? "" : string;
                Object artifactName = object7;
                if ((object7 = (CharSequence)artifactName).length() == 0) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_ARTIFACT_NAME_DID_NOT_EXIST, "expected " + name + ".artifactName to exist", new Object[0]);
                }
                for (File file : library.runtimeFiles) {
                    String string2 = name + ".runtimeFiles";
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"runtimeFile");
                    LintKt.checkCanonicalize(string2, file);
                }
                object2 = library.abi;
                Object object8 = object2 == null ? "" : object2;
                Object abiName = object8;
                CharSequence charSequence = (CharSequence)abiName;
                if (charSequence.length() == 0) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_ABI_NAME_DID_NOT_EXIST, "expected " + name + ".abi to exist", new Object[0]);
                    continue;
                }
                Abi abi = Abi.getByName((String)abiName);
                if (abi != null) continue;
                object2 = Abi.getDefaultValues();
                Intrinsics.checkNotNullExpressionValue(object2, (String)"getDefaultValues()");
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_ABI_NAME_IS_INVALID, name + ".abi '" + (String)abiName + "' is invalid. Valid values are '" + CollectionsKt.joinToString$default((Iterable)((Iterable)object2), null, null, null, (int)0, null, (Function1)lint.1.1.INSTANCE, (int)31, null) + "'", new Object[0]);
            }
            object4 = $this$lint.libraries.values();
            boolean $i$f$mapNotNull = false;
            library = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl5 = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl22 = false;
                it = (NativeLibraryValueMini)element$iv$iv;
                boolean bl52 = false;
                if (((NativeLibraryValueMini)it).abi == null) continue;
                it$iv$iv = object;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl7 = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = object2.next();
                bl2 = false;
                it = (String)element$iv$iv;
                boolean bl6 = false;
                if (Abi.getByName((String)it) == null) continue;
                it$iv$iv = object;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean bl8 = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = object2.next();
                bl2 = false;
                it = (Abi)((Object)element$iv$iv);
                boolean bl72 = false;
                if (((Abi)((Object)it)).getTag() == null) continue;
                it$iv$iv = object;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allAbis = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            if (allAbis.size() > 1) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_HAD_MULTIPLE_ABIS, "unexpected mismatched library ABIs: " + CollectionsKt.joinToString$default((Iterable)allAbis, null, null, null, (int)0, null, null, (int)63, null), new Object[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void checkCanonicalize(String location, File file) {
        try {
            file.getCanonicalFile();
        }
        catch (IOException e) {
            Object object;
            Throwable throwable = e.getCause();
            if (throwable == null) {
                object = "";
            } else {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                String string = " (" + it + ")";
                object = string == null ? "" : string;
            }
            String cause = object;
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.COULD_NOT_CANONICALIZE_PATH, "Could not canonicalize '" + file + "' in " + location + " due to " + e.getClass().getSimpleName() + cause, new Object[0]);
        }
    }
}

