/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.ninja;

import com.android.SdkConstants;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.ninja.AdaptNinjaToCxxBuildKt;
import com.android.build.gradle.internal.cxx.ninja.BuildGraph;
import com.android.build.gradle.internal.cxx.ninja.NinjaToCxxBuildAdapter;
import com.android.build.gradle.internal.cxx.os.OsBehaviorKt;
import com.android.utils.TokenizedCommandLine;
import com.android.utils.cxx.CompileCommandsCodecKt;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001af\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u001e\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0007\u001a\u0016\u0010\u0012\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0002H\u0007\u001a\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u001a%\u0010\u0018\u001a\u00020\r*\u00020\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\r*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0002\u001a%\u0010\u001e\u001a\u00020\r*\u00020\u00022\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010 \u001a\u00020\u0002*\u00020\u00022\u0006\u0010!\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010%\u001a\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"NDK_SYSTEM_LIBS", "", "", "adaptNinjaToCxxBuild", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "ninjaBuildFile", "Ljava/io/File;", "abi", "cxxBuildFolder", "createNinjaCommand", "Lkotlin/Function1;", "compileCommandsJsonBin", "buildFileFilter", "", "platform", "", "assignTargetName", "target", "deconflictSourceFiles", "sources", "isPackageable", "name", "isToolchainTool", "exe", "fileNameEndsWith", "suffixes", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "fileNameStartsWith", "prefix", "hasExtension", "extensions", "removeExtension", "ext", "stripFlags", "", "Lcom/android/utils/TokenizedCommandLine;", "sourceFile", "gradle-core"})
public final class AdaptNinjaToCxxBuildKt {
    @NotNull
    private static final List<String> NDK_SYSTEM_LIBS;

    @NotNull
    public static final NativeBuildConfigValueMini adaptNinjaToCxxBuild(@NotNull File ninjaBuildFile, @NotNull String abi, @NotNull File cxxBuildFolder, @NotNull Function1<? super List<String>, ? extends List<String>> createNinjaCommand, @NotNull File compileCommandsJsonBin, @NotNull Function1<? super File, Boolean> buildFileFilter, int platform) {
        Intrinsics.checkNotNullParameter((Object)ninjaBuildFile, (String)"ninjaBuildFile");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Intrinsics.checkNotNullParameter((Object)cxxBuildFolder, (String)"cxxBuildFolder");
        Intrinsics.checkNotNullParameter(createNinjaCommand, (String)"createNinjaCommand");
        Intrinsics.checkNotNullParameter((Object)compileCommandsJsonBin, (String)"compileCommandsJsonBin");
        Intrinsics.checkNotNullParameter(buildFileFilter, (String)"buildFileFilter");
        NinjaToCxxBuildAdapter adapter = new NinjaToCxxBuildAdapter(abi, cxxBuildFolder, createNinjaCommand, buildFileFilter, OsBehaviorKt.createOsBehavior(platform));
        BuildGraph graph = adapter.createBuildGraph(ninjaBuildFile);
        adapter.writeCompileCommandsJsonBin(ninjaBuildFile, compileCommandsJsonBin);
        return adapter.createAndroidGradleBuildMini(graph);
    }

    public static /* synthetic */ NativeBuildConfigValueMini adaptNinjaToCxxBuild$default(File file, String string, File file2, Function1 function1, File file3, Function1 function12, int n, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            function12 = adaptNinjaToCxxBuild.1.INSTANCE;
        }
        if ((n2 & 0x40) != 0) {
            n = SdkConstants.CURRENT_PLATFORM;
        }
        return AdaptNinjaToCxxBuildKt.adaptNinjaToCxxBuild(file, string, file2, (Function1<? super List<String>, ? extends List<String>>)function1, file3, (Function1<? super File, Boolean>)function12, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static final boolean isPackageable(@NotNull String name) {
        String it;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{""};
        if (AdaptNinjaToCxxBuildKt.hasExtension(name, stringArray)) return true;
        stringArray = new String[]{"so"};
        if (!AdaptNinjaToCxxBuildKt.hasExtension(name, stringArray)) return false;
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)"ndk", (boolean)false, (int)2, null)) return true;
        Iterable $this$any$iv = NDK_SYSTEM_LIBS;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.endsWith$default((String)name, (String)it, (boolean)false, (int)2, null));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToolchainTool(String exe2) {
        String[] stringArray = new String[]{"clang", "clang++", "ar"};
        if (!AdaptNinjaToCxxBuildKt.fileNameEndsWith(exe2, stringArray)) return false;
        stringArray = new String[]{"exe", ""};
        if (!AdaptNinjaToCxxBuildKt.hasExtension(exe2, stringArray)) return false;
        return true;
    }

    @VisibleForTesting
    @NotNull
    public static final String deconflictSourceFiles(@NotNull List<String> sources2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(sources2, (String)"sources");
            Iterable $this$singleOrNull$iv = sources2;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"pch"};
                if (!(!AdaptNinjaToCxxBuildKt.hasExtension(it, stringArray))) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        String string = v0;
        return string == null ? (String)CollectionsKt.first(sources2) : string;
    }

    @VisibleForTesting
    @NotNull
    public static final String assignTargetName(@NotNull String target) {
        String string;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        File targetFile = new File(target);
        Object object = new String[]{"so", "a"};
        if (!AdaptNinjaToCxxBuildKt.hasExtension(target, object)) {
            object = targetFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"targetFile.name");
            return object;
        }
        String name = FilesKt.getNameWithoutExtension((File)targetFile);
        if (AdaptNinjaToCxxBuildKt.fileNameStartsWith(target, "lib") && !AdaptNinjaToCxxBuildKt.fileNameStartsWith(target, "lib.")) {
            String string2 = name;
            int n = 3;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = name;
        }
        return string;
    }

    private static final void stripFlags(TokenizedCommandLine $this$stripFlags, String sourceFile) {
        TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)sourceFile, (int)0, (boolean)false, (boolean)false, (boolean)true, (int)12, null);
        TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)"-o", (int)1, (boolean)false, (boolean)false, (boolean)false, (int)28, null);
        TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)"--output=", (int)0, (boolean)true, (boolean)false, (boolean)false, (int)24, null);
        TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)"--output", (int)1, (boolean)false, (boolean)false, (boolean)false, (int)28, null);
        for (String flag : CompileCommandsCodecKt.getSTRIP_FLAGS_WITH_ARG()) {
            TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)flag, (int)1, (boolean)false, (boolean)false, (boolean)false, (int)28, null);
        }
        for (String flag : CompileCommandsCodecKt.getSTRIP_FLAGS_WITH_IMMEDIATE_ARG()) {
            TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)flag, (int)0, (boolean)true, (boolean)false, (boolean)false, (int)24, null);
        }
        for (String flag : CompileCommandsCodecKt.getSTRIP_FLAGS_WITHOUT_ARG()) {
            TokenizedCommandLine.removeTokenGroup$default((TokenizedCommandLine)$this$stripFlags, (String)flag, (int)0, (boolean)false, (boolean)false, (boolean)false, (int)28, null);
        }
    }

    private static final boolean fileNameStartsWith(String $this$fileNameStartsWith, String prefix) {
        String string = $this$fileNameStartsWith;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string3 = new File(string2).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"File(lowercase()).name");
        String string4 = string3;
        string3 = prefix;
        String string5 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.startsWith$default((String)string4, (String)string5, (boolean)false, (int)2, null);
    }

    private static final boolean fileNameEndsWith(String $this$fileNameEndsWith, String ... suffixes) {
        boolean bl;
        block1: {
            String string = $this$fileNameEndsWith;
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String name = FilesKt.getNameWithoutExtension((File)new File(string2));
            String[] $this$any$iv = suffixes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String prefix = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!StringsKt.endsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean hasExtension(String $this$hasExtension, String ... extensions) {
        boolean bl;
        block1: {
            String extension2 = FilesKt.getExtension((File)new File($this$hasExtension));
            String[] $this$any$iv = extensions;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String candidate = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(StringsKt.compareTo((String)extension2, (String)candidate, (boolean)true) == 0)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final String removeExtension(String $this$removeExtension, String ext) {
        return StringsKt.substringBeforeLast$default((String)$this$removeExtension, (String)("." + ext), null, (int)2, null);
    }

    public static final /* synthetic */ boolean access$hasExtension(String $receiver, String ... extensions) {
        return AdaptNinjaToCxxBuildKt.hasExtension($receiver, extensions);
    }

    public static final /* synthetic */ String access$removeExtension(String $receiver, String ext) {
        return AdaptNinjaToCxxBuildKt.removeExtension($receiver, ext);
    }

    public static final /* synthetic */ boolean access$isToolchainTool(String exe2) {
        return AdaptNinjaToCxxBuildKt.isToolchainTool(exe2);
    }

    public static final /* synthetic */ void access$stripFlags(TokenizedCommandLine $receiver, String sourceFile) {
        AdaptNinjaToCxxBuildKt.stripFlags($receiver, sourceFile);
    }

    static {
        Object[] objectArray = new String[]{"libEGL.so", "libGLESv1_CM.so", "libGLESv2.so", "libGLESv3.so", "libOpenMAXAL.so", "libOpenSLES.so", "libaaudio.so", "libamidi.so", "libandroid.so", "libbinder_ndk.so", "libc.so", "libcamera2ndk.so", "libdl.so", "libjnigraphics.so", "liblog.so", "libm.so", "libmediandk.so", "libnativewindow.so", "libneuralnetworks.so", "libstdc++.so", "libsync.so", "libvulkan.so", "libz.so"};
        NDK_SYSTEM_LIBS = CollectionsKt.listOf((Object[])objectArray);
    }
}

