/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.errors.SyncIssueKey;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImplKt;
import com.android.build.gradle.internal.ide.SyncIssueImpl;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.Message;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001bH\u0002RP\u0010\t\u001aB\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r \f* \u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0018\u00010\n0\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporter;", "mode", "Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Lorg/gradle/api/logging/Logger;)V", "_syncIssues", "Ljava/util/HashMap;", "Lcom/android/build/gradle/internal/errors/SyncIssueKey;", "kotlin.jvm.PlatformType", "Lcom/android/builder/model/SyncIssue;", "handlerLocked", "", "messageReceiverImpl", "Lcom/android/build/gradle/internal/errors/MessageReceiverImpl;", "syncIssues", "Lcom/google/common/collect/ImmutableList;", "getSyncIssues", "()Lcom/google/common/collect/ImmutableList;", "getAllIssuesAndClear", "hasIssue", "type", "Lcom/android/builder/errors/IssueReporter$Type;", "lockHandler", "", "reportIssue", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "reportRemainingIssues", "GlobalSyncIssueService", "gradle-core"})
public final class SyncIssueReporterImpl
extends SyncIssueReporter {
    @NotNull
    private final SyncOptions.EvaluationMode mode;
    @GuardedBy(value="this")
    private final HashMap<SyncIssueKey, SyncIssue> _syncIssues;
    @GuardedBy(value="this")
    private boolean handlerLocked;
    @NotNull
    private final MessageReceiverImpl messageReceiverImpl;

    public SyncIssueReporterImpl(@NotNull SyncOptions.EvaluationMode mode, @NotNull SyncOptions.ErrorFormatMode errorFormatMode, @NotNull org.gradle.api.logging.Logger logger) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.mode = mode;
        this._syncIssues = Maps.newHashMap();
        this.messageReceiverImpl = new MessageReceiverImpl(errorFormatMode, (Logger)logger);
    }

    @Override
    @NotNull
    public synchronized ImmutableList<SyncIssue> getSyncIssues() {
        ImmutableList immutableList = ImmutableList.copyOf(this._syncIssues.values());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(_syncIssues.values)");
        return immutableList;
    }

    private final synchronized ImmutableList<SyncIssue> getAllIssuesAndClear() {
        ImmutableList<SyncIssue> issues = this.getSyncIssues();
        this._syncIssues.clear();
        return issues;
    }

    private final void reportRemainingIssues() {
        this.lockHandler();
        ImmutableList<SyncIssue> issues = this.getAllIssuesAndClear();
        EvalIssueException syncErrorToThrow = null;
        block4: for (SyncIssue issue : issues) {
            int n = issue.getSeverity();
            switch (n) {
                case 1: {
                    this.messageReceiverImpl.receiveMessage(new Message(Message.Kind.WARNING, issue.getMessage(), null, null, null, 28, null));
                    continue block4;
                }
                case 2: {
                    EvalIssueException exception = new EvalIssueException(issue.getMessage(), issue.getData(), issue.getMultiLineMessage());
                    if (syncErrorToThrow == null) {
                        syncErrorToThrow = exception;
                        continue block4;
                    }
                    ExceptionsKt.addSuppressed((Throwable)((Throwable)syncErrorToThrow), (Throwable)((Throwable)exception));
                    continue block4;
                }
            }
            throw new IllegalStateException("unexpected issue severity for " + issue);
        }
        if (syncErrorToThrow != null) {
            throw syncErrorToThrow;
        }
    }

    public synchronized boolean hasIssue(@NotNull IssueReporter.Type type) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Collection<SyncIssue> collection = this._syncIssues.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"_syncIssues.values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SyncIssue issue = (SyncIssue)element$iv;
                    boolean bl2 = false;
                    if (!(issue.getType() == type.getType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected synchronized void reportIssue(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        SyncIssueImpl issue = new SyncIssueImpl(type, severity, exception);
        SyncOptions.EvaluationMode evaluationMode = this.mode;
        int n = WhenMappings.$EnumSwitchMapping$0[evaluationMode.ordinal()];
        switch (n) {
            case 1: {
                if (severity.getSeverity() != 1) {
                    throw exception;
                }
                this.messageReceiverImpl.receiveMessage(new Message(Message.Kind.WARNING, exception.getMessage(), null, null, null, 28, null));
                break;
            }
            case 2: {
                if (this.handlerLocked) {
                    throw new IllegalStateException("Issue registered after handler locked.", (Throwable)exception);
                }
                Map<SyncIssueKey, Object> map = this._syncIssues;
                Intrinsics.checkNotNullExpressionValue(map, (String)"_syncIssues");
                map = map;
                SyncIssueKey syncIssueKey = SyncIssueReporterImplKt.access$syncIssueKeyFrom(issue);
                map.put(syncIssueKey, issue);
                break;
            }
            default: {
                throw new RuntimeException("Unknown SyncIssue type");
            }
        }
    }

    @Override
    public synchronized void lockHandler() {
        this.handlerLocked = true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$Parameters;", "Lcom/android/builder/errors/IssueReporter;", "Ljava/lang/AutoCloseable;", "()V", "reporter", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl;", "close", "", "getAllIssuesAndClear", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/builder/model/SyncIssue;", "hasIssue", "", "type", "Lcom/android/builder/errors/IssueReporter$Type;", "reportIssue", "severity", "Lcom/android/builder/errors/IssueReporter$Severity;", "exception", "Lcom/android/builder/errors/EvalIssueException;", "Parameters", "RegistrationAction", "gradle-core"})
    public static abstract class GlobalSyncIssueService
    extends IssueReporter
    implements BuildService<Parameters>,
    AutoCloseable {
        @NotNull
        private final SyncIssueReporterImpl reporter;

        public GlobalSyncIssueService() {
            Object object = ((Parameters)this.getParameters()).getMode().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.mode.get()");
            SyncOptions.EvaluationMode evaluationMode = (SyncOptions.EvaluationMode)((Object)object);
            object = ((Parameters)this.getParameters()).getErrorFormatMode().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.errorFormatMode.get()");
            SyncOptions.ErrorFormatMode errorFormatMode = (SyncOptions.ErrorFormatMode)((Object)object);
            object = Logging.getLogger(GlobalSyncIssueService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(GlobalSyncIssueService::class.java)");
            this.reporter = new SyncIssueReporterImpl(evaluationMode, errorFormatMode, (org.gradle.api.logging.Logger)object);
        }

        @NotNull
        public final ImmutableList<SyncIssue> getAllIssuesAndClear() {
            return this.reporter.getAllIssuesAndClear();
        }

        protected void reportIssue(@NotNull IssueReporter.Type type, @NotNull IssueReporter.Severity severity, @NotNull EvalIssueException exception) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.reporter.reportIssue(type, severity, exception);
        }

        public boolean hasIssue(@NotNull IssueReporter.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.reporter.hasIssue(type);
        }

        @Override
        public void close() {
            this.reporter.reportRemainingIssues();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "errorFormatMode", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "()Lorg/gradle/api/provider/Property;", "mode", "Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;", "getMode", "gradle-core"})
        public static interface Parameters
        extends BuildServiceParameters {
            @NotNull
            public Property<SyncOptions.EvaluationMode> getMode();

            @NotNull
            public Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService;", "Lcom/android/build/gradle/internal/errors/SyncIssueReporterImpl$GlobalSyncIssueService$Parameters;", "project", "Lorg/gradle/api/Project;", "evaluationMode", "Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/SyncOptions$EvaluationMode;Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;)V", "configure", "", "parameters", "gradle-core"})
        public static final class RegistrationAction
        extends ServiceRegistrationAction<GlobalSyncIssueService, Parameters> {
            @NotNull
            private final SyncOptions.EvaluationMode evaluationMode;
            @NotNull
            private final SyncOptions.ErrorFormatMode errorFormatMode;

            public RegistrationAction(@NotNull Project project2, @NotNull SyncOptions.EvaluationMode evaluationMode, @NotNull SyncOptions.ErrorFormatMode errorFormatMode) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)((Object)evaluationMode), (String)"evaluationMode");
                Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
                super(project2, GlobalSyncIssueService.class, null, 4, null);
                this.evaluationMode = evaluationMode;
                this.errorFormatMode = errorFormatMode;
            }

            @Override
            public void configure(@NotNull Parameters parameters) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getMode().set((Object)this.evaluationMode);
                parameters.getErrorFormatMode().set((Object)this.errorFormatMode);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyncOptions.EvaluationMode.values().length];
            nArray[SyncOptions.EvaluationMode.STANDARD.ordinal()] = 1;
            nArray[SyncOptions.EvaluationMode.IDE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

