/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.internal.StringCachingService;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001=BG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eBk\b\u0000\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0015\u001a\u00020\n\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u0016J\t\u0010&\u001a\u00020\u0010H\u00c6\u0003J\u0015\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u0010(\u001a\u00020\u0012H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\bH\u00c6\u0003J\t\u0010/\u001a\u00020\nH\u00c6\u0003J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\r2\u0006\u00105\u001a\u000206J\u0081\u0001\u00107\u001a\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0015\u001a\u00020\n2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001J\u0013\u00108\u001a\u00020\n2\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020\rH\u00d6\u0001R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010 R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010 R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006>"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "", "mainArtifactResult", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "extractedFolder", "Ljava/io/File;", "publishedLintJar", "dependencyType", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "isWrappedModule", "", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "(Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;ZLcom/google/common/collect/ImmutableMap;)V", "componentIdentifier", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "variant", "Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "variantName", "artifactFile", "isTestFixturesArtifact", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;Lorg/gradle/api/artifacts/result/ResolvedVariantResult;Ljava/lang/String;Ljava/io/File;ZLjava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;ZLcom/google/common/collect/ImmutableMap;)V", "getArtifactFile", "()Ljava/io/File;", "getBuildMapping", "()Lcom/google/common/collect/ImmutableMap;", "getComponentIdentifier", "()Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "getDependencyType", "()Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "getExtractedFolder", "()Z", "getPublishedLintJar", "getVariant", "()Lorg/gradle/api/artifacts/result/ResolvedVariantResult;", "getVariantName", "()Ljava/lang/String;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "computeMavenCoordinates", "Lcom/android/builder/model/MavenCoordinates;", "stringCachingService", "Lcom/android/builder/internal/StringCachingService;", "computeModelAddress", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "copy", "equals", "other", "hashCode", "", "toString", "DependencyType", "gradle-core"})
public final class ResolvedArtifact {
    @NotNull
    private final ComponentIdentifier componentIdentifier;
    @NotNull
    private final ResolvedVariantResult variant;
    @Nullable
    private final String variantName;
    @Nullable
    private final File artifactFile;
    private final boolean isTestFixturesArtifact;
    @Nullable
    private final File extractedFolder;
    @Nullable
    private final File publishedLintJar;
    @NotNull
    private final DependencyType dependencyType;
    private final boolean isWrappedModule;
    @NotNull
    private final ImmutableMap<String, String> buildMapping;

    public ResolvedArtifact(@NotNull ComponentIdentifier componentIdentifier, @NotNull ResolvedVariantResult variant2, @Nullable String variantName, @Nullable File artifactFile, boolean isTestFixturesArtifact, @Nullable File extractedFolder, @Nullable File publishedLintJar, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkNotNullParameter((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        this.componentIdentifier = componentIdentifier;
        this.variant = variant2;
        this.variantName = variantName;
        this.artifactFile = artifactFile;
        this.isTestFixturesArtifact = isTestFixturesArtifact;
        this.extractedFolder = extractedFolder;
        this.publishedLintJar = publishedLintJar;
        this.dependencyType = dependencyType;
        this.isWrappedModule = isWrappedModule;
        this.buildMapping = buildMapping;
    }

    @NotNull
    public final ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @NotNull
    public final ResolvedVariantResult getVariant() {
        return this.variant;
    }

    @Nullable
    public final String getVariantName() {
        return this.variantName;
    }

    @Nullable
    public final File getArtifactFile() {
        return this.artifactFile;
    }

    public final boolean isTestFixturesArtifact() {
        return this.isTestFixturesArtifact;
    }

    @Nullable
    public final File getExtractedFolder() {
        return this.extractedFolder;
    }

    @Nullable
    public final File getPublishedLintJar() {
        return this.publishedLintJar;
    }

    @NotNull
    public final DependencyType getDependencyType() {
        return this.dependencyType;
    }

    public final boolean isWrappedModule() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ImmutableMap<String, String> getBuildMapping() {
        return this.buildMapping;
    }

    public ResolvedArtifact(@NotNull ResolvedArtifactResult mainArtifactResult, @Nullable File extractedFolder, @Nullable File publishedLintJar, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkNotNullParameter((Object)mainArtifactResult, (String)"mainArtifactResult");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        ComponentIdentifier componentIdentifier = mainArtifactResult.getId().getComponentIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"mainArtifactResult.id.componentIdentifier");
        ComponentIdentifier componentIdentifier2 = componentIdentifier;
        componentIdentifier = mainArtifactResult.getVariant();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"mainArtifactResult.variant");
        this(componentIdentifier2, (ResolvedVariantResult)componentIdentifier, LibraryUtils.getVariantName(mainArtifactResult), mainArtifactResult.getFile(), LibraryUtils.hasProjectTestFixturesCapability(mainArtifactResult) || LibraryUtils.hasLibraryTestFixturesCapability(mainArtifactResult), extractedFolder, publishedLintJar, dependencyType, isWrappedModule, buildMapping);
    }

    @NotNull
    public final MavenCoordinates computeMavenCoordinates(@NotNull StringCachingService stringCachingService) {
        MavenCoordinates mavenCoordinates;
        Intrinsics.checkNotNullParameter((Object)stringCachingService, (String)"stringCachingService");
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ModuleComponentIdentifier) {
            String module2 = ((ModuleComponentIdentifier)this.componentIdentifier).getModule();
            String version = ((ModuleComponentIdentifier)this.componentIdentifier).getVersion();
            String extension2 = this.dependencyType.getExtension();
            String classifier = null;
            File file = this.artifactFile;
            Intrinsics.checkNotNull((Object)file);
            if (!file.isDirectory()) {
                String pattern = "^" + module2 + "-" + version + "-(.+)\\." + extension2 + "$";
                Pattern p = Pattern.compile(pattern);
                File file2 = this.artifactFile;
                Intrinsics.checkNotNull((Object)file2);
                Matcher m = p.matcher(file2.getName());
                if (m.matches()) {
                    classifier = m.group(1);
                }
            }
            String string = ((ModuleComponentIdentifier)this.componentIdentifier).getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentIdentifier.group");
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesImpl.Companion.create(stringCachingService, string, module2, version, extension2, classifier);
        } else if (componentIdentifier instanceof ProjectComponentIdentifier) {
            mavenCoordinates = (MavenCoordinates)MavenCoordinatesImpl.Companion.create$default((MavenCoordinatesImpl.Companion)MavenCoordinatesImpl.Companion, (StringCachingService)stringCachingService, (String)"artifacts", (String)BuildMappingUtils.getIdString((ProjectComponentIdentifier)this.componentIdentifier), (String)"unspecified", null, null, (int)48, null);
        } else if (componentIdentifier instanceof OpaqueComponentArtifactIdentifier) {
            MavenCoordinatesImpl mavenCoordinatesImpl;
            if (this.dependencyType == DependencyType.JAVA) {
                File file = this.artifactFile;
                Intrinsics.checkNotNull((Object)file);
                mavenCoordinatesImpl = MavenCoordinatesCacheBuildService.Companion.getMavenCoordForLocalFile(file, stringCachingService);
            } else {
                File file = this.artifactFile;
                Intrinsics.checkNotNull((Object)file);
                boolean bl = file.isDirectory();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                File file3 = this.artifactFile;
                Intrinsics.checkNotNull((Object)file3);
                mavenCoordinatesImpl = MavenCoordinatesCacheBuildService.Companion.getMavenCoordForLocalFile(file3, stringCachingService);
            }
            mavenCoordinates = (MavenCoordinates)mavenCoordinatesImpl;
        } else {
            throw new RuntimeException("Don't know how to compute maven coordinate for artifact '" + this.componentIdentifier.getDisplayName() + "' with component identifier of type '" + this.componentIdentifier.getClass() + "'.");
        }
        return mavenCoordinates;
    }

    @NotNull
    public final String computeModelAddress(@NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        String string;
        Intrinsics.checkNotNullParameter((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        ComponentIdentifier componentIdentifier = this.componentIdentifier;
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            StringBuilder stringBuilder;
            StringBuilder sb = stringBuilder = new StringBuilder(100).append(BuildMappingUtils.getBuildId((ProjectComponentIdentifier)this.componentIdentifier, this.buildMapping)).append("@@").append(((ProjectComponentIdentifier)this.componentIdentifier).getProjectPath());
            boolean bl = false;
            String string2 = this.getVariantName();
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl2 = false;
                sb.append("::").append(it);
            }
            if (this.isTestFixturesArtifact()) {
                sb.append("::").append("testFixtures");
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder(100)\n     \u2026              .toString()");
            String string5 = string4.intern();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).intern()");
        } else if (componentIdentifier instanceof ModuleComponentIdentifier ? true : componentIdentifier instanceof OpaqueComponentArtifactIdentifier) {
            String string6 = mavenCoordinatesCache.getMavenCoordinates(this) + (this.isTestFixturesArtifact ? "::testFixtures" : "");
            String string7 = string6.intern();
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).intern()");
        } else {
            throw new RuntimeException("Don't know how to handle ComponentIdentifier '" + this.componentIdentifier.getDisplayName() + "'of type " + this.componentIdentifier.getClass());
        }
        return string;
    }

    @NotNull
    public final ComponentIdentifier component1() {
        return this.componentIdentifier;
    }

    @NotNull
    public final ResolvedVariantResult component2() {
        return this.variant;
    }

    @Nullable
    public final String component3() {
        return this.variantName;
    }

    @Nullable
    public final File component4() {
        return this.artifactFile;
    }

    public final boolean component5() {
        return this.isTestFixturesArtifact;
    }

    @Nullable
    public final File component6() {
        return this.extractedFolder;
    }

    @Nullable
    public final File component7() {
        return this.publishedLintJar;
    }

    @NotNull
    public final DependencyType component8() {
        return this.dependencyType;
    }

    public final boolean component9() {
        return this.isWrappedModule;
    }

    @NotNull
    public final ImmutableMap<String, String> component10() {
        return this.buildMapping;
    }

    @NotNull
    public final ResolvedArtifact copy(@NotNull ComponentIdentifier componentIdentifier, @NotNull ResolvedVariantResult variant2, @Nullable String variantName, @Nullable File artifactFile, boolean isTestFixturesArtifact, @Nullable File extractedFolder, @Nullable File publishedLintJar, @NotNull DependencyType dependencyType, boolean isWrappedModule, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkNotNullParameter((Object)componentIdentifier, (String)"componentIdentifier");
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyType), (String)"dependencyType");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        return new ResolvedArtifact(componentIdentifier, variant2, variantName, artifactFile, isTestFixturesArtifact, extractedFolder, publishedLintJar, dependencyType, isWrappedModule, buildMapping);
    }

    public static /* synthetic */ ResolvedArtifact copy$default(ResolvedArtifact resolvedArtifact, ComponentIdentifier componentIdentifier, ResolvedVariantResult resolvedVariantResult, String string, File file, boolean bl, File file2, File file3, DependencyType dependencyType, boolean bl2, ImmutableMap immutableMap, int n, Object object) {
        if ((n & 1) != 0) {
            componentIdentifier = resolvedArtifact.componentIdentifier;
        }
        if ((n & 2) != 0) {
            resolvedVariantResult = resolvedArtifact.variant;
        }
        if ((n & 4) != 0) {
            string = resolvedArtifact.variantName;
        }
        if ((n & 8) != 0) {
            file = resolvedArtifact.artifactFile;
        }
        if ((n & 0x10) != 0) {
            bl = resolvedArtifact.isTestFixturesArtifact;
        }
        if ((n & 0x20) != 0) {
            file2 = resolvedArtifact.extractedFolder;
        }
        if ((n & 0x40) != 0) {
            file3 = resolvedArtifact.publishedLintJar;
        }
        if ((n & 0x80) != 0) {
            dependencyType = resolvedArtifact.dependencyType;
        }
        if ((n & 0x100) != 0) {
            bl2 = resolvedArtifact.isWrappedModule;
        }
        if ((n & 0x200) != 0) {
            immutableMap = resolvedArtifact.buildMapping;
        }
        return resolvedArtifact.copy(componentIdentifier, resolvedVariantResult, string, file, bl, file2, file3, dependencyType, bl2, immutableMap);
    }

    @NotNull
    public String toString() {
        return "ResolvedArtifact(componentIdentifier=" + this.componentIdentifier + ", variant=" + this.variant + ", variantName=" + this.variantName + ", artifactFile=" + this.artifactFile + ", isTestFixturesArtifact=" + this.isTestFixturesArtifact + ", extractedFolder=" + this.extractedFolder + ", publishedLintJar=" + this.publishedLintJar + ", dependencyType=" + this.dependencyType + ", isWrappedModule=" + this.isWrappedModule + ", buildMapping=" + this.buildMapping + ")";
    }

    public int hashCode() {
        int result2 = this.componentIdentifier.hashCode();
        result2 = result2 * 31 + this.variant.hashCode();
        result2 = result2 * 31 + (this.variantName == null ? 0 : this.variantName.hashCode());
        result2 = result2 * 31 + (this.artifactFile == null ? 0 : this.artifactFile.hashCode());
        int n = this.isTestFixturesArtifact ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        result2 = result2 * 31 + (this.extractedFolder == null ? 0 : this.extractedFolder.hashCode());
        result2 = result2 * 31 + (this.publishedLintJar == null ? 0 : this.publishedLintJar.hashCode());
        result2 = result2 * 31 + this.dependencyType.hashCode();
        int n2 = this.isWrappedModule ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        result2 = result2 * 31 + this.buildMapping.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolvedArtifact)) {
            return false;
        }
        ResolvedArtifact resolvedArtifact = (ResolvedArtifact)other;
        if (!Intrinsics.areEqual((Object)this.componentIdentifier, (Object)resolvedArtifact.componentIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variant, (Object)resolvedArtifact.variant)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variantName, (Object)resolvedArtifact.variantName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.artifactFile, (Object)resolvedArtifact.artifactFile)) {
            return false;
        }
        if (this.isTestFixturesArtifact != resolvedArtifact.isTestFixturesArtifact) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extractedFolder, (Object)resolvedArtifact.extractedFolder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.publishedLintJar, (Object)resolvedArtifact.publishedLintJar)) {
            return false;
        }
        if (this.dependencyType != resolvedArtifact.dependencyType) {
            return false;
        }
        if (this.isWrappedModule != resolvedArtifact.isWrappedModule) {
            return false;
        }
        return Intrinsics.areEqual(this.buildMapping, resolvedArtifact.buildMapping);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact$DependencyType;", "", "extension", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "JAVA", "ANDROID", "RELOCATED_ARTIFACT", "NO_ARTIFACT_FILE", "gradle-core"})
    public static final class DependencyType
    extends Enum<DependencyType> {
        @NotNull
        private final String extension;
        public static final /* enum */ DependencyType JAVA = new DependencyType("jar");
        public static final /* enum */ DependencyType ANDROID = new DependencyType("aar");
        public static final /* enum */ DependencyType RELOCATED_ARTIFACT = new DependencyType("");
        public static final /* enum */ DependencyType NO_ARTIFACT_FILE = new DependencyType("");
        private static final /* synthetic */ DependencyType[] $VALUES;

        private DependencyType(String extension2) {
            this.extension = extension2;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        public static DependencyType[] values() {
            return (DependencyType[])$VALUES.clone();
        }

        public static DependencyType valueOf(String value) {
            return Enum.valueOf(DependencyType.class, value);
        }

        static {
            $VALUES = dependencyTypeArray = new DependencyType[]{DependencyType.JAVA, DependencyType.ANDROID, DependencyType.RELOCATED_ARTIFACT, DependencyType.NO_ARTIFACT_FILE};
        }
    }
}

