/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.dependencies.ArtifactHandler;
import com.android.build.gradle.internal.lint.DependencyCaches;
import com.android.build.gradle.internal.lint.ProjectKey;
import com.android.build.gradle.internal.lint.ProjectKeyKt;
import com.android.build.gradle.internal.lint.ProjectSourceSetKey;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelMavenName;
import com.android.tools.lint.model.DefaultLintModelModuleLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002JT\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001f2\u0006\u0010 \u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0014J`\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0014J4\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0014J8\u0010.\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0014J\f\u0010/\u001a\u000200*\u00020$H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/lint/CheckDependenciesLintModelArtifactHandler;", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactHandler;", "Lcom/android/tools/lint/model/LintModelLibrary;", "dependencyCaches", "Lcom/android/build/gradle/internal/lint/DependencyCaches;", "thisProject", "Lcom/android/build/gradle/internal/lint/ProjectKey;", "projectRuntimeLintModels", "Lorg/gradle/api/artifacts/ArtifactCollection;", "projectCompileLintModels", "compileProjectJars", "runtimeProjectJars", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "warnIfProjectTreatedAsExternalDependency", "", "(Lcom/android/build/gradle/internal/lint/DependencyCaches;Lcom/android/build/gradle/internal/lint/ProjectKey;Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/artifacts/ArtifactCollection;Lcom/google/common/collect/ImmutableMap;Z)V", "", "Lcom/android/build/gradle/internal/lint/ProjectSourceSetKey;", "Ljava/io/File;", "projectDependencyLintModels", "", "errorJarNotFound", "", "key", "handleAndroidLibrary", "aarFile", "folder", "localJavaLibraries", "", "isProvided", "variantName", "coordinatesSupplier", "Lkotlin/Function0;", "Lcom/android/builder/model/MavenCoordinates;", "addressSupplier", "handleAndroidModule", "projectPath", "buildId", "isTestFixtures", "lintJar", "identitySupplier", "handleJavaLibrary", "jarFile", "handleJavaModule", "toMavenName", "Lcom/android/tools/lint/model/LintModelMavenName;", "gradle-core"})
public final class CheckDependenciesLintModelArtifactHandler
extends ArtifactHandler<LintModelLibrary> {
    @NotNull
    private final ProjectKey thisProject;
    private final boolean warnIfProjectTreatedAsExternalDependency;
    @NotNull
    private final Set<ProjectKey> projectDependencyLintModels;
    @NotNull
    private final Map<ProjectSourceSetKey, File> compileProjectJars;
    @NotNull
    private final Map<ProjectSourceSetKey, File> runtimeProjectJars;

    public CheckDependenciesLintModelArtifactHandler(@NotNull DependencyCaches dependencyCaches, @NotNull ProjectKey thisProject, @NotNull ArtifactCollection projectRuntimeLintModels, @NotNull ArtifactCollection projectCompileLintModels, @NotNull ArtifactCollection compileProjectJars, @NotNull ArtifactCollection runtimeProjectJars, @NotNull ImmutableMap<String, String> buildMapping, boolean warnIfProjectTreatedAsExternalDependency) {
        Intrinsics.checkNotNullParameter((Object)dependencyCaches, (String)"dependencyCaches");
        Intrinsics.checkNotNullParameter((Object)thisProject, (String)"thisProject");
        Intrinsics.checkNotNullParameter((Object)projectRuntimeLintModels, (String)"projectRuntimeLintModels");
        Intrinsics.checkNotNullParameter((Object)projectCompileLintModels, (String)"projectCompileLintModels");
        Intrinsics.checkNotNullParameter((Object)compileProjectJars, (String)"compileProjectJars");
        Intrinsics.checkNotNullParameter((Object)runtimeProjectJars, (String)"runtimeProjectJars");
        Intrinsics.checkNotNullParameter(buildMapping, (String)"buildMapping");
        super(dependencyCaches.getLocalJarCache(), dependencyCaches.getMavenCoordinatesCache());
        this.thisProject = thisProject;
        this.warnIfProjectTreatedAsExternalDependency = warnIfProjectTreatedAsExternalDependency;
        this.projectDependencyLintModels = SetsKt.plus(ProjectKeyKt.asProjectKeyedMap(projectCompileLintModels, buildMapping).keySet(), (Iterable)ProjectKeyKt.asProjectKeyedMap(projectRuntimeLintModels, buildMapping).keySet());
        this.compileProjectJars = ProjectKeyKt.asProjectSourceSetKeyedMap(compileProjectJars, buildMapping);
        this.runtimeProjectJars = ProjectKeyKt.asProjectSourceSetKeyedMap(runtimeProjectJars, buildMapping);
    }

    @Override
    @NotNull
    protected LintModelLibrary handleAndroidLibrary(@NotNull File aarFile, @NotNull File folder2, @NotNull List<? extends File> localJavaLibraries, boolean isProvided, @Nullable String variantName, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter((Object)folder2, (String)"folder");
        Intrinsics.checkNotNullParameter(localJavaLibraries, (String)"localJavaLibraries");
        Intrinsics.checkNotNullParameter(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkNotNullParameter(addressSupplier, (String)"addressSupplier");
        Object object = new String[]{"jars", "classes.jar"};
        List list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FileUtils.join((File)folder2, (String[])object)), (Iterable)localJavaLibraries);
        object = (String)addressSupplier.invoke();
        File file = new File(folder2, "AndroidManifest.xml");
        File file2 = new File(folder2, "res");
        File file3 = new File(folder2, "assets");
        File file4 = new File(folder2, "lint.jar");
        File file5 = new File(folder2, "public.txt");
        File file6 = new File(folder2, "R.txt");
        File file7 = new File(folder2, "annotations.zip");
        File file8 = new File(folder2, "proguard.txt");
        LintModelMavenName lintModelMavenName = this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke());
        return (LintModelLibrary)new DefaultLintModelAndroidLibrary((String)object, list, file, folder2, file2, file3, file4, file5, file6, file7, file8, isProvided, lintModelMavenName);
    }

    @Override
    @NotNull
    protected LintModelLibrary handleAndroidModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, boolean isTestFixtures, @NotNull File aarFile, @Nullable File lintJar, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> identitySupplier) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)aarFile, (String)"aarFile");
        Intrinsics.checkNotNullParameter(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkNotNullParameter(identitySupplier, (String)"identitySupplier");
        return (LintModelLibrary)new DefaultLintModelModuleLibrary((String)identitySupplier.invoke(), projectPath, lintJar, isProvided);
    }

    @Override
    @NotNull
    protected LintModelLibrary handleJavaLibrary(@NotNull File jarFile, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> identitySupplier) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkNotNullParameter(identitySupplier, (String)"identitySupplier");
        return (LintModelLibrary)new DefaultLintModelJavaLibrary((String)identitySupplier.invoke(), CollectionsKt.listOf((Object)jarFile), this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()), isProvided);
    }

    @Override
    @NotNull
    protected LintModelLibrary handleJavaModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, boolean isTestFixtures, @NotNull Function0<String> identitySupplier) {
        File file;
        File file2;
        boolean hasLintModel;
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter(identitySupplier, (String)"identitySupplier");
        ProjectSourceSetKey sourceSetKey = new ProjectSourceSetKey(buildId, projectPath, variantName, isTestFixtures);
        ProjectKey mainKey = new ProjectKey(buildId, projectPath, variantName);
        boolean bl = hasLintModel = Intrinsics.areEqual((Object)mainKey.getBuildId(), (Object)this.thisProject.getBuildId()) && Intrinsics.areEqual((Object)mainKey.getProjectPath(), (Object)this.thisProject.getProjectPath()) || this.projectDependencyLintModels.contains(mainKey);
        if (hasLintModel) {
            return (LintModelLibrary)new DefaultLintModelModuleLibrary((String)identitySupplier.invoke(), projectPath, null, false);
        }
        if (this.warnIfProjectTreatedAsExternalDependency) {
            Logging.getLogger(CheckDependenciesLintModelArtifactHandler.class).warn("Warning: Lint will treat " + mainKey.getProjectPath() + " as an external dependency and not analyze it.\n * Recommended Action: Apply the 'com.android.lint' plugin to java library project " + mainKey.getProjectPath() + ". to enable lint to analyze those sources.\n");
        }
        if ((file2 = this.compileProjectJars.get(sourceSetKey)) == null) {
            File file3 = this.runtimeProjectJars.get(sourceSetKey);
            if (file3 == null) {
                this.errorJarNotFound(sourceSetKey);
                throw new KotlinNothingValueException();
            }
            file = file3;
        } else {
            file = file2;
        }
        File jar = file;
        return (LintModelLibrary)new DefaultLintModelJavaLibrary((String)identitySupplier.invoke(), CollectionsKt.listOf((Object)jar), (LintModelMavenName)LintModelMavenName.Companion.getNONE(), false);
    }

    private final Void errorJarNotFound(ProjectSourceSetKey key) {
        String string = "Internal errorr: Could not find jar for project " + key + "\nProject jars reachable from the compile classpath:" + CollectionsKt.joinToString$default((Iterable)this.compileProjectJars.keySet(), (CharSequence)"\n - ", (CharSequence)"\n - ", null, (int)0, null, null, (int)60, null) + "\n\nProject jars reachable from the runtime classpath:" + CollectionsKt.joinToString$default((Iterable)this.runtimeProjectJars.keySet(), (CharSequence)"\n - ", (CharSequence)"\n - ", null, (int)0, null, null, (int)60, null);
        throw new IllegalStateException(string.toString());
    }

    private final LintModelMavenName toMavenName(MavenCoordinates $this$toMavenName) {
        return (LintModelMavenName)new DefaultLintModelMavenName($this$toMavenName.getGroupId(), $this$toMavenName.getArtifactId(), $this$toMavenName.getVersion());
    }
}

