/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkR19Info;", "Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "root", "Ljava/io/File;", "(Ljava/io/File;)V", "getRoot", "()Ljava/io/File;", "supportedStls", "", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "()Ljava/util/List;", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getObjcopyExecutable", "abi", "Lcom/android/build/gradle/internal/core/Abi;", "getStlSharedObjectFile", "stl", "getStripExecutable", "getToolchainAbi", "validate", "", "gradle-core"})
public class NdkR19Info
extends DefaultNdkInfo {
    @NotNull
    private final File root;
    @NotNull
    private final List<Stl> supportedStls;

    public NdkR19Info(@NotNull File root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(root);
        this.root = root;
        Stl[] stlArray = new Stl[]{Stl.LIBCXX_SHARED, Stl.LIBCXX_STATIC, Stl.NONE, Stl.SYSTEM};
        this.supportedStls = CollectionsKt.listOf((Object[])stlArray);
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    @NotNull
    protected Abi getToolchainAbi(@NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        return abi == Abi.MIPS ? Abi.MIPS64 : abi;
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)((Object)buildSystem), (String)"buildSystem");
        NativeBuildSystem nativeBuildSystem = buildSystem;
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                stl = Stl.LIBCXX_STATIC;
                break;
            }
            case 2: {
                stl = Stl.SYSTEM;
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                String string = String.valueOf((Object)buildSystem);
                throw new IllegalStateException(string.toString());
            }
        }
        return stl;
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl, @NotNull Abi abi) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)stl), (String)"stl");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        Preconditions.checkArgument((stl == Stl.LIBCXX_SHARED ? 1 : 0) != 0, (String)"Only c++_shared is valid for packaging as of NDK r19", (Object[])new Object[0]);
        Preconditions.checkArgument((boolean)this.getSupportedAbis().contains((Object)abi), (String)("Unsupported ABI for NDK r19+: " + abi), (Object[])new Object[0]);
        Abi abi2 = abi;
        int n = WhenMappings.$EnumSwitchMapping$1[abi2.ordinal()];
        switch (n) {
            case 1: {
                string = "aarch64-linux-android";
                break;
            }
            case 2: {
                string = "arm-linux-androideabi";
                break;
            }
            case 3: {
                string = "i686-linux-android";
                break;
            }
            case 4: {
                string = "x86_64-linux-android";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported ABI for NDK r19+: " + abi);
            }
        }
        String sysrootTriple = string;
        File file = FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/sysroot/usr/lib/" + sysrootTriple + "/" + stl.getLibraryName()));
        Preconditions.checkState((boolean)file.isFile(), (String)("Expected NDK STL shared object file at " + file), (Object[])new Object[0]);
        return file;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        return FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/" + this.getToolchainAbi(abi).getGccExecutablePrefix() + "-strip"));
    }

    @Override
    @NotNull
    public File getObjcopyExecutable(@NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        return FilesKt.resolve((File)this.getRootDirectory(), (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/" + this.getToolchainAbi(abi).getGccExecutablePrefix() + "-objcopy"));
    }

    @Override
    @Nullable
    public String validate() {
        File toolchainsDir = FilesKt.resolve((File)this.getRootDirectory(), (String)"toolchains");
        if (!toolchainsDir.isDirectory()) {
            return toolchainsDir + " is not a directory.";
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            nArray[NativeBuildSystem.NINJA.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Abi.values().length];
            nArray[Abi.ARM64_V8A.ordinal()] = 1;
            nArray[Abi.ARMEABI_V7A.ordinal()] = 2;
            nArray[Abi.X86.ordinal()] = 3;
            nArray[Abi.X86_64.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

