/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.SecondaryInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.IntermediateFolderUtils;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.builder.profile.Recorder;
import com.android.ide.common.util.ReferenceHolder;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

@CacheableTask
public abstract class IncrementalTransformTask
extends TransformTask {
    @TaskAction
    void transform(final IncrementalTaskInputs incrementalTaskInputs) throws IOException, TransformException, InterruptedException {
        final ReferenceHolder consumedInputs = ReferenceHolder.empty();
        final ReferenceHolder referencedInputs = ReferenceHolder.empty();
        final ReferenceHolder isIncremental = ReferenceHolder.empty();
        final ReferenceHolder changedSecondaryInputs = ReferenceHolder.empty();
        isIncremental.setValue((Object)(this.getTransform().isIncremental() && incrementalTaskInputs.isIncremental() ? 1 : 0));
        GradleTransformExecution preExecutionInfo = GradleTransformExecution.newBuilder().setType(AnalyticsUtil.getTransformType(this.getTransform().getClass()).getNumber()).setIsIncremental(((Boolean)isIncremental.getValue()).booleanValue()).setTransformClassName(this.getTransform().getClass().getName()).build();
        AnalyticsService analyticsService = (AnalyticsService)this.getAnalyticsService().get();
        analyticsService.recordBlock(GradleBuildProfileSpan.ExecutionType.TASK_TRANSFORM_PREPARATION, preExecutionInfo, (String)this.getProjectPath().get(), this.getVariantName(), new Recorder.VoidBlock(){

            public void call() {
                List<IncrementalTransformInput> incReferencedInputs;
                List<IncrementalTransformInput> incInputs;
                HashMap changedMap = Maps.newHashMap();
                HashSet removedFiles2 = Sets.newHashSet();
                if (((Boolean)isIncremental.getValue()).booleanValue()) {
                    IncrementalTransformTask.gatherChangedFiles(IncrementalTransformTask.this.getLogger(), incrementalTaskInputs, changedMap, removedFiles2);
                    isIncremental.setValue((Object)IncrementalTransformTask.this.checkSecondaryFiles(changedMap, removedFiles2));
                }
                if (((Boolean)isIncremental.getValue()).booleanValue() && ((Boolean)isIncremental.setValue((Object)IncrementalTransformTask.this.updateIncrementalInputsWithChangedFiles(incInputs = IncrementalTransformTask.createIncrementalInputs(IncrementalTransformTask.this.consumedInputStreams), incReferencedInputs = IncrementalTransformTask.createIncrementalInputs(IncrementalTransformTask.this.referencedInputStreams), changedMap, removedFiles2))).booleanValue()) {
                    consumedInputs.setValue(IncrementalTransformTask.convertToImmutable(incInputs));
                    referencedInputs.setValue(IncrementalTransformTask.convertToImmutable(incReferencedInputs));
                }
                if (!((Boolean)isIncremental.getValue()).booleanValue()) {
                    consumedInputs.setValue(TransformTask.computeNonIncTransformInput(IncrementalTransformTask.this.consumedInputStreams));
                    referencedInputs.setValue(TransformTask.computeNonIncTransformInput(IncrementalTransformTask.this.referencedInputStreams));
                    changedSecondaryInputs.setValue((Object)ImmutableList.of());
                } else {
                    changedSecondaryInputs.setValue(IncrementalTransformTask.this.gatherSecondaryInputChanges(changedMap, removedFiles2));
                }
            }
        });
        this.runTransform((List)consumedInputs.getValue(), (List)referencedInputs.getValue(), (Boolean)isIncremental.getValue(), (Collection)changedSecondaryInputs.getValue(), preExecutionInfo, analyticsService);
    }

    private Collection<SecondaryInput> gatherSecondaryInputChanges(Map<File, Status> changedMap, Set<File> removedFiles2) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (final SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            for (File file : this.getSecondaryInputFiles(secondaryFile)) {
                final Status status = changedMap.containsKey(file) ? changedMap.get(file) : (removedFiles2.contains(file) ? Status.REMOVED : Status.NOTCHANGED);
                builder.add((Object)new SecondaryInput(){

                    public SecondaryFile getSecondaryInput() {
                        return secondaryFile;
                    }

                    public Status getStatus() {
                        return status;
                    }
                });
            }
        }
        return builder.build();
    }

    private static List<IncrementalTransformInput> createIncrementalInputs(Collection<TransformStream> streams) {
        return streams.stream().map(TransformStream::asIncrementalInput).collect(Collectors.toList());
    }

    private synchronized Collection<SecondaryFile> getAllSecondaryInputs() {
        if (this.secondaryFiles == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)this.getTransform().getSecondaryFiles());
            builder.addAll(this.getTransform().getSecondaryFileInputs().stream().map(SecondaryFile::nonIncremental).iterator());
            this.secondaryFiles = builder.build();
        }
        return this.secondaryFiles;
    }

    private static void gatherChangedFiles(Logger logger, IncrementalTaskInputs incrementalTaskInputs, Map<File, Status> changedFileMap, Set<File> removedFiles2) {
        logger.info("Transform inputs calculations based on following changes");
        incrementalTaskInputs.outOfDate(inputFileDetails -> {
            logger.info(inputFileDetails.getFile().getAbsolutePath() + ":" + IntermediateFolderUtils.inputFileDetailsToStatus(inputFileDetails));
            if (inputFileDetails.isAdded()) {
                changedFileMap.put(inputFileDetails.getFile(), Status.ADDED);
            } else if (inputFileDetails.isModified()) {
                changedFileMap.put(inputFileDetails.getFile(), Status.CHANGED);
            }
        });
        incrementalTaskInputs.removed(inputFileDetails -> {
            logger.info(inputFileDetails.getFile().getAbsolutePath() + ":REMOVED");
            removedFiles2.add(inputFileDetails.getFile());
        });
    }

    private boolean checkSecondaryFiles(Map<File, Status> changedMap, Set<File> removedFiles2) {
        for (SecondaryFile secondaryFile : this.getAllSecondaryInputs()) {
            Set<File> files2 = this.getSecondaryInputFiles(secondaryFile);
            if (Sets.intersection(files2, changedMap.keySet()).isEmpty() && Sets.intersection(files2, removedFiles2).isEmpty() || secondaryFile.supportsIncrementalBuild()) continue;
            return false;
        }
        return true;
    }

    private Set<File> getSecondaryInputFiles(SecondaryFile secondaryFile) {
        HashSet secondaryInputFiles = Sets.newHashSet();
        FileCollection secondaryInputFileCollection = secondaryFile.getFileCollection();
        if (secondaryInputFileCollection != null) {
            secondaryInputFiles.addAll(secondaryInputFileCollection.getFiles());
        } else {
            secondaryInputFiles.add(secondaryFile.getFile());
        }
        return secondaryInputFiles;
    }

    private boolean isSecondaryFile(File file) {
        for (FileCollection secondaryFileInput : this.getSecondaryFileInputs()) {
            if (!secondaryFileInput.contains(file)) continue;
            return true;
        }
        return false;
    }

    private boolean updateIncrementalInputsWithChangedFiles(List<IncrementalTransformInput> consumedInputs, List<IncrementalTransformInput> referencedInputs, Map<File, Status> changedFilesMap, Set<File> removedFiles2) {
        ArrayList iterators = Lists.newArrayListWithCapacity((int)2);
        Splitter splitter = Splitter.on((char)File.separatorChar);
        Sets.SetView scopes2 = Sets.union((Set)this.getTransform().getScopes(), (Set)this.getTransform().getReferencedScopes());
        Set inputTypes = this.getTransform().getInputTypes();
        for (File file : removedFiles2) {
            ArrayList removedFileSegments = Lists.newArrayList((Iterable)splitter.split((CharSequence)file.getAbsolutePath()));
            Iterator<IncrementalTransformInput> iterator2 = IncrementalTransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            boolean found = false;
            while (iterator2.hasNext()) {
                IncrementalTransformInput next = iterator2.next();
                if (!next.checkRemovedJarFile((Set<? super QualifiedContent.Scope>)scopes2, inputTypes, file, removedFileSegments) && !next.checkRemovedFolderFile((Set<? super QualifiedContent.Scope>)scopes2, inputTypes, file, removedFileSegments)) continue;
                found = true;
                break;
            }
            if (found || this.isSecondaryFile(file)) continue;
            return false;
        }
        for (Map.Entry entry : changedFilesMap.entrySet()) {
            File changedFile = (File)entry.getKey();
            Status changedStatus = (Status)entry.getValue();
            Iterator<IncrementalTransformInput> iterator3 = IncrementalTransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            boolean found = false;
            while (iterator3.hasNext()) {
                if (!iterator3.next().checkForJar(changedFile, changedStatus)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator3 = IncrementalTransformTask.getConcatIterator(consumedInputs, referencedInputs, iterators);
            ArrayList changedSegments = Lists.newArrayList((Iterable)splitter.split((CharSequence)changedFile.getAbsolutePath()));
            while (iterator3.hasNext() && !iterator3.next().checkForFolder(changedFile, changedSegments, changedStatus)) {
            }
        }
        return true;
    }

    private static Iterator<IncrementalTransformInput> getConcatIterator(List<IncrementalTransformInput> consumedInputs, List<IncrementalTransformInput> referencedInputs, List<Iterator<IncrementalTransformInput>> iterators) {
        iterators.clear();
        iterators.add(consumedInputs.iterator());
        iterators.add(referencedInputs.iterator());
        return Iterators.concat(iterators.iterator());
    }

    private static List<TransformInput> convertToImmutable(List<IncrementalTransformInput> inputs) {
        return inputs.stream().map(IncrementalTransformInput::asImmutable).collect(Collectors.toList());
    }
}

