/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.options.BooleanOption;
import com.android.ide.common.repository.GradleVersion;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "getVersionCheckOverridePropertyValue", "", "Companion", "gradle-core"})
public final class VersionCheckPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.parse((String)"7.5-rc-1");
    @NotNull
    private static final AtomicBoolean isCheckDone = new AtomicBoolean(false);

    public void apply(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (isCheckDone.getAndSet(true)) {
            return;
        }
        Logger logger = project2.getLogger();
        String currentVersion = project2.getGradle().getGradleVersion();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            File file = new File(project2.getRootProject().getProjectDir(), "gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Minimum supported Gradle version is " + GRADLE_MIN_VERSION + ". Current version is " + currentVersion + ". If using the gradle wrapper, try editing the distributionUrl in " + file.getAbsolutePath() + " to gradle-" + GRADLE_MIN_VERSION + "-all.zip";
            Object[] objectArray = new Object[]{};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String errorMessage = string2;
            if (this.getVersionCheckOverridePropertyValue(project2)) {
                logger.warn(errorMessage);
                logger.warn("As " + BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName() + " is set, continuing anyway.");
            } else {
                throw new RuntimeException(errorMessage);
            }
        }
    }

    private final boolean getVersionCheckOverridePropertyValue(Project project2) {
        Object value = project2.getExtensions().getExtraProperties().getProperties().get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName());
        return value == null ? BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getDefaultValue().booleanValue() : BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.parse(value).booleanValue();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin$Companion;", "", "()V", "GRADLE_MIN_VERSION", "Lcom/android/ide/common/repository/GradleVersion;", "kotlin.jvm.PlatformType", "isCheckDone", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isCheckDone$gradle_core", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicBoolean isCheckDone$gradle_core() {
            return isCheckDone;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

