/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "resourcesManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "state", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$State;", "createAnalyticsService", "", "project", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "getProjectBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "instantiateAnalyticsService", "recordBlock", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "variant", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "RegistrationAction", "State", "gradle-core"})
public abstract class AnalyticsConfiguratorService
implements BuildService<BuildServiceParameters.None> {
    @NotNull
    private final AnalyticsResourceManager resourcesManager;
    @NotNull
    private State state;

    public AnalyticsConfiguratorService() {
        GradleBuildProfile.Builder builder = GradleBuildProfile.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        this.resourcesManager = new AnalyticsResourceManager(builder, new ConcurrentHashMap(), false, null, new ConcurrentHashMap(), null, null, 64, null);
        this.state = State.COLLECTING_DATA;
    }

    @Nullable
    public GradleBuildProject.Builder getProjectBuilder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            String string = "Accessing GradleBuildProject.Builder through AnalyticsConfiguratorService is not allowed after AnalyticsService is created.";
            throw new IllegalStateException(string.toString());
        }
        return this.resourcesManager.getProjectBuilder(projectPath);
    }

    @Nullable
    public GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            String string = "Accessing GradleBuildVariant.Builder through AnalyticsConfiguratorService is not allowed after AnalyticsService is created.";
            throw new IllegalStateException(string.toString());
        }
        return this.resourcesManager.getVariantBuilder(projectPath, variantName);
    }

    public void recordBlock(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @NotNull String projectPath, @Nullable String variant2, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.resourcesManager.recordBlockAtConfiguration(executionType, projectPath, variant2, block);
    }

    public synchronized void createAnalyticsService(@NotNull Project project2, @NotNull BuildEventsListenerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (this.state == State.CALLBACK_REGISTERED) {
            return;
        }
        this.state = State.CALLBACK_REGISTERED;
        Object object = project2.getGradle().getSharedServices().getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<com.android.build.gradle.internal.profile.AnalyticsService, com.android.build.gradle.internal.profile.AnalyticsService.Params>");
        }
        BuildServiceRegistration serviceRegistration = (BuildServiceRegistration)object;
        Gradle rootBuild = project2.getGradle();
        while (rootBuild.getParent() != null) {
            Intrinsics.checkNotNull((Object)rootBuild.getParent());
        }
        if (rootBuild.getStartParameter().getTaskNames().isEmpty()) {
            project2.getGradle().projectsEvaluated(new Action(this, project2, (BuildServiceRegistration<AnalyticsService, AnalyticsService.Params>)serviceRegistration){
                final /* synthetic */ AnalyticsConfiguratorService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ BuildServiceRegistration<AnalyticsService, AnalyticsService.Params> $serviceRegistration;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$serviceRegistration = $serviceRegistration;
                }

                public final void execute(Gradle it) {
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordGlobalProperties(this.$project);
                    AnalyticsResourceManager analyticsResourceManager = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    BuildServiceParameters buildServiceParameters = this.$serviceRegistration.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"serviceRegistration.parameters");
                    analyticsResourceManager.configureAnalyticsService((AnalyticsService.Params)buildServiceParameters);
                    AnalyticsConfiguratorService.access$instantiateAnalyticsService(this.this$0, this.$project);
                }
            });
        } else {
            project2.getGradle().getTaskGraph().whenReady(new Action(this, project2, (BuildServiceRegistration<AnalyticsService, AnalyticsService.Params>)serviceRegistration, registry){
                final /* synthetic */ AnalyticsConfiguratorService this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ BuildServiceRegistration<AnalyticsService, AnalyticsService.Params> $serviceRegistration;
                final /* synthetic */ BuildEventsListenerRegistry $registry;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$serviceRegistration = $serviceRegistration;
                    this.$registry = $registry;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void execute(TaskExecutionGraph it) {
                    void buildServiceRegistry$iv;
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordGlobalProperties(this.$project);
                    AnalyticsResourceManager analyticsResourceManager = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    analyticsResourceManager.collectTaskMetadata(it);
                    AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0).recordTaskNames(it);
                    AnalyticsResourceManager analyticsResourceManager2 = AnalyticsConfiguratorService.access$getResourcesManager$p(this.this$0);
                    BuildServiceParameters buildServiceParameters = this.$serviceRegistration.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"serviceRegistration.parameters");
                    analyticsResourceManager2.configureAnalyticsService((AnalyticsService.Params)buildServiceParameters);
                    AnalyticsConfiguratorService.access$instantiateAnalyticsService(this.this$0, this.$project);
                    buildServiceParameters = this.$project.getGradle().getSharedServices();
                    Intrinsics.checkNotNullExpressionValue((Object)buildServiceParameters, (String)"project.gradle.sharedServices");
                    boolean $i$f$getBuildService = false;
                    Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
                    }
                    Provider provider2 = ((BuildServiceRegistration)object).getService();
                    Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
                    this.$registry.onTaskCompletion(provider2);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void instantiateAnalyticsService(Project project2) {
        void buildServiceRegistry$iv;
        if (this.state == State.ANALYTICS_SERVICE_CREATED) {
            return;
        }
        BuildServiceRegistry buildServiceRegistry = project2.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
        Provider analyticsService = provider2;
        ((AnalyticsService)analyticsService.get()).setInitialMemorySampleForConfiguration(this.resourcesManager.getInitialMemorySample());
        ((AnalyticsService)analyticsService.get()).setConfigurationSpans(this.resourcesManager.getConfigurationSpans());
        this.state = State.ANALYTICS_SERVICE_CREATED;
    }

    public static final /* synthetic */ AnalyticsResourceManager access$getResourcesManager$p(AnalyticsConfiguratorService $this) {
        return $this.resourcesManager;
    }

    public static final /* synthetic */ void access$instantiateAnalyticsService(AnalyticsConfiguratorService $this, Project project2) {
        $this.instantiateAnalyticsService(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$State;", "", "(Ljava/lang/String;I)V", "COLLECTING_DATA", "CALLBACK_REGISTERED", "ANALYTICS_SERVICE_CREATED", "gradle-core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State COLLECTING_DATA = new State();
        public static final /* enum */ State CALLBACK_REGISTERED = new State();
        public static final /* enum */ State ANALYTICS_SERVICE_CREATED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.COLLECTING_DATA, State.CALLBACK_REGISTERED, State.ANALYTICS_SERVICE_CREATED};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AnalyticsConfiguratorService, BuildServiceParameters.None> {
        public RegistrationAction(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            super(project2, AnalyticsConfiguratorService.class, null, 4, null);
        }

        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        }
    }
}

