/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.AnalyticsServiceApi;
import com.android.build.gradle.internal.profile.ProjectData;
import com.android.build.gradle.internal.profile.TaskMetadata;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.profile.WorkerProfilingRecord;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.profile.AnalyticsProfileWriter;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.NameAnonymizerSerializer;
import com.android.builder.profile.Recorder;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Environment;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005:\u0002>?B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\fH\u0014J\b\u0010\u001d\u001a\u00020\u000eH\u0014J\u0012\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0016J2\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\u00020\u000e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0016J\u0010\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u0012H\u0016J\u0018\u0010<\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u0012H\u0016J\u0018\u0010=\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u0012H\u0016R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsService;", "Lcom/android/build/gradle/internal/profile/AnalyticsServiceApi;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "provider", "Lorg/gradle/api/provider/ProviderFactory;", "getProvider", "()Lorg/gradle/api/provider/ProviderFactory;", "resourceManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "close", "", "getProjectBuillder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "", "getTaskRecord", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "taskPath", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "getWorkerRecord", "Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "worker", "initializeResourceManager", "initializeUsageTracker", "onFinish", "finishEvent", "Lorg/gradle/tooling/events/FinishEvent;", "reconstructProfileBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;", "recordApplicationId", "metadataFile", "Ljava/io/File;", "recordBlock", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "transform", "Lcom/google/wireless/android/sdk/stats/GradleTransformExecution;", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "recordEvent", "event", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "registerSpan", "builder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "setConfigurationSpans", "spans", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "setInitialMemorySampleForConfiguration", "sample", "Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "workerAdded", "workerKey", "workerFinished", "workerStarted", "Params", "RegistrationAction", "gradle-core"})
public abstract class AnalyticsService
implements AnalyticsServiceApi,
BuildService<Params>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    private final AnalyticsResourceManager resourceManager = this.initializeResourceManager();

    public AnalyticsService() {
        this.initializeUsageTracker();
    }

    @Inject
    @NotNull
    public abstract ProviderFactory getProvider();

    @NotNull
    protected AnalyticsResourceManager initializeResourceManager() {
        GradleBuildProfile.Builder builder = this.reconstructProfileBuilder();
        ConcurrentHashMap<String, ProjectData> concurrentHashMap = new ConcurrentHashMap<String, ProjectData>((Map)((Params)this.getParameters()).getProjects().get());
        Object object = ((Params)this.getParameters()).getEnableProfileJson().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.enableProfileJson.get()");
        boolean bl = (Boolean)object;
        File file = (File)((Params)this.getParameters()).getProfileDir().getOrNull();
        ConcurrentHashMap<String, TaskMetadata> concurrentHashMap2 = new ConcurrentHashMap<String, TaskMetadata>((Map)((Params)this.getParameters()).getTaskMetadata().get());
        String string = (String)((Params)this.getParameters()).getRootProjectPath().get();
        object = new NameAnonymizerSerializer().fromJson((String)((Params)this.getParameters()).getAnonymizer().get());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NameAnonymizerSerializer\u2026ameters.anonymizer.get())");
        return new AnalyticsResourceManager(builder, concurrentHashMap, bl, file, concurrentHashMap2, string, (NameAnonymizer)object);
    }

    protected void initializeUsageTracker() {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(AnalyticsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(AnalyticsService::class.java)");
        AnalyticsSettings.initialize((ILogger)loggerWrapper, null, (Environment)Environment.Companion.getSYSTEM());
        new AnalyticsProfileWriter().initializeUsageTracker();
    }

    @Override
    public void close() {
        this.resourceManager.writeAndFinish();
    }

    public void onFinish(@Nullable FinishEvent finishEvent) {
        this.resourceManager.recordTaskExecutionSpan(finishEvent);
    }

    @Override
    public void workerAdded(@NotNull String taskPath, @NotNull String workerKey) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
        if (taskProfilingRecord != null) {
            taskProfilingRecord.addWorker(workerKey);
        }
    }

    @Override
    public void workerStarted(@NotNull String taskPath, @NotNull String workerKey) {
        WorkerProfilingRecord workerRecord;
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
        WorkerProfilingRecord workerProfilingRecord = workerRecord = this.getWorkerRecord(taskPath, workerKey);
        if (workerProfilingRecord != null) {
            workerProfilingRecord.executionStarted();
        }
    }

    @Override
    public void workerFinished(@NotNull String taskPath, @NotNull String workerKey) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
        WorkerProfilingRecord workerRecord = this.getWorkerRecord(taskPath, workerKey);
        if (workerRecord != null) {
            workerRecord.executionFinished();
            TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
            if (taskProfilingRecord != null) {
                taskProfilingRecord.workerFinished(workerRecord);
            }
        }
    }

    @Override
    public void registerSpan(@NotNull String taskPath, @NotNull GradleBuildProfileSpan.Builder builder) {
        TaskProfilingRecord taskRecord2;
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        TaskProfilingRecord taskProfilingRecord = taskRecord2 = this.getTaskRecord(taskPath);
        if (taskProfilingRecord != null) {
            taskProfilingRecord.addSpan(builder);
        }
    }

    @Override
    @Nullable
    public synchronized GradleBuildProject.Builder getProjectBuillder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.resourceManager.getProjectBuilder(projectPath);
    }

    @Override
    @Nullable
    public synchronized GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        return this.resourceManager.getVariantBuilder(projectPath, variantName);
    }

    @Override
    @Nullable
    public synchronized TaskProfilingRecord getTaskRecord(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        return this.resourceManager.getTaskRecord(taskPath);
    }

    @Override
    public void recordBlock(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @Nullable GradleTransformExecution transform2, @NotNull String projectPath, @NotNull String variantName, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.resourceManager.recordBlockAtExecution(executionType, transform2, projectPath, variantName, block);
    }

    @Override
    public void setConfigurationSpans(@NotNull ConcurrentLinkedQueue<GradleBuildProfileSpan> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        this.resourceManager.getConfigurationSpans().addAll((Collection<GradleBuildProfileSpan>)spans);
    }

    @Override
    public void setInitialMemorySampleForConfiguration(@NotNull GradleBuildMemorySample sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.resourceManager.setInitialMemorySample(sample);
    }

    @Override
    public void recordEvent(@NotNull AndroidStudioEvent.Builder event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.resourceManager.recordEvent(event);
    }

    @Override
    public void recordApplicationId(@NotNull File metadataFile) {
        Intrinsics.checkNotNullParameter((Object)metadataFile, (String)"metadataFile");
        this.resourceManager.recordApplicationId(metadataFile);
    }

    private final WorkerProfilingRecord getWorkerRecord(String taskPath, String worker) {
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
        return taskProfilingRecord == null ? null : taskProfilingRecord.get(worker);
    }

    private final GradleBuildProfile.Builder reconstructProfileBuilder() {
        GradleBuildProfile.Builder builder = GradleBuildProfile.parseFrom((byte[])Base64.getDecoder().decode((String)((Params)this.getParameters()).getProfile().get())).toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"parseFrom(Base64.getDeco\u2026\n            .toBuilder()");
        return builder;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u001a\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006\u0019\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "anonymizer", "Lorg/gradle/api/provider/Property;", "", "getAnonymizer", "()Lorg/gradle/api/provider/Property;", "enableProfileJson", "", "getEnableProfileJson", "profile", "getProfile", "profileDir", "Ljava/io/File;", "getProfileDir", "projects", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/gradle/internal/profile/ProjectData;", "getProjects", "()Lorg/gradle/api/provider/MapProperty;", "rootProjectPath", "getRootProjectPath", "taskMetadata", "Lcom/android/build/gradle/internal/profile/TaskMetadata;", "getTaskMetadata", "gradle-core"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getProfile();

        @NotNull
        public Property<String> getAnonymizer();

        @NotNull
        public MapProperty<String, ProjectData> getProjects();

        @NotNull
        public Property<Boolean> getEnableProfileJson();

        @NotNull
        public Property<File> getProfileDir();

        @NotNull
        public MapProperty<String, TaskMetadata> getTaskMetadata();

        @NotNull
        public Property<String> getRootProjectPath();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AnalyticsService, Params> {
        public RegistrationAction(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            super(project2, AnalyticsService.class, null, 4, null);
        }

        @Override
        public void configure(@NotNull Params parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        }
    }
}

