/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\u0006\u0010\u001b\u001a\u00020\u0010R\u001a\u0010\t\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "Ljava/io/Serializable;", "taskName", "", "type", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "submissionTime", "Ljava/time/Instant;", "(Ljava/lang/String;Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;Ljava/time/Instant;)V", "endTime", "getEndTime$gradle_core", "()Ljava/time/Instant;", "setEndTime$gradle_core", "(Ljava/time/Instant;)V", "startTime", "duration", "Ljava/time/Duration;", "executionFinished", "", "executionStarted", "fillSpanRecord", "span", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "isFinished", "", "isStarted", "toString", "waitTime", "gradle-core"})
public final class WorkerProfilingRecord
implements Serializable {
    @NotNull
    private final String taskName;
    @NotNull
    private final GradleBuildProfileSpan.ExecutionType type;
    @NotNull
    private final Instant submissionTime;
    @NotNull
    private Instant startTime;
    @NotNull
    private Instant endTime;

    public WorkerProfilingRecord(@NotNull String taskName, @NotNull GradleBuildProfileSpan.ExecutionType type, @NotNull Instant submissionTime) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)submissionTime, (String)"submissionTime");
        this.taskName = taskName;
        this.type = type;
        this.submissionTime = submissionTime;
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.startTime = instant;
        instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.endTime = instant;
    }

    @NotNull
    public final Instant getEndTime$gradle_core() {
        return this.endTime;
    }

    public final void setEndTime$gradle_core(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.endTime = instant;
    }

    public final synchronized boolean isStarted() {
        return !Intrinsics.areEqual((Object)this.startTime, (Object)Instant.MIN);
    }

    public final boolean isFinished() {
        return !Intrinsics.areEqual((Object)this.endTime, (Object)Instant.MIN);
    }

    @NotNull
    public final Duration waitTime() {
        Duration duration;
        if (this.isStarted()) {
            Duration duration2 = Duration.between(this.submissionTime, this.startTime);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"between(submissionTime, startTime)");
            duration = duration2;
        } else {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            duration = duration3;
        }
        return duration;
    }

    @NotNull
    public final Duration duration() {
        Duration duration;
        if (this.isStarted() && this.isFinished()) {
            Duration duration2 = Duration.between(this.startTime, this.endTime);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"between(startTime, endTime)");
            duration = duration2;
        } else {
            Duration duration3 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ZERO");
            duration = duration3;
        }
        return duration;
    }

    public final synchronized void executionStarted() {
        Instant instant = TaskProfilingRecord.Companion.getClock().instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"TaskProfilingRecord.clock.instant()");
        this.startTime = instant;
    }

    public final void executionFinished() {
        Instant instant = TaskProfilingRecord.Companion.getClock().instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"TaskProfilingRecord.clock.instant()");
        this.endTime = instant;
    }

    public final void fillSpanRecord(@NotNull GradleBuildProfileSpan.Builder span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Instant effectiveStartTime = this.isStarted() ? this.startTime : this.endTime;
        span.setThreadId(Thread.currentThread().getId()).setStartTimeInMs(effectiveStartTime.toEpochMilli()).setDurationInMs(this.duration().toMillis()).setType(this.type);
    }

    @NotNull
    public String toString() {
        return "Worker for " + this.taskName;
    }
}

