/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.SdkConstants;
import com.android.Version;
import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.options.StringOption;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven;", "", "aapt2Directory", "Lorg/gradle/api/file/FileCollection;", "version", "", "(Lorg/gradle/api/file/FileCollection;Ljava/lang/String;)V", "getAapt2Directory", "()Lorg/gradle/api/file/FileCollection;", "getVersion", "()Ljava/lang/String;", "Companion", "gradle-core"})
public final class Aapt2FromMaven {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCollection aapt2Directory;
    @NotNull
    private final String version;
    @NotNull
    private static final String TYPE_EXTRACTED_AAPT2_BINARY = "_internal-android-aapt2-binary";
    @NotNull
    private static final String PLATFORM_WINDOWS = "windows";
    @NotNull
    private static final String PLATFORM_LINUX = "linux";
    @NotNull
    private static final String PLATFORM_OSX = "osx";
    @NotNull
    private static final List<String> ACCEPTED_PLATFORMS;

    public Aapt2FromMaven(@NotNull FileCollection aapt2Directory2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)aapt2Directory2, (String)"aapt2Directory");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.aapt2Directory = aapt2Directory2;
        this.version = version;
    }

    @NotNull
    public final FileCollection getAapt2Directory() {
        return this.aapt2Directory;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @JvmStatic
    @NotNull
    public static final Aapt2FromMaven create(@NotNull Project project2, @NotNull Function1<? super StringOption, String> stringOption) {
        return Companion.create(project2, stringOption);
    }

    static {
        Object[] objectArray = new String[]{PLATFORM_WINDOWS, PLATFORM_OSX, PLATFORM_LINUX};
        ACCEPTED_PLATFORMS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2#\u0010\u000e\u001a\u001f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion;", "", "()V", "ACCEPTED_PLATFORMS", "", "", "PLATFORM_LINUX", "PLATFORM_OSX", "PLATFORM_WINDOWS", "TYPE_EXTRACTED_AAPT2_BINARY", "create", "Lcom/android/build/gradle/internal/res/Aapt2FromMaven;", "project", "Lorg/gradle/api/Project;", "stringOption", "Lkotlin/Function1;", "Lcom/android/build/gradle/options/StringOption;", "Lkotlin/ParameterName;", "name", "option", "Aapt2Extractor", "Aapt2Version", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Aapt2FromMaven create(@NotNull Project project2, @NotNull Function1<? super StringOption, String> stringOption) {
            String string;
            String overriddenPlatform;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(stringOption, (String)"stringOption");
            String string2 = (String)stringOption.invoke((Object)StringOption.AAPT2_FROM_MAVEN_OVERRIDE);
            String customAapt2 = string2 == null ? "" : string2;
            String string3 = (String)stringOption.invoke((Object)StringOption.AAPT2_FROM_MAVEN_VERSION_OVERRIDE);
            String overriddenVersion = string3 == null ? "" : string3;
            String defaultVersion = Version.ANDROID_GRADLE_PLUGIN_VERSION + "-" + Aapt2Version.INSTANCE.getBUILD_NUMBER();
            if (StringsKt.any((CharSequence)customAapt2) && StringsKt.any((CharSequence)overriddenVersion)) {
                String string4 = "You cannot specify both local and remote custom versions of AAPT2.\nPlease use either " + StringOption.AAPT2_FROM_MAVEN_OVERRIDE.getPropertyName() + " for setting a local path to the executable or " + StringOption.AAPT2_FROM_MAVEN_VERSION_OVERRIDE + " for specifying a Maven version (e.g. \"" + defaultVersion + "\").";
                throw new IllegalStateException(string4.toString());
            }
            if (StringsKt.any((CharSequence)customAapt2)) {
                Object object = SdkConstants.FN_AAPT2;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FN_AAPT2");
                if (!StringsKt.endsWith$default((String)customAapt2, (String)object, (boolean)false, (int)2, null)) {
                    object = "Custom AAPT2 location does not point to an AAPT2 executable: " + customAapt2;
                    throw new IllegalStateException(object.toString());
                }
                Object[] objectArray = new Object[]{new File(customAapt2).getParentFile()};
                object = project2.files(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.files(File(customAapt2).parentFile)");
                return new Aapt2FromMaven((FileCollection)object, customAapt2);
            }
            Object version = StringsKt.any((CharSequence)overriddenVersion) ? overriddenVersion : defaultVersion;
            String string5 = (String)stringOption.invoke((Object)StringOption.AAPT2_FROM_MAVEN_PLATFORM_OVERRIDE);
            String string6 = overriddenPlatform = string5 == null ? "" : string5;
            if (StringsKt.any((CharSequence)overriddenPlatform)) {
                if (!ACCEPTED_PLATFORMS.contains(overriddenPlatform)) {
                    String string7 = "Unknown platform '" + overriddenPlatform + "'";
                    throw new IllegalStateException(string7.toString());
                }
                string = overriddenPlatform;
            } else {
                int n = SdkConstants.currentPlatform();
                switch (n) {
                    case 2: {
                        string = Aapt2FromMaven.PLATFORM_WINDOWS;
                        break;
                    }
                    case 3: {
                        string = Aapt2FromMaven.PLATFORM_OSX;
                        break;
                    }
                    case 1: {
                        string = Aapt2FromMaven.PLATFORM_LINUX;
                        break;
                    }
                    default: {
                        String string8 = "Unknown platform '" + System.getProperty("os.name") + "'";
                        throw new IllegalStateException(string8.toString());
                    }
                }
            }
            String classifier = string;
            Dependency[] dependencyArray = new Dependency[1];
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.build"), TuplesKt.to((Object)"name", (Object)"aapt2"), TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"classifier", (Object)classifier)};
            dependencyArray[0] = project2.getDependencies().module((Object)MapsKt.mapOf((Pair[])pairArray));
            Configuration configuration = project2.getConfigurations().detachedConfiguration(dependencyArray);
            project2.getDependencies().registerTransform(Aapt2Extractor.class, new Action(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(TransformSpec<GenericTransformParameters> it) {
                    ((GenericTransformParameters)it.getParameters()).getProjectName().set((Object)this.$project.getName());
                    it.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                    it.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-android-aapt2-binary");
                }
            });
            FileCollection aapt2Directory2 = configuration.getIncoming().artifactView((Action)create.aapt2Directory.1.INSTANCE).getArtifacts().getArtifactFiles();
            Intrinsics.checkNotNullExpressionValue((Object)aapt2Directory2, (String)"aapt2Directory");
            return new Aapt2FromMaven(aapt2Directory2, (String)version);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion$Aapt2Version;", "", "()V", "BUILD_NUMBER", "", "getBUILD_NUMBER", "()Ljava/lang/String;", "BUILD_NUMBER$delegate", "Lkotlin/Lazy;", "gradle-core"})
        private static final class Aapt2Version {
            @NotNull
            public static final Aapt2Version INSTANCE = new Aapt2Version();
            @NotNull
            private static final Lazy BUILD_NUMBER$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)BUILD_NUMBER.2.INSTANCE);

            private Aapt2Version() {
            }

            @NotNull
            public final String getBUILD_NUMBER() {
                Lazy lazy = BUILD_NUMBER$delegate;
                Object var3_2 = null;
                Object object = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-BUILD_NUMBER>(...)");
                return (String)object;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/res/Aapt2FromMaven$Companion$Aapt2Extractor;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "gradle-core"})
        public static abstract class Aapt2Extractor
        implements TransformAction<GenericTransformParameters> {
            @PathSensitive(value=PathSensitivity.NAME_ONLY)
            @InputArtifact
            @NotNull
            public abstract Provider<FileSystemLocation> getInputArtifact();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transform(@NotNull TransformOutputs transformOutputs) {
                Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
                File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                Path outDir = transformOutputs.dir((Object)FilesKt.getNameWithoutExtension((File)input)).toPath();
                Files.createDirectories(outDir, new FileAttribute[0]);
                Object object = input;
                object = new FileInputStream((File)object);
                int n = 8192;
                object = new ZipInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
                Throwable throwable = null;
                try {
                    ZipEntry zipEntry;
                    ZipInputStream zipInputStream = (ZipInputStream)object;
                    boolean bl = false;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        ZipEntry entry = zipEntry;
                        if (entry.isDirectory()) continue;
                        Path destinationFile = outDir.resolve(entry.getName());
                        Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                        Closeable closeable = Files.newOutputStream(destinationFile, new OpenOption[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"newOutputStream(destinationFile)");
                        int n2 = 8192;
                        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n2);
                        Throwable throwable2 = null;
                        try {
                            BufferedOutputStream output2 = (BufferedOutputStream)closeable;
                            boolean bl2 = false;
                            long l = ByteStreams.copy((InputStream)zipInputStream, (OutputStream)output2);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        if (!Intrinsics.areEqual((Object)entry.getName(), (Object)SdkConstants.FN_AAPT2) || SdkConstants.CURRENT_PLATFORM != 1 && SdkConstants.CURRENT_PLATFORM != 3) continue;
                        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(destinationFile, new LinkOption[0]);
                        Files.setPosixFilePermissions(destinationFile, (Set)Sets.union(permissions, (Set)SetsKt.setOf((Object)((Object)PosixFilePermission.OWNER_EXECUTE))));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }
    }
}

