/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.transform.Format;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.InternalMultipleArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.R8ParallelBuildService;
import com.android.build.gradle.internal.tasks.D8BundleMainDexListTaskKt;
import com.android.build.gradle.internal.tasks.ProguardConfigurableTask;
import com.android.build.gradle.internal.tasks.R8Task;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.utils.IgnoreLibraryKeepRulesUtilsKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.ComponentType;
import com.android.builder.dexing.DexingType;
import com.android.builder.dexing.MainDexListConfig;
import com.android.builder.dexing.ProguardConfig;
import com.android.builder.dexing.ProguardOutputFiles;
import com.android.builder.dexing.R8OutputType;
import com.android.builder.dexing.R8Tool;
import com.android.builder.dexing.ToolConfig;
import com.android.ide.common.blame.MessageReceiver;
import com.android.utils.FileUtils;
import com.android.zipflinger.ZipArchive;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 V2\u00020\u0001:\u0003VWXB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010O\u001a\u00020PH\u0014J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u0002090RH\u0007J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u0002090RH\u0007J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u0002090RH\u0007J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u0002090RH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u0014\u0010)\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010R\u0014\u0010+\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\bR\u0014\u0010-\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0010R\u0014\u0010/\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\bR\u0014\u00101\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\fR\u0014\u00103\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0010R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0015R\u001a\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0015R\u0014\u0010;\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\fR\u0014\u0010=\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\fR\u0014\u0010?\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\bR\u0014\u0010A\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\fR,\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00130C2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130C8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\bR\u0014\u0010I\u001a\u00020J8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0015\u00a8\u0006Y"}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task;", "Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "baseDexDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBaseDexDir", "()Lorg/gradle/api/file/DirectoryProperty;", "baseJar", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseJar", "()Lorg/gradle/api/file/RegularFileProperty;", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "coreLibDesugarConfig", "Lorg/gradle/api/provider/Property;", "", "getCoreLibDesugarConfig", "()Lorg/gradle/api/provider/Property;", "debuggable", "", "getDebuggable", "<set-?>", "Lcom/android/builder/dexing/DexingType;", "dexingType", "getDexingType", "()Lcom/android/builder/dexing/DexingType;", "disableMinification", "getDisableMinification", "disableTreeShaking", "getDisableTreeShaking", "duplicateClassesCheck", "getDuplicateClassesCheck", "enableDesugaring", "getEnableDesugaring", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "featureClassJars", "getFeatureClassJars", "featureDexDir", "getFeatureDexDir", "featureJavaResourceJars", "getFeatureJavaResourceJars", "featureJavaResourceOutputDir", "getFeatureJavaResourceOutputDir", "mainDexListOutput", "getMainDexListOutput", "mainDexRulesFiles", "getMainDexRulesFiles", "minSdkVersion", "", "getMinSdkVersion", "multiDexKeepFile", "Ljava/io/File;", "getMultiDexKeepFile", "multiDexKeepProguard", "getMultiDexKeepProguard", "outputClasses", "getOutputClasses", "outputDex", "getOutputDex", "outputResources", "getOutputResources", "", "proguardConfigurations", "getProguardConfigurations", "()Ljava/util/List;", "projectOutputKeepRules", "getProjectOutputKeepRules", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "getProviderFactory", "()Lorg/gradle/api/provider/ProviderFactory;", "useFullR8", "getUseFullR8", "doTaskAction", "", "getMissingKeepRulesOutput", "Lorg/gradle/api/provider/Provider;", "getProguardConfigurationOutput", "getProguardSeedsOutput", "getProguardUsageOutput", "Companion", "CreationAction", "R8Runnable", "gradle-core"})
public abstract class R8Task
extends ProguardConfigurableTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<String> proguardConfigurations;
    private DexingType dexingType;

    @Inject
    public R8Task(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        super(projectLayout);
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableDesugaring();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract Property<File> getMultiDexKeepFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getMultiDexKeepProguard();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getMainDexRulesFiles();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @Internal
    @NotNull
    public abstract Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();

    @Input
    @NotNull
    public abstract Property<Integer> getMinSdkVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getDebuggable();

    @Input
    @NotNull
    public abstract Property<Boolean> getDisableTreeShaking();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getDuplicateClassesCheck();

    @Input
    @NotNull
    public abstract Property<Boolean> getDisableMinification();

    @Input
    @NotNull
    public final List<String> getProguardConfigurations() {
        List<String> list = this.proguardConfigurations;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"proguardConfigurations");
        return null;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getUseFullR8();

    @Input
    @NotNull
    public final DexingType getDexingType() {
        DexingType dexingType = this.dexingType;
        if (dexingType != null) {
            return dexingType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dexingType");
        return null;
    }

    @Optional
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getFeatureClassJars();

    @Optional
    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getFeatureJavaResourceJars();

    @Optional
    @Classpath
    @NotNull
    public abstract RegularFileProperty getBaseJar();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCoreLibDesugarConfig();

    @Optional
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputClasses();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDex();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getProjectOutputKeepRules();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getBaseDexDir();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFeatureDexDir();

    @Optional
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFeatureJavaResourceOutputDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputResources();

    @OutputFile
    @NotNull
    public final Provider<File> getProguardSeedsOutput() {
        Provider provider2 = this.getMappingFile().flatMap(new Transformer(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider(new Callable(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"seeds.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getP\u2026eds.txt\") }\n            }");
        return provider2;
    }

    @OutputFile
    @NotNull
    public final Provider<File> getProguardUsageOutput() {
        Provider provider2 = this.getMappingFile().flatMap(new Transformer(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider(new Callable(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"usage.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getP\u2026age.txt\") }\n            }");
        return provider2;
    }

    @OutputFile
    @NotNull
    public final Provider<File> getProguardConfigurationOutput() {
        Provider provider2 = this.getMappingFile().flatMap(new Transformer(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider(new Callable(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"configuration.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getP\u2026ion.txt\") }\n            }");
        return provider2;
    }

    @OutputFile
    @NotNull
    public final Provider<File> getMissingKeepRulesOutput() {
        Provider provider2 = this.getMappingFile().flatMap(new Transformer(this){
            final /* synthetic */ R8Task this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends File> transform(RegularFile it) {
                return this.this$0.getProviderFactory().provider(new Callable(it){
                    final /* synthetic */ RegularFile $it;
                    {
                        this.$it = $it;
                    }

                    public final File call() {
                        File file = this.$it.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                        return FilesKt.resolveSibling((File)file, (String)"missing_rules.txt");
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"@OutputFile\n    fun getM\u2026les.txt\") }\n            }");
        return provider2;
    }

    @Optional
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getMainDexListOutput();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviderFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        Property property;
        Object object = (ComponentType)this.getComponentType().getOrNull();
        if (object == null ? false : object.isAar()) {
            property = (Property)this.getOutputClasses();
        } else {
            object = this.getIncludeFeaturesInScopes().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeFeaturesInScopes.get()");
            property = (Boolean)object != false ? (Property)this.getBaseDexDir() : (Property)this.getOutputDex();
        }
        Property output2 = property;
        List featureJavaResourceJarsList = CollectionsKt.toList((Iterable)((Iterable)this.getFeatureJavaResourceJars()));
        Collection collection = featureJavaResourceJarsList;
        if (!collection.isEmpty()) {
            Set paths = new LinkedHashSet();
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((Iterable)this.getResources())), (Iterable)featureJavaResourceJarsList);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                Closeable closeable = (Closeable)new ZipArchive(file.toPath());
                Throwable throwable = null;
                try {
                    ZipArchive jar = (ZipArchive)closeable;
                    boolean bl2 = false;
                    List list = jar.listEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jar.listEntries()");
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String path = (String)element$iv2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                        if (StringsKt.startsWith$default((String)path, (String)"META-INF/services/", (boolean)false, (int)2, null) || paths.add(path)) continue;
                        throw new RuntimeException("Multiple dynamic-feature and/or base APKs will contain entries with the same path, '" + path + "', which can cause unexpected behavior or errors at runtime. Please consider using android.packagingOptions in the dynamic-feature and/or application modules to ensure that only one of the APKs contains this path.");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(R8Task.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(R8Task::class.java)");
        LoggerWrapper logger = loggerWrapper;
        logger.info(StringsKt.trimMargin$default((String)("\n                |R8 is a new Android code shrinker. If you experience any issues, please file a bug at\n                |https://issuetracker.google.com, using 'Shrinker (R8)' as component name.\n                |Current version is: " + R8Tool.getR8Version() + ".\n                |"), null, (int)1, null), new Object[0]);
        this.getWorkerExecutor().noIsolation().submit(R8Runnable.class, new Action(this, (Property<? extends FileSystemLocation>)output2, featureJavaResourceJarsList){
            final /* synthetic */ R8Task this$0;
            final /* synthetic */ Property<? extends FileSystemLocation> $output;
            final /* synthetic */ List<File> $featureJavaResourceJarsList;
            {
                this.this$0 = $receiver;
                this.$output = $output;
                this.$featureJavaResourceJarsList = $featureJavaResourceJarsList;
            }

            public final void execute(R8Runnable.Params it) {
                List it2;
                Object object;
                it.initializeFromAndroidVariantTask(this.this$0);
                Object[] objectArray = new Object[]{CollectionsKt.toList((Iterable)((Iterable)this.this$0.getBootClasspath()))};
                it.getBootClasspath().from(objectArray);
                it.getMinSdkVersion().set(this.this$0.getMinSdkVersion().get());
                it.getDebuggable().set(this.this$0.getDebuggable().get());
                it.getDisableTreeShaking().set(this.this$0.getDisableTreeShaking().get());
                it.getEnableDesugaring().set(this.this$0.getEnableDesugaring().get());
                it.getDisableMinification().set(this.this$0.getDisableMinification().get());
                objectArray = new Object[1];
                Object object2 = new ArrayList<E>();
                R8Task r8Task = this.this$0;
                List list = object2;
                int n = 0;
                Object[] objectArray2 = objectArray;
                ConfigurableFileCollection configurableFileCollection = it.getMainDexListFiles();
                boolean bl = false;
                if (r8Task.getMultiDexKeepFile().isPresent()) {
                    object = r8Task.getMultiDexKeepFile().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"multiDexKeepFile.get()");
                    it2.add(object);
                }
                Unit unit = Unit.INSTANCE;
                objectArray2[n] = object2;
                configurableFileCollection.from(objectArray);
                objectArray = new Object[1];
                object2 = new ArrayList<E>();
                r8Task = this.this$0;
                it2 = object2;
                n = 0;
                objectArray2 = objectArray;
                configurableFileCollection = it.getMainDexRulesFiles();
                boolean bl2 = false;
                it2.addAll(CollectionsKt.toList((Iterable)((Iterable)r8Task.getMainDexRulesFiles())));
                if (r8Task.getMultiDexKeepProguard().isPresent()) {
                    object = ((RegularFile)r8Task.getMultiDexKeepProguard().get()).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"multiDexKeepProguard.get().asFile");
                    it2.add(object);
                }
                unit = Unit.INSTANCE;
                objectArray2[n] = object2;
                configurableFileCollection.from(objectArray);
                objectArray = (Object[])this.this$0.getMainDexListOutput().getOrNull();
                it.getMainDexListOutput().set(objectArray == null ? null : objectArray.getAsFile());
                ConfigurableFileCollection configurableFileCollection2 = it.getProguardConfigurationFiles();
                objectArray = new Object[1];
                object2 = this.this$0.getIgnoredLibraryKeepRules().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ignoredLibraryKeepRules.get()");
                Set set = (Set)object2;
                object2 = this.this$0.getIgnoreAllLibraryKeepRules().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ignoreAllLibraryKeepRules.get()");
                boolean bl3 = (Boolean)object2;
                ArtifactCollection artifactCollection = this.this$0.getLibraryKeepRules();
                ConfigurableFileCollection configurableFileCollection3 = this.this$0.getConfigurationFiles();
                object2 = LoggerWrapper.getLogger(R8Task.class);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getLogger(R8Task::class.java)");
                objectArray[0] = this.this$0.reconcileDefaultProguardFile$gradle_core(IgnoreLibraryKeepRulesUtilsKt.getFilteredConfigurationFiles(set, bl3, artifactCollection, configurableFileCollection3, (LoggerWrapper)object2), (Provider<Directory>)((Provider)this.this$0.getExtractedDefaultProguardFile()));
                configurableFileCollection2.from(objectArray);
                it.getInputProguardMapping().set(this.this$0.getTestedMappingFile().isEmpty() ? (File)null : this.this$0.getTestedMappingFile().getSingleFile());
                it.getProguardConfigurations().set((Iterable)this.this$0.getProguardConfigurations());
                objectArray = (Object[])this.this$0.getComponentType().getOrNull();
                it.getAar().set((Object)(objectArray == null ? false : objectArray.isAar()));
                it.getDexingType().set((Object)this.this$0.getDexingType());
                it.getUseFullR8().set(this.this$0.getUseFullR8().get());
                ConfigurableFileCollection configurableFileCollection4 = it.getReferencedInputs();
                objectArray = new Object[1];
                object2 = this.this$0.getReferencedClasses().plus((FileCollection)this.this$0.getReferencedResources());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"referencedClasses + referencedResources");
                objectArray[0] = CollectionsKt.toList((Iterable)((Iterable)object2));
                configurableFileCollection4.from(objectArray);
                ConfigurableFileCollection configurableFileCollection5 = it.getClasses();
                objectArray = new Object[1];
                object2 = this.this$0.getIncludeFeaturesInScopes().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"includeFeaturesInScopes.get()");
                objectArray[0] = (Boolean)object2 != false ? CollectionsKt.listOf((Object)((RegularFile)this.this$0.getBaseJar().get()).getAsFile()) : CollectionsKt.toList((Iterable)((Iterable)this.this$0.getClasses()));
                configurableFileCollection5.from(objectArray);
                objectArray = new Object[]{CollectionsKt.toList((Iterable)((Iterable)this.this$0.getResources()))};
                it.getResources().from(objectArray);
                it.getMappingFile().set(((RegularFile)this.this$0.getMappingFile().get()).getAsFile());
                it.getProguardSeedsOutput().set((File)this.this$0.getProguardSeedsOutput().get());
                it.getProguardUsageOutput().set((File)this.this$0.getProguardUsageOutput().get());
                it.getProguardConfigurationOutput().set((File)this.this$0.getProguardConfigurationOutput().get());
                it.getMissingKeepRulesOutput().set((File)this.this$0.getMissingKeepRulesOutput().get());
                it.getOutput().set(((FileSystemLocation)this.$output.get()).getAsFile());
                it.getOutputResources().set(((RegularFile)this.this$0.getOutputResources().get()).getAsFile());
                objectArray = new Object[]{CollectionsKt.toList((Iterable)((Iterable)this.this$0.getFeatureClassJars()))};
                it.getFeatureClassJars().from(objectArray);
                objectArray = new Object[]{this.$featureJavaResourceJarsList};
                it.getFeatureJavaResourceJars().from(objectArray);
                it.getFeatureDexDir().set((File)this.this$0.getFeatureDexDir().getAsFile().getOrNull());
                it.getFeatureJavaResourceOutputDir().set((File)this.this$0.getFeatureJavaResourceOutputDir().getAsFile().getOrNull());
                it.getLibConfiguration().set(this.this$0.getCoreLibDesugarConfig().getOrNull());
                it.getOutputKeepRulesDir().set((File)this.this$0.getProjectOutputKeepRules().getAsFile().getOrNull());
                it.getErrorFormatMode().set(this.this$0.getErrorFormatMode().get());
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\fH\u0014J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\fH\u0014J\b\u0010\u001d\u001a\u00020\u0016H\u0014J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0002R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task$CreationAction;", "Lcom/android/build/gradle/internal/tasks/ProguardConfigurableTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/R8Task;", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "creationConfig", "isTestApplication", "", "addCompileRClass", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;ZZ)V", "disableMinification", "disableTreeShaking", "name", "", "getName", "()Ljava/lang/String;", "proguardConfigurations", "", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "dontWarn", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "keep", "keepAttributes", "setActions", "actions", "Lcom/android/build/gradle/internal/PostprocessingFeatures;", "setBootClasspathForCodeShrinker", "gradle-core"})
    public static final class CreationAction
    extends ProguardConfigurableTask.CreationAction<R8Task, ConsumableCreationConfig> {
        @NotNull
        private final Class<R8Task> type;
        @NotNull
        private final String name;
        private boolean disableTreeShaking;
        private boolean disableMinification;
        @NotNull
        private final List<String> proguardConfigurations;

        public CreationAction(@NotNull ConsumableCreationConfig creationConfig, boolean isTestApplication, boolean addCompileRClass) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, isTestApplication, addCompileRClass);
            this.type = R8Task.class;
            this.name = this.computeTaskName("minify", "WithR8");
            this.proguardConfigurations = new ArrayList();
        }

        public /* synthetic */ CreationAction(ConsumableCreationConfig consumableCreationConfig, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(consumableCreationConfig, bl, bl2);
        }

        @Override
        @NotNull
        public Class<R8Task> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<R8Task> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            if (this.getComponentType().isAar()) {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("shrunkClasses.jar").on(InternalArtifactType.SHRUNK_CLASSES.INSTANCE);
            } else if (((ConsumableCreationConfig)this.creationConfig).getVariantScope().consumesFeatureJars()) {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).on(InternalArtifactType.BASE_DEX.INSTANCE);
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.3.INSTANCE).on(InternalArtifactType.FEATURE_DEX.INSTANCE);
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.4.INSTANCE).on(InternalArtifactType.FEATURE_SHRUNK_JAVA_RES.INSTANCE);
                if (((ConsumableCreationConfig)this.creationConfig).getNeedsShrinkDesugarLibrary()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.5.INSTANCE).on(InternalArtifactType.DESUGAR_LIB_PROJECT_KEEP_RULES.INSTANCE);
                }
            } else {
                ((ConsumableCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWith((Function1)handleProvider.6.INSTANCE).toAppendTo((Artifact.Multiple)InternalMultipleArtifactType.DEX.INSTANCE);
                if (((ConsumableCreationConfig)this.creationConfig).getNeedsShrinkDesugarLibrary()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.7.INSTANCE).on(InternalArtifactType.DESUGAR_LIB_PROJECT_KEEP_RULES.INSTANCE);
                }
            }
            ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.8.INSTANCE).withName("shrunkJavaRes.jar").on(InternalArtifactType.SHRUNK_JAVA_RES.INSTANCE);
            if (this.creationConfig instanceof ApkCreationConfig) {
                if (((ConsumableCreationConfig)this.creationConfig).getNeedsMainDexListForBundle()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.9.INSTANCE).withName("mainDexList.txt").on(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE.INSTANCE);
                } else if (((ConsumableCreationConfig)this.creationConfig).getDexingType().getNeedsMainDexList()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.10.INSTANCE).withName("mainDexList.txt").on(InternalArtifactType.LEGACY_MULTIDEX_MAIN_DEX_LIST.INSTANCE);
                }
            }
        }

        @Override
        public void configure(@NotNull R8Task task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((ProguardConfigurableTask)task);
            ArtifactsImpl artifacts = ((ConsumableCreationConfig)this.creationConfig).getArtifacts();
            BuildServiceRegistry buildServiceRegistry$iv = ((ConsumableCreationConfig)this.creationConfig).getServices().getBuildServiceRegistry();
            boolean $i$f$getBuildService = false;
            Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(R8ParallelBuildService.class));
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
            }
            Provider provider2 = ((BuildServiceRegistration)object).getService();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
            Provider r8Service = provider2;
            task.usesService(r8Service);
            task.getEnableDesugaring().set((Object)(((ConsumableCreationConfig)this.creationConfig).getJava8LangSupportType() == VariantScope.Java8LangSupport.R8 && !this.getComponentType().isAar() ? 1 : 0));
            this.setBootClasspathForCodeShrinker(task);
            task.getMinSdkVersion().set((Object)((ConsumableCreationConfig)this.creationConfig).getMinSdkVersionForDexing().getApiLevel());
            HasConfigurableValuesKt.setDisallowChanges(task.getDebuggable(), ((ConsumableCreationConfig)this.creationConfig).getDebuggable());
            task.getDisableTreeShaking().set((Object)this.disableTreeShaking);
            task.getDisableMinification().set((Object)this.disableMinification);
            task.getErrorFormatMode().set((Object)SyncOptions.getErrorFormatMode(((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions()));
            task.dexingType = ((ConsumableCreationConfig)this.creationConfig).getDexingType();
            HasConfigurableValuesKt.setDisallowChanges(task.getUseFullR8(), ((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.FULL_R8));
            if (!((ConsumableCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.R8_FAIL_ON_MISSING_CLASSES)) {
                this.proguardConfigurations.add("-ignorewarnings");
            }
            task.proguardConfigurations = this.proguardConfigurations;
            if (this.getComponentType().isApk()) {
                Object[] objectArray = new Object[]{artifacts.get(InternalArtifactType.DUPLICATE_CLASSES_CHECK.INSTANCE)};
                task.getDuplicateClassesCheck().from(objectArray);
                objectArray = new Object[]{artifacts.getAll((MultipleArtifact)MultipleArtifact.MULTIDEX_KEEP_PROGUARD.INSTANCE)};
                task.getMainDexRulesFiles().from(objectArray);
                if (((ConsumableCreationConfig)this.creationConfig).getDexingType().getNeedsMainDexList() && !((ConsumableCreationConfig)this.creationConfig).getGlobal().getNamespacedAndroidResources()) {
                    objectArray = new Object[]{artifacts.get(InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES.INSTANCE)};
                    task.getMainDexRulesFiles().from(objectArray);
                }
                if (this.creationConfig instanceof ApkCreationConfig) {
                    HasConfigurableValuesKt.setDisallowChanges(task.getMultiDexKeepFile(), ((ApkCreationConfig)this.creationConfig).getMultiDexKeepFile());
                }
                if (((ConsumableCreationConfig)this.creationConfig).getVariantScope().consumesFeatureJars()) {
                    ((ConsumableCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MODULE_AND_RUNTIME_DEPS_CLASSES.INSTANCE, (Property)task.getBaseJar());
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ConsumableCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_CLASSES, null, 8, null)};
                    task.getFeatureClassJars().from(objectArray);
                    objectArray = new Object[]{VariantDependencies.getArtifactFileCollection$default(((ConsumableCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_JAVA_RES, null, 8, null)};
                    task.getFeatureJavaResourceJars().from(objectArray);
                }
                if (((ConsumableCreationConfig)this.creationConfig).isCoreLibraryDesugaringEnabled()) {
                    task.getCoreLibDesugarConfig().set(DesugarLibUtils.getDesugarLibConfig(((ConsumableCreationConfig)this.creationConfig).getServices()));
                }
            }
            task.getBaseJar().disallowChanges();
            task.getFeatureClassJars().disallowChanges();
            task.getFeatureJavaResourceJars().disallowChanges();
        }

        @Override
        protected void keep(@NotNull String keep) {
            Intrinsics.checkNotNullParameter((Object)keep, (String)"keep");
            this.proguardConfigurations.add("-keep " + keep);
        }

        @Override
        protected void keepAttributes() {
            this.proguardConfigurations.add("-keepattributes *");
        }

        @Override
        protected void dontWarn(@NotNull String dontWarn) {
            Intrinsics.checkNotNullParameter((Object)dontWarn, (String)"dontWarn");
            this.proguardConfigurations.add("-dontwarn " + dontWarn);
        }

        @Override
        protected void setActions(@NotNull PostprocessingFeatures actions) {
            Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
            this.disableTreeShaking = !actions.isRemoveUnusedCode();
            boolean bl = this.disableMinification = !actions.isObfuscate();
            if (!actions.isOptimize()) {
                this.proguardConfigurations.add("-dontoptimize");
            }
        }

        private final void setBootClasspathForCodeShrinker(R8Task task) {
            JavaVersion javaTarget = ((ConsumableCreationConfig)this.creationConfig).getGlobal().getCompileOptions().getTargetCompatibility();
            Object[] objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getGlobal().getFullBootClasspath()};
            task.getBootClasspath().from(objectArray);
            if (javaTarget.isJava9Compatible()) {
                objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getGlobal().getVersionedSdkLoader().flatMap((Transformer)setBootClasspathForCodeShrinker.1.INSTANCE)};
                task.getBootClasspath().from(objectArray);
            } else if (javaTarget.isJava8Compatible()) {
                objectArray = new Object[]{((ConsumableCreationConfig)this.creationConfig).getGlobal().getVersionedSdkLoader().flatMap((Transformer)setBootClasspathForCodeShrinker.2.INSTANCE)};
                task.getBootClasspath().from(objectArray);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u00ce\u0002\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\b\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u00072\b\u0010/\u001a\u0004\u0018\u00010\"2\b\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u00101\u001a\u000202\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task$Companion;", "", "()V", "filterMissingFiles", "", "Ljava/nio/file/Path;", "files", "Ljava/io/File;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "shrink", "", "bootClasspath", "minSdkVersion", "", "isDebuggable", "", "enableDesugaring", "disableTreeShaking", "disableMinification", "mainDexListFiles", "mainDexRulesFiles", "mainDexListOutput", "dexingType", "Lcom/android/builder/dexing/DexingType;", "useFullR8", "referencedInputs", "classes", "resources", "proguardConfigurationFiles", "", "inputProguardMapping", "proguardConfigurations", "", "", "isAar", "mappingFile", "proguardSeedsOutput", "proguardUsageOutput", "proguardConfigurationOutput", "missingKeepRulesOutput", "output", "outputResources", "featureClassJars", "featureJavaResourceJars", "featureDexDir", "featureJavaResourceOutputDir", "libConfiguration", "outputKeepRulesDir", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void shrink(@NotNull List<? extends File> bootClasspath2, int minSdkVersion2, boolean isDebuggable, boolean enableDesugaring, boolean disableTreeShaking, boolean disableMinification, @NotNull List<? extends File> mainDexListFiles, @NotNull List<? extends File> mainDexRulesFiles, @Nullable File mainDexListOutput, @NotNull DexingType dexingType, boolean useFullR8, @NotNull List<? extends File> referencedInputs, @NotNull List<? extends File> classes, @NotNull List<? extends File> resources, @NotNull Collection<? extends File> proguardConfigurationFiles, @Nullable File inputProguardMapping, @NotNull List<String> proguardConfigurations, boolean isAar, @NotNull File mappingFile, @NotNull File proguardSeedsOutput, @NotNull File proguardUsageOutput, @NotNull File proguardConfigurationOutput, @NotNull File missingKeepRulesOutput, @NotNull File output2, @NotNull File outputResources, @NotNull List<? extends File> featureClassJars, @NotNull List<? extends File> featureJavaResourceJars, @Nullable File featureDexDir, @Nullable File featureJavaResourceOutputDir, @Nullable String libConfiguration, @Nullable File outputKeepRulesDir, @NotNull SyncOptions.ErrorFormatMode errorFormatMode) {
            Iterable<Path> iterable;
            Collection<Path> collection;
            Iterable<Path> iterable2;
            File it;
            Object $this$mapTo$iv$iv;
            Object $this$map$iv;
            MainDexListConfig mainDexListConfig;
            Iterable<Path> iterable3;
            Object $this$mapTo$iv$iv2;
            Object object;
            Collection<Path> collection2;
            void $this$mapTo$iv$iv3;
            Object it2;
            Intrinsics.checkNotNullParameter(bootClasspath2, (String)"bootClasspath");
            Intrinsics.checkNotNullParameter(mainDexListFiles, (String)"mainDexListFiles");
            Intrinsics.checkNotNullParameter(mainDexRulesFiles, (String)"mainDexRulesFiles");
            Intrinsics.checkNotNullParameter((Object)dexingType, (String)"dexingType");
            Intrinsics.checkNotNullParameter(referencedInputs, (String)"referencedInputs");
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(resources, (String)"resources");
            Intrinsics.checkNotNullParameter(proguardConfigurationFiles, (String)"proguardConfigurationFiles");
            Intrinsics.checkNotNullParameter(proguardConfigurations, (String)"proguardConfigurations");
            Intrinsics.checkNotNullParameter((Object)mappingFile, (String)"mappingFile");
            Intrinsics.checkNotNullParameter((Object)proguardSeedsOutput, (String)"proguardSeedsOutput");
            Intrinsics.checkNotNullParameter((Object)proguardUsageOutput, (String)"proguardUsageOutput");
            Intrinsics.checkNotNullParameter((Object)proguardConfigurationOutput, (String)"proguardConfigurationOutput");
            Intrinsics.checkNotNullParameter((Object)missingKeepRulesOutput, (String)"missingKeepRulesOutput");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter((Object)outputResources, (String)"outputResources");
            Intrinsics.checkNotNullParameter(featureClassJars, (String)"featureClassJars");
            Intrinsics.checkNotNullParameter(featureJavaResourceJars, (String)"featureJavaResourceJars");
            Intrinsics.checkNotNullParameter((Object)((Object)errorFormatMode), (String)"errorFormatMode");
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(R8ParallelBuildService.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(R8ParallelBuildService::class.java)");
            LoggerWrapper logger = loggerWrapper;
            R8OutputType r8OutputType = null;
            Format outputFormat = null;
            if (isAar) {
                r8OutputType = R8OutputType.CLASSES;
                outputFormat = Format.JAR;
            } else {
                r8OutputType = R8OutputType.DEX;
                outputFormat = Format.DIRECTORY;
            }
            FileUtils.deleteIfExists((File)outputResources);
            Format format = outputFormat;
            int n = WhenMappings.$EnumSwitchMapping$0[format.ordinal()];
            switch (n) {
                case 1: {
                    Unit unit;
                    Unit unit2;
                    File file;
                    Unit unit3;
                    FileUtils.cleanOutputDir((File)output2);
                    File file2 = featureDexDir;
                    if (file2 == null) {
                        unit3 = null;
                    } else {
                        file = file2;
                        it2 = file;
                        boolean bl = false;
                        FileUtils.cleanOutputDir((File)it2);
                        unit3 = Unit.INSTANCE;
                    }
                    file2 = featureJavaResourceOutputDir;
                    if (file2 == null) {
                        unit2 = null;
                    } else {
                        file = file2;
                        it2 = file;
                        boolean bl = false;
                        FileUtils.cleanOutputDir((File)it2);
                        unit2 = Unit.INSTANCE;
                    }
                    file2 = outputKeepRulesDir;
                    if (file2 == null) {
                        unit = null;
                        break;
                    }
                    file = file2;
                    it2 = file;
                    boolean bl = false;
                    FileUtils.cleanOutputDir((File)it2);
                    unit = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    FileUtils.deleteIfExists((File)output2);
                }
            }
            Path path = mappingFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"mappingFile.toPath()");
            Path path2 = path;
            path = proguardSeedsOutput.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"proguardSeedsOutput.toPath()");
            Path path3 = path;
            path = proguardUsageOutput.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"proguardUsageOutput.toPath()");
            Path path4 = path;
            path = proguardConfigurationOutput.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"proguardConfigurationOutput.toPath()");
            Path path5 = path;
            path = missingKeepRulesOutput.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"missingKeepRulesOutput.toPath()");
            ProguardOutputFiles proguardOutputFiles = new ProguardOutputFiles(path2, path3, path4, path5, path);
            Object $this$map$iv2 = proguardConfigurationFiles;
            boolean $i$f$map = false;
            it2 = $this$map$iv2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it3;
                File file = (File)item$iv$iv2;
                collection2 = destination$iv$iv;
                boolean bl = false;
                object = it3.toPath();
                collection2.add((Path)object);
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv2 = inputProguardMapping;
            Path path6 = $this$map$iv2 == null ? null : ((File)$this$map$iv2).toPath();
            ProguardOutputFiles proguardOutputFiles2 = proguardOutputFiles;
            List<String> list = proguardConfigurations;
            Path path7 = path6;
            List list2 = collection2;
            ProguardConfig proguardConfig = new ProguardConfig(list2, path7, list, proguardOutputFiles2);
            if (dexingType == DexingType.LEGACY_MULTIDEX) {
                Object item$iv$iv;
                Object item$iv$iv2;
                Object $this$map$iv3 = mainDexRulesFiles;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv3;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo2 = false;
                item$iv$iv2 = $this$mapTo$iv$iv2.iterator();
                while (item$iv$iv2.hasNext()) {
                    void it4;
                    item$iv$iv = item$iv$iv2.next();
                    File bl = (File)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    object = it4.toPath();
                    collection2.add((Path)object);
                }
                collection2 = (List)destination$iv$iv2;
                $this$map$iv3 = mainDexListFiles;
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv3;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                $i$f$mapTo2 = false;
                item$iv$iv2 = $this$mapTo$iv$iv2.iterator();
                while (item$iv$iv2.hasNext()) {
                    item$iv$iv = item$iv$iv2.next();
                    File it4 = (File)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    iterable3 = it4.toPath();
                    object.add(iterable3);
                }
                object = (List)destination$iv$iv2;
                $this$map$iv3 = mainDexListOutput;
                Path path8 = $this$map$iv3 == null ? null : ((File)$this$map$iv3).toPath();
                List<String> list3 = D8BundleMainDexListTaskKt.getPlatformRules();
                Collection collection3 = (Collection)object;
                Collection<Path> collection4 = collection2;
                mainDexListConfig = new MainDexListConfig(collection4, collection3, list3, path8);
            } else {
                mainDexListConfig = new MainDexListConfig(null, null, null, null, 15, null);
            }
            MainDexListConfig mainDexListConfig2 = mainDexListConfig;
            ToolConfig toolConfig = new ToolConfig(minSdkVersion2, isDebuggable, disableTreeShaking, !enableDesugaring, disableMinification, r8OutputType);
            $this$mapTo$iv$iv2 = outputKeepRulesDir;
            File outputKeepRulesFile = $this$mapTo$iv$iv2 == null ? null : FilesKt.resolve((File)$this$mapTo$iv$iv2, (String)"output");
            Collection collection5 = this.filterMissingFiles(classes, logger);
            $this$mapTo$iv$iv2 = output2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv2, (String)"output.toPath()");
            Object object2 = $this$mapTo$iv$iv2;
            Collection collection6 = this.filterMissingFiles(resources, logger);
            $this$mapTo$iv$iv2 = outputResources.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv2, (String)"outputResources.toPath()");
            Object object3 = $this$mapTo$iv$iv2;
            $this$mapTo$iv$iv2 = bootClasspath2;
            object = object3;
            collection2 = collection6;
            Object object4 = object2;
            Collection collection7 = collection5;
            boolean $i$f$map3 = false;
            void $i$f$mapTo3 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                File file = (File)item$iv$iv;
                iterable3 = destination$iv$iv3;
                boolean bl = false;
                iterable2 = it.toPath();
                iterable3.add(iterable2);
            }
            iterable3 = (List)destination$iv$iv3;
            Collection collection8 = (Collection)iterable3;
            Collection collection9 = this.filterMissingFiles(referencedInputs, logger);
            $this$map$iv = Logging.getLogger(R8Runnable.class);
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"getLogger(R8Runnable::class.java)");
            MessageReceiverImpl messageReceiverImpl = new MessageReceiverImpl(errorFormatMode, (Logger)$this$map$iv);
            $this$map$iv = featureClassJars;
            boolean bl = useFullR8;
            MessageReceiver messageReceiver = messageReceiverImpl;
            MainDexListConfig mainDexListConfig3 = mainDexListConfig2;
            ProguardConfig proguardConfig2 = proguardConfig;
            ToolConfig toolConfig2 = toolConfig;
            iterable2 = collection9;
            iterable3 = collection8;
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo4 = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it = (File)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                iterable = it.toPath();
                collection.add((Path)iterable);
            }
            collection = (List)destination$iv$iv3;
            $this$map$iv = featureJavaResourceJars;
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo4 = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                it = (File)item$iv$iv;
                iterable = destination$iv$iv3;
                boolean bl4 = false;
                Path path9 = it.toPath();
                iterable.add(path9);
            }
            iterable = (List)destination$iv$iv3;
            File file = featureDexDir;
            Path path10 = file == null ? null : file.toPath();
            file = featureJavaResourceOutputDir;
            Path path11 = file == null ? null : file.toPath();
            file = outputKeepRulesFile;
            R8Tool.runR8((Collection)collection7, (Path)object4, collection2, (Path)object, iterable3, (Collection)iterable2, (ToolConfig)toolConfig2, (ProguardConfig)proguardConfig2, (MainDexListConfig)mainDexListConfig3, (MessageReceiver)messageReceiver, (boolean)bl, collection, (Collection)((Collection)iterable), (Path)path10, (Path)path11, (String)libConfiguration, (Path)(file == null ? null : file.toPath()));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Path> filterMissingFiles(List<? extends File> files2, LoggerWrapper logger) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = files2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Path path;
                Path path2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                File file = (File)element$iv$iv;
                boolean bl2 = false;
                if (file.exists()) {
                    path2 = file.toPath();
                } else {
                    logger.verbose(file + " is ignored as it does not exist.", new Object[0]);
                    path2 = null;
                }
                if (path2 == null) continue;
                Path it$iv$iv = path = path2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Format.values().length];
                nArray[Format.DIRECTORY.ordinal()] = 1;
                nArray[Format.JAR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task$R8Runnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/R8Task$R8Runnable$Params;", "()V", "run", "", "Params", "gradle-core"})
    public static abstract class R8Runnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            Object object = ((Params)this.getParameters()).getBootClasspath().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.bootClasspath.files");
            List list = CollectionsKt.toList((Iterable)((Iterable)object));
            object = ((Params)this.getParameters()).getMinSdkVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.minSdkVersion.get()");
            int n = ((Number)object).intValue();
            object = ((Params)this.getParameters()).getDebuggable().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.debuggable.get()");
            boolean bl = (Boolean)object;
            object = ((Params)this.getParameters()).getEnableDesugaring().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.enableDesugaring.get()");
            boolean bl2 = (Boolean)object;
            object = ((Params)this.getParameters()).getDisableTreeShaking().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.disableTreeShaking.get()");
            boolean bl3 = (Boolean)object;
            object = ((Params)this.getParameters()).getDisableMinification().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.disableMinification.get()");
            boolean bl4 = (Boolean)object;
            object = ((Params)this.getParameters()).getMainDexListFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.mainDexListFiles.files");
            List list2 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = ((Params)this.getParameters()).getMainDexRulesFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.mainDexRulesFiles.files");
            List list3 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = (RegularFile)((Params)this.getParameters()).getMainDexListOutput().getOrNull();
            File file = object == null ? null : object.getAsFile();
            object = ((Params)this.getParameters()).getDexingType().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.dexingType.get()");
            DexingType dexingType = (DexingType)object;
            object = ((Params)this.getParameters()).getUseFullR8().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.useFullR8.get()");
            boolean bl5 = (Boolean)object;
            object = ((Params)this.getParameters()).getReferencedInputs().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.referencedInputs.files");
            List list4 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = ((Params)this.getParameters()).getClasses().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.classes.files");
            List list5 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = ((Params)this.getParameters()).getResources().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.resources.files");
            List list6 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = ((Params)this.getParameters()).getProguardConfigurationFiles().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.proguardConfigurationFiles.files");
            Collection collection = CollectionsKt.toList((Iterable)((Iterable)object));
            object = (RegularFile)((Params)this.getParameters()).getInputProguardMapping().getOrNull();
            File file2 = object == null ? null : object.getAsFile();
            object = ((Params)this.getParameters()).getProguardConfigurations().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.proguardConfigurations.get()");
            List list7 = (List)object;
            object = ((Params)this.getParameters()).getAar().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.aar.get()");
            boolean bl6 = (Boolean)object;
            object = ((RegularFile)((Params)this.getParameters()).getMappingFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.mappingFile.get().asFile");
            Object object2 = object;
            object = ((RegularFile)((Params)this.getParameters()).getProguardSeedsOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.proguardSeedsOutput.get().asFile");
            Object object3 = object;
            object = ((RegularFile)((Params)this.getParameters()).getProguardUsageOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.proguardUsageOutput.get().asFile");
            Object object4 = object;
            object = ((RegularFile)((Params)this.getParameters()).getProguardConfigurationOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.proguardConfi\u2026rationOutput.get().asFile");
            Object object5 = object;
            object = ((RegularFile)((Params)this.getParameters()).getMissingKeepRulesOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.missingKeepRulesOutput.get().asFile");
            Object object6 = object;
            object = ((RegularFile)((Params)this.getParameters()).getOutput().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.output.get().asFile");
            Object object7 = object;
            object = ((RegularFile)((Params)this.getParameters()).getOutputResources().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.outputResources.get().asFile");
            Object object8 = object;
            object = ((Params)this.getParameters()).getFeatureClassJars().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.featureClassJars.files");
            List list8 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = ((Params)this.getParameters()).getFeatureJavaResourceJars().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.featureJavaResourceJars.files");
            List list9 = CollectionsKt.toList((Iterable)((Iterable)object));
            object = (Directory)((Params)this.getParameters()).getFeatureDexDir().getOrNull();
            File file3 = object == null ? null : object.getAsFile();
            object = (Directory)((Params)this.getParameters()).getFeatureJavaResourceOutputDir().getOrNull();
            File file4 = object == null ? null : object.getAsFile();
            String string = (String)((Params)this.getParameters()).getLibConfiguration().getOrNull();
            object = (Directory)((Params)this.getParameters()).getOutputKeepRulesDir().getOrNull();
            File file5 = object == null ? null : object.getAsFile();
            object = ((Params)this.getParameters()).getErrorFormatMode().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.errorFormatMode.get()");
            Companion.shrink(list, n, bl, bl2, bl3, bl4, list2, list3, file, dexingType, bl5, list4, list5, list6, collection, file2, list7, bl6, (File)object2, (File)object3, (File)object4, (File)object5, (File)object6, (File)object7, (File)object8, list8, list9, file3, file4, string, file5, (SyncOptions.ErrorFormatMode)((Object)object));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0012\u0010\u001c\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000bR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u0012\u0010$\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\u0012\u0010&\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0007R\u0012\u0010-\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000bR\u0012\u0010/\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010)R\u0012\u00101\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000bR\u0012\u00103\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010)R\u0018\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0007R\u0012\u00108\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010)R\u0012\u0010:\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010)R\u0012\u0010<\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010!R\u0012\u0010>\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010)R\u0012\u0010@\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000bR\u0012\u0010B\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010)R\u0018\u0010D\u001a\b\u0012\u0004\u0012\u00020+0EX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0012\u0010H\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010)R\u0012\u0010J\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010)R\u0012\u0010L\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u000bR\u0012\u0010N\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u000bR\u0018\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0007\u00a8\u0006R"}, d2={"Lcom/android/build/gradle/internal/tasks/R8Task$R8Runnable$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "aar", "Lorg/gradle/api/provider/Property;", "", "getAar", "()Lorg/gradle/api/provider/Property;", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classes", "getClasses", "debuggable", "getDebuggable", "dexingType", "Lcom/android/builder/dexing/DexingType;", "getDexingType", "disableMinification", "getDisableMinification", "disableTreeShaking", "getDisableTreeShaking", "enableDesugaring", "getEnableDesugaring", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "featureClassJars", "getFeatureClassJars", "featureDexDir", "Lorg/gradle/api/file/DirectoryProperty;", "getFeatureDexDir", "()Lorg/gradle/api/file/DirectoryProperty;", "featureJavaResourceJars", "getFeatureJavaResourceJars", "featureJavaResourceOutputDir", "getFeatureJavaResourceOutputDir", "inputProguardMapping", "Lorg/gradle/api/file/RegularFileProperty;", "getInputProguardMapping", "()Lorg/gradle/api/file/RegularFileProperty;", "libConfiguration", "", "getLibConfiguration", "mainDexListFiles", "getMainDexListFiles", "mainDexListOutput", "getMainDexListOutput", "mainDexRulesFiles", "getMainDexRulesFiles", "mappingFile", "getMappingFile", "minSdkVersion", "", "getMinSdkVersion", "missingKeepRulesOutput", "getMissingKeepRulesOutput", "output", "getOutput", "outputKeepRulesDir", "getOutputKeepRulesDir", "outputResources", "getOutputResources", "proguardConfigurationFiles", "getProguardConfigurationFiles", "proguardConfigurationOutput", "getProguardConfigurationOutput", "proguardConfigurations", "Lorg/gradle/api/provider/ListProperty;", "getProguardConfigurations", "()Lorg/gradle/api/provider/ListProperty;", "proguardSeedsOutput", "getProguardSeedsOutput", "proguardUsageOutput", "getProguardUsageOutput", "referencedInputs", "getReferencedInputs", "resources", "getResources", "useFullR8", "getUseFullR8", "gradle-core"})
        public static abstract class Params
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract ConfigurableFileCollection getBootClasspath();

            @NotNull
            public abstract Property<Integer> getMinSdkVersion();

            @NotNull
            public abstract Property<Boolean> getDebuggable();

            @NotNull
            public abstract Property<Boolean> getDisableTreeShaking();

            @NotNull
            public abstract Property<Boolean> getEnableDesugaring();

            @NotNull
            public abstract Property<Boolean> getDisableMinification();

            @NotNull
            public abstract ConfigurableFileCollection getMainDexListFiles();

            @NotNull
            public abstract ConfigurableFileCollection getMainDexRulesFiles();

            @NotNull
            public abstract RegularFileProperty getMainDexListOutput();

            @NotNull
            public abstract Property<DexingType> getDexingType();

            @NotNull
            public abstract Property<Boolean> getUseFullR8();

            @NotNull
            public abstract ConfigurableFileCollection getReferencedInputs();

            @NotNull
            public abstract ConfigurableFileCollection getClasses();

            @NotNull
            public abstract ConfigurableFileCollection getResources();

            @NotNull
            public abstract ConfigurableFileCollection getProguardConfigurationFiles();

            @NotNull
            public abstract RegularFileProperty getInputProguardMapping();

            @NotNull
            public abstract ListProperty<String> getProguardConfigurations();

            @NotNull
            public abstract Property<Boolean> getAar();

            @NotNull
            public abstract RegularFileProperty getMappingFile();

            @NotNull
            public abstract RegularFileProperty getProguardSeedsOutput();

            @NotNull
            public abstract RegularFileProperty getProguardUsageOutput();

            @NotNull
            public abstract RegularFileProperty getProguardConfigurationOutput();

            @NotNull
            public abstract RegularFileProperty getMissingKeepRulesOutput();

            @NotNull
            public abstract RegularFileProperty getOutput();

            @NotNull
            public abstract RegularFileProperty getOutputResources();

            @NotNull
            public abstract ConfigurableFileCollection getFeatureClassJars();

            @NotNull
            public abstract ConfigurableFileCollection getFeatureJavaResourceJars();

            @NotNull
            public abstract DirectoryProperty getFeatureDexDir();

            @NotNull
            public abstract DirectoryProperty getFeatureJavaResourceOutputDir();

            @NotNull
            public abstract Property<String> getLibConfiguration();

            @NotNull
            public abstract DirectoryProperty getOutputKeepRulesDir();

            @NotNull
            public abstract Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();
        }
    }
}

