/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.SdkDependencyDataGeneratorTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.tools.build.libraries.metadata.AppDependencies;
import com.google.crypto.tink.BinaryKeysetReader;
import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.hybrid.HybridConfig;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/SdkDependencyDataGeneratorTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "context", "", "dependencies", "Lorg/gradle/api/file/RegularFileProperty;", "getDependencies", "()Lorg/gradle/api/file/RegularFileProperty;", "sdkDependencyData", "getSdkDependencyData", "sdkDependencyDataPublic", "getSdkDependencyDataPublic", "compress", "", "data", "doTaskAction", "", "encrypt", "Companion", "CreationAction", "gradle-core"})
public abstract class SdkDependencyDataGeneratorTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String context;
    @NotNull
    private static final byte[] publicKey;

    public SdkDependencyDataGeneratorTask() {
        this.context = "SDK_DEPENDENCY_INFO";
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getDependencies();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getSdkDependencyData();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getSdkDependencyDataPublic();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTaskAction() {
        Object object;
        OutputStream it2;
        Closeable closeable = new FileOutputStream(((RegularFile)this.getSdkDependencyData().get()).getAsFile());
        Throwable throwable = null;
        try {
            it2 = (FileOutputStream)closeable;
            boolean bl = false;
            object = Files.readAllBytes(((RegularFile)this.getDependencies().get()).getAsFile().toPath());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readAllBytes(dependencies.get().asFile.toPath())");
            ((FileOutputStream)it2).write(this.encrypt(this.compress((byte[])object)));
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = new PrintStream(((RegularFile)this.getSdkDependencyDataPublic().get()).getAsFile());
        throwable = null;
        try {
            it2 = (PrintStream)closeable;
            boolean bl = false;
            ((PrintStream)it2).print("# List of SDK dependencies of this app, this information is also included in an encrypted form in the APK.\n# For more information visit: https://d.android.com/r/tools/dependency-metadata\n\n");
            object = ((RegularFile)this.getDependencies().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dependencies.get().asFile");
            object = new FileInputStream((File)object);
            int n = 8192;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Throwable throwable2 = null;
            try {
                BufferedInputStream dependenciesInputStream = (BufferedInputStream)object;
                boolean bl2 = false;
                ((PrintStream)it2).print(AppDependencies.parseFrom(dependenciesInputStream).toString());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] compress(byte[] data) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Object object = new DeflaterOutputStream(outputStream);
        Throwable throwable = null;
        try {
            DeflaterOutputStream it = (DeflaterOutputStream)object;
            boolean bl = false;
            it.write(data);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputStream.toByteArray()");
        return object;
    }

    private final byte[] encrypt(byte[] data) {
        HybridEncrypt hybridEncrypt = (HybridEncrypt)KeysetHandle.readNoSecret((KeysetReader)BinaryKeysetReader.withBytes((byte[])publicKey)).getPrimitive(HybridEncrypt.class);
        String string = this.context;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = hybridEncrypt.encrypt(data, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"hybridEncrypt.encrypt(da\u2026ntext.toByteArray(UTF_8))");
        return byArray2;
    }

    static {
        HybridConfig.register();
        byte[] byArray = new byte[]{8, -84, -65, -63, -105, 10, 18, -37, 1, 10, -50, 1, 10, 61, 116, 121, 112, 101, 46, 103, 111, 111, 103, 108, 101, 97, 112, 105, 115, 46, 99, 111, 109, 47, 103, 111, 111, 103, 108, 101, 46, 99, 114, 121, 112, 116, 111, 46, 116, 105, 110, 107, 46, 69, 99, 105, 101, 115, 65, 101, 97, 100, 72, 107, 100, 102, 80, 117, 98, 108, 105, 99, 75, 101, 121, 18, -118, 1, 18, 68, 10, 4, 8, 2, 16, 3, 18, 58, 18, 56, 10, 48, 116, 121, 112, 101, 46, 103, 111, 111, 103, 108, 101, 97, 112, 105, 115, 46, 99, 111, 109, 47, 103, 111, 111, 103, 108, 101, 46, 99, 114, 121, 112, 116, 111, 46, 116, 105, 110, 107, 46, 65, 101, 115, 71, 99, 109, 75, 101, 121, 18, 2, 16, 16, 24, 1, 24, 3, 26, 32, -62, 68, 123, 18, 86, -43, -7, 122, 73, -18, 19, -128, -26, -19, 36, 108, -6, 81, 13, -31, 117, 27, -126, -83, 114, -115, 8, 35, 21, -7, 78, -39, 34, 32, 51, 48, 123, 99, -84, -95, 126, 10, -70, -74, 47, -15, -28, 124, -83, 23, 78, -3, 59, -91, 38, -103, -90, 69, 67, -28, -20, -95, -90, -83, -115, -52, 24, 3, 16, 1, 24, -84, -65, -63, -105, 10, 32, 4};
        publicKey = byArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/SdkDependencyDataGeneratorTask$Companion;", "", "()V", "publicKey", "", "getPublicKey$annotations", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getPublicKey$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/SdkDependencyDataGeneratorTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/SdkDependencyDataGeneratorTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<SdkDependencyDataGeneratorTask, VariantCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<SdkDependencyDataGeneratorTask> type;

        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.name = this.computeTaskName("sdk", "DependencyData");
            this.type = SdkDependencyDataGeneratorTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<SdkDependencyDataGeneratorTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<SdkDependencyDataGeneratorTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("sdkDependencyData.pb").on(InternalArtifactType.SDK_DEPENDENCY_DATA.INSTANCE);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).withName("sdkDependencies.txt").on(InternalArtifactType.SDK_DEPENDENCY_DATA_PUBLIC.INSTANCE);
        }

        @Override
        public void configure(@NotNull SdkDependencyDataGeneratorTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.METADATA_LIBRARY_DEPENDENCIES_REPORT.INSTANCE, (Property)task.getDependencies());
        }
    }
}

