/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitUtils;
import com.android.build.gradle.options.IntegerOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8G@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "inputFiles", "getInputFiles", "()Lorg/gradle/api/file/FileCollection;", "setInputFiles$gradle_core", "(Lorg/gradle/api/file/FileCollection;)V", "", "maxNumberOfFeaturesBeforeOreo", "getMaxNumberOfFeaturesBeforeOreo", "()I", "setMaxNumberOfFeaturesBeforeOreo$gradle_core", "(I)V", "minSdkVersion", "getMinSdkVersion", "setMinSdkVersion$gradle_core", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "CreationAction", "FeatureSetRunnable", "Params", "gradle-core"})
public abstract class FeatureSetMetadataWriterTask
extends NonIncrementalTask {
    public FileCollection inputFiles;
    private int minSdkVersion = 1;
    private int maxNumberOfFeaturesBeforeOreo;

    public FeatureSetMetadataWriterTask() {
        Integer n = FeatureSetMetadata.MAX_NUMBER_OF_SPLITS_BEFORE_O;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"MAX_NUMBER_OF_SPLITS_BEFORE_O");
        this.maxNumberOfFeaturesBeforeOreo = ((Number)n).intValue();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getInputFiles() {
        FileCollection fileCollection2 = this.inputFiles;
        if (fileCollection2 != null) {
            return fileCollection2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inputFiles");
        return null;
    }

    public final void setInputFiles$gradle_core(@NotNull FileCollection fileCollection2) {
        Intrinsics.checkNotNullParameter((Object)fileCollection2, (String)"<set-?>");
        this.inputFiles = fileCollection2;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    public final int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public final void setMinSdkVersion$gradle_core(int n) {
        this.minSdkVersion = n;
    }

    @Input
    public final int getMaxNumberOfFeaturesBeforeOreo() {
        return this.maxNumberOfFeaturesBeforeOreo;
    }

    public final void setMaxNumberOfFeaturesBeforeOreo$gradle_core(int n) {
        this.maxNumberOfFeaturesBeforeOreo = n;
    }

    @Override
    public void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(FeatureSetRunnable.class, new Action(this){
            final /* synthetic */ FeatureSetMetadataWriterTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                Object[] objectArray = new Object[]{this.this$0.getInputFiles()};
                it.getFeatureFiles().from(objectArray);
                it.getMinSdkVersion().set((Object)this.this$0.getMinSdkVersion());
                it.getMaxNumberOfFeaturesBeforeOreo().set((Object)this.this$0.getMaxNumberOfFeaturesBeforeOreo());
                it.getOutputFile().set((Provider)this.this$0.getOutputFile());
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "featureFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getFeatureFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "maxNumberOfFeaturesBeforeOreo", "Lorg/gradle/api/provider/Property;", "", "getMaxNumberOfFeaturesBeforeOreo", "()Lorg/gradle/api/provider/Property;", "minSdkVersion", "getMinSdkVersion", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract ConfigurableFileCollection getFeatureFiles();

        @NotNull
        public abstract Property<Integer> getMinSdkVersion();

        @NotNull
        public abstract Property<Integer> getMaxNumberOfFeaturesBeforeOreo();

        @NotNull
        public abstract RegularFileProperty getOutputFile();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$FeatureSetRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$Params;", "()V", "run", "", "gradle-core"})
    public static abstract class FeatureSetRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            List features = new ArrayList();
            FeatureSetMetadata featureMetadata = new FeatureSetMetadata((Integer)((Params)this.getParameters()).getMaxNumberOfFeaturesBeforeOreo().get());
            for (File file : ((Params)this.getParameters()).getFeatureFiles().getAsFileTree().getFiles()) {
                try {
                    FeatureSplitDeclaration featureSplitDeclaration = FeatureSplitDeclaration.load(file);
                    Intrinsics.checkNotNullExpressionValue((Object)featureSplitDeclaration, (String)"load(file)");
                    features.add(featureSplitDeclaration);
                }
                catch (FileNotFoundException e) {
                    throw new BuildException("Cannot read features split declaration file", (Throwable)e);
                }
            }
            Map<String, String> featureNameMap = FeatureSplitUtils.computeFeatureNames(features);
            for (FeatureSplitDeclaration feature : features) {
                Object object = ((Params)this.getParameters()).getMinSdkVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.minSdkVersion.get()");
                int n = ((Number)object).intValue();
                String string = feature.getModulePath();
                String string2 = featureNameMap.get(feature.getModulePath());
                Intrinsics.checkNotNull((Object)string2);
                featureMetadata.addFeatureSplit(n, string, string2, feature.getNamespace());
            }
            featureMetadata.save((File)((Params)this.getParameters()).getOutputFile().getAsFile().get());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FeatureSetMetadataWriterTask, VariantCreationConfig> {
        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("generate", "FeatureMetadata");
        }

        @Override
        @NotNull
        public Class<FeatureSetMetadataWriterTask> getType() {
            return FeatureSetMetadataWriterTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<FeatureSetMetadataWriterTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("feature-metadata.json").on(InternalArtifactType.FEATURE_SET_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull FeatureSetMetadataWriterTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setMinSdkVersion$gradle_core(((VariantCreationConfig)this.creationConfig).getMinSdkVersion().getApiLevel());
            task.setInputFiles$gradle_core(VariantDependencies.getArtifactFileCollection$default(((VariantCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.REVERSE_METADATA_FEATURE_DECLARATION, null, 8, null));
            Integer maxNumberOfFeaturesBeforeOreo = ((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions().get(IntegerOption.PRE_O_MAX_NUMBER_OF_FEATURES);
            if (maxNumberOfFeaturesBeforeOreo != null) {
                task.setMaxNumberOfFeaturesBeforeOreo$gradle_core(Integer.min(100, maxNumberOfFeaturesBeforeOreo));
            }
        }
    }
}

