/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassMetadata;
import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.build.gradle.internal.tasks.mlkit.codegen.CodeUtils;
import com.android.build.gradle.internal.tasks.mlkit.codegen.ModelGenerator;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.InjectorUtils;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.codeblock.CodeBlockInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.codeblock.processor.DefaultProcessInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.fields.FieldInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.innerclass.GroupClassInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.innerclass.OutputsClassInjector;
import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/codegen/TfliteModelGenerator;", "Lcom/android/build/gradle/internal/tasks/mlkit/codegen/ModelGenerator;", "modelFile", "Ljava/io/File;", "packageName", "", "localModelPath", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "androidLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "className", "logger", "Lorg/gradle/api/logging/Logger;", "modelInfo", "Lcom/android/tools/mlkit/ModelInfo;", "buildCloseMethod", "", "classBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "buildConstructor", "buildFields", "buildInnerClass", "buildProcessMethod", "isGeneric", "", "buildStaticNewInstanceMethods", "generateBuildClass", "outputDirProperty", "Lorg/gradle/api/file/DirectoryProperty;", "Companion", "gradle-core"})
public final class TfliteModelGenerator
implements ModelGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File modelFile;
    @NotNull
    private final String packageName;
    @NotNull
    private final String localModelPath;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ModelInfo modelInfo;
    @NotNull
    private final String className;
    @NotNull
    private final LoggerWrapper androidLogger;
    @NotNull
    private static final String FIELD_MODEL = "model";

    public TfliteModelGenerator(@NotNull File modelFile, @NotNull String packageName, @NotNull String localModelPath) {
        Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)localModelPath, (String)"localModelPath");
        this.modelFile = modelFile;
        this.packageName = packageName;
        this.localModelPath = localModelPath;
        Object object = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLogger(this.javaClass)");
        this.logger = object;
        object = ModelInfo.buildFrom(ByteBuffer.wrap(FilesKt.readBytes((File)this.modelFile)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buildFrom(ByteBuffer.wrap(modelFile.readBytes()))");
        this.modelInfo = object;
        object = MlNames.computeModelClassName(this.localModelPath);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeModelClassName(localModelPath)");
        this.className = object;
        this.androidLogger = new LoggerWrapper(this.logger);
    }

    @Override
    public void generateBuildClass(@NotNull DirectoryProperty outputDirProperty) {
        boolean bl;
        TypeSpec.Builder classBuilder;
        block9: {
            Intrinsics.checkNotNullParameter((Object)outputDirProperty, (String)"outputDirProperty");
            Object object = new Modifier[]{Modifier.PUBLIC, Modifier.FINAL};
            classBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(object);
            if (!this.modelInfo.isMinParserVersionSatisfied()) {
                this.androidLogger.warning("Model is not fully supported in current Android Gradle Plugin and will use fallback APIs, so please update to the latest version: " + this.modelFile.getAbsolutePath(), new Object[0]);
            }
            if (this.modelInfo.isMetadataExisted()) {
                classBuilder.addJavadoc(this.modelInfo.getModelDescription(), new Object[0]);
            } else {
                classBuilder.addJavadoc("This model doesn't have metadata, so no javadoc can be generated.", new Object[0]);
            }
            Intrinsics.checkNotNullExpressionValue((Object)classBuilder, (String)"classBuilder");
            this.buildFields(classBuilder);
            this.buildConstructor(classBuilder);
            this.buildStaticNewInstanceMethods(classBuilder);
            TfliteModelGenerator.buildProcessMethod$default(this, classBuilder, false, 2, null);
            this.buildCloseMethod(classBuilder);
            object = this.modelInfo.getInputs();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"modelInfo.inputs");
            Iterable $this$any$iv = (Iterable)object;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TensorInfo it = (TensorInfo)element$iv;
                    boolean bl2 = false;
                    if (!it.isRGBImage()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            this.buildProcessMethod(classBuilder, true);
        }
        this.buildInnerClass(classBuilder);
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).build().writeTo((File)outputDirProperty.getAsFile().get());
        }
        catch (IOException e) {
            this.logger.debug("Failed to write mlkit generated java file");
        }
    }

    private final void buildFields(TypeSpec.Builder classBuilder) {
        for (TensorInfo tensorInfo : this.modelInfo.getInputs()) {
            FieldInjector fieldInjector = InjectorUtils.getFieldInjector();
            Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
            fieldInjector.inject(classBuilder, tensorInfo);
        }
        for (TensorInfo tensorInfo : this.modelInfo.getOutputs()) {
            FieldInjector fieldInjector = InjectorUtils.getFieldInjector();
            Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
            fieldInjector.inject(classBuilder, tensorInfo);
        }
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        FieldSpec model = FieldSpec.builder((TypeName)((TypeName)ClassNames.MODEL), (String)FIELD_MODEL, (Modifier[])new Modifier[0]).addModifiers(modifierArray).addAnnotation(ClassNames.NON_NULL).build();
        classBuilder.addField(model);
    }

    private final void buildInnerClass(TypeSpec.Builder classBuilder) {
        new OutputsClassInjector(new ClassMetadata(this.packageName, this.className)).inject(classBuilder, this.modelInfo);
        Collection<TensorGroupInfo> collection = this.modelInfo.getOutputTensorGroups();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"modelInfo.outputTensorGroups");
        collection = collection;
        if (!collection.isEmpty()) {
            new GroupClassInjector().inject(classBuilder, this.modelInfo);
        }
    }

    private final void buildConstructor(TypeSpec.Builder classBuilder) {
        ParameterSpec context = ParameterSpec.builder((TypeName)((TypeName)ClassNames.CONTEXT), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        ParameterSpec options = ParameterSpec.builder((TypeName)((TypeName)ClassNames.MODEL_OPTIONS), (String)"options", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        Object object = new Modifier[]{Modifier.PRIVATE};
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers((Modifier[])object).addParameter(context).addParameter(options).addException((TypeName)ClassNames.IO_EXCEPTION);
        object = new Object[]{FIELD_MODEL, ClassNames.MODEL, this.localModelPath};
        MethodSpec.Builder builder2 = builder.addStatement("$L = $T.createModel(context, $S, options)", (Object[])object);
        object = new Object[]{ClassNames.METADATA_EXTRACTOR, ClassNames.METADATA_EXTRACTOR};
        MethodSpec.Builder constructorBuilder = builder2.addStatement("$T extractor = new $T(model.getData())", (Object[])object);
        for (TensorInfo tensorInfo : this.modelInfo.getInputs()) {
            if (!tensorInfo.isMetadataExisted()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
            CodeBlockInjector preprocessorInjector = InjectorUtils.getInputProcessorInjector(tensorInfo);
            Intrinsics.checkNotNullExpressionValue((Object)constructorBuilder, (String)"constructorBuilder");
            preprocessorInjector.inject(constructorBuilder, tensorInfo);
        }
        for (TensorInfo tensorInfo : this.modelInfo.getOutputs()) {
            if (!tensorInfo.isMetadataExisted()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
            CodeBlockInjector postprocessorInjector = InjectorUtils.getOutputProcessorInjector(tensorInfo);
            Intrinsics.checkNotNullExpressionValue((Object)constructorBuilder, (String)"constructorBuilder");
            postprocessorInjector.inject(constructorBuilder, tensorInfo);
            CodeBlockInjector codeBlockInjector = InjectorUtils.getAssociatedFileInjector();
            codeBlockInjector.inject(constructorBuilder, tensorInfo);
        }
        classBuilder.addMethod(constructorBuilder.build());
    }

    private final void buildProcessMethod(TypeSpec.Builder classBuilder, boolean isGeneric) {
        ClassName className = ClassName.get((String)this.packageName, (String)this.className, (String[])new String[0]).nestedClass("Outputs");
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(packageName, classNa\u2026tedClass(MlNames.OUTPUTS)");
        TypeName outputType = (TypeName)className;
        String localOutputs = "outputs";
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"process").addModifiers(modifierArray).addAnnotation(ClassNames.NON_NULL).returns(outputType);
        List byteBufferList = new ArrayList();
        for (TensorInfo tensorInfo : this.modelInfo.getInputs()) {
            Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
            String processedTypeName = CodeUtils.getProcessedTypeName(tensorInfo);
            TypeName parameterType = isGeneric ? (TypeName)ClassNames.TENSOR_BUFFER : CodeUtils.getParameterType(tensorInfo);
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)parameterType, (String)tensorInfo.getIdentifierName(), (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
            methodBuilder.addParameter(parameterSpec);
            byteBufferList.add(processedTypeName + ".getBuffer()");
        }
        for (TensorInfo tensorInfo : this.modelInfo.getInputs()) {
            if (isGeneric) {
                DefaultProcessInjector defaultProcessInjector = new DefaultProcessInjector();
                Intrinsics.checkNotNullExpressionValue((Object)methodBuilder, (String)"methodBuilder");
                Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
                defaultProcessInjector.inject(methodBuilder, tensorInfo);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)tensorInfo, (String)"tensorInfo");
            CodeBlockInjector codeBlockInjector = InjectorUtils.getProcessInjector(tensorInfo);
            Intrinsics.checkNotNullExpressionValue((Object)methodBuilder, (String)"methodBuilder");
            codeBlockInjector.inject(methodBuilder, tensorInfo);
        }
        Object[] objectArray = new Object[]{outputType, localOutputs, outputType};
        methodBuilder.addStatement("$T $L = new $T(model)", objectArray);
        objectArray = new Object[3];
        objectArray[0] = FIELD_MODEL;
        Collection $this$toTypedArray$iv = byteBufferList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        objectArray[1] = CodeUtils.getObjectArrayString(stringArray);
        objectArray[2] = localOutputs;
        methodBuilder.addStatement("$L.run($L, $L.getBuffer())", objectArray);
        objectArray = new Object[]{localOutputs};
        methodBuilder.addStatement("return $L", objectArray);
        classBuilder.addMethod(methodBuilder.build());
    }

    static /* synthetic */ void buildProcessMethod$default(TfliteModelGenerator tfliteModelGenerator, TypeSpec.Builder builder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        tfliteModelGenerator.buildProcessMethod(builder, bl);
    }

    private final void buildCloseMethod(TypeSpec.Builder classBuilder) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"close").addModifiers(objectArray);
        objectArray = new Object[]{FIELD_MODEL};
        MethodSpec.Builder methodBuilder = builder.addStatement("$L.close()", objectArray);
        classBuilder.addMethod(methodBuilder.build());
    }

    private final void buildStaticNewInstanceMethods(TypeSpec.Builder classBuilder) {
        ParameterSpec context = ParameterSpec.builder((TypeName)((TypeName)ClassNames.CONTEXT), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        ParameterSpec options = ParameterSpec.builder((TypeName)((TypeName)ClassNames.MODEL_OPTIONS), (String)"options", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        ClassName className = ClassName.get((String)this.packageName, (String)this.className, (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(packageName, className)");
        TypeName returnType = (TypeName)className;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"newInstance").addModifiers(objectArray).addParameter(context).addException((TypeName)ClassNames.IO_EXCEPTION).addAnnotation(ClassNames.NON_NULL).returns(returnType);
        objectArray = new Object[]{returnType, ClassNames.MODEL_OPTIONS};
        MethodSpec.Builder methodBuilder = builder.addStatement("return new $T(context, (new $T.Builder()).build())", objectArray);
        classBuilder.addMethod(methodBuilder.build());
        Object[] objectArray2 = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"newInstance").addModifiers(objectArray2).addParameter(context).addParameter(options).addException((TypeName)ClassNames.IO_EXCEPTION).addAnnotation(ClassNames.NON_NULL).returns(returnType);
        objectArray2 = new Object[]{returnType};
        MethodSpec.Builder methodWithOptionsBuilder = builder2.addStatement("return new $T(context, options)", objectArray2);
        classBuilder.addMethod(methodWithOptionsBuilder.build());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/codegen/TfliteModelGenerator$Companion;", "", "()V", "FIELD_MODEL", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

