/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.CompileData;
import com.android.sdklib.AndroidVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"ADDON_PATTERN", "Ljava/util/regex/Pattern;", "API_PATTERN", "FULL_PREVIEW_PATTERN", "parseTargetHash", "Lcom/android/build/gradle/internal/utils/CompileData;", "targetHash", "", "validatePreviewTargetValue", "value", "gradle-core"})
public final class SdkUtilsKt {
    @NotNull
    private static final Pattern API_PATTERN;
    @NotNull
    private static final Pattern FULL_PREVIEW_PATTERN;
    @NotNull
    private static final Pattern ADDON_PATTERN;

    @NotNull
    public static final CompileData parseTargetHash(@NotNull String targetHash) {
        Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
        Matcher apiMatcher = API_PATTERN.matcher(targetHash);
        if (apiMatcher.matches()) {
            String string = apiMatcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apiMatcher.group(1)");
            Integer n = Integer.parseInt(string);
            string = apiMatcher.group(3);
            return new CompileData(n, null, string == null ? null : StringsKt.toIntOrNull((String)string), null, null, 26, null);
        }
        Matcher previewMatcher = FULL_PREVIEW_PATTERN.matcher(targetHash);
        if (previewMatcher.matches()) {
            return new CompileData(null, previewMatcher.group(1), null, null, null, 29, null);
        }
        Matcher addonMatcher = ADDON_PATTERN.matcher(targetHash);
        if (addonMatcher.matches()) {
            String string = addonMatcher.group(1);
            String string2 = addonMatcher.group(2);
            String string3 = addonMatcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"addonMatcher.group(3)");
            int n = Integer.parseInt(string3);
            return new CompileData(n, null, null, string, string2, 6, null);
        }
        throw new RuntimeException(StringsKt.trimIndent((String)("\n                    Unsupported value: " + targetHash + ". Format must be one of:\n                    - android-31\n                    - android-31-ext2\n                    - android-T\n                    - vendorName:addonName:31\n                    ")));
    }

    @Nullable
    public static final String validatePreviewTargetValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AndroidVersion.PREVIEW_PATTERN.matcher(value).matches() ? value : null;
    }

    static {
        Pattern pattern = Pattern.compile("^android-([0-9]+)(-ext(\\d+))?$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^android-([0-9]+)(-ext(\\\\d+))?$\")");
        API_PATTERN = pattern;
        pattern = Pattern.compile("^android-([A-Z][0-9A-Za-z_]*)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^android-([A-Z][0-9A-Za-z_]*)$\")");
        FULL_PREVIEW_PATTERN = pattern;
        pattern = Pattern.compile("^(.+):(.+):(\\d+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^(.+):(.+):(\\\\d+)$\")");
        ADDON_PATTERN = pattern;
    }
}

