/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughDeduplicatingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessKt;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessType;
import com.android.build.gradle.tasks.ErrorMatchBehavior;
import com.android.build.gradle.tasks.ErrorMatchType;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0006\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002\" \u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"errorMatchers", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "Lcom/android/build/gradle/tasks/ErrorMatchBehavior;", "prefabConfigurationPackages", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "getPrefabConfigurationPackages", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;)Ljava/util/List;", "generatePrefabPackages", "", "ops", "Lorg/gradle/process/ExecOperations;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "reportErrors", "stderr", "toFinalPrefabPackage", "", "from", "translateFromConfigurationToFinal", "configureOutput", "finalOutput", "gradle-core"})
public final class GeneratePrefabPackagesKt {
    @NotNull
    private static final List<Pair<Regex, ErrorMatchBehavior>> errorMatchers;

    /*
     * WARNING - void declaration
     */
    public static final void generatePrefabPackages(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        NativeBuildSystem nativeBuildSystem = abi.getVariant().getModule().getBuildSystem();
        int n = WhenMappings.$EnumSwitchMapping$0[nativeBuildSystem.ordinal()];
        switch (n) {
            case 1: {
                string = "ndk-build";
                break;
            }
            case 2: {
                string = "cmake";
                break;
            }
            default: {
                String string2 = String.valueOf((Object)abi.getVariant().getModule().getBuildSystem());
                throw new IllegalStateException(string2.toString());
            }
        }
        String buildSystem = string;
        int osVersion = abi.getAbiPlatformVersion();
        File file = CreateCxxVariantModelKt.getPrefabClassPath(abi.getVariant());
        if (file == null) {
            String string3 = "CxxAbiModule.prefabClassPath cannot be null when Prefab is used";
            throw new IllegalStateException(string3.toString());
        }
        File prefabClassPath = file;
        File configureOutput = FilesKt.resolve((File)abi.getPrefabFolder(), (String)"prefab-configure");
        File finalOutput = FilesKt.resolve((File)abi.getPrefabFolder(), (String)"prefab");
        Object object = prefabClassPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"prefabClassPath.path");
        ExecuteProcessCommand executeProcessCommand = ExecuteProcessKt.createJavaExecuteProcessCommand$default((String)object, "com.google.prefab.cli.AppKt", null, 4, null);
        object = new String[]{"--build-system", buildSystem};
        ExecuteProcessCommand executeProcessCommand2 = executeProcessCommand.addArgs((String)object);
        object = new String[]{"--platform", "android"};
        ExecuteProcessCommand executeProcessCommand3 = executeProcessCommand2.addArgs((String)object);
        object = new String[2];
        object[0] = "--abi";
        String string4 = abi.getAbi().getTag();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"abi.abi.tag");
        object[1] = string4;
        ExecuteProcessCommand executeProcessCommand4 = executeProcessCommand3.addArgs((String)object);
        object = new String[]{"--os-version", String.valueOf(osVersion)};
        ExecuteProcessCommand executeProcessCommand5 = executeProcessCommand4.addArgs((String)object);
        object = new String[]{"--stl", abi.getVariant().getStlType()};
        ExecuteProcessCommand executeProcessCommand6 = executeProcessCommand5.addArgs((String)object);
        object = new String[]{"--ndk-version", String.valueOf(abi.getVariant().getModule().getNdkVersion().getMajor())};
        ExecuteProcessCommand executeProcessCommand7 = executeProcessCommand6.addArgs((String)object);
        object = new String[2];
        object[0] = "--output";
        string4 = configureOutput.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"configureOutput.path");
        object[1] = string4;
        ExecuteProcessCommand executeProcessCommand8 = executeProcessCommand7.addArgs((String)object);
        object = GeneratePrefabPackagesKt.getPrefabConfigurationPackages(abi.getVariant());
        ExecuteProcessCommand executeProcessCommand9 = executeProcessCommand8;
        boolean $i$f$map = false;
        void var10_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string5 = it.getPath();
            collection.add(string5);
        }
        collection = (List)destination$iv$iv;
        ExecuteProcessCommand executeCommand = executeProcessCommand9.addArgs((List<String>)collection);
        ExecuteProcessKt.executeProcess$default(abi, ExecuteProcessType.PREFAB_PROCESS, executeCommand, ops2, null, generatePrefabPackages.1.INSTANCE, null, 40, null);
        GeneratePrefabPackagesKt.translateFromConfigurationToFinal(configureOutput, finalOutput);
    }

    private static final void translateFromConfigurationToFinal(File configureOutput, File finalOutput) {
        for (File configureFile : FilesKt.walkTopDown((File)configureOutput)) {
            File relativeFile = FilesKt.relativeTo((File)configureFile, (File)configureOutput);
            File finalFile = FilesKt.resolve((File)finalOutput, (File)relativeFile);
            if (configureFile.isDirectory()) {
                finalFile.mkdirs();
                continue;
            }
            String string = FilesKt.getExtension((File)relativeFile);
            if (Intrinsics.areEqual((Object)string, (Object)"cmake")) {
                StringBuilder sb = new StringBuilder();
                FilesKt.forEachLine$default((File)configureFile, null, (Function1)((Function1)new Function1<String, Unit>(sb){
                    final /* synthetic */ StringBuilder $sb;
                    {
                        this.$sb = $sb;
                        super(1);
                    }

                    public final void invoke(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        StringBuilder stringBuilder = this.$sb;
                        String string = StringsKt.contains$default((CharSequence)line, (CharSequence)"IMPORTED_LOCATION", (boolean)false, (int)2, null) ? GeneratePrefabPackagesKt.access$toFinalPrefabPackage(line) : line;
                        StringBuilder stringBuilder2 = stringBuilder.append(string);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                    }
                }), (int)1, null);
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
                FilesKt.writeText$default((File)finalFile, (String)string2, null, (int)2, null);
                continue;
            }
            FilesKt.copyTo$default((File)configureFile, (File)finalFile, (boolean)false, (int)0, (int)6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getPrefabConfigurationPackages(@NotNull CxxVariantModel $this$prefabConfigurationPackages) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$prefabConfigurationPackages, (String)"<this>");
        Iterable $this$map$iv = CreateCxxVariantModelKt.getPrefabPackageConfigurationDirectoriesList($this$prefabConfigurationPackages);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            String string2 = GeneratePrefabPackagesKt.toFinalPrefabPackage(string);
            collection.add(string2);
        }
        Set coveredByConfigurationPackage = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = CreateCxxVariantModelKt.getPrefabPackageDirectoryList($this$prefabConfigurationPackages);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(!coveredByConfigurationPackage.contains(it.getPath()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List aarPackages = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)CreateCxxVariantModelKt.getPrefabPackageConfigurationDirectoriesList($this$prefabConfigurationPackages), (Iterable)aarPackages);
    }

    private static final String toFinalPrefabPackage(String from) {
        return StringsKt.replaceFirst$default((String)from, (String)"prefab_package_configuration", (String)"prefab_package", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reportErrors(@NotNull File stderr) {
        Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
        if (!stderr.isFile()) {
            return;
        }
        Ref.ObjectRef relevantLibrary = new Ref.ObjectRef();
        relevantLibrary.element = "";
        Ref.BooleanRef errorPresent = new Ref.BooleanRef();
        AutoCloseable autoCloseable = new PassThroughDeduplicatingLoggingEnvironment();
        Throwable throwable = null;
        try {
            PassThroughDeduplicatingLoggingEnvironment logger = (PassThroughDeduplicatingLoggingEnvironment)autoCloseable;
            boolean bl = false;
            FilesKt.forEachLine$default((File)stderr, null, (Function1)((Function1)new Function1<String, Unit>(logger, errorPresent, (Ref.ObjectRef<String>)relevantLibrary){
                final /* synthetic */ PassThroughDeduplicatingLoggingEnvironment $logger;
                final /* synthetic */ Ref.BooleanRef $errorPresent;
                final /* synthetic */ Ref.ObjectRef<String> $relevantLibrary;
                {
                    this.$logger = $logger;
                    this.$errorPresent = $errorPresent;
                    this.$relevantLibrary = $relevantLibrary;
                    super(1);
                }

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    Collection collection = this.$logger.getErrors();
                    if (!collection.isEmpty()) {
                        LoggingEnvironmentKt.lifecycleln(line, new Object[0]);
                        return;
                    }
                    if (StringsKt.isBlank((CharSequence)line)) {
                        LoggingEnvironmentKt.infoln(line, new Object[0]);
                        return;
                    }
                    this.$errorPresent.element = true;
                    for (Pair pair : GeneratePrefabPackagesKt.access$getErrorMatchers$p()) {
                        Regex regex = (Regex)pair.component1();
                        ErrorMatchBehavior behavior = (ErrorMatchBehavior)pair.component2();
                        MatchResult found = Regex.find$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null);
                        if (found == null) continue;
                        ErrorMatchType errorMatchType = behavior.getType();
                        int n = reportErrors.1.WhenMappings.$EnumSwitchMapping$0[errorMatchType.ordinal()];
                        switch (n) {
                            case 1: {
                                MatchResult.Destructured destructured = found.getDestructured();
                                this.$relevantLibrary.element = " [" + (String)destructured.getMatch().getGroupValues().get(1) + "]";
                                LoggingEnvironmentKt.lifecycleln(line, new Object[0]);
                                break;
                            }
                            case 2: {
                                MatchResult.Destructured destructured = found.getDestructured();
                                String text = (String)destructured.getMatch().getGroupValues().get(1);
                                CxxDiagnosticCode cxxDiagnosticCode = behavior.getCode();
                                Intrinsics.checkNotNull((Object)cxxDiagnosticCode);
                                LoggingEnvironmentKt.errorln(cxxDiagnosticCode, text + this.$relevantLibrary.element, new Object[0]);
                                break;
                            }
                            case 3: {
                                this.$relevantLibrary.element = "";
                                CxxDiagnosticCode cxxDiagnosticCode = behavior.getCode();
                                Intrinsics.checkNotNull((Object)cxxDiagnosticCode);
                                MatchResult.Destructured destructured = found.getDestructured();
                                LoggingEnvironmentKt.errorln(cxxDiagnosticCode, (String)destructured.getMatch().getGroupValues().get(1), new Object[0]);
                                break;
                            }
                            case 4: {
                                LoggingEnvironmentKt.infoln(line, new Object[0]);
                                break;
                            }
                            case 5: {
                                String string = line + this.$relevantLibrary.element;
                                throw new IllegalStateException(string.toString());
                            }
                        }
                        break;
                    }
                }
            }), (int)1, null);
            if (errorPresent.element && logger.getErrors().isEmpty()) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.PREFAB_NO_LIBRARY_FOUND, "No compatible library found" + relevantLibrary.element, new Object[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final ErrorMatchBehavior errorMatchers$lambda-5$library(CxxDiagnosticCode code) {
        return new ErrorMatchBehavior(ErrorMatchType.RelevantLibraryError, code);
    }

    private static final ErrorMatchBehavior errorMatchers$lambda-5$other(CxxDiagnosticCode code) {
        return new ErrorMatchBehavior(ErrorMatchType.OtherError, code);
    }

    public static final /* synthetic */ String access$toFinalPrefabPackage(String from) {
        return GeneratePrefabPackagesKt.toFinalPrefabPackage(from);
    }

    public static final /* synthetic */ List access$getErrorMatchers$p() {
        return errorMatchers;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        ErrorMatchBehavior fatal = GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_FATAL);
        ErrorMatchBehavior informational = new ErrorMatchBehavior(ErrorMatchType.InformationOnly, null, 2, null);
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"^.*NoMatchingLibraryException.*No compatible library found for (.*)\\.", (Object)new ErrorMatchBehavior(ErrorMatchType.RelevantLibraryDiscovery, null, 2, null)), TuplesKt.to((Object)"^.*(User requested .* but library requires .*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$library(CxxDiagnosticCode.PREFAB_MISMATCHED_STL_TYPE)), TuplesKt.to((Object)"^.*(User has minSdkVersion .* but library was built for .*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$library(CxxDiagnosticCode.PREFAB_MISMATCHED_MIN_SDK_VERSION)), TuplesKt.to((Object)"^.*(Library is a shared library with a statically linked STL and cannot be used with any library using the STL.*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$library(CxxDiagnosticCode.PREFAB_SINGLE_STL_VIOLATION_LIBRARY_IS_SHARED_WITH_STATIC_STL)), TuplesKt.to((Object)"^.*(User is using a static STL but library requires a shared STL.*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$library(CxxDiagnosticCode.PREFAB_SINGLE_STL_VIOLATION_LIBRARY_REQUIRES_SHARED_STL)), TuplesKt.to((Object)"^.*UnsupportedPlatformException: (.*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_UNSUPPORTED_PLATFORM)), TuplesKt.to((Object)"^.*DuplicateModuleNameException: (.*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_DUPLICATE_MODULE_NAME)), TuplesKt.to((Object)"^.*IllegalArgumentException: (Only schema_version 1 is supported\\. .* uses version .*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_MISMATCHED_SCHEMA)), TuplesKt.to((Object)"^.*IllegalArgumentException: (schema_version must be between .* and .*. Package uses version .*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_MISMATCHED_SCHEMA)), TuplesKt.to((Object)"^.*JsonDecodingException: (.*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_JSON_FORMAT_PROBLEM)), TuplesKt.to((Object)"^.*RuntimeException: (Prebuilt directory does not contain .*)", (Object)GeneratePrefabPackagesKt.errorMatchers$lambda-5$other(CxxDiagnosticCode.PREFAB_PREBUILTS_MISSING)), TuplesKt.to((Object)"^.*IllegalArgumentException: (Unknown ABI.*)", (Object)fatal), TuplesKt.to((Object)"^.*IllegalArgumentException: (version must be compatible with CMake, if present.*)", (Object)fatal), TuplesKt.to((Object)"^.*Error: (Invalid value for \".*\".*)", (Object)fatal), TuplesKt.to((Object)"^.*(Unknown ABI: .*)", (Object)fatal), TuplesKt.to((Object)"^.*(Unknown STL: .*)", (Object)fatal), TuplesKt.to((Object)"^.*(User is targeting .* but library is for .*)", (Object)informational), TuplesKt.to((Object)"^Usage: prefab.*", (Object)informational), TuplesKt.to((Object)".*", (Object)new ErrorMatchBehavior(ErrorMatchType.Unrecognized, null, 2, null))};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair2 = TuplesKt.to((Object)new Regex((String)it.getFirst()), (Object)it.getSecond());
            collection.add(pair2);
        }
        errorMatchers = (List)destination$iv$iv;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 1;
            nArray[NativeBuildSystem.CMAKE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

