/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantOutputImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.UnitTestCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b'\u0018\u0000 \u00142\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "projectDir", "Lorg/gradle/api/file/RegularFileProperty;", "getProjectDir", "()Lorg/gradle/api/file/RegularFileProperty;", "<set-?>", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigInputs;", "testConfigInputs", "getTestConfigInputs", "()Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigInputs;", "doTaskAction", "", "Companion", "CreationAction", "GenerateTestConfigParams", "GenerateTestConfigRunnable", "TestConfigInputs", "TestConfigProperties", "gradle-core"})
public abstract class GenerateTestConfig
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private TestConfigInputs testConfigInputs;
    @NotNull
    private final DirectoryProperty outputDirectory;
    @NotNull
    private static final String TEST_CONFIG_FILE = "com/android/tools/test_config.properties";
    @NotNull
    private static final String ANDROID_RESOURCE_APK = "android_resource_apk";
    @NotNull
    private static final String ANDROID_MERGED_ASSETS = "android_merged_assets";
    @NotNull
    private static final String ANDROID_MERGED_MANIFEST = "android_merged_manifest";
    @NotNull
    private static final String ANDROID_CUSTOM_PACKAGE = "android_custom_package";
    @NotNull
    private static final String COMMENT_GENERATED_BY_AGP = "Generated by the Android Gradle plugin";

    @Inject
    public GenerateTestConfig(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.outputDirectory = directoryProperty;
    }

    @Nested
    @NotNull
    public final TestConfigInputs getTestConfigInputs() {
        TestConfigInputs testConfigInputs = this.testConfigInputs;
        if (testConfigInputs != null) {
            return testConfigInputs;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testConfigInputs");
        return null;
    }

    @Internal(value="only for task execution")
    @NotNull
    public abstract RegularFileProperty getProjectDir();

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(GenerateTestConfigRunnable.class, new Action(this){
            final /* synthetic */ GenerateTestConfig this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(GenerateTestConfigParams it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                Property<TestConfigProperties> property = it.getTestConfigProperties();
                TestConfigInputs testConfigInputs = this.this$0.getTestConfigInputs();
                File file = ((RegularFile)this.this$0.getProjectDir().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"projectDir.get().asFile");
                property.set((Object)testConfigInputs.computeProperties(file));
                it.getOutputDirectory().set((Provider)this.this$0.getOutputDirectory());
            }
        });
    }

    @JvmStatic
    @VisibleForTesting
    public static final void generateTestConfigFile(@NotNull TestConfigProperties config2, @NotNull Path outputDir) throws IOException {
        Companion.generateTestConfigFile(config2, outputDir);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$GenerateTestConfigRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/tasks/GenerateTestConfig$GenerateTestConfigParams;", "()V", "run", "", "gradle-core"})
    public static abstract class GenerateTestConfigRunnable
    extends ProfileAwareWorkAction<GenerateTestConfigParams> {
        @Override
        public void run() {
            Object object = ((GenerateTestConfigParams)this.getParameters()).getTestConfigProperties().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.testConfigProperties.get()");
            TestConfigProperties testConfigProperties = (TestConfigProperties)object;
            object = ((Directory)((GenerateTestConfigParams)this.getParameters()).getOutputDirectory().get()).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.outputDirectory.get().asFile.toPath()");
            Companion.generateTestConfigFile(testConfigProperties, (Path)object);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$GenerateTestConfigParams;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "testConfigProperties", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "getTestConfigProperties", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class GenerateTestConfigParams
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<TestConfigProperties> getTestConfigProperties();

        @NotNull
        public abstract DirectoryProperty getOutputDirectory();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/GenerateTestConfig;", "Lcom/android/build/gradle/internal/component/UnitTestCreationConfig;", "unitTestCreationConfig", "(Lcom/android/build/gradle/internal/component/UnitTestCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<GenerateTestConfig, UnitTestCreationConfig> {
        @NotNull
        private final UnitTestCreationConfig unitTestCreationConfig;

        public CreationAction(@NotNull UnitTestCreationConfig unitTestCreationConfig) {
            Intrinsics.checkNotNullParameter((Object)unitTestCreationConfig, (String)"unitTestCreationConfig");
            super((ComponentCreationConfig)unitTestCreationConfig);
            this.unitTestCreationConfig = unitTestCreationConfig;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("generate", "Config");
        }

        @Override
        @NotNull
        public Class<GenerateTestConfig> getType() {
            return GenerateTestConfig.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<GenerateTestConfig> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((UnitTestCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE);
        }

        @Override
        public void configure(@NotNull GenerateTestConfig task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.testConfigInputs = new TestConfigInputs(this.unitTestCreationConfig);
            task.getProjectDir().set(task.getProject().getProjectDir());
            task.getProjectDir().disallowChanges();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001fH\u0002R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001b\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigInputs;", "", "creationConfig", "Lcom/android/build/gradle/internal/component/UnitTestCreationConfig;", "(Lcom/android/build/gradle/internal/component/UnitTestCreationConfig;)V", "buildDirectoryPath", "", "getBuildDirectoryPath", "()Ljava/lang/String;", "isUseRelativePathEnabled", "", "()Z", "mainVariantOutput", "Lcom/android/build/api/variant/impl/VariantOutputImpl;", "getMainVariantOutput", "()Lcom/android/build/api/variant/impl/VariantOutputImpl;", "mergedAssets", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getMergedAssets", "()Lorg/gradle/api/provider/Provider;", "mergedManifest", "getMergedManifest", "packageNameOfFinalRClass", "getPackageNameOfFinalRClass", "resourceApk", "Lorg/gradle/api/file/RegularFile;", "getResourceApk", "computeProperties", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "projectDir", "Ljava/io/File;", "getRelativePathIfRequired", "file", "rootProjectDir", "gradle-core"})
    public static final class TestConfigInputs {
        private final boolean isUseRelativePathEnabled;
        @Nullable
        private final Provider<RegularFile> resourceApk;
        @NotNull
        private final Provider<Directory> mergedAssets;
        @NotNull
        private final Provider<Directory> mergedManifest;
        @NotNull
        private final String buildDirectoryPath;
        @NotNull
        private final VariantOutputImpl mainVariantOutput;
        @NotNull
        private final Provider<String> packageNameOfFinalRClass;

        public TestConfigInputs(@NotNull UnitTestCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.isUseRelativePathEnabled = creationConfig.getServices().getProjectOptions().get(BooleanOption.USE_RELATIVE_PATH_IN_TEST_CONFIG);
            this.resourceApk = creationConfig.getArtifacts().get(InternalArtifactType.APK_FOR_LOCAL_TEST.INSTANCE);
            this.mergedAssets = creationConfig.getMainVariant().getArtifacts().get((SingleArtifact)SingleArtifact.ASSETS.INSTANCE);
            this.mergedManifest = creationConfig.getMainVariant().getArtifacts().get(InternalArtifactType.PACKAGED_MANIFESTS.INSTANCE);
            this.mainVariantOutput = creationConfig.getMainVariant().getOutputs().getMainSplit();
            this.packageNameOfFinalRClass = creationConfig.getMainVariant().getNamespace();
            File file = ((Directory)creationConfig.getServices().getProjectInfo().getBuildDirectory().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"creationConfig.services.\u2026ildDirectory.get().asFile");
            File file2 = file;
            file = creationConfig.getServices().getProjectInfo().getProjectDirectory().getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"creationConfig.services.\u2026o.projectDirectory.asFile");
            this.buildDirectoryPath = FilesKt.toRelativeString((File)file2, (File)file);
        }

        @Input
        public final boolean isUseRelativePathEnabled() {
            return this.isUseRelativePathEnabled;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @Optional
        @Nullable
        public final Provider<RegularFile> getResourceApk() {
            return this.resourceApk;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<Directory> getMergedAssets() {
            return this.mergedAssets;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<Directory> getMergedManifest() {
            return this.mergedManifest;
        }

        @Input
        @NotNull
        public final String getBuildDirectoryPath() {
            return this.buildDirectoryPath;
        }

        @Nested
        @NotNull
        public final VariantOutputImpl getMainVariantOutput() {
            return this.mainVariantOutput;
        }

        @Input
        @NotNull
        public final Provider<String> getPackageNameOfFinalRClass() {
            return this.packageNameOfFinalRClass;
        }

        @NotNull
        public final TestConfigProperties computeProperties(@NotNull File projectDir) {
            String string;
            Object object;
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            Object object2 = new BuiltArtifactsLoaderImpl().load(this.mergedManifest);
            Provider<RegularFile> provider2 = object = object2 == null ? null : ((BuiltArtifactsImpl)object2).getBuiltArtifact(this.mainVariantOutput);
            if (object == null) {
                object2 = "Unable to find manifest output";
                throw new IllegalStateException(object2.toString());
            }
            Provider<RegularFile> manifestOutput = object;
            object = this.resourceApk;
            if (object == null) {
                string = null;
            } else {
                object2 = (RegularFile)object.get();
                if (object2 == null) {
                    string = null;
                } else {
                    String string2;
                    Object object3;
                    Object it = object3 = object2;
                    boolean bl = false;
                    File file = it.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it.asFile");
                    string = string2 = this.getRelativePathIfRequired(file, projectDir);
                }
            }
            object = ((Directory)this.mergedAssets.get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(object, (String)"mergedAssets.get().asFile");
            String string3 = this.getRelativePathIfRequired((File)object, projectDir);
            String string4 = this.getRelativePathIfRequired(new File(manifestOutput.getOutputFile()), projectDir);
            object = this.packageNameOfFinalRClass.get();
            Intrinsics.checkNotNullExpressionValue(object, (String)"packageNameOfFinalRClass.get()");
            String string5 = (String)object;
            String string6 = string4;
            String string7 = string3;
            String string8 = string;
            return new TestConfigProperties(string8, string7, string6, string5);
        }

        private final String getRelativePathIfRequired(File file, File rootProjectDir) {
            return this.isUseRelativePathEnabled ? ((Object)rootProjectDir.toPath().relativize(file.toPath())).toString() : ((Object)rootProjectDir.toPath().resolve(file.toPath())).toString();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "Ljava/io/Serializable;", "resourceApkFile", "", "mergedAssetsDir", "mergedManifestDir", "customPackage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCustomPackage", "()Ljava/lang/String;", "getMergedAssetsDir", "getMergedManifestDir", "getResourceApkFile", "gradle-core"})
    public static final class TestConfigProperties
    implements Serializable {
        @Nullable
        private final String resourceApkFile;
        @NotNull
        private final String mergedAssetsDir;
        @NotNull
        private final String mergedManifestDir;
        @NotNull
        private final String customPackage;

        public TestConfigProperties(@Nullable String resourceApkFile, @NotNull String mergedAssetsDir, @NotNull String mergedManifestDir, @NotNull String customPackage) {
            Intrinsics.checkNotNullParameter((Object)mergedAssetsDir, (String)"mergedAssetsDir");
            Intrinsics.checkNotNullParameter((Object)mergedManifestDir, (String)"mergedManifestDir");
            Intrinsics.checkNotNullParameter((Object)customPackage, (String)"customPackage");
            this.resourceApkFile = resourceApkFile;
            this.mergedAssetsDir = mergedAssetsDir;
            this.mergedManifestDir = mergedManifestDir;
            this.customPackage = customPackage;
        }

        @Nullable
        public final String getResourceApkFile() {
            return this.resourceApkFile;
        }

        @NotNull
        public final String getMergedAssetsDir() {
            return this.mergedAssetsDir;
        }

        @NotNull
        public final String getMergedManifestDir() {
            return this.mergedManifestDir;
        }

        @NotNull
        public final String getCustomPackage() {
            return this.customPackage;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/tasks/GenerateTestConfig$Companion;", "", "()V", "ANDROID_CUSTOM_PACKAGE", "", "ANDROID_MERGED_ASSETS", "ANDROID_MERGED_MANIFEST", "ANDROID_RESOURCE_APK", "COMMENT_GENERATED_BY_AGP", "TEST_CONFIG_FILE", "generateTestConfigFile", "", "config", "Lcom/android/build/gradle/tasks/GenerateTestConfig$TestConfigProperties;", "outputDir", "Ljava/nio/file/Path;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @VisibleForTesting
        public final void generateTestConfigFile(@NotNull TestConfigProperties config2, @NotNull Path outputDir) throws IOException {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            Properties properties = new Properties();
            if (config2.getResourceApkFile() != null) {
                properties.setProperty(GenerateTestConfig.ANDROID_RESOURCE_APK, config2.getResourceApkFile());
            }
            properties.setProperty(GenerateTestConfig.ANDROID_MERGED_ASSETS, config2.getMergedAssetsDir());
            properties.setProperty(GenerateTestConfig.ANDROID_MERGED_MANIFEST, config2.getMergedManifestDir());
            properties.setProperty(GenerateTestConfig.ANDROID_CUSTOM_PACKAGE, config2.getCustomPackage());
            StringWriter stringWriter = new StringWriter();
            Closeable closeable = stringWriter;
            Object object = null;
            try {
                StringWriter it = (StringWriter)closeable;
                boolean bl = false;
                properties.store(it, GenerateTestConfig.COMMENT_GENERATED_BY_AGP);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                object = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            object = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stringWriter.toString()");
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)((CharSequence)object));
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                CharSequence charSequence = it;
                boolean bl3 = !(charSequence.length() == 0);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List lines = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = lines;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!(!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)GenerateTestConfig.COMMENT_GENERATED_BY_AGP, (boolean)false, (int)2, null))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List linesWithoutTimestamp = (List)destination$iv$iv2;
            String string = outputDir.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputDir.fileSystem.separator");
            Path testConfigFile = outputDir.resolve(StringsKt.replace$default((String)GenerateTestConfig.TEST_CONFIG_FILE, (String)"/", (String)string, (boolean)false, (int)4, null));
            Files.createDirectories(testConfigFile.getParent(), new FileAttribute[0]);
            Files.write(testConfigFile, (Iterable<? extends CharSequence>)linesWithoutTimestamp, new OpenOption[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

