/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.res.shrinker.DummyContent;
import com.android.build.gradle.internal.res.shrinker.LinkedResourcesFormat;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinker;
import com.android.builder.dexing.AnalysisCallback;
import com.android.builder.dexing.MethodVisitingStatus;
import com.android.builder.dexing.R8ResourceShrinker;
import com.android.builder.utils.ZipEntryUtils;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.r8.references.MethodReference;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ResourceUsageAnalyzer
implements ResourceShrinker {
    private static final String ANDROID_RES = "android_res/";
    public static final boolean REPLACE_DELETED_WITH_EMPTY = true;
    private static final int ASM_VERSION = 458752;
    public static final boolean TWO_PASS_AAPT = false;
    static final String NO_MATCH = "-nomatch-";
    private final File mResourceClasseseSource;
    private final File mProguardMapping;
    private final Iterable<File> mClasses;
    private final File mMergedManifest;
    private final Iterable<File> mResourceDirs;
    private final File mReportFile;
    private final StringWriter mDebugOutput;
    private final PrintWriter mDebugPrinter;
    private boolean mVerbose;
    private boolean mDebug;
    private boolean mDryRun;
    private List<ResourceUsageModel.Resource> mUnused;
    private Map<String, Pair<ResourceType, Map<String, String>>> mResourceObfuscation = Maps.newHashMapWithExpectedSize((int)30);
    private String mSuggestionsAdapter;
    private String mResourcesWrapper;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private Set<String> mStrings;
    private boolean mFoundGetIdentifier;
    private boolean mFoundWebContent;
    private final ResourceShrinkerUsageModel mModel = new ResourceShrinkerUsageModel();

    public ResourceUsageAnalyzer(File rClasses, Iterable<File> classes, File manifest, File mapping, Iterable<File> resources, File reportFile2) {
        this.mResourceClasseseSource = rClasses;
        this.mProguardMapping = mapping;
        this.mClasses = classes;
        this.mMergedManifest = manifest;
        this.mResourceDirs = resources;
        this.mReportFile = reportFile2;
        if (reportFile2 != null || this.mDebug) {
            this.mDebugOutput = new StringWriter(8192);
            this.mDebugPrinter = new PrintWriter(this.mDebugOutput);
        } else {
            this.mDebugOutput = null;
            this.mDebugPrinter = null;
        }
    }

    public ResourceUsageAnalyzer(File rClasses, Iterable<File> classes, File manifest, File mapping, File resources, File reportFile2) {
        this(rClasses, classes, manifest, mapping, Arrays.asList(resources), reportFile2);
    }

    @Override
    public void close() {
        if (this.mDebugOutput != null) {
            File dir;
            String output2 = this.mDebugOutput.toString();
            if (this.mDebug) {
                System.out.println(output2);
            }
            if (this.mReportFile != null && (dir = this.mReportFile.getParentFile()) != null && (dir.exists() || dir.mkdir()) && dir.canWrite()) {
                try {
                    Files.asCharSink((File)this.mReportFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)output2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void analyze() throws IOException, ParserConfigurationException, SAXException {
        this.gatherResourceValues(this.mResourceClasseseSource);
        this.recordMapping(this.mProguardMapping);
        for (File jarOrDir : this.mClasses) {
            this.recordClassUsages(jarOrDir);
        }
        this.recordManifestUsages(this.mMergedManifest);
        this.recordResources(this.mResourceDirs);
        this.keepPossiblyReferencedResources();
        this.dumpReferences();
        this.mModel.processToolsAttributes();
        this.mUnused = this.mModel.findUnused();
    }

    public boolean isDryRun() {
        return this.mDryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.mDryRun = dryRun;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean verbose) {
        this.mDebug = verbose;
    }

    @Override
    public void rewriteResourcesInBundleFormat(File source, File dest, Map<String, String> moduleToPackageName) {
        throw new UnsupportedOperationException("App bundles are not supported by ResourceUsageAnalyzer");
    }

    @Override
    public void rewriteResourcesInApkFormat(File source, File dest, LinkedResourcesFormat format) throws IOException {
        boolean deleted;
        if (dest.exists() && !(deleted = dest.delete())) {
            throw new IOException("Could not delete " + dest);
        }
        try (JarInputStream zis = new JarInputStream(new BufferedInputStream(new FileInputStream(source)));
             JarOutputStream zos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            zos.setLevel(9);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean directory2 = entry.isDirectory();
                ResourceUsageModel.Resource resource = this.getResourceByJarPath(name);
                if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) {
                    throw new InvalidPathException(entry.getName(), "Entry name contains invalid characters");
                }
                if (resource == null || resource.isReachable()) {
                    ResourceUsageAnalyzer.copyToOutput(zis, zos, entry, name, directory2);
                } else if (!directory2) {
                    this.replaceWithDummyEntry(zos, entry, name, format);
                } else if (this.isVerbose() || this.mDebugPrinter != null) {
                    String message2 = "Skipped unused resource " + name + ": " + entry.getSize() + " bytes";
                    if (this.isVerbose()) {
                        System.out.println(message2);
                    }
                    if (this.mDebugPrinter != null) {
                        this.mDebugPrinter.println(message2);
                    }
                }
                entry = zis.getNextEntry();
            }
            zos.flush();
        }
        long before = source.length();
        long after = dest.length();
        if (after > before) {
            String message3 = "Resource shrinking did not work (grew from " + before + " to " + after + "); using original instead";
            if (this.isVerbose()) {
                System.out.println(message3);
            }
            if (this.mDebugPrinter != null) {
                this.mDebugPrinter.println(message3);
            }
            Files.copy((File)source, (File)dest);
        }
    }

    private void replaceWithDummyEntry(JarOutputStream zos, ZipEntry entry, String name, LinkedResourcesFormat format) throws IOException {
        long crc;
        byte[] bytes2;
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!name.endsWith(".9.png")) break block9;
                        bytes2 = DummyContent.TINY_9PNG;
                        crc = 289995143L;
                        break block10;
                    }
                    if (!name.endsWith(".png")) break block11;
                    bytes2 = DummyContent.TINY_PNG;
                    crc = 2293408688L;
                    break block10;
                }
                if (!name.endsWith(".xml")) break block12;
                switch (format) {
                    case BINARY: {
                        bytes2 = DummyContent.TINY_BINARY_XML;
                        crc = 3622196803L;
                        break block10;
                    }
                    case PROTO: {
                        bytes2 = DummyContent.TINY_PROTO_XML;
                        crc = 3204905971L;
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("");
                    }
                }
            }
            bytes2 = new byte[]{};
            crc = 0L;
        }
        JarEntry outEntry = new JarEntry(name);
        if (entry.getTime() != -1L) {
            outEntry.setTime(entry.getTime());
        }
        if (entry.getMethod() == 0) {
            outEntry.setMethod(0);
            outEntry.setSize(bytes2.length);
            outEntry.setCrc(crc);
        }
        zos.putNextEntry(outEntry);
        zos.write(bytes2);
        zos.closeEntry();
        if (this.isVerbose() || this.mDebugPrinter != null) {
            String message2 = "Skipped unused resource " + name + ": " + entry.getSize() + " bytes (replaced with small dummy file of size " + bytes2.length + " bytes)";
            if (this.isVerbose()) {
                System.out.println(message2);
            }
            if (this.mDebugPrinter != null) {
                this.mDebugPrinter.println(message2);
            }
        }
    }

    private static void copyToOutput(JarInputStream zis, JarOutputStream zos, ZipEntry entry, String name, boolean directory2) throws IOException {
        byte[] bytes2;
        JarEntry outEntry;
        if (entry.getMethod() == 0) {
            outEntry = new JarEntry(entry);
        } else {
            outEntry = new JarEntry(name);
            if (entry.getTime() != -1L) {
                outEntry.setTime(entry.getTime());
            }
        }
        zos.putNextEntry(outEntry);
        if (!directory2 && (bytes2 = ByteStreams.toByteArray((InputStream)zis)) != null) {
            zos.write(bytes2);
        }
        zos.closeEntry();
    }

    public void emitKeepResources(Path destination) throws IOException {
        File destinationFile = destination.toFile();
        if (!destinationFile.exists()) {
            destinationFile.getParentFile().mkdirs();
            boolean success = destinationFile.createNewFile();
            if (!success) {
                throw new IOException("Could not create " + destination);
            }
        }
        Files.asCharSink((File)destinationFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.mModel.dumpKeepResources());
    }

    public void emitConfig(Path destination) throws IOException {
        File destinationFile = destination.toFile();
        if (!destinationFile.exists()) {
            destinationFile.getParentFile().mkdirs();
            boolean success = destinationFile.createNewFile();
            if (!success) {
                throw new IOException("Could not create " + destination);
            }
        }
        Files.asCharSink((File)destinationFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)this.mModel.dumpConfig());
    }

    public void removeUnused(File destination) throws IOException, ParserConfigurationException, SAXException {
        assert (false);
    }

    private static void filteredCopy(File source, File destination, Set<File> skip, Map<File, String> replace) throws IOException {
        assert (false);
    }

    private void stripUnused(Element element, List<String> removed) {
        assert (false);
    }

    private ResourceUsageModel.Resource getResourceByJarPath(String path) {
        if (!path.startsWith("res/")) {
            return null;
        }
        int folderStart = 4;
        int folderEnd = path.indexOf(47, folderStart);
        if (folderEnd == -1) {
            return null;
        }
        String folderName = path.substring(folderStart, folderEnd);
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
        if (folderType == null) {
            return null;
        }
        int nameStart = folderEnd + 1;
        int nameEnd = path.indexOf(46, nameStart);
        if (nameEnd == -1) {
            nameEnd = path.length();
        }
        String name = path.substring(nameStart, nameEnd);
        for (ResourceType type : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType)) {
            ResourceUsageModel.Resource resource;
            if (type == ResourceType.ID || (resource = this.mModel.getResource(type, name)) == null) continue;
            return resource;
        }
        return null;
    }

    private void dumpReferences() {
        if (this.mDebugPrinter != null) {
            this.mDebugPrinter.print(this.mModel.dumpReferences());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void keepPossiblyReferencedResources() {
        if (!this.mFoundGetIdentifier && !this.mFoundWebContent || this.mStrings == null) {
            return;
        }
        if (!this.mModel.isSafeMode()) {
            return;
        }
        if (this.mDebugPrinter != null) {
            ArrayList<String> strings = new ArrayList<String>(this.mStrings);
            Collections.sort(strings);
            this.mDebugPrinter.println("android.content.res.Resources#getIdentifier present: " + this.mFoundGetIdentifier);
            this.mDebugPrinter.println("Web content present: " + this.mFoundWebContent);
            this.mDebugPrinter.println("Referenced Strings:");
            for (String string : strings) {
                void var3_4;
                String string2 = string.trim().replace("\n", "\\n");
                if (string2.length() > 40) {
                    String string3 = string2.substring(0, 37) + "...";
                } else if (string2.isEmpty()) continue;
                this.mDebugPrinter.println("  " + (String)var3_4);
            }
        }
        int shortest = Integer.MAX_VALUE;
        HashSet names = Sets.newHashSetWithExpectedSize((int)50);
        for (ResourceUsageModel.Resource resource : this.mModel.getResources()) {
            String name = resource.name;
            names.add(name);
            int length = name.length();
            if (length >= shortest) continue;
            shortest = length;
        }
        for (String string : this.mStrings) {
            String name;
            if (string.length() < shortest) continue;
            if (this.mFoundWebContent) {
                int dot;
                String name2;
                ResourceUsageModel.Resource resource = this.mModel.getResourceFromFilePath(string);
                if (resource != null) {
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                    continue;
                }
                int start = 0;
                int slash = string.lastIndexOf(47);
                if (slash != -1) {
                    start = slash + 1;
                }
                if (names.contains(name2 = string.substring(start, (dot = string.indexOf(46, start)) != -1 ? dot : string.length()))) {
                    for (ListMultimap map : this.mModel.getResourceMaps()) {
                        Iterator iterator2 = map.get((Object)name2).iterator();
                        while (iterator2.hasNext()) {
                            ResourceUsageModel.Resource currentResource;
                            resource = currentResource = (ResourceUsageModel.Resource)iterator2.next();
                            if (this.mDebug && resource != null) {
                                this.mDebugPrinter.println("Marking " + resource + " used because it matches string pool constant " + string);
                            }
                            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                        }
                    }
                }
            }
            int n = string.length();
            boolean justName = true;
            boolean formatting = false;
            boolean haveSlash = false;
            for (int i2 = 0; i2 < n; ++i2) {
                char c = string.charAt(i2);
                if (c == '/') {
                    haveSlash = true;
                    justName = false;
                    continue;
                }
                if (c == '.' || c == ':' || c == '%') {
                    justName = false;
                    if (c != '%') continue;
                    formatting = true;
                    continue;
                }
                if (Character.isJavaIdentifierPart(c)) continue;
                assert (false) : string;
                break;
            }
            if (justName) {
                name = string;
                for (Object resource : this.mModel.getResources()) {
                    if (!((ResourceUsageModel.Resource)resource).name.startsWith(name)) continue;
                    if (this.mDebugPrinter != null) {
                        this.mDebugPrinter.println("Marking " + (ResourceUsageModel.Resource)resource + " used because its prefix matches string pool constant " + string);
                    }
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                }
            } else {
                if (!haveSlash) {
                    if (!formatting) continue;
                    try {
                        Object resource;
                        Pattern pattern = Pattern.compile(ResourceUsageAnalyzer.convertFormatStringToRegexp(string));
                        resource = this.mModel.getResources().iterator();
                        while (resource.hasNext()) {
                            ResourceUsageModel.Resource resource2 = (ResourceUsageModel.Resource)resource.next();
                            if (!pattern.matcher(resource2.name).matches()) continue;
                            if (this.mDebugPrinter != null) {
                                this.mDebugPrinter.println("Marking " + resource2 + " used because it format-string matches string pool constant " + string);
                            }
                            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource2);
                        }
                        continue;
                    }
                    catch (PatternSyntaxException pattern) {
                        continue;
                    }
                }
                int slash = string.indexOf(47);
                assert (slash != -1);
                name = string.substring(slash + 1);
                if (name.isEmpty() || !names.contains(name)) continue;
                if (slash > 0) {
                    int colon = string.indexOf(58);
                    String typeName = string.substring(colon != -1 ? colon + 1 : 0, slash);
                    ResourceType type = ResourceType.fromClassName((String)typeName);
                    if (type == null) continue;
                    ResourceUsageModel.Resource resource = this.mModel.getResource(type, name);
                    if (this.mDebug && resource != null) {
                        this.mDebugPrinter.println("Marking " + resource + " used because it matches string pool constant " + string);
                    }
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                    continue;
                }
            }
            if (names.contains(name)) {
                for (ListMultimap map : this.mModel.getResourceMaps()) {
                    for (ResourceUsageModel.Resource resource : map.get((Object)name)) {
                        if (this.mDebug && resource != null) {
                            this.mDebugPrinter.println("Marking " + resource + " used because it matches string pool constant " + string);
                        }
                        ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                    }
                }
                continue;
            }
            if (!Character.isDigit(name.charAt(0))) continue;
            try {
                int id = Integer.parseInt(name);
                if (id == 0) continue;
                ResourceUsageModel.markReachable((ResourceUsageModel.Resource)this.mModel.getResource(id));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    @VisibleForTesting
    static String convertFormatStringToRegexp(String formatString) {
        StringBuilder regexp = new StringBuilder();
        int from = 0;
        boolean hasEscapedLetters = false;
        Matcher matcher = FORMAT.matcher(formatString);
        int length = formatString.length();
        while (matcher.find(from)) {
            int start = matcher.start();
            int end = matcher.end();
            if (start == 0 && end == length) {
                return NO_MATCH;
            }
            if (start > from) {
                hasEscapedLetters |= ResourceUsageAnalyzer.appendEscapedPattern(formatString, regexp, from, start);
            }
            Object pattern = ".*";
            String conversion = matcher.group(6);
            String timePrefix = matcher.group(5);
            if (timePrefix == null && conversion != null && conversion.length() == 1) {
                String width;
                char type = conversion.charAt(0);
                switch (type) {
                    case 'S': 
                    case 'T': 
                    case 's': 
                    case 't': {
                        break;
                    }
                    case '%': {
                        pattern = "%";
                        break;
                    }
                    case 'n': {
                        pattern = "\n";
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        pattern = ".";
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        pattern = "\\p{XDigit}+";
                        break;
                    }
                    case 'd': 
                    case 'o': {
                        pattern = "\\p{Digit}+";
                        break;
                    }
                    case 'b': {
                        pattern = "(true|false)";
                        break;
                    }
                    case 'B': {
                        pattern = "(TRUE|FALSE)";
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        pattern = "(null|\\p{XDigit}+)";
                        break;
                    }
                    case 'f': {
                        pattern = "-?[\\p{XDigit},.]+";
                        break;
                    }
                    case 'e': {
                        pattern = "-?\\p{Digit}+[,.]\\p{Digit}+e\\+?\\p{Digit}+";
                        break;
                    }
                    case 'E': {
                        pattern = "-?\\p{Digit}+[,.]\\p{Digit}+E\\+?\\p{Digit}+";
                        break;
                    }
                    case 'a': {
                        pattern = "0x[\\p{XDigit},.+p]+";
                        break;
                    }
                    case 'A': {
                        pattern = "0X[\\p{XDigit},.+P]+";
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        pattern = "-?[\\p{XDigit},.+eE]+";
                    }
                }
                if (!".*".equals(pattern) && (width = matcher.group(3)) != null) {
                    String flags = matcher.group(2);
                    pattern = "0".equals(flags) ? "0*" + (String)pattern : " " + (String)pattern;
                }
                int regexLength = regexp.length();
                if (!".*".equals(pattern) || regexLength < 2 || regexp.charAt(regexLength - 1) != '*' || regexp.charAt(regexLength - 2) != '.') {
                    regexp.append((String)pattern);
                }
            }
            from = end;
        }
        if (from < length) {
            hasEscapedLetters |= ResourceUsageAnalyzer.appendEscapedPattern(formatString, regexp, from, length);
        }
        if (!hasEscapedLetters) {
            return NO_MATCH;
        }
        return regexp.toString();
    }

    private static boolean appendEscapedPattern(String formatString, StringBuilder regexp, int from, int to) {
        regexp.append(Pattern.quote(formatString.substring(from, to)));
        for (int i2 = from; i2 < to; ++i2) {
            if (!Character.isLetter(formatString.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private void recordResources(Iterable<File> resources) throws IOException, SAXException, ParserConfigurationException {
        for (File resDir : resources) {
            File[] resourceFolders2 = resDir.listFiles();
            if (resourceFolders2 == null) continue;
            for (File folder2 : resourceFolders2) {
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder2.getName());
                if (folderType == null) continue;
                this.recordResources(folderType, folder2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordResources(ResourceFolderType folderType, File folder2) throws ParserConfigurationException, SAXException, IOException {
        File[] files2 = folder2.listFiles();
        if (files2 != null) {
            for (File file : files2) {
                String path = file.getPath();
                this.mModel.file = file;
                try {
                    boolean isXml = SdkUtils.endsWithIgnoreCase((String)path, (String)".xml");
                    if (isXml) {
                        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
                        this.mModel.visitXmlDocument(file, folderType, document);
                        continue;
                    }
                    this.mModel.visitBinaryResource(folderType, file);
                }
                finally {
                    this.mModel.file = null;
                }
            }
        }
    }

    @VisibleForTesting
    void recordMapping(File mapping) throws IOException {
        if (mapping == null || !mapping.exists()) {
            return;
        }
        String ARROW = " -> ";
        String RESOURCE = ".R$";
        HashMap nameMap = null;
        for (String line : Files.readLines((File)mapping, (Charset)Charsets.UTF_8)) {
            String typeName;
            ResourceType type;
            int end;
            if (line.startsWith(" ") || line.startsWith("\t")) {
                int i2;
                if (nameMap == null) continue;
                int n = line.length();
                for (i2 = 0; i2 < n && Character.isWhitespace(line.charAt(i2)); ++i2) {
                }
                if (i2 >= n || !line.startsWith("int", i2)) continue;
                int start = line.indexOf(32, i2 + 3) + 1;
                int arrow = line.indexOf(" -> ");
                if (start <= 0 || arrow == -1 || (end = line.indexOf(32, start + 1)) == -1) continue;
                String oldName = line.substring(start, end);
                String newName = line.substring(arrow + " -> ".length()).trim();
                if (newName.equals(oldName)) continue;
                nameMap.put(newName, oldName);
                continue;
            }
            nameMap = null;
            int index = line.indexOf(".R$");
            if (index == -1) {
                if (line.startsWith("android.support.v7.widget.SuggestionsAdapter ")) {
                    this.mSuggestionsAdapter = line.substring(line.indexOf(" -> ") + " -> ".length(), line.indexOf(58) != -1 ? line.indexOf(58) : line.length()).trim().replace('.', '/') + ".class";
                    continue;
                }
                if (!line.startsWith("android.support.v7.internal.widget.ResourcesWrapper ") && !line.startsWith("android.support.v7.widget.ResourcesWrapper ") && (this.mResourcesWrapper != null || !line.startsWith("android.support.v7.widget.TintContextWrapper$TintResources "))) continue;
                this.mResourcesWrapper = line.substring(line.indexOf(" -> ") + " -> ".length(), line.indexOf(58) != -1 ? line.indexOf(58) : line.length()).trim().replace('.', '/') + ".class";
                continue;
            }
            int arrow = line.indexOf(" -> ", index + 3);
            if (arrow == -1 || (type = ResourceType.fromClassName((String)(typeName = line.substring(index + ".R$".length(), arrow)))) == null) continue;
            end = line.indexOf(58, arrow + " -> ".length());
            if (end == -1) {
                end = line.length();
            }
            String target = line.substring(arrow + " -> ".length(), end).trim();
            String ownerName = target.replace('.', '/');
            nameMap = Maps.newHashMap();
            Pair pair = Pair.of((Object)type, (Object)nameMap);
            this.mResourceObfuscation.put(ownerName, (Pair<ResourceType, Map<String, String>>)pair);
            this.mResourceObfuscation.put(ownerName + ".class", (Pair<ResourceType, Map<String, String>>)pair);
        }
    }

    private void recordManifestUsages(File manifest) throws IOException, ParserConfigurationException, SAXException {
        String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
        this.mModel.visitXmlDocument(manifest, null, document);
    }

    private void referencedString(String string) {
        if (string.isEmpty() || string.length() > 80) {
            return;
        }
        boolean haveIdentifierChar = false;
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = string.charAt(i2);
            boolean identifierChar = Character.isJavaIdentifierPart(c);
            if (!identifierChar && c != '.' && c != ':' && c != '/' && c != '%') {
                return;
            }
            if (!identifierChar) continue;
            haveIdentifierChar = true;
        }
        if (!haveIdentifierChar) {
            return;
        }
        if (this.mStrings == null) {
            this.mStrings = Sets.newHashSetWithExpectedSize((int)300);
        }
        this.mStrings.add(string);
        if (!this.mFoundWebContent && string.contains(ANDROID_RES)) {
            this.mFoundWebContent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordClassUsages(File file) throws IOException {
        block12: {
            block13: {
                block11: {
                    if (!file.isDirectory()) break block11;
                    File[] children2 = file.listFiles();
                    if (children2 != null) {
                        for (File child : children2) {
                            this.recordClassUsages(child);
                        }
                    }
                    break block12;
                }
                if (!file.isFile()) break block12;
                if (!file.getPath().endsWith(".class") && !file.getPath().endsWith(".dex")) break block13;
                byte[] bytes2 = Files.toByteArray((File)file);
                this.recordClassUsages(file, file.getName(), bytes2);
                break block12;
            }
            if (file.getPath().endsWith(".jar")) {
                ZipInputStream zis = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        zis = new ZipInputStream(fis);
                        ZipEntry entry = zis.getNextEntry();
                        while (entry != null) {
                            byte[] bytes3;
                            String name = entry.getName();
                            if ((name.endsWith(".class") && !this.isResourceClass(name) || name.endsWith(".dex")) && (bytes3 = ByteStreams.toByteArray((InputStream)zis)) != null) {
                                this.recordClassUsages(file, name, bytes3);
                            }
                            entry = zis.getNextEntry();
                        }
                    }
                    finally {
                        Closeables.close((Closeable)fis, (boolean)true);
                    }
                }
                catch (Throwable throwable) {
                    Closeables.close(zis, (boolean)true);
                    throw throwable;
                }
                Closeables.close((Closeable)zis, (boolean)true);
            }
        }
    }

    private void recordClassUsages(final File file, final String name, byte[] bytes2) {
        if (name.endsWith(".class")) {
            ClassReader classReader = new ClassReader(bytes2);
            classReader.accept((ClassVisitor)new UsageVisitor(file, name), 6);
        } else {
            assert (name.endsWith(".dex"));
            AnalysisCallback callback = new AnalysisCallback(){
                Boolean isRClass = null;
                final MethodVisitingStatus visitingMethod = new MethodVisitingStatus();

                public boolean shouldProcess(String internalName) {
                    this.isRClass = ResourceUsageAnalyzer.this.isResourceClass(internalName);
                    return true;
                }

                public void referencedInt(int value) {
                    if (this.shouldIgnoreField()) {
                        return;
                    }
                    ResourceUsageAnalyzer.this.referencedInt("dex", value, file, name);
                }

                public void referencedString(String value) {
                    if (this.shouldIgnoreField()) {
                        return;
                    }
                    ResourceUsageAnalyzer.this.referencedString(value);
                }

                public void referencedStaticField(String internalName, String fieldName) {
                    if (this.shouldIgnoreField()) {
                        return;
                    }
                    ResourceUsageModel.Resource resource = ResourceUsageAnalyzer.this.getResourceFromCode(internalName, fieldName);
                    if (resource != null) {
                        ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                    }
                }

                public void referencedMethod(String internalName, String methodName, String methodDescriptor) {
                    if (this.isRClass.booleanValue() && this.visitingMethod.isVisiting() && this.visitingMethod.getMethodName().equals("<clinit>")) {
                        return;
                    }
                    ResourceUsageAnalyzer.this.referencedMethodInvocation(internalName, methodName, methodDescriptor, internalName + ".class");
                }

                public void startMethodVisit(@NotNull MethodReference methodReference) {
                    this.visitingMethod.setVisiting(true);
                    this.visitingMethod.setMethodName(methodReference.getMethodName());
                }

                public void endMethodVisit(@NotNull MethodReference methodReference) {
                    this.visitingMethod.setVisiting(false);
                    this.visitingMethod.setMethodName(null);
                }

                private boolean shouldIgnoreField() {
                    boolean visitingFromStaticInitRClass = this.isRClass != false && this.visitingMethod.isVisiting() && this.visitingMethod.getMethodName().equals("<clinit>");
                    return visitingFromStaticInitRClass || this.isRClass != false && !this.visitingMethod.isVisiting();
                }
            };
            R8ResourceShrinker.runResourceShrinkerAnalysis((byte[])bytes2, (File)file, (AnalysisCallback)callback);
        }
    }

    @VisibleForTesting
    boolean isResourceClass(String name) {
        if (this.mResourceObfuscation.containsKey(name)) {
            return true;
        }
        int index = name.lastIndexOf(47);
        if (index != -1 && name.startsWith("R$", index + 1) && name.endsWith(".class")) {
            String typeName = name.substring(index + 3, name.length() - ".class".length());
            return ResourceType.fromClassName((String)typeName) != null;
        }
        return false;
    }

    @VisibleForTesting
    ResourceUsageModel.Resource getResourceFromCode(String owner, String name) {
        ResourceType type;
        Pair<ResourceType, Map<String, String>> pair = this.mResourceObfuscation.get(owner);
        if (pair != null) {
            ResourceType type2 = (ResourceType)pair.getFirst();
            Map nameMap = (Map)pair.getSecond();
            String renamedField = (String)nameMap.get(name);
            if (renamedField != null) {
                name = renamedField;
            }
            return this.mModel.getResource(type2, name);
        }
        if (this.isValidResourceType(owner).booleanValue() && (type = ResourceType.fromClassName((String)owner.substring(owner.lastIndexOf(36) + 1))) != null) {
            return this.mModel.getResource(type, name);
        }
        return null;
    }

    private Boolean isValidResourceType(String candidateString) {
        return candidateString.contains("/") && candidateString.substring(candidateString.lastIndexOf(47) + 1).contains("$");
    }

    private void gatherResourceValues(File file) throws IOException {
        if (file.isDirectory()) {
            File[] children2 = file.listFiles();
            if (children2 != null) {
                for (File child : children2) {
                    this.gatherResourceValues(child);
                }
            }
        } else if (file.isFile()) {
            if (file.getName().equals("R.java")) {
                this.parseResourceSourceClass(file);
            }
            if (file.getName().equals("R.jar")) {
                this.parseResourceRJar(file);
            }
            if (file.getName().equals("R.txt")) {
                this.addResourcesFromRTxtFile(file);
            }
        }
    }

    private void addResourcesFromRTxtFile(File file) {
        try {
            SymbolTable st = SymbolIo.readFromAapt((File)file, null);
            for (Symbol symbol : st.getSymbols().values()) {
                String symbolValue = symbol.getValue();
                if (symbol.getResourceType() == ResourceType.STYLEABLE) {
                    if (!symbolValue.trim().startsWith("{")) continue;
                    this.mModel.addResource(symbol.getResourceType(), symbol.getName(), null);
                    continue;
                }
                this.mModel.addResource(symbol.getResourceType(), symbol.getName(), symbolValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ResourceType extractResourceType(String entryName) {
        String rClassName = entryName.substring(entryName.lastIndexOf(47) + 1);
        if (!rClassName.startsWith("R$")) {
            return null;
        }
        String resourceTypeName = rClassName.substring("R$".length(), rClassName.length() - ".class".length());
        return ResourceType.fromClassName((String)resourceTypeName);
    }

    private void parseResourceRJar(File jarFile) throws IOException {
        try (ZipFile zFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> entries2 = zFile.entries();
            while (entries2.hasMoreElements()) {
                ResourceType resourceType;
                ZipEntry entry = entries2.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || (resourceType = ResourceUsageAnalyzer.extractResourceType(entryName)) == null) continue;
                String owner = entryName.substring(0, entryName.length() - ".class".length());
                byte[] classData2 = ByteStreams.toByteArray((InputStream)zFile.getInputStream(entry));
                this.parseResourceCompiledClass(classData2, owner, resourceType);
            }
        }
    }

    private void parseResourceCompiledClass(byte[] classData2, final String owner, final ResourceType resourceType) {
        ClassReader classReader = new ClassReader(classData2);
        ClassVisitor fieldVisitor = new ClassVisitor(458752){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if (desc.equals("I") || desc.equals("[I")) {
                    String resourceValue = resourceType == ResourceType.STYLEABLE ? null : value.toString();
                    ResourceUsageAnalyzer.this.mModel.addResource(resourceType, name, resourceValue);
                    ResourceUsageAnalyzer.this.addOwner(owner, resourceType);
                }
                return null;
            }
        };
        classReader.accept(fieldVisitor, 6);
    }

    private void addOwner(String owner, ResourceType type) {
        Pair pair = this.mResourceObfuscation.get(owner);
        if (pair == null) {
            HashMap nameMap = Maps.newHashMap();
            pair = Pair.of((Object)type, (Object)nameMap);
        }
        this.mResourceObfuscation.put(owner, pair);
    }

    private void parseResourceSourceClass(File file) throws IOException {
        String typeName;
        ResourceType type;
        int start;
        int end;
        String s = Files.toString((File)file, (Charset)Charsets.UTF_8);
        String pkg = null;
        int index = s.indexOf("package ");
        if (index != -1) {
            int end2 = s.indexOf(59, index);
            pkg = s.substring(index + "package ".length(), end2).trim().replace('.', '/');
        }
        index = 0;
        int length = s.length();
        String classDeclaration = "public static final class ";
        block0: while ((index = s.indexOf(classDeclaration, index)) != -1 && (end = s.indexOf(32, start = index + classDeclaration.length())) != -1 && (type = ResourceType.fromClassName((String)(typeName = s.substring(start, end)))) != null) {
            if (pkg != null) {
                this.addOwner(pkg + "/R$" + type.getName(), type);
            }
            for (index = end; index < length - 1; ++index) {
                char c = s.charAt(index);
                if (Character.isWhitespace(c)) continue;
                if (c == '/') {
                    char next = s.charAt(index + 1);
                    if (next == '*') {
                        for (end = index + 2; end < length - 2; ++end) {
                            c = s.charAt(end);
                            if (c != '*' || s.charAt(end + 1) != '/') continue;
                            ++end;
                            break;
                        }
                        index = end;
                        continue;
                    }
                    if (next == '/' ? !$assertionsDisabled : !$assertionsDisabled) {
                        throw new AssertionError((Object)s.substring(index - 1, index + 50));
                    }
                    continue;
                }
                if (c == 'p' && s.startsWith("public ", index)) {
                    if (type == ResourceType.STYLEABLE) {
                        start = s.indexOf(" int", index);
                        if (s.startsWith(" int[] ", start)) {
                            end = s.indexOf(61, start += " int[] ".length());
                            assert (end != -1);
                            String styleable = s.substring(start, end).trim();
                            this.mModel.addResource(ResourceType.STYLEABLE, styleable, null);
                            index = s.indexOf(59, index);
                            if (index != -1) continue;
                            continue block0;
                        }
                        if (!s.startsWith(" int ", start) || (index = s.indexOf(59, index)) != -1) continue;
                        continue block0;
                    }
                    start = s.indexOf(" int ", index);
                    if (start == -1) continue;
                    end = s.indexOf(61, start += " int ".length());
                    assert (end != -1);
                    String name = s.substring(start, end).trim();
                    start = end + 1;
                    end = s.indexOf(59, start);
                    assert (end != -1);
                    String value = s.substring(start, end).trim();
                    this.mModel.addResource(type, name, value);
                    continue;
                }
                if (c == '}') continue block0;
            }
        }
    }

    @Override
    public int getUnusedResourceCount() {
        return this.mUnused.size();
    }

    @VisibleForTesting
    ResourceUsageModel getModel() {
        return this.mModel;
    }

    private void referencedInt(String context, int value, File file, String currentClass) {
        ResourceUsageModel.Resource resource = this.mModel.getResource(value);
        if (ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource) && this.mDebug) {
            assert (this.mDebugPrinter != null) : "mDebug is true, but mDebugPrinter is null.";
            this.mDebugPrinter.println("Marking " + resource + " reachable: referenced from " + context + " in " + file + ":" + currentClass);
        }
    }

    private void referencedMethodInvocation(String owner, String name, String desc, String currentClass) {
        if (owner.equals("android/content/res/Resources") && name.equals("getIdentifier") && desc.equals("(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I")) {
            if (currentClass.equals(this.mResourcesWrapper) || currentClass.equals(this.mSuggestionsAdapter)) {
                return;
            }
            this.mFoundGetIdentifier = true;
        }
        if (owner.equals("android/webkit/WebView") && name.startsWith("load")) {
            this.mFoundWebContent = true;
        }
    }

    private class ResourceShrinkerUsageModel
    extends ResourceUsageModel {
        public File file;

        private ResourceShrinkerUsageModel() {
        }

        protected boolean ignoreToolsAttributes() {
            return true;
        }

        protected void onRootResourcesFound(List<ResourceUsageModel.Resource> roots) {
            if (ResourceUsageAnalyzer.this.mDebugPrinter != null) {
                ResourceUsageAnalyzer.this.mDebugPrinter.println("\nThe root reachable resources are:\n" + Joiner.on((String)",\n   ").join(roots));
            }
        }

        protected ResourceUsageModel.Resource declareResource(ResourceType type, String name, Node node) {
            ResourceUsageModel.Resource resource = super.declareResource(type, name, node);
            resource.addLocation(this.file);
            return resource;
        }

        protected void referencedString(String string) {
            ResourceUsageAnalyzer.this.referencedString(string);
            ResourceUsageAnalyzer.this.mFoundWebContent = true;
        }
    }

    private class UsageVisitor
    extends ClassVisitor {
        private final File mJarFile;
        private final String mCurrentClass;

        public UsageVisitor(File jarFile, String name) {
            super(458752);
            this.mJarFile = jarFile;
            this.mCurrentClass = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(this.api){

                public void visitLdcInsn(Object cst) {
                    UsageVisitor.this.handleCodeConstant(cst, "ldc");
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ResourceUsageModel.Resource resource;
                    if (opcode == 178 && (resource = ResourceUsageAnalyzer.this.getResourceFromCode(owner, name)) != null) {
                        ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    ResourceUsageAnalyzer.this.referencedMethodInvocation(owner, name, desc, UsageVisitor.this.mCurrentClass);
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return new AnnotationUsageVisitor();
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }
            };
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationUsageVisitor();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.handleCodeConstant(value, "field");
            return new FieldVisitor(this.api){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new AnnotationUsageVisitor();
                }
            };
        }

        private void handleCodeConstant(Object cst, String context) {
            if (cst instanceof Integer) {
                Integer value = (Integer)cst;
                ResourceUsageAnalyzer.this.referencedInt(context, value, this.mJarFile, this.mCurrentClass);
            } else if (cst instanceof Long) {
                Long value = (Long)cst;
                ResourceUsageAnalyzer.this.referencedInt(context, value.intValue(), this.mJarFile, this.mCurrentClass);
            } else if (cst instanceof int[]) {
                int[] values;
                for (int value : values = (int[])cst) {
                    ResourceUsageAnalyzer.this.referencedInt(context, value, this.mJarFile, this.mCurrentClass);
                }
            } else if (cst instanceof String) {
                String string = (String)cst;
                ResourceUsageAnalyzer.this.referencedString(string);
            }
        }

        private class AnnotationUsageVisitor
        extends AnnotationVisitor {
            public AnnotationUsageVisitor() {
                super(458752);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new AnnotationUsageVisitor();
            }

            public AnnotationVisitor visitArray(String name) {
                return new AnnotationUsageVisitor();
            }

            public void visit(String name, Object value) {
                UsageVisitor.this.handleCodeConstant(value, "annotation");
                super.visit(name, value);
            }
        }
    }
}

