/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0005"}, d2={"trySymlinkNdk", "Ljava/io/File;", "originalNdkFolder", "cxxVariantFolder", "ndkSymlinkFolder", "gradle-core"})
public final class NdkSymlinkerKt {
    @NotNull
    public static final File trySymlinkNdk(@NotNull File originalNdkFolder, @NotNull File cxxVariantFolder, @Nullable File ndkSymlinkFolder) {
        File file;
        Intrinsics.checkNotNullParameter((Object)originalNdkFolder, (String)"originalNdkFolder");
        Intrinsics.checkNotNullParameter((Object)cxxVariantFolder, (String)"cxxVariantFolder");
        if (ndkSymlinkFolder == null) {
            return originalNdkFolder;
        }
        String string = ndkSymlinkFolder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ndkSymlinkFolder.path");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null)) {
            LoggingEnvironmentKt.warnln("Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because that path contains '$'", new Object[0]);
            return originalNdkFolder;
        }
        if (!originalNdkFolder.isDirectory()) {
            LoggingEnvironmentKt.warnln("Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because " + originalNdkFolder + " doesn't exist", new Object[0]);
            return originalNdkFolder;
        }
        if (!originalNdkFolder.toPath().resolve("source.properties").toFile().isFile()) {
            LoggingEnvironmentKt.warnln("Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because " + originalNdkFolder + " doesn't have source.properties", new Object[0]);
            return originalNdkFolder;
        }
        String version = SdkSourceProperties.Companion.tryReadPackageRevision(originalNdkFolder);
        if (version == null) {
            LoggingEnvironmentKt.warnln("Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because " + originalNdkFolder + " doesn't have source.properties that looks like NDK", new Object[0]);
            return originalNdkFolder;
        }
        Path absoluteNdkSymlinkFolder = cxxVariantFolder.toPath().resolve(ndkSymlinkFolder.getPath()).resolve("ndk").normalize();
        absoluteNdkSymlinkFolder.toFile().mkdirs();
        Path versionedSymlinkFolder = absoluteNdkSymlinkFolder.resolve(version);
        if (versionedSymlinkFolder.toFile().exists()) {
            LoggingEnvironmentKt.infoln("Symlink target " + versionedSymlinkFolder + " already existed", new Object[0]);
            File file2 = versionedSymlinkFolder.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"versionedSymlinkFolder.toFile()");
            return file2;
        }
        Path originalNdkFolderRealPath = originalNdkFolder.toPath().toRealPath(new LinkOption[0]);
        LoggingEnvironmentKt.infoln("Symlinking NDK folder " + originalNdkFolder + " to " + versionedSymlinkFolder, new Object[0]);
        try {
            File file3 = Files.createSymbolicLink(versionedSymlinkFolder, originalNdkFolderRealPath, new FileAttribute[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"{\n        Files.createSy\u2026\n        ).toFile()\n    }");
            file = file3;
        }
        catch (FileAlreadyExistsException e) {
            LoggingEnvironmentKt.infoln("Symlink target " + versionedSymlinkFolder + " already existed", new Object[0]);
            File file4 = versionedSymlinkFolder.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"{\n        // The symlink\u2026linkFolder.toFile()\n    }");
            file = file4;
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warnln("Could not symlink NDK folder " + originalNdkFolder + " to " + versionedSymlinkFolder + " due to exception " + e, new Object[0]);
            file = originalNdkFolder;
        }
        return file;
    }
}

