/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.ide.common.resources.CompileResourceRequest;
import com.android.ide.common.resources.ResourceCompilationService;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.utils.FileUtils;
import com.android.utils.PositionXmlParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\nH\u0007J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/NamespaceRemover;", "Lcom/android/ide/common/resources/ResourceCompilationService;", "()V", "close", "", "compileOutputFor", "Ljava/io/File;", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "removeNamespace", "", "content", "removeNamespaces", "node", "Lorg/w3c/dom/Node;", "rewrite", "input", "Ljava/io/InputStream;", "lineSeparator", "Ljava/nio/file/Path;", "output", "submitCompile", "gradle-core"})
public final class NamespaceRemover
implements ResourceCompilationService {
    @NotNull
    public static final NamespaceRemover INSTANCE = new NamespaceRemover();

    private NamespaceRemover() {
    }

    public void submitCompile(@NotNull CompileResourceRequest request2) throws Exception {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        File input = request2.getInputFile();
        File output2 = this.compileOutputFor(request2);
        FileUtils.mkdirs((File)output2.getParentFile());
        String string = input.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.name");
        if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) {
            Path path = input.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"input.toPath()");
            Path path2 = output2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"output.toPath()");
            this.rewrite(path, path2);
        } else {
            FileUtils.copyFile((File)input, (File)output2);
        }
    }

    @NotNull
    public File compileOutputFor(@NotNull CompileResourceRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        File parentDir = new File(request2.getOutputDirectory(), request2.getInputDirectoryName());
        return new File(parentDir, request2.getInputFile().getName());
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewrite(@NotNull Path input, @NotNull Path output2) throws IOException, ParserConfigurationException, SAXException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Closeable closeable = new BufferedInputStream(Files.newInputStream(input, new OpenOption[0]));
        Throwable throwable = null;
        try {
            BufferedInputStream is = (BufferedInputStream)closeable;
            boolean bl = false;
            byte[] byArray = NamespaceRemover.rewrite$default(INSTANCE, is, null, 2, null).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Path path = Files.write(output2, byArray, new OpenOption[0]);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @VisibleForTesting
    @NotNull
    public final String rewrite(@NotNull InputStream input, @NotNull String lineSeparator) throws ParserConfigurationException, SAXException, IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Document doc = PositionXmlParser.parse((InputStream)input);
        Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
        this.removeNamespaces(doc);
        String string = XmlPrettyPrinter.prettyPrint((Node)doc, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)doc), (String)lineSeparator, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prettyPrint(\n           \u2026r,\n                false)");
        return string;
    }

    public static /* synthetic */ String rewrite$default(NamespaceRemover namespaceRemover, InputStream inputStream, String string, int n, Object object) throws ParserConfigurationException, SAXException, IOException {
        if ((n & 2) != 0) {
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator()");
            string = string2;
        }
        return namespaceRemover.rewrite(inputStream, string);
    }

    private final void removeNamespaces(Node node) {
        String uri;
        String prefix;
        if (node.getNodeType() == 3) {
            String content2 = node.getTextContent();
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"content");
            String nonNamespacedContent = this.removeNamespace(content2);
            if (!Intrinsics.areEqual((Object)content2, (Object)nonNamespacedContent)) {
                node.setTextContent(nonNamespacedContent);
            }
        } else if (node.getNodeType() == 2 && (prefix = node.getPrefix()) != null && Intrinsics.areEqual((Object)prefix, (Object)"xmlns") && !Intrinsics.areEqual((Object)(uri = node.getTextContent()), (Object)"http://schemas.android.com/apk/res/android") && !Intrinsics.areEqual((Object)uri, (Object)"http://schemas.android.com/tools") && !Intrinsics.areEqual((Object)uri, (Object)"http://schemas.android.com/aapt")) {
            node.setTextContent("http://schemas.android.com/apk/res-auto");
        }
        NamedNodeMap attributes2 = node.getAttributes();
        NamespaceRemover $this$removeNamespaces_u24lambda_u2d1 = this;
        boolean bl = false;
        for (int i = 0; attributes2 != null && i < attributes2.getLength(); ++i) {
            Node node2 = attributes2.item(i);
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"attributes.item(i)");
            $this$removeNamespaces_u24lambda_u2d1.removeNamespaces(node2);
        }
        NodeList children2 = node.getChildNodes();
        int n = children2.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = children2.item(i);
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"children.item(i)");
            this.removeNamespaces(node3);
        }
    }

    private final String removeNamespace(String content2) {
        if (StringsKt.startsWith$default((String)content2, (String)"@", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)content2, (CharSequence)":", (boolean)false, (int)2, null)) {
            String string = content2.substring(1, StringsKt.indexOf$default((CharSequence)content2, (char)':', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String ns = string;
            if (!Intrinsics.areEqual((Object)ns, (Object)"android") && !Intrinsics.areEqual((Object)ns, (Object)"tools")) {
                String string2 = content2.substring(StringsKt.indexOf$default((CharSequence)content2, (char)':', (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                return "@" + string2;
            }
        }
        return content2;
    }
}

